/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.ui;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CompositeUtils {
    public static Group createGroup(Composite parent, String text, int GroupStyle, int GridDataStyle) {
        Group group = new Group(parent, GroupStyle);
        group.setText(text);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)CompositeUtils.createGridData(GridDataStyle, -1, -1, -1));
        return group;
    }

    public static Composite createComposite(Composite parent, int CompositeStyle, int GridDataStyle, int numColumns, int marginHeight, int marginWidth, int widthHint, int heightHint, int horizontalSpan) {
        Composite composite = new Composite(parent, CompositeStyle);
        composite.setLayout((Layout)CompositeUtils.createGridLayout(numColumns, marginHeight, marginWidth));
        composite.setLayoutData((Object)CompositeUtils.createGridData(GridDataStyle, widthHint, heightHint, horizontalSpan));
        return composite;
    }

    public static GridData createGridData(int GridDataStyle, int widthHint, int heightHint, int horizontalSpan) {
        GridData gridData = GridDataStyle != -1 ? new GridData(GridDataStyle) : new GridData();
        if (heightHint != -1) {
            gridData.heightHint = heightHint;
        }
        if (widthHint != -1) {
            gridData.widthHint = widthHint;
        }
        if (horizontalSpan != -1) {
            gridData.horizontalSpan = horizontalSpan;
        }
        return gridData;
    }

    public static GridLayout createGridLayout(int numColumns, int marginHeight, int marginWidth) {
        GridLayout layout = new GridLayout();
        if (numColumns != -1) {
            layout.numColumns = numColumns;
        }
        if (marginHeight != -1) {
            layout.marginHeight = marginHeight;
        }
        if (marginWidth != -1) {
            layout.marginWidth = marginWidth;
        }
        return layout;
    }

    public static Button createButton(Composite parent, String text, int style) {
        Button button = new Button(parent, style);
        button.setText(text);
        return button;
    }

    public static Label createLabel(Composite parent, String text, int style) {
        Label label = new Label(parent, style);
        if (text != null && text != "") {
            label.setText(text);
        }
        return label;
    }

    public static Text createText(Composite parent, GridData gd, int style) {
        Text text = new Text(parent, style);
        text.setLayoutData((Object)gd);
        return text;
    }

    public static void addSelectionListener(Button button, SelectionListener listener) {
        button.addSelectionListener(listener);
    }

    public static void addModifyListener(Text text, ModifyListener listener) {
        text.addModifyListener(listener);
    }

    public static void addVerifyListener(Text text, VerifyListener listener) {
        text.addVerifyListener(listener);
    }
}

