/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.liveexpressions;

import java.util.ArrayList;

public class LiveVariable {
    private String expVar;
    private LiveVariable parent;
    private String gdbVarName = "";
    private String type = "";
    private String value = "";
    private int nrChildren = 0;
    private ArrayList<LiveVariable> children = new ArrayList();
    private boolean editable;

    public LiveVariable(String expVar, LiveVariable parent) {
        this.expVar = expVar;
        this.parent = parent;
        this.value = "Effective after re-debugging";
    }

    public boolean isComplex() {
        return this.nrChildren > 0;
    }

    public String getExpression() {
        return this.expVar;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setNumChildren(int nrChildren) {
        this.nrChildren = nrChildren;
    }

    public int getNumChildren() {
        return this.nrChildren;
    }

    public ArrayList<LiveVariable> getExpressions() {
        return this.children;
    }

    public LiveVariable getParent() {
        return this.parent;
    }

    public String getGdbVarName() {
        return this.gdbVarName;
    }

    public void setGdbVarName(String gdbVarName) {
        this.gdbVarName = gdbVarName;
    }

    public void addChildExpression(LiveVariable childExpr) {
        this.children.add(childExpr);
    }

    public void reset() {
        this.parent = null;
        this.gdbVarName = "";
        this.type = "";
        this.value = "";
        this.nrChildren = 0;
        this.children.clear();
    }

    public boolean inContext() {
        return !this.gdbVarName.isEmpty();
    }

    private LiveVariable findChild(LiveVariable expr, String childName) {
        for (LiveVariable tmp : expr.getExpressions()) {
            if (!tmp.getGdbVarName().equals(childName)) continue;
            return tmp;
        }
        return null;
    }

    public LiveVariable findExpression(String path) {
        LiveVariable found = null;
        if (path.equals(this.gdbVarName)) {
            found = this;
        } else if (path.startsWith(this.gdbVarName)) {
            found = this;
            String[] pathSeg = path.split("\\.");
            int pathSegCtr = 1;
            String name = pathSeg[0];
            while (path.contains(".")) {
                if ((found = this.findChild(found, name = String.valueOf(String.valueOf(name)) + "." + pathSeg[pathSegCtr])) == null) break;
                path = path.substring(path.indexOf(".") + 1);
                ++pathSegCtr;
            }
        }
        return found;
    }
}

