/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.dsf;

import com.gigadevice.debug.Activator;
import com.gigadevice.debug.utils.DebugUtil;
import com.gigadevice.utils.constants.DebugConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ResetProcessSequence
extends ReflectionSequence {
    private IGDBControl fGdbControl;
    private CommandFactory fCommandFactory;
    private IGDBProcesses fGdbProcesses;
    private DsfServicesTracker fTracker;
    private IRunControl.IContainerDMContext fContainerDmc;
    private final Map<String, Object> fAttributes;

    public ResetProcessSequence(DsfExecutor executor, IRunControl.IContainerDMContext containerDmc, Map<String, Object> attributes, boolean restart, DataRequestMonitor<IRunControl.IContainerDMContext> rm) {
        super(executor, rm);
        assert (executor != null);
        assert (containerDmc != null);
        if (attributes == null) {
            attributes = new HashMap<String, Object>();
        }
        this.fContainerDmc = containerDmc;
        this.fAttributes = attributes;
    }

    protected String[] getExecutionOrder(String groupName) {
        if ("GROUP_TOP_LEVEL".equals(groupName)) {
            return new String[]{"stepInitializeBaseSequence", "stepResetCommands"};
        }
        return null;
    }

    @ReflectionSequence.Execute
    public void stepInitializeBaseSequence(RequestMonitor rm) {
        this.fTracker = new DsfServicesTracker(Activator.getBundleContext(), this.fContainerDmc.getSessionId());
        this.fGdbControl = (IGDBControl)this.fTracker.getService(IGDBControl.class);
        this.fCommandFactory = ((IMICommandControl)this.fTracker.getService(IMICommandControl.class)).getCommandFactory();
        this.fGdbProcesses = (IGDBProcesses)this.fTracker.getService(IGDBProcesses.class);
        if (this.fGdbControl == null || this.fCommandFactory == null || this.fGdbProcesses == null) {
            rm.setStatus((IStatus)new Status(4, "com.gigadevice.debug", 10005, "Cannot obtain service", null));
            rm.done();
            return;
        }
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepResetCommands(RequestMonitor rm) {
        ArrayList<String> commandsList = new ArrayList<String>();
        String debugger = (String)this.fAttributes.get("com.gigadevice.debug.launch.jtagDevice");
        if (debugger.equals(DebugConstants.debuggerEnum.GDLink.toString())) {
            commandsList.add("monitor reset halt");
            commandsList.add("monitor halt");
            commandsList.add("tbreak main");
            commandsList.add("continue");
        } else {
            commandsList.add("monitor reset");
            commandsList.add("monitor halt");
            commandsList.add("tbreak main");
            commandsList.add("continue");
        }
        this.queueCommands(commandsList, rm);
    }

    private void queueCommands(List<String> commands, RequestMonitor rm) {
        DebugUtil.queueCommands(commands, rm, this.fGdbControl, this.getExecutor());
    }
}

