/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.dsf;

import com.gigadevice.debug.dsf.GdbExtendedProcesses;
import com.gigadevice.debug.liveexpressions.GDBVarManagerService;
import com.gigadevice.debug.liveexpressions.IGDBVarManagerService;
import com.gigadevice.debug.service.command.GdbExtendedControl;
import com.gigadevice.debug.utils.DebugUtil;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.gdb.service.GdbDebugServicesFactory;
import org.eclipse.cdt.dsf.gdb.service.command.CommandFactory_6_8;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.ILaunchConfiguration;

public class DebugServicesFactory
extends GdbDebugServicesFactory {
    private final String fVersion;
    private final ILaunchConfiguration fConfiguration;

    public DebugServicesFactory(String version, ILaunchConfiguration config) {
        super(version, config);
        this.fVersion = version;
        this.fConfiguration = config;
    }

    public <V> V createService(Class<V> clazz, DsfSession session, Object ... optionalArguments) {
        if (IGDBVarManagerService.class.isAssignableFrom(clazz)) {
            Object[] arrayOfObject = optionalArguments;
            int i = optionalArguments.length;
            int b = 0;
            while (b < i) {
                Object arg = arrayOfObject[b];
                if (arg instanceof ILaunchConfiguration) {
                    return (V)this.createGDBVarManagerService(session);
                }
                b = (byte)(b + 1);
            }
        }
        return (V)super.createService(clazz, session, optionalArguments);
    }

    private IGDBVarManagerService createGDBVarManagerService(DsfSession session) {
        return new GDBVarManagerService(session);
    }

    protected ICommandControl createCommandControl(DsfSession session, ILaunchConfiguration config) {
        if (this.compareVersionWith("6.8") >= 0) {
            return new GdbExtendedControl(session, config, (CommandFactory)new CommandFactory_6_8());
        }
        return new GDBControl(session, config, new CommandFactory());
    }

    protected IProcesses createProcessesService(DsfSession session) {
        if (DebugUtil.compareVersions("7.2.1", this.fVersion) <= 0) {
            return new GdbExtendedProcesses(session);
        }
        return super.createProcessesService(session);
    }
}

