/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug;

import com.gigadevice.debug.AbstractDebugServer;
import com.gigadevice.utils.constants.DebugConstants;
import java.util.HashMap;
import org.eclipse.core.runtime.Platform;

public class GdbServerFactory {
    private static final String gdlinkClassBundle = "com.gigadevice.debug.gdlink";
    private static final String gdlinkClass = "com.gigadevice.debug.gdlink.OpenocdDebug";
    private static final String jlinkClassBundle = "com.gigadevice.debug.jlink";
    private static final String jlinkClass = "com.gigadevice.debug.jlink.JlinkDebug";
    static HashMap<String, AbstractDebugServer> serverMap = new HashMap();

    public static void registerServer() {
        Object o = null;
        try {
            o = Platform.getBundle((String)gdlinkClassBundle).loadClass(gdlinkClass).newInstance();
            serverMap.put(DebugConstants.debuggerEnum.GDLink.toString(), o);
            o = Platform.getBundle((String)jlinkClassBundle).loadClass(jlinkClass).newInstance();
            serverMap.put(DebugConstants.debuggerEnum.JLink.toString(), o);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static AbstractDebugServer getServer(String server) {
        if (serverMap.size() == 0) {
            GdbServerFactory.registerServer();
        }
        AbstractDebugServer serverClass = null;
        boolean existed = serverMap.containsKey(server);
        if (existed) {
            serverClass = serverMap.get(server);
        }
        return serverClass;
    }

    public static HashMap<String, AbstractDebugServer> getServerMap() {
        if (serverMap.size() == 0) {
            GdbServerFactory.registerServer();
        }
        return serverMap;
    }
}

