/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.diff.provider.DiffTree;
import org.eclipse.team.internal.core.subscribers.SubscriberDiffTreeEventHandler;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.synchronize.patch.ApplyPatchModelSynchronizeParticipant;
import org.eclipse.team.internal.ui.synchronize.patch.ApplyPatchSubscriber;
import org.eclipse.team.internal.ui.synchronize.patch.ApplyPatchSubscriberMergeContext;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class IgnoreLeadingPathSegmentsAction
extends Action {
    private final ISynchronizePageConfiguration configuration;
    private final ApplyPatchModelSynchronizeParticipant participant;
    private final ApplyPatchSubscriberMergeContext context;
    private final ApplyPatchSubscriber subscriber;
    private int maxValue;

    public IgnoreLeadingPathSegmentsAction(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
        this.participant = (ApplyPatchModelSynchronizeParticipant)configuration.getParticipant();
        this.context = (ApplyPatchSubscriberMergeContext)this.participant.getContext();
        this.subscriber = (ApplyPatchSubscriber)this.context.getSubscriber();
    }

    public boolean isEnabled() {
        return !this.subscriber.getPatcher().isWorkspacePatch();
    }

    public void run() {
        String input2;
        int newValue;
        int oldValue = this.subscriber.getPatcher().getStripPrefixSegments();
        this.maxValue = this.subscriber.getPatcher().calculatePrefixSegmentCount() - 1;
        InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), TeamUIMessages.IgnoreLeadingPathSegmentsDialog_title, NLS.bind((String)TeamUIMessages.IgnoreLeadingPathSegmentsDialog_message, (Object)this.maxValue), Integer.toString(oldValue), input -> {
            try {
                int i = Integer.parseInt(input);
                if (i < 0 || i > this.maxValue) {
                    return TeamUIMessages.IgnoreLeadingPathSegmentsDialog_numberOutOfRange;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return TeamUIMessages.IgnoreLeadingPathSegmentsDialog_notANumber;
            }
            return null;
        });
        if (dlg.open() == 0 && (newValue = Integer.parseInt(input2 = dlg.getValue())) != oldValue) {
            DiffTree tree = (DiffTree)this.context.getDiffTree();
            tree.clear();
            SubscriberDiffTreeEventHandler handler = (SubscriberDiffTreeEventHandler)this.context.getAdapter(SubscriberDiffTreeEventHandler.class);
            handler.reset();
            this.subscriber.getPatcher().setStripPrefixSegments(newValue);
            this.participant.refresh(this.configuration.getSite().getWorkbenchSite(), this.context.getScope().getMappings());
        }
    }
}

