/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTAttribute;
import org.eclipse.cdt.core.dom.ast.IASTAttributeList;
import org.eclipse.cdt.core.dom.ast.IASTAttributeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

public abstract class ASTAttributeList
extends ASTNode
implements IASTAttributeList {
    protected IASTAttribute[] attributes = IASTAttribute.EMPTY_ATTRIBUTE_ARRAY;

    @Override
    public void addAttribute(IASTAttribute attribute) {
        this.assertNotFrozen();
        if (attribute != null) {
            attribute.setParent(this);
            attribute.setPropertyInParent(IASTAttributeSpecifier.ATTRIBUTE);
            this.attributes = ArrayUtil.append(this.attributes, attribute);
        }
    }

    @Override
    public IASTAttribute[] getAttributes() {
        this.attributes = ArrayUtil.trim(this.attributes);
        return this.attributes;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitAttributes) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        IASTAttribute[] iASTAttributeArray = this.getAttributes();
        int n = iASTAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTAttribute attribute = iASTAttributeArray[n2];
            if (!attribute.accept(action)) {
                return false;
            }
            ++n2;
        }
        return !action.shouldVisitAttributes || action.leave(this) != 2;
    }

    @Override
    protected <T extends ASTAttributeList> T copy(T copy, IASTNode.CopyStyle style) {
        copy.attributes = ArrayUtil.trim(this.attributes, true);
        int i = 0;
        while (i < copy.attributes.length) {
            IASTAttribute attributeCopy = copy.attributes[i].copy(style);
            attributeCopy.setParent(this);
            copy.attributes[i] = attributeCopy;
            ++i;
        }
        return super.copy(copy, style);
    }
}

