/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.mbs;

import com.gigadevice.mbs.Activator;
import com.gigadevice.venustool.TargetOSInfo;
import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

public class OptionBase {
    public static String getOptionStringValue(IConfiguration config, String sOptionId) {
        IOption option = config.getToolChain().getOptionBySuperClassId(sOptionId);
        String sReturn = null;
        if (option != null) {
            try {
                sReturn = option.getStringValue().trim();
            }
            catch (BuildException e) {
                Activator.log(e);
            }
        } else {
            Activator.log("getOptionStringValue returns null. " + sOptionId + " not found");
        }
        return sReturn;
    }

    public static String getOptionEnumCommand(IConfiguration config, String sOptionId) {
        IOption option = config.getToolChain().getOptionBySuperClassId(sOptionId);
        String sReturn = null;
        if (option != null) {
            try {
                String sEnumId = option.getStringValue();
                sReturn = option.getEnumCommand(sEnumId).trim();
            }
            catch (BuildException e) {
                Activator.log(e);
            }
        } else {
            Activator.log("getOptionEnumCommand returns null. " + sOptionId + " not found");
        }
        return sReturn;
    }

    public static Boolean getOptionBooleanValue(IConfiguration config, String sOptionId) {
        IOption option = config.getToolChain().getOptionBySuperClassId(sOptionId);
        Boolean bReturn = null;
        if (option != null) {
            try {
                bReturn = new Boolean(option.getBooleanValue());
            }
            catch (BuildException e) {
                Activator.log(e);
            }
        } else {
            Activator.log("getOptionBooleanValue returns null. " + sOptionId + " not found");
        }
        return bReturn;
    }

    public static String getOptionBooleanCommand(IConfiguration config, String sOptionId) {
        IOption option = config.getToolChain().getOptionBySuperClassId(sOptionId);
        String sReturn = null;
        if (option != null) {
            try {
                if (option.getBooleanValue()) {
                    sReturn = option.getCommand().trim();
                }
            }
            catch (BuildException e) {
                Activator.log(e);
            }
        } else {
            Activator.log("getOptionBooleanCommand returns null. " + sOptionId + " not found");
        }
        return sReturn;
    }

    public static String getOptionIncludePathCommand(IConfiguration config, String sOptionId) {
        IOption option = config.getToolChain().getOptionBySuperClassId(sOptionId);
        String sReturn = null;
        if (option != null) {
            try {
                String[] sReturnArray = option.getIncludePaths();
                String CmdStr = "";
                sReturn = "";
                CmdStr = option.getCommand().trim();
                String[] stringArray = sReturnArray;
                int n = sReturnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String tempStr = stringArray[n2];
                    sReturn = String.valueOf(sReturn) + CmdStr + tempStr + " ";
                    ++n2;
                }
            }
            catch (BuildException e) {
                Activator.log(e);
            }
        } else {
            Activator.log("getOptionIncludePathCommand returns null. " + sOptionId + " not found");
        }
        return sReturn;
    }

    public static String getOptionIncludeFileCommand(IConfiguration config, String sOptionId) {
        IOption option = config.getToolChain().getOptionBySuperClassId(sOptionId);
        String sReturn = null;
        if (option != null) {
            ArrayList v = (ArrayList)option.getValue();
            if (v != null) {
                String CmdStr = "";
                v.trimToSize();
                sReturn = "";
                CmdStr = option.getCommand().trim();
                int i = 0;
                while (i < v.size()) {
                    sReturn = String.valueOf(sReturn) + CmdStr + (String)v.get(i) + " ";
                    ++i;
                }
            }
        } else {
            Activator.log("getOptionIncludeFileCommand returns null. " + sOptionId + " not found");
        }
        return sReturn;
    }

    public static String getOptionDefineSymbolsCommand(IConfiguration config, String sOptionId) {
        IOption option = config.getToolChain().getOptionBySuperClassId(sOptionId);
        String sReturn = null;
        if (option != null) {
            try {
                String[] sReturnArray = option.getDefinedSymbols();
                String CmdStr = "";
                sReturn = "";
                CmdStr = option.getCommand().trim();
                String[] stringArray = sReturnArray;
                int n = sReturnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String tempStr = stringArray[n2];
                    sReturn = String.valueOf(sReturn) + CmdStr + tempStr + " ";
                    ++n2;
                }
            }
            catch (BuildException e) {
                Activator.log(e);
            }
        } else {
            Activator.log("getOptionDefineSymbolsCommand returns null. " + sOptionId + " not found");
        }
        return sReturn;
    }

    public static String getOptionUnDefineSymbolsCommand(IConfiguration config, String sOptionId) {
        IOption option = config.getToolChain().getOptionBySuperClassId(sOptionId);
        String sReturn = null;
        if (option != null) {
            ArrayList v = (ArrayList)option.getValue();
            if (v != null) {
                String CmdStr = "";
                v.trimToSize();
                sReturn = "";
                CmdStr = option.getCommand().trim();
                int i = 0;
                while (i < v.size()) {
                    sReturn = String.valueOf(sReturn) + CmdStr + (String)v.get(i) + " ";
                    ++i;
                }
            }
        } else {
            Activator.log("getOptionUnDefineSymbolsCommand returns null. " + sOptionId + " not found");
        }
        return sReturn;
    }

    public static String getOptionStringCommandValue(IConfiguration config, String sOptionId) {
        IOption option = config.getToolChain().getOptionBySuperClassId(sOptionId);
        String sReturn = null;
        if (option != null) {
            try {
                String sValue = option.getStringValue();
                if (!sValue.isEmpty()) {
                    sReturn = String.valueOf(option.getCommand().trim()) + sValue.trim();
                }
            }
            catch (BuildException e) {
                Activator.log(e);
            }
        } else {
            Activator.log("getOptionStringCommandValue returns null. " + sOptionId + " not found");
        }
        return sReturn;
    }

    public static String getToolsPath() {
        Location l = Platform.getInstallLocation();
        String filePath = l.getURL().toString();
        int start = 0;
        int length = 0;
        if (TargetOSInfo.isWindows()) {
            start = filePath.indexOf("file:/") + 6;
            length = filePath.length() - filePath.indexOf("file:/");
        } else if (TargetOSInfo.isLinux()) {
            start = filePath.indexOf("file:") + 5;
            length = filePath.length() - filePath.indexOf("file:");
        }
        filePath = filePath.substring(start, length);
        String str = "/";
        filePath = filePath.substring(0, filePath.length() - str.length());
        String[] splits = filePath.split("/");
        filePath = splits[0];
        int n = 1;
        while (n < splits.length - 1) {
            filePath = String.valueOf(filePath) + "/" + splits[n];
            ++n;
        }
        return filePath;
    }
}

