/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.mbs;

import com.gigadevice.mbs.ProjectUpdateFile;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.makegen.gnu2.GnuMakefileGenerator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class GDMakefileGenerator
extends GnuMakefileGenerator {
    public static String ARMLinker = "GD ARM MCU Linker";
    public static String ARMCLinker = "GD ARM MCU C Linker";
    public static String ARMCLinkerScriptFileID = "com.gigadevice.mbs.arm.option.linker.general.scriptFile";
    public static String ARMCAddLinker = "GD ARM MCU C++ Linker";
    public static String ARMCAddLinkerScriptFileID = "com.gigadevice.mbs.arm.option.cpp.linker.general.scriptFile";
    public static String RISCVLinker = "GD RISC-V MCU Linker";
    public static String RISCVCLinker = "GD RISC-V MCU C Linker";
    public static String RISCVCLinkerScriptFileID = "com.gigadevice.mbs.riscv.option.linker.general.scriptFile";
    public static String RISCVCAddLinker = "GD RISC-V MCU C++ Linker";
    public static String RISCVCAddLinkerScriptFileID = "com.gigadevice.mbs.riscv.option.cpp.linker.general.scriptFile";

    protected boolean getToolInputsOutputs(ITool tool, Vector<String> inputs, Vector<String> dependencies, Vector<String> outputs, Vector<String> enumeratedPrimaryOutputs, Vector<String> enumeratedSecondaryOutputs, Vector<String> outputVariables, Vector<String> additionalTargets, boolean bTargetTool, Vector<String> managedProjectOutputs) {
        boolean result = super.getToolInputsOutputs(tool, inputs, dependencies, outputs, enumeratedPrimaryOutputs, enumeratedSecondaryOutputs, outputVariables, additionalTargets, bTargetTool, managedProjectOutputs);
        if (result && bTargetTool && this.isLinkerTool(tool)) {
            this.addLinkerScriptDependencies(dependencies);
        }
        return result;
    }

    private boolean isLinkerTool(ITool tool) {
        String toolName = tool.getName();
        return toolName != null && (toolName.equals(ARMLinker) || toolName.equals(ARMCLinker) || toolName.equals(ARMCAddLinker) || toolName.equals(RISCVLinker) || toolName.equals(RISCVCLinker) || toolName.equals(RISCVCAddLinker));
    }

    private void addLinkerScriptDependencies(Vector<String> dependencies) {
        try {
            String[] linkerScripts = this.getLinkerScriptsFromConfiguration();
            if (linkerScripts != null && linkerScripts.length > 0) {
                String ldString = linkerScripts[linkerScripts.length - 1];
                ldString = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(ldString, "", " ", 3, (Object)this.getConfig());
                if (!(ldString = this.ensurePathIsGNUMakeTargetRuleCompatibleSyntax(ldString)).replace('\\', '/').contains("/")) {
                    IProject project = this.getConfig().getOwner().getProject();
                    ldString = ProjectUpdateFile.parseLdFilePath(project.getLocation().toOSString(), ldString);
                }
                if (!dependencies.contains(ldString)) {
                    dependencies.add(ldString);
                }
            }
        }
        catch (Exception e) {
            System.err.println("\u5a23\u8bf2\u59de\u95be\u70ac\u5e34\u9363\u3128\u527c\u93c8\ue0ff\u7df7\u74a7\u6828\u6902\u9351\u6d2a\u654a: " + e.getMessage());
        }
    }

    private String[] getLinkerScriptsFromConfiguration() {
        block15: {
            try {
                IOption[] options;
                IConfiguration config = this.getConfig();
                ITool linkerTool = config.calculateTargetTool();
                if (linkerTool == null) break block15;
                IOption[] iOptionArray = options = linkerTool.getOptions();
                int n = options.length;
                int n2 = 0;
                while (n2 < n) {
                    IOption option = iOptionArray[n2];
                    if (option != null) {
                        String idString = "";
                        if (linkerTool.getName().equals(ARMLinker) || linkerTool.getName().equals(ARMCLinker)) {
                            idString = ARMCLinkerScriptFileID;
                        } else if (linkerTool.getName().equals(ARMCAddLinker)) {
                            idString = ARMCAddLinkerScriptFileID;
                        } else if (linkerTool.getName().equals(RISCVLinker) || linkerTool.getName().equals(RISCVCLinker)) {
                            idString = RISCVCLinkerScriptFileID;
                        } else if (linkerTool.getName().equals(RISCVCAddLinker)) {
                            idString = RISCVCAddLinkerScriptFileID;
                        }
                        if (option.getSuperClass().getId().equals(idString)) {
                            try {
                                String[] LdFilePathList = option.getStringListValue();
                                if (LdFilePathList.length > 0) {
                                    return LdFilePathList;
                                }
                            }
                            catch (BuildException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                System.err.println("\u947e\u5cf0\u5f47\u95be\u70ac\u5e34\u9363\u3128\u527c\u93c8\ue104\u53a4\u7f03\ue1bd\u6902\u9351\u6d2a\u654a: " + e.getMessage());
            }
        }
        return null;
    }

    private void findLinkerScriptsInContainer(IContainer container, Vector<IPath> scripts) {
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getType() == 1) {
                    String ext = resource.getFileExtension();
                    if ("ld".equals(ext) || "lds".equals(ext) || "ldscript".equals(ext)) {
                        scripts.add(resource.getProjectRelativePath());
                    }
                } else if (resource.getType() == 2 && !this.isGeneratedResource(resource)) {
                    this.findLinkerScriptsInContainer((IContainer)resource, scripts);
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
    }
}

