/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.managedbuilder.buildproperties.IOptionalBuildProperties;

public class OptionalBuildProperties
implements IOptionalBuildProperties {
    public static final String PROPERTY_VALUE_SEPARATOR = "=";
    public static final String PROPERTIES_SEPARATOR = ",";
    private Map<String, String> fProperties = new HashMap<String, String>();

    public OptionalBuildProperties() {
    }

    public OptionalBuildProperties(String properties) {
        StringTokenizer t = new StringTokenizer(properties, PROPERTIES_SEPARATOR);
        while (t.hasMoreTokens()) {
            String value;
            String id;
            String property = t.nextToken();
            int index = property.indexOf(PROPERTY_VALUE_SEPARATOR);
            if (index != -1) {
                id = SafeStringInterner.safeIntern((String)property.substring(0, index));
                value = SafeStringInterner.safeIntern((String)property.substring(index + 1));
            } else {
                id = SafeStringInterner.safeIntern((String)property);
                value = null;
            }
            this.fProperties.put(id, value);
        }
    }

    public OptionalBuildProperties(OptionalBuildProperties properties) {
        this.fProperties.putAll(properties.fProperties);
    }

    @Override
    public String getProperty(String id) {
        return this.fProperties.get(id);
    }

    @Override
    public void setProperty(String id, String value) {
        this.fProperties.put(id, value);
    }

    @Override
    public String[] getProperties() {
        return this.fProperties.values().toArray(new String[this.fProperties.size()]);
    }

    @Override
    public void removeProperty(String id) {
        this.fProperties.remove(id);
    }

    public String toString() {
        int size = this.fProperties.size();
        Set<Map.Entry<String, String>> entries = this.fProperties.entrySet();
        if (size == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = entries.iterator();
        Map.Entry<String, String> entry = iterator.next();
        buf.append(String.valueOf(entry.getKey()) + PROPERTY_VALUE_SEPARATOR + entry.getValue());
        while (iterator.hasNext()) {
            buf.append(PROPERTIES_SEPARATOR);
            entry = iterator.next();
            buf.append(String.valueOf(entry.getKey()) + PROPERTY_VALUE_SEPARATOR + entry.getValue());
        }
        return buf.toString();
    }

    @Override
    public Object clone() {
        return new OptionalBuildProperties(this);
    }

    @Override
    public void clear() {
        this.fProperties.clear();
    }
}

