/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.clockconfigview.utils;

import com.gigadevice.clockconfigview.RCUClockSource;
import com.gigadevice.clockconfigview.info.RCUConfigControl;
import com.gigadevice.clockconfigview.info.RCUConfigImage;
import com.gigadevice.clockconfigview.utils.RCURelateUtil;
import com.gigadevice.logging.ide.LogManager;
import com.gigadevice.venustool.GeneralPathUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.clockconfiginfo.RCUCondition;
import com.gigadevice.venustool.clockconfiginfo.RCUConfigControlGroup;
import com.gigadevice.venustool.clockconfiginfo.RCUConfigInfo_Abstract;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RCUTreeUtil {
    public static String RCUFilePath;
    public static String RCUImageName;
    public static Double RCUImageInitialSize;
    public static Double RCUImageMinSize;
    public static Double RCUImageMaxSize;
    public static boolean OnlyInitBeforeUI;
    public static Map<String, String> RCUUserConfigInfoMap;
    public static Map<String, String> RCUUserConfigInfoMapfromT;
    public static boolean CheckValid;
    public static final String Oper_Division = "DIVISION";
    public static final String Oper_Multiply = "MULTIPLY";
    public static Set<RCUConfigImage> TempRCUConfigImageList;
    public static Map<String, RCUConfigControl> TempRCUConfigControlMap;
    public static Map<String, com.gigadevice.clockconfigview.info.RCUConfigControlGroup> TempRCUConfigControlGroupMap;
    public static Map<String, RCUClockSource> TempRCUClockSourceMap;
    static Map<String, RCUConfigInfo_Abstract> TemphasSetValueMap;

    static {
        OnlyInitBeforeUI = false;
        RCUUserConfigInfoMap = new HashMap<String, String>();
        RCUUserConfigInfoMapfromT = new HashMap<String, String>();
        CheckValid = true;
        TempRCUConfigImageList = new HashSet<RCUConfigImage>();
        TempRCUConfigControlMap = new HashMap<String, RCUConfigControl>();
        TempRCUConfigControlGroupMap = new HashMap<String, com.gigadevice.clockconfigview.info.RCUConfigControlGroup>();
        TempRCUClockSourceMap = new HashMap<String, RCUClockSource>();
        TemphasSetValueMap = new HashMap<String, RCUConfigInfo_Abstract>();
    }

    public static boolean isOnlyInitBeforeUI() {
        return OnlyInitBeforeUI;
    }

    public static void setOnlyInitBeforeUI(boolean onlyInitBeforeUI) {
        OnlyInitBeforeUI = onlyInitBeforeUI;
    }

    public static void InitAllGlobalVars() {
        RCUTreeUtil.setOnlyInitBeforeUI(true);
        RCUTreeUtil.InitRCUFilePath();
        RCUTreeUtil.InitControlsValueDisplay();
        RCUTreeUtil.setOnlyInitBeforeUI(false);
    }

    public static void LoadAllGlobalVars() {
        RCUTreeUtil.setOnlyInitBeforeUI(true);
        RCUTreeUtil.UpdateUserInfoValuetoMap();
        RCUTreeUtil.setOnlyInitBeforeUI(false);
    }

    public static boolean InitControlsValueDisplay() {
        boolean ret = true;
        if (RCUCondition.RCUClockSourceMap.size() > 0) {
            for (Map.Entry entry : RCUCondition.RCUClockSourceMap.entrySet()) {
                com.gigadevice.venustool.clockconfiginfo.RCUClockSource rCUClockSource;
                String unitString;
                if (entry.getValue() == null || (ret = (unitString = (rCUClockSource = (com.gigadevice.venustool.clockconfiginfo.RCUClockSource)entry.getValue()).getUnit()).equals("K") ? RCUTreeUtil.SetControlsValuebyInputName((String)entry.getKey(), ((com.gigadevice.venustool.clockconfiginfo.RCUClockSource)entry.getValue()).getValue() / 1000.0, false, CheckValid) : RCUTreeUtil.SetControlsValuebyInputName((String)entry.getKey(), ((com.gigadevice.venustool.clockconfiginfo.RCUClockSource)entry.getValue()).getValue(), false, CheckValid))) continue;
                return ret;
            }
        }
        return ret;
    }

    public static boolean InitRCUFilePath() {
        com.gigadevice.venustool.clockconfiginfo.RCUConfigControl TempObj;
        String BorderWidth;
        RCUTreeUtil.setOnlyInitBeforeUI(true);
        RCURelateUtil.InitRCUConditionFile();
        RCUFilePath = String.valueOf(GeneralPathUtil.ResourcePath) + GlobalVariables.McuSeletorInfo.getRCUPath();
        File f = new File(RCUFilePath);
        if (!f.exists()) {
            return false;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builder = factory.newDocumentBuilder();
            doc = builder.parse(f);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (doc == null) {
            return false;
        }
        NodeList RCUImagesList = doc.getElementsByTagName("RCUImages");
        if (RCUImagesList == null) {
            return false;
        }
        int RCUImagesNum = RCUImagesList.getLength();
        int i = 0;
        while (i < RCUImagesNum) {
            String NodeName;
            Node RCUImageNode = RCUImagesList.item(i);
            if (RCUImageNode != null) {
                RCUTreeUtil.removeTextNode(RCUImageNode);
            }
            if (RCUImageNode != null && RCUImageNode.getNodeType() == 1 && (NodeName = RCUImageNode.getNodeName()).equals("RCUImages")) {
                Node ImageNode = RCUImageNode.getFirstChild();
                while (ImageNode != null) {
                    String Name = null;
                    if (ImageNode.getAttributes().getNamedItem("Name") != null) {
                        Name = ImageNode.getAttributes().getNamedItem("Name").getNodeValue();
                    }
                    String PositionX = null;
                    if (ImageNode.getAttributes().getNamedItem("PositionX") != null) {
                        PositionX = ImageNode.getAttributes().getNamedItem("PositionX").getNodeValue();
                    }
                    String PositionY = null;
                    if (ImageNode.getAttributes().getNamedItem("PositionY") != null) {
                        PositionY = ImageNode.getAttributes().getNamedItem("PositionY").getNodeValue();
                    }
                    String InitialSize = null;
                    if (ImageNode.getAttributes().getNamedItem("InitialSize") != null) {
                        InitialSize = ImageNode.getAttributes().getNamedItem("InitialSize").getNodeValue();
                    }
                    String MinSize = null;
                    if (ImageNode.getAttributes().getNamedItem("MinSize") != null) {
                        MinSize = ImageNode.getAttributes().getNamedItem("MinSize").getNodeValue();
                    }
                    String MaxSize = null;
                    if (ImageNode.getAttributes().getNamedItem("MaxSize") != null) {
                        MaxSize = ImageNode.getAttributes().getNamedItem("MaxSize").getNodeValue();
                    }
                    com.gigadevice.venustool.clockconfiginfo.RCUConfigImage TempObj2 = new com.gigadevice.venustool.clockconfiginfo.RCUConfigImage();
                    TempObj2.setName(Name);
                    TempObj2.setPositionX(PositionX);
                    TempObj2.setPositionY(PositionY);
                    TempObj2.setInitialSize(InitialSize);
                    TempObj2.setMinSize(MinSize);
                    TempObj2.setMaxSize(MaxSize);
                    RCUImageName = Name;
                    RCUImageInitialSize = TempObj2.getInitialSize();
                    RCUImageMinSize = TempObj2.getMinSize();
                    RCUImageMaxSize = TempObj2.getMaxSize();
                    RCUCondition.RCUConfigImageList.add(TempObj2);
                    ImageNode = ImageNode.getNextSibling();
                }
            }
            ++i;
        }
        NodeList RCUControlsList = doc.getElementsByTagName("Controls");
        if (RCUControlsList == null) {
            return false;
        }
        int RCUControlsNum = RCUControlsList.getLength();
        int i2 = 0;
        while (i2 < RCUControlsNum) {
            String NodeName;
            Node RCUControlsNode = RCUControlsList.item(i2);
            if (RCUControlsNode != null) {
                RCUTreeUtil.removeTextNode(RCUControlsNode);
            }
            if (RCUControlsNode != null && RCUControlsNode.getNodeType() == 1 && (NodeName = RCUControlsNode.getNodeName()).equals("Controls")) {
                Node RCUControlUnitNode = RCUControlsNode.getFirstChild();
                while (RCUControlUnitNode != null) {
                    String Type2;
                    String Name;
                    if (RCUControlUnitNode.getNodeName().equals("Control")) {
                        Name = null;
                        if (RCUControlUnitNode.getAttributes().getNamedItem("Name") != null) {
                            Name = RCUControlUnitNode.getAttributes().getNamedItem("Name").getNodeValue();
                        }
                        Type2 = null;
                        if (RCUControlUnitNode.getAttributes().getNamedItem("Type") != null) {
                            Type2 = RCUControlUnitNode.getAttributes().getNamedItem("Type").getNodeValue();
                        }
                        String Oper = null;
                        if (RCUControlUnitNode.getAttributes().getNamedItem("Oper") != null) {
                            Oper = RCUControlUnitNode.getAttributes().getNamedItem("Oper").getNodeValue();
                        }
                        String ClockOutputName = null;
                        if (RCUControlUnitNode.getAttributes().getNamedItem("ClockOutputName") != null) {
                            ClockOutputName = RCUControlUnitNode.getAttributes().getNamedItem("ClockOutputName").getNodeValue();
                        }
                        String ClockInputName = null;
                        if (RCUControlUnitNode.getAttributes().getNamedItem("ClockInputName") != null) {
                            ClockInputName = RCUControlUnitNode.getAttributes().getNamedItem("ClockInputName").getNodeValue();
                        }
                        String MaxValue = null;
                        if (RCUControlUnitNode.getAttributes().getNamedItem("MaxValue") != null && (MaxValue = RCUControlUnitNode.getAttributes().getNamedItem("MaxValue").getNodeValue()).equals("")) {
                            MaxValue = null;
                        }
                        String MinValue = null;
                        if (RCUControlUnitNode.getAttributes().getNamedItem("MinValue") != null && (MinValue = RCUControlUnitNode.getAttributes().getNamedItem("MinValue").getNodeValue()).equals("")) {
                            MinValue = null;
                        }
                        String IntervalValue = null;
                        if (RCUControlUnitNode.getAttributes().getNamedItem("IntervalValue") != null && (IntervalValue = RCUControlUnitNode.getAttributes().getNamedItem("IntervalValue").getNodeValue()).equals("")) {
                            IntervalValue = null;
                        }
                        String Location2 = null;
                        if (RCUControlUnitNode.getAttributes().getNamedItem("Location") != null) {
                            Location2 = RCUControlUnitNode.getAttributes().getNamedItem("Location").getNodeValue();
                        }
                        String ReadOnly = null;
                        if (RCUControlUnitNode.getAttributes().getNamedItem("ReadOnly") != null) {
                            ReadOnly = RCUControlUnitNode.getAttributes().getNamedItem("ReadOnly").getNodeValue();
                        }
                        String PositionX = null;
                        if (RCUControlUnitNode.getAttributes().getNamedItem("PositionX") != null) {
                            PositionX = RCUControlUnitNode.getAttributes().getNamedItem("PositionX").getNodeValue();
                        }
                        String PositionY = null;
                        if (RCUControlUnitNode.getAttributes().getNamedItem("PositionY") != null) {
                            PositionY = RCUControlUnitNode.getAttributes().getNamedItem("PositionY").getNodeValue();
                        }
                        String TipText_NA = null;
                        if (RCUControlUnitNode.getAttributes().getNamedItem("TipText_NA") != null) {
                            TipText_NA = RCUControlUnitNode.getAttributes().getNamedItem("TipText_NA").getNodeValue();
                        }
                        String TipText = null;
                        if (RCUControlUnitNode.getAttributes().getNamedItem("TipText") != null) {
                            TipText = RCUControlUnitNode.getAttributes().getNamedItem("TipText").getNodeValue();
                        }
                        BorderWidth = null;
                        if (RCUControlUnitNode.getAttributes().getNamedItem("BorderWidth") != null) {
                            BorderWidth = RCUControlUnitNode.getAttributes().getNamedItem("BorderWidth").getNodeValue();
                        }
                        TempObj = new com.gigadevice.venustool.clockconfiginfo.RCUConfigControl();
                        TempObj.setName(Name);
                        TempObj.setType(Type2);
                        TempObj.setOper(Oper);
                        TempObj.setClockOutputName(ClockOutputName);
                        TempObj.setClockInputName(ClockInputName);
                        TempObj.setLocation(Location2);
                        TempObj.setPositionX(PositionX);
                        TempObj.setPositionY(PositionY);
                        TempObj.setReadOnly(ReadOnly);
                        TempObj.setMaxValue(MaxValue);
                        TempObj.setMinValue(MinValue);
                        TempObj.setTipText_NA(TipText_NA);
                        TempObj.setTipText(TipText);
                        TempObj.setIntervalValue(IntervalValue);
                        TempObj.setBorderWidth(BorderWidth);
                        Node RCUControlChildUnitNode = RCUControlUnitNode.getFirstChild();
                        while (RCUControlChildUnitNode != null) {
                            RCUControlChildUnitNode.getNodeName();
                            if (RCUControlChildUnitNode.getNodeName().equals("EnumValues")) {
                                Node EnumValueNode = RCUControlChildUnitNode.getFirstChild();
                                while (EnumValueNode != null) {
                                    if (EnumValueNode.getNodeName().equals("EnumValue")) {
                                        String Value = null;
                                        if (EnumValueNode.getAttributes().getNamedItem("Value") != null) {
                                            Value = EnumValueNode.getAttributes().getNamedItem("Value").getNodeValue();
                                        }
                                        String Default = null;
                                        if (EnumValueNode.getAttributes().getNamedItem("Default") != null) {
                                            Default = EnumValueNode.getAttributes().getNamedItem("Default").getNodeValue();
                                        }
                                        String Macro = null;
                                        if (EnumValueNode.getAttributes().getNamedItem("Macro") != null) {
                                            Macro = EnumValueNode.getAttributes().getNamedItem("Macro").getNodeValue();
                                        }
                                        String RelateControl = null;
                                        if (EnumValueNode.getAttributes().getNamedItem("RelateControl") != null) {
                                            RelateControl = EnumValueNode.getAttributes().getNamedItem("RelateControl").getNodeValue();
                                        }
                                        String RelateControlValue = null;
                                        if (EnumValueNode.getAttributes().getNamedItem("RelateControlValue") != null) {
                                            RelateControlValue = EnumValueNode.getAttributes().getNamedItem("RelateControlValue").getNodeValue();
                                        }
                                        String OperType = null;
                                        if (EnumValueNode.getAttributes().getNamedItem("OperType") != null) {
                                            OperType = EnumValueNode.getAttributes().getNamedItem("OperType").getNodeValue();
                                        }
                                        String EnumValueContent = EnumValueNode.getTextContent();
                                        if (Default != null && Default.toUpperCase().equals("TRUE")) {
                                            TempObj.setDisplayText(EnumValueContent);
                                        }
                                        TempObj.InsertEnumValueItem(Value, Default, EnumValueContent, Macro, OperType, RelateControl, RelateControlValue);
                                    }
                                    EnumValueNode = EnumValueNode.getNextSibling();
                                }
                            }
                            RCUControlChildUnitNode = RCUControlChildUnitNode.getNextSibling();
                        }
                        RCUTreeUtil.AttributeChange(Name, TempObj);
                        RCUCondition.RCUConfigControlMap.put(TempObj.getName(), TempObj);
                    } else if (RCUControlUnitNode.getNodeName().equals("ControlGroup")) {
                        Name = null;
                        if (RCUControlUnitNode.getAttributes().getNamedItem("Name") != null) {
                            Name = RCUControlUnitNode.getAttributes().getNamedItem("Name").getNodeValue();
                        }
                        Type2 = null;
                        if (RCUControlUnitNode.getAttributes().getNamedItem("Type") != null) {
                            Type2 = RCUControlUnitNode.getAttributes().getNamedItem("Type").getNodeValue();
                        }
                        String ClockOutputName = null;
                        if (RCUControlUnitNode.getAttributes().getNamedItem("ClockOutputName") != null) {
                            ClockOutputName = RCUControlUnitNode.getAttributes().getNamedItem("ClockOutputName").getNodeValue();
                        }
                        String Location3 = null;
                        if (RCUControlUnitNode.getAttributes().getNamedItem("Location") != null) {
                            Location3 = RCUControlUnitNode.getAttributes().getNamedItem("Location").getNodeValue();
                        }
                        String BorderWidth2 = null;
                        if (RCUControlUnitNode.getAttributes().getNamedItem("BorderWidth") != null) {
                            BorderWidth2 = RCUControlUnitNode.getAttributes().getNamedItem("BorderWidth").getNodeValue();
                        }
                        RCUConfigControlGroup TempObj3 = new RCUConfigControlGroup();
                        TempObj3.setName(Name);
                        TempObj3.setClockOutputName(ClockOutputName);
                        TempObj3.setLocation(Location3);
                        TempObj3.setType(Type2);
                        TempObj3.setBorderWidth(BorderWidth2);
                        Node ControlGroupChildNode = RCUControlUnitNode.getFirstChild();
                        while (ControlGroupChildNode != null) {
                            if (ControlGroupChildNode.getNodeName().equals("Control")) {
                                String ControlName = null;
                                if (ControlGroupChildNode.getAttributes().getNamedItem("Name") != null) {
                                    ControlName = ControlGroupChildNode.getAttributes().getNamedItem("Name").getNodeValue();
                                }
                                String ClockInputName = null;
                                if (ControlGroupChildNode.getAttributes().getNamedItem("ClockInputName") != null) {
                                    ClockInputName = ControlGroupChildNode.getAttributes().getNamedItem("ClockInputName").getNodeValue();
                                }
                                String PositionX = null;
                                if (ControlGroupChildNode.getAttributes().getNamedItem("PositionX") != null) {
                                    PositionX = ControlGroupChildNode.getAttributes().getNamedItem("PositionX").getNodeValue();
                                }
                                String PositionY = null;
                                if (ControlGroupChildNode.getAttributes().getNamedItem("PositionY") != null) {
                                    PositionY = ControlGroupChildNode.getAttributes().getNamedItem("PositionY").getNodeValue();
                                }
                                String Default = null;
                                if (ControlGroupChildNode.getAttributes().getNamedItem("Default") != null) {
                                    Default = ControlGroupChildNode.getAttributes().getNamedItem("Default").getNodeValue();
                                }
                                String Value = null;
                                if (ControlGroupChildNode.getAttributes().getNamedItem("Value") != null) {
                                    Value = ControlGroupChildNode.getAttributes().getNamedItem("Value").getNodeValue();
                                }
                                String Macro = null;
                                if (ControlGroupChildNode.getAttributes().getNamedItem("Macro") != null) {
                                    Macro = ControlGroupChildNode.getAttributes().getNamedItem("Macro").getNodeValue();
                                }
                                String TipText_NA = null;
                                if (ControlGroupChildNode.getAttributes().getNamedItem("TipText_NA") != null) {
                                    TipText_NA = ControlGroupChildNode.getAttributes().getNamedItem("TipText_NA").getNodeValue();
                                }
                                String TipText = null;
                                if (ControlGroupChildNode.getAttributes().getNamedItem("TipText") != null) {
                                    TipText = ControlGroupChildNode.getAttributes().getNamedItem("TipText").getNodeValue();
                                }
                                TempObj3.insertControltoGroup(ControlName, ClockInputName, PositionX, PositionY, Value, Default, Macro, TipText_NA, TipText);
                            }
                            ControlGroupChildNode = ControlGroupChildNode.getNextSibling();
                        }
                        RCUTreeUtil.AttributeChange(Name, TempObj3);
                        RCUCondition.RCUConfigControlGroupMap.put(TempObj3.getName(), TempObj3);
                    }
                    RCUControlUnitNode = RCUControlUnitNode.getNextSibling();
                }
            }
            ++i2;
        }
        NodeList RCUClockSourcesList = doc.getElementsByTagName("ClockSources");
        if (RCUControlsList.getLength() == 0) {
            return false;
        }
        int RCUClockSourceNum = RCUClockSourcesList.getLength();
        int i3 = 0;
        while (i3 < RCUClockSourceNum) {
            String NodeName;
            Node RCUClockSourceNode = RCUClockSourcesList.item(i3);
            if (RCUClockSourceNode != null) {
                RCUTreeUtil.removeTextNode(RCUClockSourceNode);
            }
            if (RCUClockSourceNode != null && RCUClockSourceNode.getNodeType() == 1 && (NodeName = RCUClockSourceNode.getNodeName()).equals("ClockSources")) {
                Node RCUClockSourceUnitNode = RCUClockSourceNode.getFirstChild();
                while (RCUClockSourceUnitNode != null) {
                    if (RCUClockSourceUnitNode.getNodeName().equals("ClockSource")) {
                        String Name = null;
                        if (RCUClockSourceUnitNode.getAttributes().getNamedItem("Name") != null) {
                            Name = RCUClockSourceUnitNode.getAttributes().getNamedItem("Name").getNodeValue();
                        }
                        String Value = null;
                        if (RCUClockSourceUnitNode.getAttributes().getNamedItem("Value") != null) {
                            Value = RCUClockSourceUnitNode.getAttributes().getNamedItem("Value").getNodeValue();
                        }
                        String Unit = null;
                        if (RCUClockSourceUnitNode.getAttributes().getNamedItem("Unit") != null) {
                            Unit = RCUClockSourceUnitNode.getAttributes().getNamedItem("Unit").getNodeValue();
                        }
                        String MinValue = null;
                        if (RCUClockSourceUnitNode.getAttributes().getNamedItem("MinValue") != null && (MinValue = RCUClockSourceUnitNode.getAttributes().getNamedItem("MinValue").getNodeValue()).equals("")) {
                            MinValue = null;
                        }
                        String MaxValue = null;
                        if (RCUClockSourceUnitNode.getAttributes().getNamedItem("MaxValue") != null && (MaxValue = RCUClockSourceUnitNode.getAttributes().getNamedItem("MaxValue").getNodeValue()).equals("")) {
                            MaxValue = null;
                        }
                        String Location4 = null;
                        if (RCUClockSourceUnitNode.getAttributes().getNamedItem("Location") != null) {
                            Location4 = RCUClockSourceUnitNode.getAttributes().getNamedItem("Location").getNodeValue();
                        }
                        String PositionX = null;
                        if (RCUClockSourceUnitNode.getAttributes().getNamedItem("PositionX") != null) {
                            PositionX = RCUClockSourceUnitNode.getAttributes().getNamedItem("PositionX").getNodeValue();
                        }
                        String PositionY = null;
                        if (RCUClockSourceUnitNode.getAttributes().getNamedItem("PositionY") != null) {
                            PositionY = RCUClockSourceUnitNode.getAttributes().getNamedItem("PositionY").getNodeValue();
                        }
                        String Type3 = null;
                        if (RCUClockSourceUnitNode.getAttributes().getNamedItem("Type") != null) {
                            Type3 = RCUClockSourceUnitNode.getAttributes().getNamedItem("Type").getNodeValue();
                        }
                        String ReadOnly = null;
                        if (RCUClockSourceUnitNode.getAttributes().getNamedItem("ReadOnly") != null) {
                            ReadOnly = RCUClockSourceUnitNode.getAttributes().getNamedItem("ReadOnly").getNodeValue();
                        }
                        String TipText = null;
                        if (RCUClockSourceUnitNode.getAttributes().getNamedItem("TipText") != null) {
                            TipText = RCUClockSourceUnitNode.getAttributes().getNamedItem("TipText").getNodeValue();
                        }
                        String TipText_NA = null;
                        if (RCUClockSourceUnitNode.getAttributes().getNamedItem("TipText_NA") != null) {
                            TipText_NA = RCUClockSourceUnitNode.getAttributes().getNamedItem("TipText_NA").getNodeValue();
                        }
                        BorderWidth = null;
                        if (RCUClockSourceUnitNode.getAttributes().getNamedItem("BorderWidth") != null) {
                            BorderWidth = RCUClockSourceUnitNode.getAttributes().getNamedItem("BorderWidth").getNodeValue();
                        }
                        TempObj = new com.gigadevice.venustool.clockconfiginfo.RCUClockSource();
                        TempObj.setName(Name);
                        TempObj.setValue(Value);
                        TempObj.setControlInitValue(Value);
                        TempObj.setControlCurrentTextValue(Value);
                        TempObj.setUnit(Unit);
                        TempObj.setMaxValue(MaxValue);
                        TempObj.setLocation(Location4);
                        TempObj.setMinValue(MinValue);
                        TempObj.setReadOnly(ReadOnly);
                        TempObj.setPositionX(PositionX);
                        TempObj.setPositionY(PositionY);
                        TempObj.setType(Type3);
                        TempObj.setTipText(TipText);
                        TempObj.setTipText_NA(TipText_NA);
                        TempObj.setBorderWidth(BorderWidth);
                        RCUTreeUtil.AttributeChange(Name, TempObj);
                        RCUCondition.RCUClockSourceMap.put(TempObj.getName(), TempObj);
                    }
                    RCUClockSourceUnitNode = RCUClockSourceUnitNode.getNextSibling();
                }
            }
            ++i3;
        }
        RCURelateUtil.UpdatePropertyBeforeLoad();
        return true;
    }

    private static void removeTextNode(Node root) {
        if (root.hasChildNodes()) {
            NodeList children = root.getChildNodes();
            int count = children.getLength();
            int i = count - 1;
            while (i >= 0) {
                Node child = children.item(i);
                if (child.getNodeType() == 3) {
                    child.getParentNode().removeChild(child);
                }
                --i;
            }
        }
    }

    public static LinkedHashSet<String> GetEnumValueSet(String name) {
        LinkedHashSet ItemList = new LinkedHashSet();
        com.gigadevice.venustool.clockconfiginfo.RCUConfigControl Obj = (com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)RCUCondition.RCUConfigControlMap.get(name);
        if (Obj != null) {
            ItemList = Obj.GetEnumValueSet();
        }
        return ItemList;
    }

    public static void BackupMaptoTemp() {
        RCUCondition.TempRCUConfigControlMap = RCUTreeUtil.cloneFrom(RCUCondition.RCUConfigControlMap);
        RCUCondition.TempRCUConfigControlGroupMap = RCUTreeUtil.cloneFrom(RCUCondition.RCUConfigControlGroupMap);
        RCUCondition.TempRCUClockSourceMap = RCUTreeUtil.cloneFrom(RCUCondition.RCUClockSourceMap);
    }

    public static void CopyTempMap() {
        RCUCondition.RCUConfigControlMap = RCUTreeUtil.cloneFrom(RCUCondition.TempRCUConfigControlMap);
        RCUCondition.RCUConfigControlGroupMap = RCUTreeUtil.cloneFrom(RCUCondition.TempRCUConfigControlGroupMap);
        RCUCondition.RCUClockSourceMap = RCUTreeUtil.cloneFrom(RCUCondition.TempRCUClockSourceMap);
    }

    public static Component GetComponentbyName(String name) {
        com.gigadevice.venustool.clockconfiginfo.RCUConfigControl Obj;
        Component ObjComp = null;
        if (RCUCondition.RCUConfigControlMap.size() > 0 && (Obj = (com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)RCUCondition.RCUConfigControlMap.get(name)) != null) {
            ObjComp = Obj.getControlComponent();
            return ObjComp;
        }
        if (RCUCondition.RCUConfigControlGroupMap.size() > 0 && (Obj = (RCUConfigControlGroup)RCUCondition.RCUConfigControlGroupMap.get(name)) != null) {
            ObjComp = Obj.getControlComponent(name);
            return ObjComp;
        }
        if (RCUCondition.RCUClockSourceMap.size() > 0 && (Obj = (com.gigadevice.venustool.clockconfiginfo.RCUClockSource)RCUCondition.RCUClockSourceMap.get(name)) != null) {
            ObjComp = Obj.getControlComponent();
            return ObjComp;
        }
        return null;
    }

    public static String GetClockInputNamebyName(String name) {
        RCUConfigInfo_Abstract ObjClass = RCUCondition.GetRCUClassTypebyName((String)name);
        String InputName = null;
        if (ObjClass != null) {
            InputName = ObjClass.getClockInputName(name);
        }
        return InputName;
    }

    public static String GetClockOutputNamebyName(String name) {
        RCUConfigInfo_Abstract ObjClass = RCUCondition.GetRCUClassTypebyName((String)name);
        String OutputName = null;
        if (ObjClass != null) {
            OutputName = ObjClass.getClockOutputName();
        }
        return OutputName;
    }

    public static boolean SetControlsValuebyInputName(String InputName, double Value, boolean isFindSelf, boolean isCheck) {
        boolean ret = true;
        if (RCUCondition.RCUConfigControlMap.size() > 0) {
            for (Map.Entry entry : RCUCondition.RCUConfigControlMap.entrySet()) {
                JComponent Comp;
                if (entry.getValue() == null || isFindSelf && ((String)entry.getKey()).equals(InputName) || ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getClockInputName((String)entry.getKey()) == null) continue;
                String inputNameTemp = ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getClockInputName((String)entry.getKey());
                Vector<String> inputNameTempVector = new Vector<String>();
                if (inputNameTemp.contains(",")) {
                    String[] arr = inputNameTemp.split(",");
                    int i = 0;
                    while (i < arr.length) {
                        inputNameTempVector.add(arr[i]);
                        ++i;
                    }
                }
                if (!((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getClockInputName((String)entry.getKey()).equals(InputName) && !inputNameTempVector.contains(InputName)) continue;
                if (inputNameTempVector.size() != 0) {
                    if (!RCUTreeUtil.isOnlyInitBeforeUI()) {
                        JTextField Comp1 = (JTextField)((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getControlComponent();
                        if (Comp1 != null) {
                            if (!RCUTreeUtil.InitControlsValueDisplay_HasFunc((String)entry.getKey())) {
                                return false;
                            }
                            String TempValue = Comp1.getText();
                            if (((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getClockOutputName().equals("")) continue;
                            ret = RCUTreeUtil.SetControlsValuebyInputName((String)entry.getKey(), Double.parseDouble(TempValue), true, isCheck);
                            if (!ret) {
                                return false;
                            }
                        }
                    } else {
                        if (!RCUTreeUtil.InitControlsValueDisplay_HasFunc((String)entry.getKey())) {
                            return false;
                        }
                        String TempValue = ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getControlCurrentTextValue();
                        if (TempValue == null) {
                            System.out.println(String.valueOf((String)entry.getKey()) + " " + TempValue);
                        }
                        if (((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getClockOutputName().equals("")) continue;
                        ret = RCUTreeUtil.SetControlsValuebyInputName((String)entry.getKey(), Double.parseDouble(TempValue), true, isCheck);
                        if (!ret) {
                            return false;
                        }
                    }
                    return true;
                }
                if (((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getType().toUpperCase().equals("COMBO")) {
                    double TempValue = 0.0;
                    ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).setControlInputValue(Value);
                    String TempItem = RCUTreeUtil.isOnlyInitBeforeUI() ? ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getDisplayText() : (String)((JComboBox)((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getControlComponent()).getSelectedItem();
                    if (((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getOper().toUpperCase().equals(Oper_Multiply)) {
                        TempValue = Value * ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).GetValueinEnumItems(TempItem);
                    } else if (((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getOper().toUpperCase().equals(Oper_Division)) {
                        TempValue = Value / ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).GetValueinEnumItems(TempItem);
                    }
                    if (!((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).setControlCurrentValue(TempValue, isCheck)) {
                        return false;
                    }
                    ret = RCUTreeUtil.SetControlsValuebyInputName((String)entry.getKey(), TempValue, true, isCheck);
                    if (ret) continue;
                    return false;
                }
                if (((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getType().toUpperCase().equals("EDIT")) {
                    ret = ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).setControlCurrentValue(Value, isCheck);
                    if (!ret) {
                        return false;
                    }
                    Comp = null;
                    if (!RCUTreeUtil.isOnlyInitBeforeUI()) {
                        Comp = (JTextField)((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getControlComponent();
                    }
                    boolean isRelate = false;
                    if (RCURelateUtil.GetControlType((String)entry.getKey()) == 2) {
                        List<String> TextList = RCURelateUtil.GetEnumValueList((String)entry.getKey());
                        if (TextList != null && TextList.size() != 0) {
                            if (Comp != null) {
                                ((JTextComponent)Comp).setText(TextList.get(0));
                            }
                            ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).setControlCurrentTextValue(TextList.get(0));
                        }
                        if (isRelate = true) {
                            double TempValue = 0.0;
                            ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).setControlInputValue(Value);
                            if (((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getOper().toUpperCase().equals(Oper_Multiply)) {
                                TempValue = Value * ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).GetValueinEnumItems(((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getControlCurrentTextValue());
                            } else if (((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getOper().toUpperCase().equals(Oper_Division)) {
                                TempValue = Value / ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).GetValueinEnumItems(((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getControlCurrentTextValue());
                            }
                            if (!((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getClockOutputName().equals("") && !(ret = RCUTreeUtil.SetControlsValuebyInputName((String)entry.getKey(), TempValue, true, isCheck))) {
                                return false;
                            }
                        }
                    }
                    if (isRelate) continue;
                    String valueTemp = new DecimalFormat("0.######").format(Value);
                    if (!RCUTreeUtil.isOnlyInitBeforeUI()) {
                        ((JTextComponent)Comp).setText(valueTemp);
                    }
                    ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).setControlCurrentTextValue(valueTemp);
                    if (((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getClockOutputName().equals("") || (ret = RCUTreeUtil.SetControlsValuebyInputName((String)entry.getKey(), Value, true, isCheck))) continue;
                    return false;
                }
                if (!((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getType().toUpperCase().equals("LABEL")) continue;
                ret = ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).setControlCurrentValue(Value, isCheck);
                if (!ret) {
                    return false;
                }
                if (!RCUTreeUtil.isOnlyInitBeforeUI()) {
                    Comp = (JLabel)((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getControlComponent();
                    ((JLabel)Comp).setText(String.valueOf(Value));
                }
                ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).setControlCurrentTextValue(String.valueOf(Value));
                if (((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getClockOutputName().equals("") || (ret = RCUTreeUtil.SetControlsValuebyInputName((String)entry.getKey(), Value, true, isCheck))) continue;
                return false;
            }
        }
        if (RCUCondition.RCUConfigControlGroupMap.size() > 0) {
            for (Map.Entry entry : RCUCondition.RCUConfigControlGroupMap.entrySet()) {
                if (entry.getValue() == null || isFindSelf && ((String)entry.getKey()).equals(InputName)) continue;
                TreeSet ControlNameSet = ((RCUConfigControlGroup)entry.getValue()).GetControlSet();
                Iterator iter = ControlNameSet.iterator();
                while (iter.hasNext()) {
                    String radioControlName = iter.next().toString();
                    if (!((RCUConfigControlGroup)entry.getValue()).getClockInputName(radioControlName).equals(InputName)) continue;
                    ((RCUConfigControlGroup)entry.getValue()).setControlCurrentValue(radioControlName, Value);
                    if (!RCUTreeUtil.isOnlyInitBeforeUI()) {
                        JRadioButton radioButton = (JRadioButton)((RCUConfigControlGroup)entry.getValue()).getControlComponent(radioControlName);
                        if (!radioButton.isSelected()) continue;
                        ((RCUConfigControlGroup)entry.getValue()).setControlCurrentValue(Value);
                        ret = RCUTreeUtil.SetControlsValuebyInputName((String)entry.getKey(), Value, false, isCheck);
                        if (ret) continue;
                        return false;
                    }
                    if (!((RCUConfigControlGroup)entry.getValue()).getControlDefault(radioControlName) || (ret = RCUTreeUtil.SetControlsValuebyInputName((String)entry.getKey(), Value, false, isCheck))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean UpdateUserConfigInfo(String Name) {
        Object Comp;
        com.gigadevice.venustool.clockconfiginfo.RCUConfigControl Obj;
        boolean isFind = false;
        int Flag = 0;
        String Value = null;
        String Key2 = Name;
        if (RCUCondition.RCUConfigControlMap.size() > 0) {
            Obj = (com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)RCUCondition.RCUConfigControlMap.get(Name);
            if (Obj != null) {
                isFind = true;
            }
            if (isFind) {
                if (Obj.getType().toUpperCase().equals("COMBO")) {
                    Value = (String)((JComboBox)Obj.getControlComponent()).getSelectedItem();
                    Obj.setControlCurrentTextValue(Value);
                } else if (Obj.getType().toUpperCase().equals("EDIT")) {
                    Comp = (JTextField)Obj.getControlComponent();
                    Value = ((JTextComponent)Comp).getText();
                    Obj.setControlCurrentTextValue(Value);
                }
                if (Value != null) {
                    Flag = Value.toUpperCase().equalsIgnoreCase(Obj.getControlInitValue()) ? -1 : 1;
                }
            }
        }
        if (!isFind && RCUCondition.RCUConfigControlGroupMap.size() > 0) {
            for (Map.Entry entry : RCUCondition.RCUConfigControlGroupMap.entrySet()) {
                TreeSet RadioNameSet;
                if (entry.getValue() == null || !(RadioNameSet = ((RCUConfigControlGroup)entry.getValue()).GetControlSet()).contains(Name)) continue;
                isFind = true;
                Value = Name;
                Key2 = (String)entry.getKey();
                Flag = Value.toUpperCase().equalsIgnoreCase(((RCUConfigControlGroup)entry.getValue()).getControlInitValue()) ? -1 : 1;
            }
        }
        if (!isFind) {
            Obj = (com.gigadevice.venustool.clockconfiginfo.RCUClockSource)RCUCondition.RCUClockSourceMap.get(Name);
            if (Obj != null) {
                isFind = true;
            }
            if (isFind && Obj.getType().toUpperCase().equals("EDIT")) {
                Comp = (JTextField)Obj.getControlComponent();
                Value = ((JTextComponent)Comp).getText();
                Obj.setControlCurrentTextValue(Value);
                Flag = Value.toUpperCase().equalsIgnoreCase(Obj.getControlInitValue()) ? -1 : 1;
            }
        }
        if (Flag == 1) {
            RCUUserConfigInfoMap.put(Key2, Value);
        } else if (Flag == -1) {
            if (RCUUserConfigInfoMap.containsKey(Key2)) {
                RCUUserConfigInfoMap.remove(Key2);
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean UpdateCurrentRelatedControlValue(String Name, boolean isCheck) {
        boolean ret;
        com.gigadevice.venustool.clockconfiginfo.RCUConfigControl Obj;
        boolean isFind = false;
        double TempValue = 0.0;
        String ObjName = Name;
        if (RCUCondition.RCUConfigControlMap.size() > 0) {
            Obj = (com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)RCUCondition.RCUConfigControlMap.get(Name);
            if (Obj != null) {
                isFind = true;
            }
            if (isFind) {
                if (Obj.getType().toUpperCase().equals("COMBO")) {
                    double InputValue = Obj.getInputValue();
                    String TempItem = RCUTreeUtil.isOnlyInitBeforeUI() ? Obj.getControlCurrentTextValue() : (String)((JComboBox)Obj.getControlComponent()).getSelectedItem();
                    double ComboValue = Obj.GetValueinEnumItems(TempItem);
                    Obj.setDisplayText(TempItem);
                    if (Obj.getOper().toUpperCase().equals(Oper_Multiply)) {
                        TempValue = InputValue * ComboValue;
                    } else if (Obj.getOper().toUpperCase().equals(Oper_Division)) {
                        TempValue = InputValue / ComboValue;
                    }
                } else if (Obj.getType().toUpperCase().equals("EDIT")) {
                    String Value;
                    if (RCUTreeUtil.isOnlyInitBeforeUI()) {
                        Value = Obj.getControlCurrentTextValue();
                    } else {
                        JTextField Comp = (JTextField)Obj.getControlComponent();
                        Value = Comp.getText();
                    }
                    TempValue = Double.parseDouble(Value);
                    Obj.setDisplayText(Value);
                    boolean ret2 = Obj.setControlCurrentValue(TempValue);
                    if (isCheck && !ret2) {
                        return false;
                    }
                }
                boolean res = ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)RCUCondition.RCUConfigControlMap.get(Name)).setControlCurrentValue(TempValue);
                if (!res) {
                    return false;
                }
            }
        }
        if (!isFind && RCUCondition.RCUConfigControlGroupMap.size() > 0) {
            for (Map.Entry entry : RCUCondition.RCUConfigControlGroupMap.entrySet()) {
                TreeSet RadioNameSet;
                if (entry.getValue() == null || !(RadioNameSet = ((RCUConfigControlGroup)entry.getValue()).GetControlSet()).contains(Name)) continue;
                isFind = true;
                ((RCUConfigControlGroup)entry.getValue()).setControlDefault(Name);
                TempValue = ((RCUConfigControlGroup)entry.getValue()).getControlCurrentValue(Name);
                ObjName = (String)entry.getKey();
                break;
            }
        }
        if (!isFind) {
            Obj = (com.gigadevice.venustool.clockconfiginfo.RCUClockSource)RCUCondition.RCUClockSourceMap.get(Name);
            if (Obj != null) {
                isFind = true;
            }
            if (isFind && Obj.getType().toUpperCase().equals("EDIT")) {
                String valueTemp;
                if (RCUTreeUtil.isOnlyInitBeforeUI()) {
                    valueTemp = Obj.getControlCurrentTextValue();
                } else {
                    JTextField Comp = (JTextField)Obj.getControlComponent();
                    valueTemp = Comp.getText();
                }
                Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
                Matcher matcher = pattern.matcher(valueTemp);
                boolean isNumeric = matcher.matches();
                if (!isNumeric) {
                    return false;
                }
                TempValue = Double.parseDouble(valueTemp);
                if (TempValue < 0.0) {
                    return false;
                }
                if (isCheck && (Obj.getMaxValue() != 0.0 && Obj.getMinValue() != 0.0 ? TempValue > Obj.getMaxValue() || TempValue < Obj.getMinValue() : Obj.getMaxValue() != 0.0 && TempValue > Obj.getMaxValue())) {
                    return false;
                }
                Obj.setDisplayText(valueTemp);
                ((com.gigadevice.venustool.clockconfiginfo.RCUClockSource)RCUCondition.RCUClockSourceMap.get(Name)).setControlCurrentValue(TempValue);
                ((com.gigadevice.venustool.clockconfiginfo.RCUClockSource)RCUCondition.RCUClockSourceMap.get(Name)).setValue(valueTemp);
            }
        }
        return !isFind || (ret = RCUTreeUtil.SetControlsValuebyInputName(ObjName, TempValue, false, isCheck));
    }

    public static String GetControlMacrofromClockTree(String ControlName) {
        com.gigadevice.venustool.clockconfiginfo.RCUConfigControl Obj;
        String DstMacro = null;
        boolean isFind = false;
        if (RCUCondition.RCUConfigControlMap.size() > 0) {
            Obj = (com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)RCUCondition.RCUConfigControlMap.get(ControlName);
            if (Obj != null) {
                isFind = true;
            }
            if (isFind) {
                if (Obj.getType().toUpperCase().equals("COMBO")) {
                    DstMacro = Obj.GetMacroinEnumItems((String)((JComboBox)Obj.getControlComponent()).getSelectedItem());
                } else if (Obj.getType().toUpperCase().equals("EDIT")) {
                    JTextField Comp = (JTextField)Obj.getControlComponent();
                    DstMacro = Comp.getText();
                }
            }
        }
        if (!isFind && RCUCondition.RCUConfigControlGroupMap.size() > 0) {
            Obj = (RCUConfigControlGroup)RCUCondition.RCUConfigControlGroupMap.get(ControlName);
            if (Obj != null) {
                isFind = true;
            }
            if (isFind) {
                DstMacro = Obj.getCurrentControlMacro();
                String rex0 = "@(.*?)@";
                Pattern pattern0 = Pattern.compile(rex0);
                Matcher matcher0 = pattern0.matcher(DstMacro);
                while (matcher0.find()) {
                    String Var = matcher0.group();
                    Var = Var.substring(1, Var.length() - 1);
                    DstMacro = RCUTreeUtil.GetControlMacrofromClockTree(Var);
                }
            }
        }
        return DstMacro;
    }

    public static void ClearUserConfigVars() {
        RCUUserConfigInfoMap.clear();
        RCUTreeUtil.ClearAllGlobalVars();
        RCUTreeUtil.InitAllGlobalVars();
        RCUTreeUtil.LoadAllGlobalVars();
    }

    public static void ClearAllGlobalVars() {
        RCUCondition.RCUConfigControlMap.clear();
        RCUCondition.RCUConfigControlGroupMap.clear();
        RCUCondition.RCUClockSourceMap.clear();
        RCUCondition.RCUConfigImageList.clear();
        RCUUserConfigInfoMap.clear();
    }

    public static void Serialize(ObjectOutputStream out) {
        try {
            out.writeObject(RCUFilePath);
            out.writeObject(RCUImageName);
            out.writeObject(RCUCondition.RCUConfigControlMap);
            out.writeObject(RCUCondition.RCUConfigControlGroupMap);
            out.writeObject(RCUCondition.RCUClockSourceMap);
            out.writeObject(RCUCondition.RCUConfigImageList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void DeSerialize(ObjectInputStream ins, String version) {
        switch (version) {
            case "1.1": {
                RCUTreeUtil.DeSerializeV1(ins);
            }
        }
    }

    private static void DeSerializeV1(ObjectInputStream ins) {
        try {
            RCUFilePath = (String)ins.readObject();
            RCUImageName = (String)ins.readObject();
            TempRCUConfigControlMap = (Map)ins.readObject();
            TempRCUConfigControlGroupMap = (Map)ins.readObject();
            TempRCUClockSourceMap = (Map)ins.readObject();
            TempRCUConfigImageList = (Set)ins.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        RCUTreeUtil.GetUserInfofromSerGDC();
    }

    public static void GetUserInfofromSerGDC() {
        if (TempRCUConfigControlMap.size() > 0) {
            for (Map.Entry<String, com.gigadevice.clockconfigview.info.RCUConfigInfo_Abstract> entry : TempRCUConfigControlMap.entrySet()) {
                String Name;
                if (!((RCUConfigControl)entry.getValue()).getType().toUpperCase().equals("COMBO") || (Name = ((RCUConfigControl)entry.getValue()).GetDefaultEnumValue()) == null || Name.equalsIgnoreCase(((RCUConfigControl)entry.getValue()).getDisplayText())) continue;
                RCUUserConfigInfoMap.put(entry.getKey(), ((RCUConfigControl)entry.getValue()).getDisplayText());
            }
        }
        if (TempRCUConfigControlGroupMap.size() > 0) {
            for (Map.Entry<String, com.gigadevice.clockconfigview.info.RCUConfigInfo_Abstract> entry : TempRCUConfigControlGroupMap.entrySet()) {
                String ControlName = ((com.gigadevice.clockconfigview.info.RCUConfigControlGroup)entry.getValue()).getControlGroupDefault();
                RCUUserConfigInfoMap.put(entry.getKey(), ControlName);
            }
        }
        if (TempRCUClockSourceMap.size() > 0) {
            for (Map.Entry<String, com.gigadevice.clockconfigview.info.RCUConfigInfo_Abstract> entry : TempRCUClockSourceMap.entrySet()) {
                RCUUserConfigInfoMap.put(entry.getKey(), String.valueOf(((RCUClockSource)entry.getValue()).getValue()));
            }
        }
        if (RCUUserConfigInfoMap.size() > 0) {
            RCUUserConfigInfoMapfromT = RCUTreeUtil.cloneFrom(RCUUserConfigInfoMap);
        }
    }

    public static String Serialize() {
        String Content = "";
        if (RCUUserConfigInfoMap.size() == 0) {
            return Content;
        }
        for (Map.Entry<String, String> entry : RCUUserConfigInfoMap.entrySet()) {
            String getKeyTemp = entry.getKey().replaceAll("\\.", "@2E@");
            String getValueTemp = entry.getValue().replaceAll("\\.", "@2E@");
            Content = String.valueOf(Content) + "RCU." + getKeyTemp + "=" + getValueTemp + System.getProperty("line.separator");
        }
        return Content;
    }

    public static void DeSerialize(String ins, int version) {
        RCUTreeUtil.UpdateUserInfotoMap(ins);
    }

    public static void UpdateUserInfotoMap() {
        if (RCUUserConfigInfoMap.size() > 0) {
            CheckValid = false;
            for (Map.Entry<String, String> entry : RCUUserConfigInfoMap.entrySet()) {
                JTextField Comp;
                com.gigadevice.venustool.clockconfiginfo.RCUConfigControl Obj;
                boolean isFind = false;
                String Name = entry.getKey();
                String Value = entry.getValue();
                if (RCUCondition.RCUConfigControlMap.size() > 0) {
                    Obj = (com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)RCUCondition.RCUConfigControlMap.get(Name);
                    if (Obj != null) {
                        isFind = true;
                    }
                    if (isFind) {
                        if (Obj.getType().toUpperCase().equals("COMBO")) {
                            ((JComboBox)Obj.getControlComponent()).setSelectedItem(Value);
                        } else if (Obj.getType().toUpperCase().equals("EDIT")) {
                            Comp = (JTextField)Obj.getControlComponent();
                            Comp.setText(Value);
                        }
                    }
                }
                if (!isFind && RCUCondition.RCUConfigControlGroupMap.size() > 0) {
                    Obj = (RCUConfigControlGroup)RCUCondition.RCUConfigControlGroupMap.get(Name);
                    if (Obj != null) {
                        isFind = true;
                    }
                    if (isFind) {
                        Obj.setControlCurrentTextValue(Value);
                        if (!RCUTreeUtil.isOnlyInitBeforeUI()) {
                            ((JRadioButton)Obj.getControlComponent(Value)).setSelected(true);
                        }
                        RCUTreeUtil.UpdateCurrentRelatedControlValue(Value, false);
                        continue;
                    }
                }
                if (!isFind) {
                    Obj = (com.gigadevice.venustool.clockconfiginfo.RCUClockSource)RCUCondition.RCUClockSourceMap.get(Name);
                    if (Obj != null) {
                        isFind = true;
                    }
                    if (isFind && Obj.getType().toUpperCase().equals("EDIT")) {
                        Comp = (JTextField)Obj.getControlComponent();
                        Comp.setText(Value);
                    }
                }
                if (!isFind) continue;
                RCUTreeUtil.UpdateCurrentRelatedControlValue(Name, false);
            }
        }
        RCUUserConfigInfoMap = RCUTreeUtil.cloneFrom(RCUUserConfigInfoMapfromT);
        RCUUserConfigInfoMapfromT.clear();
        CheckValid = true;
    }

    public static void UpdateUserInfoValuetoMap() {
        if (RCUUserConfigInfoMapfromT.size() > 0) {
            CheckValid = false;
            for (Map.Entry<String, String> entry : RCUUserConfigInfoMapfromT.entrySet()) {
                com.gigadevice.venustool.clockconfiginfo.RCUConfigControl Obj;
                boolean isFind = false;
                String Name = entry.getKey();
                String Value = entry.getValue();
                if (RCUCondition.RCUConfigControlMap.size() > 0) {
                    Obj = (com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)RCUCondition.RCUConfigControlMap.get(Name);
                    if (Obj != null) {
                        isFind = true;
                    }
                    if (isFind) {
                        if (Obj.getType().toUpperCase().equals("COMBO")) {
                            Obj.setControlCurrentTextValue(Value);
                        } else if (Obj.getType().toUpperCase().equals("EDIT")) {
                            Obj.setControlCurrentTextValue(Value);
                        }
                    }
                }
                if (!isFind && RCUCondition.RCUConfigControlGroupMap.size() > 0) {
                    Obj = (RCUConfigControlGroup)RCUCondition.RCUConfigControlGroupMap.get(Name);
                    if (Obj != null) {
                        isFind = true;
                    }
                    if (isFind) {
                        Obj.setControlCurrentTextValue(Value);
                        RCUTreeUtil.UpdateCurrentRelatedControlValue(Value, false);
                    }
                }
                if (!isFind) {
                    Obj = (com.gigadevice.venustool.clockconfiginfo.RCUClockSource)RCUCondition.RCUClockSourceMap.get(Name);
                    if (Obj != null) {
                        isFind = true;
                    }
                    if (isFind && Obj.getType().toUpperCase().equals("EDIT")) {
                        Obj.setControlCurrentTextValue(Value);
                    }
                }
                if (isFind) {
                    RCUTreeUtil.UpdateCurrentRelatedControlValue(Name, false);
                }
                if (isFind) continue;
                LogManager.getInstance().error("Clock Tree", "Not found node: " + Name);
            }
        }
        RCUUserConfigInfoMap = RCUTreeUtil.cloneFrom(RCUUserConfigInfoMapfromT);
        RCUUserConfigInfoMapfromT.clear();
        CheckValid = true;
    }

    public static void UpdateUserInfotoMap(String input) {
        String regex = "\\.(.*?)=(.*)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            String key = matcher.group(1).replaceAll("@2E@", "\\.");
            String value = matcher.group(2).replaceAll("@2E@", "\\.");
            RCUUserConfigInfoMapfromT.put(key, value);
        }
    }

    public static <T> T cloneFrom(T src) throws RuntimeException {
        ByteArrayOutputStream memoryBuffer = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        ObjectInputStream in = null;
        Object dist = null;
        try {
            try {
                out = new ObjectOutputStream(memoryBuffer);
                out.writeObject(src);
                out.flush();
                in = new ObjectInputStream(new ByteArrayInputStream(memoryBuffer.toByteArray()));
                dist = in.readObject();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                    out = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                    in = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return (T)dist;
    }

    public static boolean InitControlsValueDisplay_HasFunc(String controlName) {
        if (RCUCondition.RCUConfigControlMap.size() > 0) {
            for (Map.Entry entry : RCUCondition.RCUConfigControlMap.entrySet()) {
                if (entry.getValue() == null || !((String)entry.getKey()).equals(controlName)) continue;
                Object result = RCURelateUtil.getExtendNodeResult(controlName, "UpdateValue");
                String resultString = (String)result;
                if (resultString.equals("")) {
                    return false;
                }
                String Type2 = ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getType();
                String displayText = "";
                if (!Type2.toUpperCase().equals("EDIT")) continue;
                if (RCUTreeUtil.isOnlyInitBeforeUI()) {
                    double valueDouble = Double.valueOf(resultString);
                    double ControlCurrentValue = ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getControlCurrentValue();
                    displayText = resultString;
                    boolean ret = ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).setControlCurrentValue(valueDouble);
                    if (ret) {
                        ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).setControlCurrentTextValue(displayText);
                    } else {
                        ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).setControlCurrentTextValue(String.valueOf(ControlCurrentValue));
                    }
                    return ret;
                }
                JTextField controlComponent = (JTextField)((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getControlComponent();
                if (controlComponent == null) continue;
                double valueDouble = Double.valueOf(resultString);
                double ControlCurrentValue = ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).getControlCurrentValue();
                displayText = resultString;
                boolean ret = ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)entry.getValue()).setControlCurrentValue(valueDouble);
                if (ret) {
                    controlComponent.setText(displayText);
                } else {
                    controlComponent.setText(String.valueOf(ControlCurrentValue));
                }
                return ret;
            }
        }
        return true;
    }

    public static void AttributeChange(String Name, Object TempObj) {
        block17: {
            if (!RCURelateUtil.AttributeChangeMap.containsKey(Name)) break block17;
            Map<String, Object> attributeChangeMap = RCURelateUtil.AttributeChangeMap.get(Name);
            block10: for (Map.Entry<String, Object> entry : attributeChangeMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                switch (key) {
                    case "ReadOnly": {
                        if (TempObj instanceof com.gigadevice.venustool.clockconfiginfo.RCUConfigControl) {
                            ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)TempObj).setReadOnly((String)value);
                            break;
                        }
                        if (TempObj instanceof RCUConfigControlGroup || !(TempObj instanceof com.gigadevice.venustool.clockconfiginfo.RCUClockSource)) continue block10;
                        ((com.gigadevice.venustool.clockconfiginfo.RCUClockSource)TempObj).setReadOnly((String)value);
                        break;
                    }
                    case "MaxValue": {
                        if (TempObj instanceof com.gigadevice.venustool.clockconfiginfo.RCUConfigControl) {
                            ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)TempObj).setMaxValue((String)value);
                            break;
                        }
                        if (TempObj instanceof RCUConfigControlGroup || !(TempObj instanceof com.gigadevice.venustool.clockconfiginfo.RCUClockSource)) continue block10;
                        ((com.gigadevice.venustool.clockconfiginfo.RCUClockSource)TempObj).setMaxValue((String)value);
                        break;
                    }
                    case "MinValue": {
                        if (TempObj instanceof com.gigadevice.venustool.clockconfiginfo.RCUConfigControl) {
                            ((com.gigadevice.venustool.clockconfiginfo.RCUConfigControl)TempObj).setMinValue((String)value);
                            break;
                        }
                        if (TempObj instanceof RCUConfigControlGroup || !(TempObj instanceof com.gigadevice.venustool.clockconfiginfo.RCUClockSource)) continue block10;
                        ((com.gigadevice.venustool.clockconfiginfo.RCUClockSource)TempObj).setMinValue((String)value);
                        break;
                    }
                }
            }
        }
    }
}

