/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.utils;

import com.gigadevice.debug.ui.PeripheralsView;
import com.gigadevice.debug.utils.TreePeripheral;
import com.gigadevice.debug.utils.TreePeripheralGroup;
import com.gigadevice.debug.utils.TreeUnit;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;

public class TreeRegister
extends TreePeripheralGroup
implements Cloneable {
    private long addressOffset;
    private int size;
    private long resetValue;
    private long registerAddr;
    private long old_value;

    public TreeRegister(String name, String description) {
        super(name, description);
    }

    public long getAddressOffset() {
        return this.addressOffset;
    }

    public void setAddressOffset(long addressOffset) {
        this.addressOffset = addressOffset;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size / 8;
    }

    public long getResetValue() {
        return this.resetValue;
    }

    public void setResetValue(long resetValue) {
        this.resetValue = resetValue;
    }

    public synchronized void readValue() {
        IAdaptable context;
        this.old_value = this.value;
        TreeUnit parent = this.getParentUnit();
        if (parent instanceof TreePeripheral && (context = DebugUITools.getDebugContext()) == null) {
            this.value = -1L;
        }
    }

    public synchronized void updateValue(long val) {
        this.old_value = this.value;
        this.value = val;
    }

    @Override
    public void setValue(long value) {
        if (this.getRWState() != 2) {
            this.old_value = this.value;
            this.value = value;
            this.writeValue(this.value);
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.readValue();
        }
    }

    public void writeValue(long value) {
        PeripheralsView.setMemory(this.registerAddr, value, this.getSize());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TreeRegister o = null;
        o = (TreeRegister)super.clone();
        return o;
    }

    public void clearValue() {
        this.value = 0L;
    }

    public long getRegisterAddr() {
        return this.registerAddr;
    }

    public void setRegisterAddr(long registerAddr) {
        this.registerAddr = registerAddr;
    }
}

