/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.utils;

import com.gigadevice.venustool.TargetOSInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KillPort {
    public int port;

    public void start(int port) {
        try {
            if (TargetOSInfo.isWindows()) {
                this.killPortOnWindows(port);
            } else if (TargetOSInfo.isLinux()) {
                this.killPortOnUnix(port);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void start(String ExeName) {
        try {
            if (TargetOSInfo.isWindows()) {
                ProcessBuilder builder = new ProcessBuilder("taskkill", "/f", "/t", "/im", ExeName);
                Process process = builder.start();
                process.waitFor();
            } else if (TargetOSInfo.isLinux()) {
                ProcessBuilder builder = new ProcessBuilder("killall", "-9", ExeName);
                Process process = builder.start();
                process.waitFor();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean PortisValid(String str) {
        int port;
        Pattern pt = Pattern.compile("^ *[a-zA-Z]+ +\\S+");
        Matcher mt = pt.matcher(str);
        if (!mt.find()) {
            return false;
        }
        String content = mt.group();
        content = content.substring(content.lastIndexOf(":") + 1);
        try {
            port = Integer.parseInt(content);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("error port: " + content);
            return false;
        }
        return this.port == port;
    }

    private void taskkill(List<String> content) {
        for (String linecontent : content) {
            String pidStr = linecontent.substring(linecontent.lastIndexOf(" ") + 1).trim();
            try {
                int pidNo = Integer.parseInt(pidStr);
                try {
                    Runtime.getRuntime().exec(String.format("taskkill /F /pid %d", pidNo));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("error pid: " + pidStr);
            }
        }
    }

    private void killPortOnWindows(int port) {
        try {
            String line;
            Process pro = Runtime.getRuntime().exec(String.format("cmd /c netstat -ano | findstr %d", port));
            ArrayList<String> data = new ArrayList<String>();
            BufferedReader content = new BufferedReader(new InputStreamReader(pro.getInputStream(), "UTF-8"));
            while ((line = content.readLine()) != null) {
                if (!this.PortisValid(line)) continue;
                data.add(line);
            }
            content.close();
            if (data.size() == 0) {
                System.out.printf("not find %d pid.%n", port);
            } else {
                this.taskkill(data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void killPortOnWindows1(int port) {
        try {
            String line;
            String findCommand = "netstat -ano | findstr " + port;
            Process findProcess = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", findCommand});
            BufferedReader findReader = new BufferedReader(new InputStreamReader(findProcess.getInputStream()));
            while ((line = findReader.readLine()) != null) {
                if (!line.contains("LISTENING")) continue;
                String[] tokens = line.trim().split("\\s+");
                String pid = tokens[tokens.length - 1];
                String killCommand = "taskkill /F /pid " + pid;
                Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", killCommand});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void killPortOnUnix(int port) {
        try {
            String pid;
            String[] findCommand = new String[]{"/bin/sh", "-c", "lsof -t -i:" + port};
            Process findProcess = Runtime.getRuntime().exec(findCommand);
            BufferedReader findReader = new BufferedReader(new InputStreamReader(findProcess.getInputStream()));
            while ((pid = findReader.readLine()) != null) {
                String killCommand = "kill -9 " + pid;
                Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", killCommand});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

