/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.utils;

import com.gigadevice.adapter.AdapterUtils;
import com.gigadevice.debug.utils.ToolUtil;
import com.gigadevice.utils.ProjectUtils;
import com.gigadevice.utils.preferences.EclipsePreferences;
import com.gigadevice.venustool.GeneralPathUtil;
import com.gigadevice.venustool.TargetOSInfo;
import com.gigadevice.venustool.baseinfo.MCUSeletorInfo;
import com.gigadevice.venustool.mcuxmlinfo.CoreInfo;
import com.gigadevice.venustool.mcuxmlinfo.McuFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.service.datalocation.Location;

public class DebugUtil {
    public static IProject getCurProject(ILaunchConfiguration configuration) {
        IProject project = null;
        String Name = "";
        try {
            Name = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        if (!Name.equals("") && Name != null) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(Name);
        }
        return project;
    }

    public static String getFirstFileByType(ILaunchConfiguration config, String FileType) {
        String FirstFile = "";
        IProject project = DebugUtil.getCurProject(config);
        FirstFile = AdapterUtils.getFirstFileByType((IProject)project, (String)FileType, (boolean)true);
        return FirstFile;
    }

    public static String getFirstFileAbsolutePath(ILaunchConfiguration configuration, String FileType, boolean DoInitMCUSeletorInfo) {
        String FirstFileAbsolutePath = "";
        try {
            String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            String path = project.getLocation().toString();
            path = path.replace("/", File.separator);
            FirstFileAbsolutePath = ProjectUtils.parseFilePath((String)path, (String)AdapterUtils.getFirstFileByType((IProject)project, (String)FileType, (boolean)DoInitMCUSeletorInfo));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return FirstFileAbsolutePath;
    }

    public static String getSVDFilePath(ILaunchConfiguration configuration) {
        EclipsePreferences tempPreferences = new EclipsePreferences("com.gigadevice.utils");
        IProject project = DebugUtil.getCurProject(configuration);
        AdapterUtils.initMCUSeletorInfoByIProject((IProject)project);
        if (AdapterUtils.tmpMcuSeletorInfo != null) {
            String SvdName = AdapterUtils.tmpMcuSeletorInfo.getSvdPath();
            if (SvdName == null) {
                try {
                    SvdName = tempPreferences.getMCUTargetSVD(ResourcesPlugin.getWorkspace().getRoot().getProject(configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "")));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            String SVDFilePath = String.valueOf(GeneralPathUtil.ResourcePath) + "svd" + File.separator + SvdName;
            return SVDFilePath;
        }
        return "";
    }

    public static int getProjectTypeByConfiguration(ILaunchConfiguration configuration) {
        int ProjectType = 1;
        IProject project = DebugUtil.getCurProject(configuration);
        ProjectType = AdapterUtils.getProjectTypeByIProject((IProject)project);
        return ProjectType;
    }

    public static String getEclipsePath() {
        String filePath = "";
        Location l = Platform.getInstallLocation();
        filePath = l.getURL().toString();
        int start = 0;
        int length = 0;
        if (TargetOSInfo.isWindows()) {
            start = filePath.indexOf("file:/") + 6;
            length = filePath.length() - filePath.indexOf("file:/");
        } else if (TargetOSInfo.isLinux()) {
            start = filePath.indexOf("file:") + 5;
            length = filePath.length() - filePath.indexOf("file:");
        }
        filePath = filePath.substring(start, length);
        filePath = filePath.replace("/", File.separator);
        return filePath;
    }

    public static String getToolsPath() {
        String filePath = DebugUtil.getEclipsePath();
        filePath = filePath.substring(0, filePath.length() - 1);
        filePath = filePath.substring(0, filePath.lastIndexOf(File.separator) + 1);
        return filePath;
    }

    public static void queueCommands(List<String> commands, RequestMonitor rm, IGDBControl control, DsfExecutor executor) {
        if (commands != null && !commands.isEmpty()) {
            CountingRequestMonitor crm = new CountingRequestMonitor((Executor)executor, rm);
            crm.setDoneCount(commands.size());
            Iterator<String> it = commands.iterator();
            while (it.hasNext()) {
                String s = it.next().trim();
                if (s.isEmpty() || s.startsWith("#")) {
                    crm.done();
                    continue;
                }
                control.queueCommand((ICommand)new CLICommand((IDMContext)control.getContext(), s), new DataRequestMonitor((Executor)executor, (RequestMonitor)crm));
            }
        } else {
            rm.done();
        }
    }

    public static int compareVersions(String v1, String v2) {
        if (v1 == null || v2 == null) {
            throw new NullPointerException();
        }
        String[] v1Parts = v1.split("\\.");
        String[] v2Parts = v2.split("\\.");
        int i = 0;
        while (i < v1Parts.length && i < v2Parts.length) {
            int v2PartValue;
            int v1PartValue;
            block16: {
                try {
                    v1PartValue = Integer.parseInt(v1Parts[i]);
                    v2PartValue = Integer.parseInt(v2Parts[i]);
                    if (v1PartValue <= v2PartValue) break block16;
                    return 1;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (v1PartValue < v2PartValue) {
                return -1;
            }
            ++i;
        }
        if (v1Parts.length < v2Parts.length) {
            i = v1Parts.length;
            while (i < v2Parts.length) {
                try {
                    if (Integer.parseInt(v2Parts[i]) != 0) {
                        return -1;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                ++i;
            }
        }
        if (v1Parts.length > v2Parts.length) {
            i = v2Parts.length;
            while (i < v1Parts.length) {
                try {
                    if (Integer.parseInt(v1Parts[i]) != 0) {
                        return 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                ++i;
            }
        }
        return 0;
    }

    public static String getOpenocdEXELoc() {
        String EXEPath = "";
        if (TargetOSInfo.isWindows()) {
            EXEPath = String.valueOf(DebugUtil.getToolsPath()) + "Tools" + File.separator + "OpenOCD" + File.separator + "xpack-openocd-0.11.0-3" + File.separator + "bin" + File.separator + "openocd.exe";
        } else if (TargetOSInfo.isLinux()) {
            EXEPath = String.valueOf(DebugUtil.getToolsPath()) + "Tools" + File.separator + "OpenOCD" + File.separator + "xpack-openocd-0.11.0-3" + File.separator + "bin" + File.separator + "openocd";
        }
        return EXEPath;
    }

    public static String getGDLinkGDBServerEXELoc() {
        String EXEPath = "";
        if (TargetOSInfo.isWindows()) {
            EXEPath = String.valueOf(DebugUtil.getToolsPath()) + "Tools" + File.separator + "GDLinkGDBServer" + File.separator + "GDLinkGDBServer.exe";
        } else if (TargetOSInfo.isLinux()) {
            EXEPath = String.valueOf(DebugUtil.getToolsPath()) + "Tools" + File.separator + "GDLinkGDBServer" + File.separator + "GDLinkGDBServer";
        }
        return EXEPath;
    }

    public static String getGDLinkGDBServerEXEPath() {
        String GDLinkGDBServerEXEPath = AdapterUtils.getGDLinkDirPath();
        if (TargetOSInfo.isWindows()) {
            GDLinkGDBServerEXEPath = String.valueOf(GDLinkGDBServerEXEPath) + "GDLinkGDBServer.exe";
        } else if (TargetOSInfo.isLinux()) {
            GDLinkGDBServerEXEPath = String.valueOf(GDLinkGDBServerEXEPath) + "bin" + File.separator + "GDLinkGDBServer";
        }
        return GDLinkGDBServerEXEPath;
    }

    public static String getOpenocdEXEPath() {
        String OpenocdEXEPath = AdapterUtils.getOpenocdDirPath();
        if (TargetOSInfo.isWindows()) {
            OpenocdEXEPath = String.valueOf(OpenocdEXEPath) + "openocd.exe";
        } else if (TargetOSInfo.isLinux()) {
            OpenocdEXEPath = String.valueOf(OpenocdEXEPath) + "openocd";
        }
        return OpenocdEXEPath;
    }

    public static String getJLinkGDBServerEXELoc() {
        String EXEPath = "";
        if (TargetOSInfo.isWindows()) {
            EXEPath = String.valueOf(DebugUtil.getToolsPath()) + "Tools" + File.separator + "J-Link" + File.separator + "JLinkGDBServerCL.exe";
        } else if (TargetOSInfo.isLinux()) {
            EXEPath = String.valueOf(DebugUtil.getToolsPath()) + "Tools" + File.separator + "J-Link" + File.separator + "JLinkGDBServerCLExe";
        }
        return EXEPath;
    }

    public static String getJLinkGDBServerEXEPath() {
        String GDLinkGDBServerEXEPath = McuFactory.getToolsPath();
        if (TargetOSInfo.isWindows()) {
            GDLinkGDBServerEXEPath = String.valueOf(GDLinkGDBServerEXEPath) + "Tools" + File.separator + "J-Link" + File.separator + "JLinkGDBServerCL.exe";
        } else if (TargetOSInfo.isLinux()) {
            GDLinkGDBServerEXEPath = String.valueOf(GDLinkGDBServerEXEPath) + "Tools" + File.separator + "J-Link" + File.separator + "JLinkGDBServerCLExe";
        }
        return GDLinkGDBServerEXEPath;
    }

    public static int getCoreNum(ILaunchConfiguration config) {
        IProject project = DebugUtil.getCurProject(config);
        return DebugUtil.getCoreNumByProject(project);
    }

    public static int getCoreNumByProject(IProject project) {
        String McuNo = AdapterUtils.getTargetMcuPartNo((IProject)project);
        MCUSeletorInfo tmpMcuSeletorInfo = McuFactory.getSeletorInfoByPartNo((int)1, (String)McuNo);
        int CoreNum = tmpMcuSeletorInfo.getCoreNum();
        return CoreNum;
    }

    public static LinkedHashMap<String, CoreInfo> getCoreInfo(ILaunchConfiguration config) {
        IProject project = DebugUtil.getCurProject(config);
        String McuNo = AdapterUtils.getTargetMcuPartNo((IProject)project);
        MCUSeletorInfo tmpMcuSeletorInfo = McuFactory.getSeletorInfoByPartNo((int)1, (String)McuNo);
        LinkedHashMap CoreInfoMap = tmpMcuSeletorInfo.getCoreInfoMap();
        if (CoreInfoMap == null || CoreInfoMap.size() == 0) {
            CoreInfoMap = tmpMcuSeletorInfo.getMCUSubGroupCoreInfoMap();
        }
        return CoreInfoMap;
    }

    public static List<String> getBinaries(ILaunchConfiguration config) {
        ArrayList<String> fBinaries = new ArrayList<String>();
        try {
            int CoreNum = DebugUtil.getCoreNum(config);
            int i = 0;
            while (i < CoreNum) {
                fBinaries.add(DebugUtil.getAttribute(config, "org.eclipse.cdt.launch.PROGRAM_NAME", i));
                ++i;
            }
        }
        catch (Exception ce) {
            ce.printStackTrace();
        }
        return fBinaries;
    }

    public static String getAttribute(ILaunchConfiguration configuration, String AttributeName, int index) {
        String MultiCoreAttribute = "";
        try {
            MultiCoreAttribute = index == 0 ? configuration.getAttribute(AttributeName, "") : ToolUtil.getAttribute((ILaunchConfigurationWorkingCopy)configuration, AttributeName, "", index);
        }
        catch (CoreException e) {
            LaunchUIPlugin.log((Throwable)e);
        }
        return MultiCoreAttribute;
    }

    public static Boolean getAttribute(ILaunchConfiguration configuration, String AttributeName, int index, boolean defaultValue) {
        Boolean MultiCoreAttribute = defaultValue;
        String tempString = "";
        try {
            tempString = index == 0 ? configuration.getAttribute(AttributeName, "") : ToolUtil.getAttribute((ILaunchConfigurationWorkingCopy)configuration, AttributeName, "", index);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        switch (tempString) {
            case "1": 
            case "true": {
                MultiCoreAttribute = true;
                break;
            }
            case "0": 
            case "false": {
                MultiCoreAttribute = false;
                break;
            }
        }
        return MultiCoreAttribute;
    }

    public static void setAttribute(ILaunchConfigurationWorkingCopy configuration, String AttributeName, String AttributeValue, int index) {
        try {
            if (index == 0) {
                configuration.setAttribute(AttributeName, AttributeValue);
            } else {
                ToolUtil.setAttribute(configuration, AttributeName, AttributeValue, index);
            }
        }
        catch (Exception e) {
            LaunchUIPlugin.log((Throwable)e);
        }
    }

    public static void setAttribute(ILaunchConfigurationWorkingCopy configuration, String AttributeName, int AttributeValue, int index) {
        try {
            if (index == 0) {
                configuration.setAttribute(AttributeName, AttributeValue);
            } else {
                ToolUtil.setAttribute(configuration, AttributeName, AttributeValue, index);
            }
        }
        catch (Exception e) {
            LaunchUIPlugin.log((Throwable)e);
        }
    }

    public static String getCoreIndexFromProgram(String ApplicationStr, ILaunchConfiguration config) {
        String CoreIndexStr;
        block3: {
            CoreIndexStr = "";
            try {
                String configName = ApplicationStr.substring(0, ApplicationStr.lastIndexOf(File.separator));
                String[] temp = configName.split("_");
                configName = temp[temp.length - 1];
                ApplicationStr = ApplicationStr.substring(ApplicationStr.lastIndexOf(File.separator));
                ApplicationStr = ApplicationStr.substring(ApplicationStr.lastIndexOf("_") + 1);
                CoreIndexStr = ApplicationStr.substring(0, ApplicationStr.lastIndexOf("."));
                if (CoreIndexStr.equalsIgnoreCase(configName)) break block3;
                return "";
            }
            catch (Exception exception) {
                return "";
            }
        }
        CoreIndexStr = DebugUtil.findItemByCoreItem(CoreIndexStr, config);
        return CoreIndexStr;
    }

    private static String findItemByCoreItem(String CoreIndex, ILaunchConfiguration config) {
        try {
            LinkedHashMap<String, CoreInfo> CoreInfoMap = DebugUtil.getCoreInfo(config);
            Set<String> CoreItems = CoreInfoMap.keySet();
            String Index = CoreIndex.split("-")[0].trim();
            String ID = CoreIndex.split("-")[1].toLowerCase().trim();
            for (String Core : CoreItems) {
                CoreInfo coreInfo = CoreInfoMap.get(Core);
                if (!coreInfo.getCoreIndex().equals(Index) || !Core.toLowerCase().contains(ID)) continue;
                return Core;
            }
        }
        catch (Exception exception) {
            return "";
        }
        return "";
    }

    public static void addMultiLine(String multiLine, List<String> commandsList) {
        if (!multiLine.isEmpty()) {
            String[] commandsStr;
            String[] stringArray = commandsStr = multiLine.split("\\r?\\n");
            int n = commandsStr.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if (!(str = str.trim()).isEmpty()) {
                    str = str.replace("\\", "/");
                    commandsList.add(String.valueOf(str) + System.lineSeparator());
                }
                ++n2;
            }
        }
    }

    public static String resolveAll(String value) {
        try {
            value = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value, false).trim();
        }
        catch (CoreException coreException) {}
        return value;
    }

    public static boolean getCodeinRAMBooleanValue(ILaunchConfiguration configuration) {
        boolean codeInRam = false;
        try {
            Object raw = configuration.getAttributes().get("com.gigadevice.debug.launch.codeinRAM");
            codeInRam = raw instanceof Boolean ? (Boolean)raw : (raw instanceof String ? Boolean.parseBoolean(((String)raw).trim()) : false);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return codeInRam;
    }
}

