/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.ui;

import com.gigadevice.debug.messages.Messages;
import com.gigadevice.debug.startup.IStartupCoreTab;
import com.gigadevice.debug.startup.IStartupTab;
import com.gigadevice.debug.ui.StartupCoreTab;
import com.gigadevice.debug.utils.DebugUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class StartupTab
extends AbstractLaunchConfigurationTab
implements IStartupTab {
    protected Composite fMainComp;
    protected Composite fTabComp;
    protected static Map<String, IStartupCoreTab> fmapCoreTab;
    protected static List<String> fBinaries;

    public void createControl(Composite parent) {
        this.fMainComp = new Composite(parent, 0);
        this.setControl((Control)this.fMainComp);
        GridLayout gridLayout = new GridLayout();
        this.fMainComp.setLayout((Layout)gridLayout);
        fmapCoreTab = new HashMap<String, IStartupCoreTab>();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (!super.isValid(launchConfig)) {
            return false;
        }
        this.setErrorMessage(null);
        this.setWarningMessage(null);
        this.setMessage(null);
        int i = 0;
        while (i < fBinaries.size()) {
            IStartupCoreTab coreTab;
            if (DebugUtil.getAttribute(launchConfig, "com.gigadevice.debug.launch.debugIsActivated", i, true).booleanValue() && (coreTab = fmapCoreTab.get(fBinaries.get(i))) != null && !coreTab.isValid(launchConfig)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.doSetDefaults(configuration);
    }

    @Override
    public void doSetDefaults(ILaunchConfigurationWorkingCopy configuration) {
        fBinaries = DebugUtil.getBinaries((ILaunchConfiguration)configuration);
        int index = fBinaries.size();
        if (index == 0) {
            index = 1;
        }
        String strIndex = "";
        int i = 0;
        while (i < index) {
            if (i > 0) {
                strIndex = "_" + i;
            }
            configuration.setAttribute("com.gigadevice.debug.launch.doFirstReset" + strIndex, true);
            configuration.setAttribute("com.gigadevice.debug.launch.firstResetType" + strIndex, "init");
            configuration.setAttribute("com.gigadevice.debug.launch.otherInitCommands" + strIndex, "");
            configuration.setAttribute("com.gigadevice.debug.launch.loadSymbols" + strIndex, true);
            configuration.setAttribute("com.gigadevice.debug.launch.useProjBinaryForSymbols" + strIndex, true);
            configuration.setAttribute("com.gigadevice.debug.launch.useFileForSymbols" + strIndex, false);
            configuration.setAttribute("com.gigadevice.debug.launch.symbolsFileName" + strIndex, "");
            configuration.setAttribute("com.gigadevice.debug.launch.symbolsOffset" + strIndex, "");
            configuration.setAttribute("com.gigadevice.debug.launch.loadImage" + strIndex, true);
            configuration.setAttribute("com.gigadevice.debug.launch.useProjBinaryForImage" + strIndex, true);
            configuration.setAttribute("com.gigadevice.debug.launch.useFileForImage" + strIndex, false);
            configuration.setAttribute("com.gigadevice.debug.launch.imageFileName" + strIndex, "");
            configuration.setAttribute("com.gigadevice.debug.launch.imageOffset" + strIndex, "");
            configuration.setAttribute("com.gigadevice.debug.launch.doSecondReset" + strIndex, true);
            configuration.setAttribute("com.gigadevice.debug.launch.secondResetType" + strIndex, "halt");
            configuration.setAttribute("com.gigadevice.debug.launch.otherRunCommands" + strIndex, "");
            configuration.setAttribute("com.gigadevice.debug.launch.setPcRegister" + strIndex, false);
            configuration.setAttribute("com.gigadevice.debug.launch.pcRegister" + strIndex, "");
            configuration.setAttribute("com.gigadevice.debug.launch.setStopAt" + strIndex, true);
            configuration.setAttribute("com.gigadevice.debug.launch.stopAt" + strIndex, "main");
            configuration.setAttribute("com.gigadevice.debug.launch.doContinue" + strIndex, true);
            ++i;
        }
    }

    @Override
    public AbstractLaunchConfigurationTab getAbstractLaunchConfigurationTab() {
        return this;
    }

    public Shell getShell() {
        return super.getShell();
    }

    public Button createPushButton(Composite parent, String label, Image image) {
        return super.createPushButton(parent, label, image);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateWizardFromConfig(configuration);
        for (Map.Entry<String, IStartupCoreTab> entry : fmapCoreTab.entrySet()) {
            IStartupCoreTab coreTab = entry.getValue();
            if (coreTab == null) continue;
            coreTab.initializeFrom(configuration);
        }
        this.fMainComp.layout();
    }

    public void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public void setMessage(String message) {
        super.setMessage(message);
    }

    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public void setWarningMessage(String warningMessage) {
        super.setWarningMessage(warningMessage);
    }

    private void updateWizardFromConfig(ILaunchConfiguration config) {
        fBinaries = DebugUtil.getBinaries(config);
        if (this.fTabComp != null) {
            fmapCoreTab.clear();
            this.fTabComp.dispose();
        }
        this.fTabComp = new Composite(this.fMainComp, 0);
        GridLayout tabLayout = new GridLayout();
        this.fTabComp.setLayoutData((Object)new GridData(1808));
        int nbCores = DebugUtil.getCoreNum(config);
        if (nbCores > 1) {
            tabLayout.marginHeight = 10;
            CTabFolder tabFolder = new CTabFolder(this.fTabComp, 0);
            tabFolder.setSimple(PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
            tabFolder.setBorderVisible(true);
            GridData gd = new GridData(1808);
            gd.horizontalSpan = 2;
            tabFolder.setLayoutData((Object)gd);
            CTabItem tabItemCandidateForFocus = null;
            int i = 0;
            while (i < nbCores) {
                CTabItem tabItem = new CTabItem(tabFolder, 0);
                String tabName = "Core " + i;
                if (fBinaries.size() > i && fBinaries.get(i) != null && !fBinaries.get(i).isEmpty()) {
                    tabName = fBinaries.get(i);
                }
                tabItem.setText(tabName);
                IStartupCoreTab coreTab = this.createCoreTab((Composite)tabFolder, tabName);
                coreTab.setfIndex(i);
                tabItem.setControl((Control)coreTab.getComposite());
                if (tabItemCandidateForFocus == null && DebugUtil.getAttribute(config, "com.gigadevice.debug.launch.debugIsActivated", i, true).booleanValue()) {
                    tabItemCandidateForFocus = tabItem;
                }
                ++i;
            }
            if (tabItemCandidateForFocus == null) {
                tabItemCandidateForFocus = tabFolder.getItem(0);
            }
            tabFolder.setSelection(tabItemCandidateForFocus);
        } else {
            String tabName = "Core 0";
            if (!fBinaries.isEmpty()) {
                tabName = fBinaries.get(0);
            }
            this.createCoreTab(this.fTabComp, tabName);
        }
        this.fTabComp.setLayout((Layout)tabLayout);
        this.fTabComp.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                StartupTab.this.adjustSize();
            }
        });
        this.adjustSize();
    }

    public void scheduleUpdateJob() {
        super.scheduleUpdateJob();
    }

    public void adjustSize() {
        int newWidth = this.fTabComp.getSize().x;
        int width = -1;
        if (newWidth != width) {
            ((ScrolledComposite)this.fMainComp.getParent()).setMinHeight(this.fTabComp.computeSize((int)newWidth, (int)-1).y);
            width = newWidth;
        }
    }

    public IStartupCoreTab createCoreTab(Composite parent, String tabName) {
        StartupCoreTab coreTab = new StartupCoreTab(this, parent);
        fmapCoreTab.put(tabName, coreTab);
        return coreTab;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        fBinaries = DebugUtil.getBinaries((ILaunchConfiguration)configuration);
        int index = fBinaries.size();
        if (index == 0) {
            index = 1;
        }
        String strIndex = "";
        int i = 0;
        while (i < index) {
            IStartupCoreTab coreTab;
            String tabName = "Core " + i;
            if (fBinaries.size() > i && !fBinaries.get(i).isEmpty()) {
                tabName = fBinaries.get(i);
            }
            if ((coreTab = fmapCoreTab.get(tabName)) != null) {
                if (i > 0) {
                    strIndex = "_" + i;
                }
                configuration.setAttribute("com.gigadevice.debug.launch.doFirstReset" + strIndex, coreTab.getfDoFirstReset().getSelection());
                configuration.setAttribute("com.gigadevice.debug.launch.firstResetType" + strIndex, coreTab.getfFirstResetType().getText().trim());
                configuration.setAttribute("com.gigadevice.debug.launch.otherInitCommands" + strIndex, coreTab.getfInitCommands().getText().trim());
                configuration.setAttribute("com.gigadevice.debug.launch.loadSymbols" + strIndex, coreTab.getfLoadSymbols().getSelection());
                configuration.setAttribute("com.gigadevice.debug.launch.useProjBinaryForSymbols" + strIndex, coreTab.getfUseProjectBinaryForSymbols().getSelection());
                configuration.setAttribute("com.gigadevice.debug.launch.useFileForSymbols" + strIndex, coreTab.getfUseFileForSymbols().getSelection());
                configuration.setAttribute("com.gigadevice.debug.launch.symbolsFileName" + strIndex, coreTab.getfSymbolsFileName().getText().trim());
                configuration.setAttribute("com.gigadevice.debug.launch.symbolsOffset" + strIndex, coreTab.getfSymbolsOffset().getText());
                configuration.setAttribute("com.gigadevice.debug.launch.loadImage" + strIndex, coreTab.getfLoadExecutable().getSelection());
                configuration.setAttribute("com.gigadevice.debug.launch.useProjBinaryForImage" + strIndex, coreTab.getfUseProjectBinaryForImage().getSelection());
                configuration.setAttribute("com.gigadevice.debug.launch.useFileForImage" + strIndex, coreTab.getfUseFileForImage().getSelection());
                configuration.setAttribute("com.gigadevice.debug.launch.imageFileName" + strIndex, coreTab.getfImageFileName().getText().trim());
                configuration.setAttribute("com.gigadevice.debug.launch.imageOffset" + strIndex, coreTab.getfImageOffset().getText());
                configuration.setAttribute("com.gigadevice.debug.launch.doSecondReset" + strIndex, coreTab.getfDoSecondReset().getSelection());
                configuration.setAttribute("com.gigadevice.debug.launch.secondResetType" + strIndex, coreTab.getfSecondResetType().getText().trim());
                configuration.setAttribute("com.gigadevice.debug.launch.otherRunCommands" + strIndex, coreTab.getfRunCommands().getText().trim());
                configuration.setAttribute("com.gigadevice.debug.launch.setPcRegister" + strIndex, coreTab.getfSetPcRegister().getSelection());
                configuration.setAttribute("com.gigadevice.debug.launch.pcRegister" + strIndex, coreTab.getfPcRegister().getText());
                configuration.setAttribute("com.gigadevice.debug.launch.setStopAt" + strIndex, coreTab.getfSetStopAt().getSelection());
                configuration.setAttribute("com.gigadevice.debug.launch.stopAt" + strIndex, coreTab.getfStopAt().getText());
                configuration.setAttribute("com.gigadevice.debug.launch.doContinue" + strIndex, coreTab.getfDoContinue().getSelection());
            }
            ++i;
        }
    }

    public String getName() {
        return Messages.SwitchLanguageHandler_Startup;
    }
}

