/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.ui;

import com.gigadevice.debug.messages.Messages;
import com.gigadevice.debug.startup.IStartupCoreTab;
import com.gigadevice.debug.ui.CompositeUtils;
import com.gigadevice.debug.ui.StartupTab;
import com.gigadevice.debug.utils.DebugUtil;
import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class StartupCoreTab
implements IStartupCoreTab {
    protected StartupTab fStartupTab;
    private Composite fComp;
    private Text fInitCommands;
    private Button fDoFirstReset;
    private Text fFirstResetType;
    private Button fDoSecondReset;
    private Text fSecondResetType;
    private Button fLoadExecutable;
    private Text fImageFileName;
    private Button fImageFileBrowseWs;
    private Button fImageFileBrowse;
    private Text fImageOffset;
    private Button fLoadSymbols;
    private Text fSymbolsFileName;
    private Button fSymbolsFileBrowseWs;
    private Button fSymbolsFileBrowse;
    private Text fSymbolsOffset;
    private Button fSetPcRegister;
    private Text fPcRegister;
    private Button fSetStopAt;
    private Text fStopAt;
    private Text fRunCommands;
    private Button fDoContinue;
    private Button fUseProjectBinaryForImage;
    private Button fUseFileForImage;
    private Button fUseProjectBinaryForSymbols;
    private Button fUseFileForSymbols;
    private Label fImageOffsetLabel;
    private Label fSymbolsOffsetLabel;
    private Label fProjBinaryLabel1;
    private Label fProjBinaryLabel2;
    private String fSavedProgName = "";
    private int fIndex;

    public StartupCoreTab(StartupTab tab, Composite parent) {
        this.fStartupTab = tab;
        this.fComp = new Composite(parent, 2048);
        this.fComp.setLayout((Layout)new GridLayout());
        GridData tabData = new GridData(1808);
        this.fComp.setLayoutData((Object)tabData);
        this.createInitGroup();
        this.createLoadGroup();
        this.createRunGroup();
    }

    private void createInitGroup() {
        Group group = CompositeUtils.createGroup(this.fComp, Messages.SwitchLanguageHandler_InitializationSettings, 0, 768);
        Composite comp = CompositeUtils.createComposite((Composite)group, 0, 768, 1, 0, -1, -1, -1, -1);
        Composite composite1 = CompositeUtils.createComposite(comp, 0, 768, 3, 0, 0, -1, -1, -1);
        this.fDoFirstReset = CompositeUtils.createButton(composite1, Messages.SwitchLanguageHandler_InitialReset, 32);
        CompositeUtils.createLabel(composite1, Messages.SwitchLanguageHandler_TypeLabel, 0);
        GridData gd = CompositeUtils.createGridData(-1, 30, -1, -1);
        this.fFirstResetType = CompositeUtils.createText(composite1, gd, 2048);
        gd = CompositeUtils.createGridData(1808, -1, 60, -1);
        this.fInitCommands = CompositeUtils.createText(comp, gd, 2626);
        this.fDoFirstReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StartupCoreTab.this.doFirstResetChanged();
                StartupCoreTab.this.fStartupTab.scheduleUpdateJob();
            }
        });
        ModifyListener scheduleUpdateJobModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StartupCoreTab.this.fStartupTab.scheduleUpdateJob();
            }
        };
        this.fFirstResetType.addModifyListener(scheduleUpdateJobModifyListener);
        this.fInitCommands.addModifyListener(scheduleUpdateJobModifyListener);
    }

    private void createLoadGroup() {
        Group group = CompositeUtils.createGroup(this.fComp, Messages.SwitchLanguageHandler_LoadSymbolsAndExecutable, 0, 768);
        Composite comp = CompositeUtils.createComposite((Composite)group, 0, 768, 1, 0, -1, -1, -1, -1);
        this.fLoadSymbols = CompositeUtils.createButton(comp, Messages.SwitchLanguageHandler_LoadSymbols, 32);
        Composite local = CompositeUtils.createComposite(comp, 0, 768, 4, 0, -1, -1, -1, -1);
        this.fUseProjectBinaryForSymbols = CompositeUtils.createButton(local, Messages.SwitchLanguageHandler_UseProjectBinary, 16);
        this.fProjBinaryLabel2 = CompositeUtils.createLabel(local, null, 0);
        this.fProjBinaryLabel2.setLayoutData((Object)CompositeUtils.createGridData(768, -1, -1, ((GridLayout)local.getLayout()).numColumns - 1));
        this.fUseFileForSymbols = CompositeUtils.createButton(local, Messages.SwitchLanguageHandler_UseFile, 16);
        this.fSymbolsFileName = CompositeUtils.createText(local, CompositeUtils.createGridData(768, -1, -1, -1), 2048);
        this.fSymbolsFileBrowseWs = this.fStartupTab.createPushButton(local, Messages.SwitchLanguageHandler_WorkspaceButton, null);
        this.fSymbolsFileBrowse = this.fStartupTab.createPushButton(local, Messages.SwitchLanguageHandler_FileSystemButton, null);
        this.fSymbolsOffsetLabel = CompositeUtils.createLabel(local, Messages.SwitchLanguageHandler_SymbolsOffsetLabel, 0);
        this.fSymbolsOffset = CompositeUtils.createText(local, CompositeUtils.createGridData(-1, 100, -1, ((GridLayout)local.getLayout()).numColumns - 1), 2048);
        this.fLoadExecutable = CompositeUtils.createButton(comp, Messages.SwitchLanguageHandler_LoadExecutable, 32);
        local = CompositeUtils.createComposite(comp, 0, 768, 4, 0, -1, -1, -1, -1);
        this.fUseProjectBinaryForImage = CompositeUtils.createButton(local, Messages.SwitchLanguageHandler_UseProjectBinary, 16);
        this.fProjBinaryLabel1 = CompositeUtils.createLabel(local, null, 0);
        this.fProjBinaryLabel1.setLayoutData((Object)CompositeUtils.createGridData(768, -1, -1, ((GridLayout)local.getLayout()).numColumns - 1));
        this.fUseFileForImage = CompositeUtils.createButton(local, Messages.SwitchLanguageHandler_UseFile, 16);
        this.fImageFileName = CompositeUtils.createText(local, CompositeUtils.createGridData(768, -1, -1, -1), 2048);
        this.fImageFileBrowseWs = this.fStartupTab.createPushButton(local, Messages.SwitchLanguageHandler_WorkspaceButton, null);
        this.fImageFileBrowse = this.fStartupTab.createPushButton(local, Messages.SwitchLanguageHandler_FileSystemButton, null);
        this.fImageOffsetLabel = CompositeUtils.createLabel(local, Messages.SwitchLanguageHandler_ExecutableOffsetLabel, 0);
        this.fImageOffset = CompositeUtils.createText(local, CompositeUtils.createGridData(-1, 100, -1, ((GridLayout)local.getLayout()).numColumns - 1), 2048);
        this.fLoadExecutable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StartupCoreTab.this.loadExecutableChanged();
                StartupCoreTab.this.fStartupTab.scheduleUpdateJob();
            }
        });
        SelectionListener radioButtonListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StartupCoreTab.this.updateUseFileEnablement();
                StartupCoreTab.this.fStartupTab.scheduleUpdateJob();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fUseProjectBinaryForImage.addSelectionListener(radioButtonListener);
        this.fUseFileForImage.addSelectionListener(radioButtonListener);
        this.fUseProjectBinaryForSymbols.addSelectionListener(radioButtonListener);
        this.fUseFileForSymbols.addSelectionListener(radioButtonListener);
        this.fImageFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StartupCoreTab.this.fStartupTab.scheduleUpdateJob();
            }
        });
        this.fImageFileBrowseWs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StartupCoreTab.this.browseWsButtonSelected(Messages.SwitchLanguageHandler_ExecutableFileBrowseWs_Title, StartupCoreTab.this.fImageFileName);
            }
        });
        this.fImageFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StartupCoreTab.this.browseButtonSelected(Messages.SwitchLanguageHandler_ExecutableFileBrowse_Title, StartupCoreTab.this.fImageFileName);
            }
        });
        this.fImageOffset.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character) || "abcdef".contains(String.valueOf(e.character).toLowerCase());
            }
        });
        this.fImageOffset.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StartupCoreTab.this.fStartupTab.scheduleUpdateJob();
            }
        });
        this.fLoadSymbols.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StartupCoreTab.this.loadSymbolsChanged();
                StartupCoreTab.this.fStartupTab.scheduleUpdateJob();
            }
        });
        this.fSymbolsFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StartupCoreTab.this.fStartupTab.scheduleUpdateJob();
            }
        });
        this.fSymbolsFileBrowseWs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StartupCoreTab.this.browseWsButtonSelected(Messages.SwitchLanguageHandler_SymbolsFileBrowseWs_Title, StartupCoreTab.this.fSymbolsFileName);
            }
        });
        this.fSymbolsFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StartupCoreTab.this.browseButtonSelected(Messages.SwitchLanguageHandler_SymbolsFileBrowse_Title, StartupCoreTab.this.fSymbolsFileName);
            }
        });
        this.fSymbolsOffset.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character) || "abcdef".contains(String.valueOf(e.character).toLowerCase());
            }
        });
        this.fSymbolsOffset.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StartupCoreTab.this.fStartupTab.scheduleUpdateJob();
            }
        });
    }

    private void createRunGroup() {
        Group group = CompositeUtils.createGroup(this.fComp, Messages.SwitchLanguageHandler_RunRestartSettings, 0, 768);
        Composite comp = CompositeUtils.createComposite((Composite)group, 0, 768, 4, 0, -1, -1, -1, -1);
        this.fSetPcRegister = CompositeUtils.createButton(comp, Messages.SwitchLanguageHandler_SetPcRegister, 32);
        GridData gd = CompositeUtils.createGridData(-1, 100, -1, ((GridLayout)comp.getLayout()).numColumns - 1);
        this.fPcRegister = CompositeUtils.createText(comp, gd, 2048);
        this.fSetStopAt = CompositeUtils.createButton(comp, Messages.SwitchLanguageHandler_SetBreakpoint, 32);
        gd = CompositeUtils.createGridData(-1, 100, -1, ((GridLayout)comp.getLayout()).numColumns - 1);
        this.fStopAt = CompositeUtils.createText(comp, gd, 2048);
        this.fDoContinue = CompositeUtils.createButton(comp, Messages.SwitchLanguageHandler_DoContinue, 32);
        gd = CompositeUtils.createGridData(-1, 100, -1, ((GridLayout)comp.getLayout()).numColumns);
        this.fDoContinue.setLayoutData((Object)gd);
        this.fDoSecondReset = CompositeUtils.createButton(comp, Messages.SwitchLanguageHandler_PreRunRestartReset, 32);
        gd = CompositeUtils.createGridData(-1, 100, -1, ((GridLayout)comp.getLayout()).numColumns - 1);
        CompositeUtils.createLabel(comp, Messages.SwitchLanguageHandler_TypeLabel, 0);
        gd = CompositeUtils.createGridData(-1, 30, -1, -1);
        this.fSecondResetType = CompositeUtils.createText(comp, gd, 2048);
        gd = CompositeUtils.createGridData(1808, -1, 60, ((GridLayout)comp.getLayout()).numColumns);
        this.fRunCommands = CompositeUtils.createText(comp, gd, 2626);
        this.fDoSecondReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StartupCoreTab.this.doSecondResetChanged();
                StartupCoreTab.this.fStartupTab.scheduleUpdateJob();
            }
        });
        this.fSetPcRegister.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StartupCoreTab.this.pcRegisterChanged();
                StartupCoreTab.this.fStartupTab.scheduleUpdateJob();
            }
        });
        this.fPcRegister.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character) || "abcdef".contains(String.valueOf(e.character).toLowerCase());
            }
        });
        this.fPcRegister.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StartupCoreTab.this.fStartupTab.scheduleUpdateJob();
            }
        });
        this.fSetStopAt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StartupCoreTab.this.stopAtChanged();
                StartupCoreTab.this.fStartupTab.scheduleUpdateJob();
            }
        });
        this.fStopAt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StartupCoreTab.this.fStartupTab.scheduleUpdateJob();
            }
        });
        ModifyListener scheduleUpdateJobModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StartupCoreTab.this.fStartupTab.scheduleUpdateJob();
            }
        };
        SelectionAdapter scheduleUpdateJobSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StartupCoreTab.this.fStartupTab.scheduleUpdateJob();
            }
        };
        this.fSecondResetType.addModifyListener(scheduleUpdateJobModifyListener);
        this.fRunCommands.addModifyListener(scheduleUpdateJobModifyListener);
        this.fDoContinue.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
    }

    protected void stopAtChanged() {
        this.fStopAt.setEnabled(this.fSetStopAt.getSelection());
    }

    protected void pcRegisterChanged() {
        this.fPcRegister.setEnabled(this.fSetPcRegister.getSelection());
    }

    protected void doSecondResetChanged() {
        boolean enabled = this.fDoSecondReset.getSelection();
        this.fSecondResetType.setEnabled(enabled);
    }

    private void browseWsButtonSelected(String title, Text text) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.fStartupTab.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(title);
        dialog.setMessage(Messages.SwitchLanguageHandler_FileBrowseWs_Message);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            String arg = resource.getFullPath().toOSString();
            String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", arg);
            text.setText(fileLoc);
        }
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.fStartupTab.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    protected void doFirstResetChanged() {
        boolean enabled = this.fDoFirstReset.getSelection();
        this.fFirstResetType.setEnabled(enabled);
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        String strIndex = this.fIndex != 0 ? "_" + this.fIndex : "";
        try {
            this.fDoFirstReset.setSelection(configuration.getAttribute("com.gigadevice.debug.launch.doFirstReset" + strIndex, true));
            this.fFirstResetType.setText(configuration.getAttribute("com.gigadevice.debug.launch.firstResetType" + strIndex, "init"));
            this.fInitCommands.setText(configuration.getAttribute("com.gigadevice.debug.launch.otherInitCommands" + strIndex, ""));
            this.fLoadSymbols.setSelection(configuration.getAttribute("com.gigadevice.debug.launch.loadSymbols" + strIndex, true));
            this.fUseProjectBinaryForSymbols.setSelection(configuration.getAttribute("com.gigadevice.debug.launch.useProjBinaryForSymbols" + strIndex, true));
            this.fUseFileForSymbols.setSelection(configuration.getAttribute("com.gigadevice.debug.launch.useFileForSymbols" + strIndex, false));
            this.fSymbolsFileName.setText(configuration.getAttribute("com.gigadevice.debug.launch.symbolsFileName" + strIndex, ""));
            this.fSymbolsOffset.setText(configuration.getAttribute("com.gigadevice.debug.launch.symbolsOffset" + strIndex, ""));
            this.fLoadExecutable.setSelection(configuration.getAttribute("com.gigadevice.debug.launch.loadImage" + strIndex, true));
            this.fUseProjectBinaryForImage.setSelection(configuration.getAttribute("com.gigadevice.debug.launch.useProjBinaryForImage" + strIndex, true));
            this.fUseFileForImage.setSelection(configuration.getAttribute("com.gigadevice.debug.launch.useFileForImage" + strIndex, false));
            this.fImageFileName.setText(configuration.getAttribute("com.gigadevice.debug.launch.imageFileName" + strIndex, ""));
            this.fImageOffset.setText(configuration.getAttribute("com.gigadevice.debug.launch.imageOffset" + strIndex, ""));
            String programName = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME" + strIndex, "");
            if (programName != null) {
                int lastSlash = programName.indexOf(92);
                if (lastSlash >= 0) {
                    programName = programName.substring(lastSlash + 1);
                }
                if ((lastSlash = programName.indexOf(47)) >= 0) {
                    programName = programName.substring(lastSlash + 1);
                }
                this.fProjBinaryLabel1.setText(programName);
                this.fProjBinaryLabel2.setText(programName);
            }
            this.fSavedProgName = programName;
            this.fDoSecondReset.setSelection(configuration.getAttribute("com.gigadevice.debug.launch.doSecondReset" + strIndex, true));
            this.fSecondResetType.setText(configuration.getAttribute("com.gigadevice.debug.launch.secondResetType" + strIndex, "halt"));
            this.fRunCommands.setText(configuration.getAttribute("com.gigadevice.debug.launch.otherRunCommands" + strIndex, ""));
            this.fSetPcRegister.setSelection(configuration.getAttribute("com.gigadevice.debug.launch.setPcRegister" + strIndex, false));
            this.fPcRegister.setText(configuration.getAttribute("com.gigadevice.debug.launch.pcRegister" + strIndex, ""));
            this.fSetStopAt.setSelection(configuration.getAttribute("com.gigadevice.debug.launch.setStopAt" + strIndex, true));
            this.fStopAt.setText(configuration.getAttribute("com.gigadevice.debug.launch.stopAt" + strIndex, "main"));
            this.fDoContinue.setSelection(configuration.getAttribute("com.gigadevice.debug.launch.doContinue" + strIndex, true));
            this.doFirstResetChanged();
            this.doSecondResetChanged();
            this.loadExecutableChanged();
            this.loadSymbolsChanged();
            this.pcRegisterChanged();
            this.stopAtChanged();
            this.updateUseFileEnablement();
            this.activateTab(configuration);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateUseFileEnablement() {
        boolean enabled = this.fLoadExecutable.getSelection() && this.fUseFileForImage.getSelection();
        this.fImageFileName.setEnabled(enabled);
        this.fImageFileBrowseWs.setEnabled(enabled);
        this.fImageFileBrowse.setEnabled(enabled);
        enabled = this.fLoadSymbols.getSelection() && this.fUseFileForSymbols.getSelection();
        this.fSymbolsFileName.setEnabled(enabled);
        this.fSymbolsFileBrowseWs.setEnabled(enabled);
        this.fSymbolsFileBrowse.setEnabled(enabled);
    }

    private void loadSymbolsChanged() {
        boolean enabled = this.fLoadSymbols.getSelection();
        this.fUseProjectBinaryForSymbols.setEnabled(enabled);
        this.fUseFileForSymbols.setEnabled(enabled);
        this.fSymbolsOffset.setEnabled(enabled);
        this.fSymbolsOffsetLabel.setEnabled(enabled);
        this.updateUseFileEnablement();
    }

    private void loadExecutableChanged() {
        boolean enabled = this.fLoadExecutable.getSelection();
        this.fUseProjectBinaryForImage.setEnabled(enabled);
        this.fUseFileForImage.setEnabled(enabled);
        this.fImageOffset.setEnabled(enabled);
        this.fImageOffsetLabel.setEnabled(enabled);
        this.updateUseFileEnablement();
    }

    @Override
    public boolean isValid(ILaunchConfiguration paramILaunchConfiguration) {
        Path path1;
        String path;
        if (this.fLoadExecutable.getSelection()) {
            if (!this.fUseProjectBinaryForImage.getSelection()) {
                if (this.fImageFileName.getText().trim().length() == 0) {
                    this.fStartupTab.setErrorMessage(Messages.SwitchLanguageHandler_ExecutableFileName_not_specified);
                    return false;
                }
                try {
                    path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.fImageFileName.getText().trim());
                    path1 = new Path(path);
                    if (!path1.toFile().exists()) {
                        this.fStartupTab.setErrorMessage(Messages.SwitchLanguageHandler_ExecutableFileName_does_not_exist);
                        return false;
                    }
                }
                catch (CoreException coreException) {
                    this.fStartupTab.setErrorMessage(Messages.SwitchLanguageHandler_ExecutableFileName_does_not_exist);
                    return false;
                }
            }
        } else {
            this.fStartupTab.setErrorMessage(null);
        }
        if (this.fLoadSymbols.getSelection()) {
            if (!this.fUseProjectBinaryForSymbols.getSelection()) {
                if (this.fSymbolsFileName.getText().trim().length() == 0) {
                    this.fStartupTab.setErrorMessage(Messages.SwitchLanguageHandler_SymbolsFileName_not_specified);
                    return false;
                }
                try {
                    path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.fSymbolsFileName.getText().trim());
                    path1 = new Path(path);
                    if (!path1.toFile().exists()) {
                        this.fStartupTab.setErrorMessage(Messages.SwitchLanguageHandler_SymbolsFileName_does_not_exist);
                        return false;
                    }
                }
                catch (CoreException coreException) {
                    this.fStartupTab.setErrorMessage(Messages.SwitchLanguageHandler_SymbolsFileName_does_not_exist);
                    return false;
                }
            }
        } else {
            this.fStartupTab.setErrorMessage(null);
        }
        if (this.fSetPcRegister.getSelection()) {
            if (this.fPcRegister.getText().trim().length() == 0) {
                this.fStartupTab.setErrorMessage(Messages.SwitchLanguageHandler_PcRegister_not_specified);
                return false;
            }
        } else {
            this.fStartupTab.setErrorMessage(null);
        }
        if (this.fSetStopAt.getSelection()) {
            if (this.fStopAt.getText().trim().length() == 0) {
                this.fStartupTab.setErrorMessage(Messages.SwitchLanguageHandler_StopAt_not_specified);
            }
        } else {
            this.fStartupTab.setErrorMessage(null);
        }
        return true;
    }

    public void activateTab(ILaunchConfiguration configuration) throws CoreException {
        Boolean isActivated = DebugUtil.getAttribute(configuration, "com.gigadevice.debug.launch.debugIsActivated", this.fIndex, true);
        this.doActivateTabRecursively((Control)this.fComp, isActivated);
    }

    public void doActivateTabRecursively(Control ctrl, boolean enabled) {
        if (ctrl instanceof Composite) {
            Composite comp = (Composite)ctrl;
            Control[] arrayOfControl = comp.getChildren();
            int i = 0;
            while (i < arrayOfControl.length) {
                Control c = arrayOfControl[i];
                this.doActivateTabRecursively(c, enabled);
                ++i;
            }
        } else {
            ctrl.setEnabled(enabled);
        }
    }

    @Override
    public Composite getComposite() {
        return this.fComp;
    }

    @Override
    public StartupTab getfStartupTab() {
        return this.fStartupTab;
    }

    @Override
    public Composite getfComp() {
        return this.fComp;
    }

    @Override
    public Text getfInitCommands() {
        return this.fInitCommands;
    }

    @Override
    public Button getfDoFirstReset() {
        return this.fDoFirstReset;
    }

    @Override
    public Text getfFirstResetType() {
        return this.fFirstResetType;
    }

    @Override
    public Button getfDoSecondReset() {
        return this.fDoSecondReset;
    }

    @Override
    public Text getfSecondResetType() {
        return this.fSecondResetType;
    }

    @Override
    public Button getfLoadExecutable() {
        return this.fLoadExecutable;
    }

    @Override
    public Text getfImageFileName() {
        return this.fImageFileName;
    }

    @Override
    public Button getfImageFileBrowseWs() {
        return this.fImageFileBrowseWs;
    }

    @Override
    public Button getfImageFileBrowse() {
        return this.fImageFileBrowse;
    }

    @Override
    public Text getfImageOffset() {
        return this.fImageOffset;
    }

    @Override
    public Button getfLoadSymbols() {
        return this.fLoadSymbols;
    }

    @Override
    public Text getfSymbolsFileName() {
        return this.fSymbolsFileName;
    }

    @Override
    public Button getfSymbolsFileBrowseWs() {
        return this.fSymbolsFileBrowseWs;
    }

    @Override
    public Button getfSymbolsFileBrowse() {
        return this.fSymbolsFileBrowse;
    }

    @Override
    public Text getfSymbolsOffset() {
        return this.fSymbolsOffset;
    }

    @Override
    public Button getfSetPcRegister() {
        return this.fSetPcRegister;
    }

    @Override
    public Text getfPcRegister() {
        return this.fPcRegister;
    }

    @Override
    public Button getfSetStopAt() {
        return this.fSetStopAt;
    }

    @Override
    public Text getfStopAt() {
        return this.fStopAt;
    }

    @Override
    public Text getfRunCommands() {
        return this.fRunCommands;
    }

    @Override
    public Button getfDoContinue() {
        return this.fDoContinue;
    }

    @Override
    public Button getfUseProjectBinaryForImage() {
        return this.fUseProjectBinaryForImage;
    }

    @Override
    public Button getfUseFileForImage() {
        return this.fUseFileForImage;
    }

    @Override
    public Button getfUseProjectBinaryForSymbols() {
        return this.fUseProjectBinaryForSymbols;
    }

    @Override
    public Button getfUseFileForSymbols() {
        return this.fUseFileForSymbols;
    }

    @Override
    public Label getfImageOffsetLabel() {
        return this.fImageOffsetLabel;
    }

    @Override
    public Label getfSymbolsOffsetLabel() {
        return this.fSymbolsOffsetLabel;
    }

    @Override
    public Label getfProjBinaryLabel1() {
        return this.fProjBinaryLabel1;
    }

    @Override
    public Label getfProjBinaryLabel2() {
        return this.fProjBinaryLabel2;
    }

    @Override
    public String getfSavedProgName() {
        return this.fSavedProgName;
    }

    @Override
    public int getfIndex() {
        return this.fIndex;
    }

    @Override
    public void setfIndex(int fIndex) {
        this.fIndex = fIndex;
    }
}

