/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.ui;

import com.gigadevice.debug.liveexpressions.IGDBVarManagerService;
import com.gigadevice.debug.ui.IPeriRegListener;
import com.gigadevice.debug.utils.GdbDebugUtil;
import com.gigadevice.debug.utils.TreeRegister;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.eclipse.swt.widgets.Display;

public class PeripheralsViewManager {
    private IGDBVarManagerService liveService;
    private ArrayList<IPeriRegListener> listeners;
    private PeriRegUpdateThread updateThread = null;
    private Map<String, TreeRegister> periRegs = new HashMap<String, TreeRegister>();

    public PeripheralsViewManager() {
        this.listeners = new ArrayList();
        this.updateThread = new PeriRegUpdateThread();
        this.updateThread.start();
    }

    public synchronized void updatePeriRegs(TreeRegister periRegObj, int oper) {
        String registerAddr = Long.toString(periRegObj.getRegisterAddr());
        if (oper == 0) {
            if (!this.periRegs.containsKey(registerAddr)) {
                this.periRegs.put(registerAddr, periRegObj);
            }
        } else if (this.periRegs.containsKey(registerAddr)) {
            this.periRegs.remove(registerAddr);
        }
    }

    public synchronized void clearPeriRegs() {
        this.periRegs.clear();
    }

    public synchronized long getMemoryValue(String address, int iByteCount) {
        boolean[] success = new boolean[1];
        return this.getMemoryValue(address, iByteCount, success);
    }

    public synchronized long getMemoryValue(String address, int iByteCount, boolean[] success) {
        long value = 0L;
        success[0] = false;
        IGDBVarManagerService tmpService = this.getLiveService();
        if (tmpService != null) {
            value = tmpService.getMemoryValue(address, iByteCount, success);
        }
        return value;
    }

    public synchronized int setMemory(String address, String value, int iByteCount) {
        int ret = -1;
        IGDBVarManagerService tmpService = this.getLiveService();
        if (tmpService != null) {
            ret = tmpService.setMemory(address, value, iByteCount);
        }
        return ret;
    }

    public synchronized void setLiveService(IGDBVarManagerService liveService) {
        this.liveService = liveService;
    }

    public IGDBVarManagerService getLiveService() {
        if (this.liveService != null && this.liveService.isRegistered()) {
            return this.liveService;
        }
        this.retryGetLiveService();
        if (this.liveService != null && this.liveService.isRegistered()) {
            return this.liveService;
        }
        return null;
    }

    private void retryGetLiveService() {
        try {
            System.out.println("PeripheralsViewManager: Attempting to retry get liveService...");
        }
        catch (Exception e) {
            System.err.println("PeripheralsViewManager: Failed to retry get live service: " + e.getMessage());
        }
    }

    public void addListener(IPeriRegListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IPeriRegListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyExpressionUpdate() {
        for (IPeriRegListener listener : this.listeners) {
            listener.periRegUpdate();
        }
    }

    public void setThreadState(int state) {
        this.updateThread.setThreadState(state);
    }

    public void setUpdateTimer(int state) {
        this.updateThread.setUpdateTimer(state);
    }

    public class PeriRegUpdateThread
    extends Thread {
        private int state = 1;
        private int updateTimer = 1000;
        private Semaphore semaphore = new Semaphore(0);

        public synchronized int getThreadState() {
            return this.state;
        }

        public synchronized void setThreadState(int newState) {
            if (3 == newState) {
                this.state = newState;
                this.semaphore.release();
            } else if (newState != this.state) {
                if (newState == 0) {
                    this.state = newState;
                    this.interrupt();
                } else if (1 == newState) {
                    this.state = newState;
                } else if (2 == newState) {
                    if (1 == this.state || 3 == this.state) {
                        this.state = newState;
                        this.semaphore.release();
                    } else {
                        this.state = newState;
                    }
                }
            }
        }

        public synchronized void setUpdateTimer(int value) {
            this.updateTimer = value;
        }

        @Override
        public void run() {
            try {
                block2: while (true) {
                    int state;
                    if ((state = this.getThreadState()) == 0) {
                        return;
                    }
                    if (1 == state) {
                        this.semaphore.acquire();
                        continue;
                    }
                    if (2 != state && 3 != state) continue;
                    while (true) {
                        if (2 != this.getThreadState() && 3 != this.getThreadState()) continue block2;
                        HashMap copyPeriRegs = new HashMap(PeripheralsViewManager.this.periRegs);
                        Set addressList = copyPeriRegs.keySet();
                        for (String address : addressList) {
                            if (!copyPeriRegs.containsKey(address)) continue;
                            TreeRegister regObj = (TreeRegister)copyPeriRegs.get(address);
                            boolean[] success = new boolean[1];
                            long value = PeripheralsViewManager.this.getMemoryValue(address, regObj.getSize(), success);
                            if (success[0]) {
                                System.out.println(String.valueOf(Long.toHexString(Integer.valueOf(address).intValue())) + " -register value " + Long.toHexString(value) + System.getProperty("line.separator"));
                                regObj.updateValue(value);
                                continue;
                            }
                            System.out.println("Failed to read memory at address: " + address);
                            if (!GdbDebugUtil.isNonStop) break;
                        }
                        PeripheralsViewManager.this.notifyExpressionUpdate();
                        if (3 == this.getThreadState()) {
                            this.setThreadState(1);
                            Thread.sleep(this.updateTimer);
                            continue block2;
                        }
                        Thread.sleep(this.updateTimer);
                        if (!GdbDebugUtil.isNonStop) {
                            this.setThreadState(1);
                            continue block2;
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!GdbDebugUtil.isNonStop) {
                                    PeriRegUpdateThread.this.setThreadState(0);
                                    return;
                                }
                            }
                        });
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

