/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.liveexpressions;

import com.gigadevice.debug.liveexpressions.GDBDebugManager;
import com.gigadevice.debug.liveexpressions.IDebugContextManagerListener;
import com.gigadevice.debug.liveexpressions.IGDBVarManagerService;
import com.gigadevice.debug.liveexpressions.ILiveVarListener;
import com.gigadevice.debug.liveexpressions.LiveVarManager;
import com.gigadevice.debug.liveexpressions.LiveVariable;
import com.gigadevice.debug.liveexpressions.actions.NumberFormatMenu;
import com.gigadevice.debug.liveexpressions.actions.RemoveAction;
import com.gigadevice.debug.liveexpressions.actions.RemoveAllAction;
import com.gigadevice.debug.utils.GdbDebugUtil;
import com.gigadevice.venustool.GeneralPathUtil;
import java.util.ArrayList;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeAdapter;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class LiveVarExpressionView
extends ViewPart
implements ILiveVarListener,
IDebugContextManagerListener {
    private Tree tree;
    private TreeViewer fTreeView;
    private TreeColumn typeColumn;
    private TreeColumn valueColumn;
    private TreeColumn exprColumn;
    private TreeViewerColumn exprViewerColumn;
    Composite delayComposite;
    protected Spinner delaySpinBox;
    protected int delay = 1000;
    private RemoveAction removeAction;
    private RemoveAllAction removeAllAction;
    private NumberFormatMenu numberFormatMenu;
    public LiveVarManager fVarManager;
    private MyPartListener myPartListener;
    public static Object curSession = null;
    private GDBDebugManager fContextManager = new GDBDebugManager(this);
    public boolean isOpenView;
    private DebugState viewState;
    protected final ContributionItem delaySpin = new ContributionItem("delaySpin"){
        protected int minValue;
        protected int maxValue;
        {
            this.minValue = 500;
            this.maxValue = 10000;
        }

        public void fill(ToolBar parent, int index) {
            ToolItem item = new ToolItem(parent, 2);
            LiveVarExpressionView.this.delayComposite = new Composite((Composite)parent, 0);
            LiveVarExpressionView.this.delayComposite.setToolTipText("test");
            LiveVarExpressionView.this.delayComposite.setBounds(0, 0, 150, 23);
            Label lblNewLabel = new Label(LiveVarExpressionView.this.delayComposite, 0);
            lblNewLabel.setBounds(0, 5, 40, 18);
            lblNewLabel.setText("Delay:");
            LiveVarExpressionView.this.delaySpinBox = new Spinner(LiveVarExpressionView.this.delayComposite, 2048);
            LiveVarExpressionView.this.delaySpinBox.setBounds(40, 2, 80, 22);
            LiveVarExpressionView.this.delaySpinBox.setToolTipText("valid range: [500,10000]");
            LiveVarExpressionView.this.delaySpinBox.setIncrement(100);
            LiveVarExpressionView.this.delaySpinBox.setMinimum(this.minValue);
            LiveVarExpressionView.this.delaySpinBox.setMaximum(this.maxValue);
            LiveVarExpressionView.this.delaySpinBox.setSelection(LiveVarExpressionView.this.delay);
            LiveVarExpressionView.this.delaySpinBox.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    this.setDelay((this).LiveVarExpressionView.this.delaySpinBox.getSelection());
                }
            });
            LiveVarExpressionView.this.delaySpinBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.setDelay((this).LiveVarExpressionView.this.delaySpinBox.getSelection());
                }

                public void widgetSelected(SelectionEvent e) {
                    if ((e.stateMask & SWT.BUTTON_MASK) != 0) {
                        this.setDelay((this).LiveVarExpressionView.this.delaySpinBox.getSelection());
                    }
                }
            });
            LiveVarExpressionView.this.delaySpinBox.setEnabled(true);
            item.setWidth(120);
            item.setControl((Control)LiveVarExpressionView.this.delayComposite);
        }

        private int round(int number, int increment) {
            int a = number / increment * increment;
            int b = a + increment;
            return number - a > b - number ? b : a;
        }

        private void setDelay(int spinnerValue) {
            int value = this.round(spinnerValue, 100);
            if (value < this.minValue) {
                value = this.minValue;
            } else if (value > this.maxValue) {
                value = this.maxValue;
            }
            LiveVarExpressionView.this.delaySpinBox.setSelection(value);
            LiveVarExpressionView.this.delay = value;
            LiveVarExpressionView.this.fVarManager.setDelay(value);
        }

        public void fill(CoolBar parent, int index) {
            super.fill(parent, index);
            Spinner spinner = new Spinner((Composite)parent, 0);
            spinner.setLayoutData((Object)new GridData());
        }
    };

    public LiveVarExpressionView() {
        this.fVarManager = new LiveVarManager();
        this.fVarManager.addExpressionListener(this);
        this.isOpenView = true;
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        composite.setLayout((Layout)gl_composite);
        this.fTreeView = new TreeViewer(composite, 67584);
        this.tree = this.fTreeView.getTree();
        this.tree.setLinesVisible(true);
        this.tree.setHeaderVisible(true);
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.exprViewerColumn = new TreeViewerColumn(this.fTreeView, 0);
        this.exprColumn = this.exprViewerColumn.getColumn();
        this.exprColumn.setWidth(250);
        this.exprColumn.setText("Name");
        this.exprViewerColumn.setEditingSupport((EditingSupport)new ViewerEditingSupport(this.fTreeView, ColumnInfo.COLUMN_NAME));
        this.exprViewerColumn.setLabelProvider((CellLabelProvider)new ViewerLabelProvider(ColumnInfo.COLUMN_NAME));
        TreeViewerColumn typeViewerColumn = new TreeViewerColumn(this.fTreeView, 0);
        this.typeColumn = typeViewerColumn.getColumn();
        this.typeColumn.setWidth(200);
        this.typeColumn.setText("Type");
        typeViewerColumn.setLabelProvider((CellLabelProvider)new ViewerLabelProvider(ColumnInfo.COLUMN_TYPE));
        TreeViewerColumn valueViewerColumn = new TreeViewerColumn(this.fTreeView, 0);
        this.valueColumn = valueViewerColumn.getColumn();
        this.valueColumn.setWidth(300);
        this.valueColumn.setText("Value");
        valueViewerColumn.setEditingSupport((EditingSupport)new ViewerEditingSupport(this.fTreeView, ColumnInfo.COLUMN_VALUE));
        valueViewerColumn.setLabelProvider((CellLabelProvider)new ViewerLabelProvider(ColumnInfo.COLUMN_VALUE));
        this.fTreeView.setContentProvider((IContentProvider)new LiveExpressionsContentProvider(this));
        this.addListener();
        this.fTreeView.setInput(this.fVarManager.getExpressions());
        this.fContextManager.start();
        this.fTreeView.expandAll();
        IWorkbenchPage page = this.getSite().getPage();
        this.myPartListener = new MyPartListener();
        page.addPartListener((IPartListener)this.myPartListener);
    }

    private void addListener() {
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LiveVarExpressionView.this.updateRowAction();
            }
        });
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LiveVarExpressionView.this.updateMenuState(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fTreeView.getControl());
        this.fTreeView.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fTreeView);
        this.fTreeView.getTree().addTreeListener((TreeListener)new TreeAdapter(){

            public void treeExpanded(TreeEvent e) {
                Object node;
                if (e.getSource() instanceof Tree && (node = e.item.getData()) instanceof LiveVariable) {
                    LiveVariable expr = (LiveVariable)node;
                    LiveVarExpressionView.this.fVarManager.changeNumberFormat(expr.getExpressions());
                }
            }

            public void treeCollapsed(TreeEvent e) {
            }
        });
        this.createActions();
    }

    public void updateRowAction() {
        LiveVariable expr;
        Object element;
        this.removeAllAction.setEnabled(this.fVarManager.getSize() > 1);
        this.removeAction.setEnabled(false);
        ITreeSelection selection = (ITreeSelection)this.fTreeView.getSelection();
        if (selection != null && (element = selection.getFirstElement()) instanceof LiveVariable && (expr = (LiveVariable)element).getExpression() != null && expr.getParent() == null) {
            this.removeAction.setEnabled(true);
        }
    }

    public void refreshUI() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                LiveVarExpressionView.this.fTreeView.refresh();
                LiveVarExpressionView.this.fTreeView.expandAll();
            }
        });
    }

    private void createActions() {
        this.removeAction = new RemoveAction(this);
        this.removeAllAction = new RemoveAllAction(this);
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager toolbar = bars.getToolBarManager();
        toolbar.add((IContributionItem)this.delaySpin);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IAction)this.removeAction);
        toolbar.add((IAction)this.removeAllAction);
        IMenuManager menuMan = bars.getMenuManager();
        this.numberFormatMenu = new NumberFormatMenu(this);
        menuMan.add((IContributionItem)this.numberFormatMenu);
        this.delaySpin.setVisible(true);
    }

    protected void updateMenuState(IMenuManager manager) {
        LiveVariable expr;
        Object element;
        ITreeSelection selection;
        this.removeAction.setEnabled(false);
        this.removeAllAction.setEnabled(false);
        int nrExpressions = this.fVarManager.getExpressions().size();
        if (nrExpressions > 1 && (selection = (ITreeSelection)this.fTreeView.getSelection()) != null && (element = selection.getFirstElement()) instanceof LiveVariable && (expr = (LiveVariable)element).getExpression() != null && expr.getParent() == null) {
            this.removeAction.setEnabled(true);
        }
        manager.add((IAction)this.removeAction);
        manager.add((IAction)this.removeAllAction);
    }

    public ITreeSelection getSelection() {
        return (ITreeSelection)this.fTreeView.getSelection();
    }

    public LiveVarManager getDataModel() {
        return this.fVarManager;
    }

    public void setFocus() {
    }

    @Override
    public void gdbResume() {
        if (!this.isViewActive()) {
            return;
        }
        this.fVarManager.setAutoUpdate(2);
    }

    @Override
    public void gdbSuspend() {
        this.fVarManager.setAutoUpdate(1);
    }

    public void handleNoDebugContext() {
        this.fVarManager.setAutoUpdate(1);
        this.fVarManager.reset();
        this.fVarManager.setLiveService(null);
        this.viewState = DebugState.NO_DEBUG;
        this.refreshUI();
        this.numberFormatMenu.setEnabled(false);
    }

    public void handleDebugContext() {
        this.viewState = DebugState.DEBUG;
        this.fVarManager.setAutoUpdate(1);
        this.fVarManager.reset();
        this.numberFormatMenu.setEnabled(false);
        DsfServicesTracker tracker = this.fContextManager.getServicesTracker();
        IGDBVarManagerService liveService = (IGDBVarManagerService)tracker.getService(IGDBVarManagerService.class);
        if (liveService != null) {
            this.fVarManager.setLiveService(liveService);
            this.viewState = DebugState.DEBUG_LIVE;
            this.numberFormatMenu.setEnabled(true);
            if (GdbDebugUtil.isNonStop) {
                this.fVarManager.reCreateVar();
            }
            if (!this.fContextManager.getIsSuspendedState()) {
                this.fVarManager.setAutoUpdate(2);
            } else if (!GdbDebugUtil.isNonStop) {
                this.fVarManager.reCreateVar();
            }
        } else {
            this.fVarManager.setLiveService(null);
        }
        this.refreshUI();
    }

    @Override
    public void gdbSession(String id) {
        if (!this.isOpenView) {
            return;
        }
        if (id != null) {
            GdbDebugUtil.fGDBDebug = true;
            this.handleDebugContext();
        } else {
            this.handleNoDebugContext();
        }
    }

    @Override
    public void gdbExited() {
    }

    public void dispose() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null && this.myPartListener != null) {
            page.removePartListener((IPartListener)this.myPartListener);
        }
        this.fVarManager.removeExpressionListener(this);
        this.fVarManager.dispose();
        super.dispose();
        this.isOpenView = false;
    }

    protected void updateData() {
        this.fVarManager.updateExpressionList();
    }

    @Override
    public void varUpdate(final LiveVariable paramExpression) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (paramExpression != null) {
                    LiveVarExpressionView.this.fTreeView.update((Object)paramExpression, null);
                } else {
                    LiveVarExpressionView.this.fTreeView.refresh();
                }
                LiveVarExpressionView.this.fTreeView.expandAll();
            }
        });
    }

    public boolean isViewActive() {
        return this.getSite().getPage().getActivePart() == this;
    }

    private static enum ColumnInfo {
        COLUMN_NAME,
        COLUMN_TYPE,
        COLUMN_VALUE;

    }

    private static enum DebugState {
        NO_DEBUG,
        DEBUG,
        DEBUG_LIVE;

    }

    private class LiveExpressionsContentProvider
    implements ITreeContentProvider {
        private LiveVarExpressionView view;

        public LiveExpressionsContentProvider(LiveVarExpressionView view) {
            this.view = view;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object tasks) {
            return this.getChildren(tasks);
        }

        public Object[] getChildren(Object parentElement) {
            LiveVariable expr;
            if (parentElement instanceof ArrayList) {
                return ((ArrayList)parentElement).toArray();
            }
            if (parentElement instanceof LiveVariable && (expr = (LiveVariable)parentElement).isComplex()) {
                if (expr.getExpressions().size() == 0) {
                    this.view.getDataModel().listChildren(expr);
                }
                return expr.getExpressions().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof LiveVariable && ((LiveVariable)element).isComplex()) {
                ((LiveVariable)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof LiveVariable && ((LiveVariable)element).isComplex();
        }
    }

    private class MyPartListener
    implements IPartListener {
        private MyPartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part == LiveVarExpressionView.this) {
                if (!GdbDebugUtil.fGDBDebug || !GdbDebugUtil.isNonStop) {
                    return;
                }
                if (LiveVarExpressionView.this.fVarManager.updateThread.getThreadState() != 2) {
                    LiveVarExpressionView.this.fVarManager.setAutoUpdate(2);
                }
                System.out.println("LiveVarExpressionView_partActivated");
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            if (part == LiveVarExpressionView.this) {
                System.out.println("LiveVarExpressionView_partBroughtToTop");
            }
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == LiveVarExpressionView.this) {
                System.out.println("LiveVarExpressionView_partClosed");
                LiveVarExpressionView.this.fVarManager.setAutoUpdate(1);
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part == LiveVarExpressionView.this) {
                System.out.println("LiveVarExpressionView_partDeactivated");
            }
        }

        public void partOpened(IWorkbenchPart part) {
            System.out.println("LiveVarExpressionView_partOpened");
        }
    }

    private class ViewerEditingSupport
    extends EditingSupport {
        private ColumnInfo columnId;
        private TextCellEditor editor;

        public ViewerEditingSupport(TreeViewer viewer, ColumnInfo columnId) {
            super((ColumnViewer)viewer);
            this.columnId = columnId;
            this.editor = new TextCellEditor((Composite)viewer.getTree());
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            boolean ret = false;
            if (element instanceof LiveVariable) {
                LiveVariable expr = (LiveVariable)element;
                switch (this.columnId) {
                    case COLUMN_VALUE: {
                        ret = expr.isEditable();
                        break;
                    }
                    case COLUMN_NAME: {
                        if (expr.getParent() != null) break;
                        ret = true;
                    }
                }
            }
            return ret;
        }

        protected Object getValue(Object element) {
            String ret = null;
            if (element instanceof LiveVariable) {
                LiveVariable expr = (LiveVariable)element;
                switch (this.columnId) {
                    case COLUMN_VALUE: {
                        ret = expr.getValue();
                        break;
                    }
                    case COLUMN_NAME: {
                        String gdbExpression = expr.getExpression();
                        ret = gdbExpression == null ? "" : gdbExpression;
                    }
                }
            }
            return ret;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof LiveVariable && value instanceof String) {
                LiveVariable expr = (LiveVariable)element;
                switch (this.columnId) {
                    case COLUMN_VALUE: {
                        LiveVarExpressionView.this.fVarManager.setExpressionValue(expr, (String)value);
                        break;
                    }
                    case COLUMN_NAME: {
                        String newExpression = (String)value;
                        if (newExpression.isEmpty()) break;
                        if (expr.getExpression() != null) {
                            if (newExpression.equals(expr.getExpression())) break;
                            LiveVarExpressionView.this.fVarManager.updateExpression(expr, newExpression);
                            LiveVarExpressionView.this.refreshUI();
                            break;
                        }
                        LiveVarExpressionView.this.fVarManager.addExpression(newExpression);
                        LiveVarExpressionView.this.refreshUI();
                    }
                }
            }
        }
    }

    private class ViewerLabelProvider
    extends ColumnLabelProvider {
        private ColumnInfo columnId;

        public ViewerLabelProvider(ColumnInfo columnId) {
            this.columnId = columnId;
        }

        public Font getFont(Object element) {
            Font ret = null;
            FontRegistry fontReg = JFaceResources.getFontRegistry();
            ret = fontReg.getItalic("org.eclipse.jface.defaultfont");
            return ret;
        }

        public Image getImage(Object element) {
            Image imageObj = null;
            if (element instanceof LiveVariable) {
                LiveVariable expr = (LiveVariable)element;
                switch (this.columnId) {
                    case COLUMN_NAME: {
                        imageObj = expr.getExpression() != null ? new Image(null, String.valueOf(GeneralPathUtil.ResourcePath) + "icons/varWatch/variable_view.gif") : new Image(null, String.valueOf(GeneralPathUtil.ResourcePath) + "icons/varWatch/addexpression.gif");
                    }
                }
            }
            return imageObj;
        }

        public String getText(Object element) {
            String ret = "";
            if (element instanceof LiveVariable) {
                LiveVariable expr = (LiveVariable)element;
                String expression = expr.getExpression();
                switch (this.columnId) {
                    case COLUMN_NAME: {
                        if (expression != null) {
                            ret = expression;
                            break;
                        }
                        ret = "Add new expression ";
                        break;
                    }
                    case COLUMN_TYPE: {
                        if (expression == null) break;
                        ret = expr.getType();
                        break;
                    }
                    case COLUMN_VALUE: {
                        if (expression == null) break;
                        ret = expr.getValue();
                        if (LiveVarExpressionView.this.viewState != DebugState.DEBUG_LIVE) break;
                        ret = expr.inContext() ? expr.getValue() : "Failed to evaluate expression";
                    }
                }
            }
            return ret;
        }
    }
}

