/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.liveexpressions;

import com.gigadevice.debug.liveexpressions.IDebugContextManagerListener;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMEvent;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GDBDebugManager
implements IDebugContextListener {
    private DsfServicesTracker servicesTracker;
    private DsfSession dsfSession = null;
    private IDebugContextManagerListener debugManageListener;
    private IWorkbenchWindow workbench;
    private boolean isSuspended = true;

    public GDBDebugManager(IDebugContextManagerListener listener) {
        this.debugManageListener = listener;
    }

    public void start() {
        this.workbench = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(this.workbench);
        contextService.addDebugContextListener((IDebugContextListener)this);
    }

    public void debugContextChanged(DebugContextEvent event) {
        if (event.getFlags() != 1) {
            return;
        }
        IAdaptable context = DebugUITools.getDebugContext();
        if (context != null) {
            IDMContext dmc = (IDMContext)context.getAdapter(IDMContext.class);
            if (dmc instanceof IMIContainerDMContext || dmc instanceof IMIExecutionDMContext || dmc instanceof IStack.IFrameDMContext) {
                String eventSessionId = dmc.getSessionId();
                if (!DsfSession.isSessionActive((String)eventSessionId)) {
                    return;
                }
                String sessionId = eventSessionId;
                this.dsfSession = DsfSession.getSession((String)eventSessionId);
                if (this.dsfSession != null) {
                    this.dsfSession.addServiceEventListener((Object)this, null);
                }
                this.servicesTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), eventSessionId);
                System.out.println("GDBDebugManager: Created new servicesTracker for session: " + eventSessionId);
                IRunControl rc = (IRunControl)this.servicesTracker.getService(IRunControl.class);
                this.isSuspended = rc != null && rc instanceof IRunControl && rc.isSuspended((IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)context).getDMContext(), IRunControl.IExecutionDMContext.class));
                this.debugManageListener.gdbSession(sessionId);
            }
        } else {
            if (this.dsfSession != null) {
                this.dsfSession.removeServiceEventListener((Object)this);
                if (this.servicesTracker != null) {
                    this.servicesTracker.dispose();
                }
            }
            this.dsfSession = null;
            this.servicesTracker = null;
            System.out.println("GDBDebugManager: Cleared servicesTracker and dsfSession");
            this.debugManageListener.gdbSession(null);
        }
    }

    @DsfServiceEventHandler
    public void DsfServiceEvent(Object event) {
        IDMEvent idmEvent;
        IDMContext context;
        if (event instanceof IDMEvent && (context = (idmEvent = (IDMEvent)event).getDMContext()) instanceof IRunControl.IExecutionDMContext) {
            if (idmEvent instanceof IRunControl.ISuspendedDMEvent) {
                this.isSuspended = true;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GDBDebugManager.this.debugManageListener.gdbSuspend();
                    }
                });
            } else if (idmEvent instanceof IRunControl.IResumedDMEvent) {
                IRunControl.IResumedDMEvent realEvent = (IRunControl.IResumedDMEvent)idmEvent;
                if (realEvent.getReason() == IRunControl.StateChangeReason.USER_REQUEST) {
                    this.isSuspended = false;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            GDBDebugManager.this.debugManageListener.gdbResume();
                        }
                    });
                }
            } else if (idmEvent instanceof IRunControl.IExitedDMEvent) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GDBDebugManager.this.debugManageListener.gdbExited();
                    }
                });
            }
        }
    }

    public void dispose() {
        DebugUITools.getDebugContextManager().getContextService(this.workbench).removeDebugContextListener((IDebugContextListener)this);
        if (this.dsfSession != null) {
            this.dsfSession.removeServiceEventListener((Object)this);
        }
        if (this.servicesTracker != null) {
            this.servicesTracker.dispose();
        }
    }

    public boolean getIsSuspendedState() {
        return this.isSuspended;
    }

    public DsfServicesTracker getServicesTracker() {
        return this.servicesTracker;
    }

    public DsfServicesTracker getOrCreateServicesTracker() {
        if (this.servicesTracker != null) {
            return this.servicesTracker;
        }
        try {
            String sessionId;
            IDMContext dmc;
            IAdaptable context = DebugUITools.getDebugContext();
            if (context != null && (dmc = (IDMContext)context.getAdapter(IDMContext.class)) != null && (dmc instanceof IMIContainerDMContext || dmc instanceof IMIExecutionDMContext || dmc instanceof IStack.IFrameDMContext) && DsfSession.isSessionActive((String)(sessionId = dmc.getSessionId()))) {
                this.servicesTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), sessionId);
                if (this.dsfSession == null || !this.dsfSession.getId().equals(sessionId)) {
                    if (this.dsfSession != null) {
                        this.dsfSession.removeServiceEventListener((Object)this);
                    }
                    this.dsfSession = DsfSession.getSession((String)sessionId);
                    if (this.dsfSession != null) {
                        this.dsfSession.addServiceEventListener((Object)this, null);
                    }
                }
                System.out.println("GDBDebugManager: Successfully recreated servicesTracker for session: " + sessionId);
                return this.servicesTracker;
            }
        }
        catch (Exception e) {
            System.err.println("GDBDebugManager: Failed to recreate servicesTracker: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }
}

