/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.dsf;

import com.gigadevice.debug.AbstractDebugServer;
import com.gigadevice.debug.Activator;
import com.gigadevice.debug.GdbServerDebugUtil;
import com.gigadevice.debug.GdbServerFactory;
import com.gigadevice.debug.dsf.DebugCommandsService;
import com.gigadevice.debug.service.command.CliExtendedCommand;
import com.gigadevice.debug.utils.GdbDebugUtil;
import com.gigadevice.venustool.TargetOSInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIGDBVersionInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class GdbExtendedFinalLaunchSequence
extends ReflectionSequence {
    final boolean debug = false;
    GdbLaunch fLaunch;
    SessionType fSessionType;
    boolean fAttach;
    private IGDBControl fGdbControl;
    private IGDBBackend fGdbBackend;
    private IMIProcesses fMIProcesses;
    private CommandFactory fCommandFactory;
    private AbstractDebugServer fDebugger;
    DsfServicesTracker fTracker;
    String mode = "";
    DebugCommandsService debugCommandsService;

    public GdbExtendedFinalLaunchSequence(DsfExecutor executor, GdbLaunch launch, SessionType sessionType, boolean attach, RequestMonitorWithProgress pm) {
        super(executor, pm, LaunchMessages.getString((String)"FinalLaunchSequence.0"), LaunchMessages.getString((String)"FinalLaunchSequence.1"));
        this.fLaunch = launch;
        this.fSessionType = sessionType;
        this.fAttach = attach;
        this.mode = this.fLaunch.getLaunchMode();
    }

    protected String[] getExecutionOrder(String groupName) {
        if ("GROUP_TOP_LEVEL".equals(groupName)) {
            return new String[]{"stepStartServer", "stepInitializeBaseSequence", "stepCreateMIEnvironmentCD", "stepSetEnvironment", "stepCreateMIGDBSetAutoSolib", "stepGetDebugger", "stepSetNonStop", "stepCreateMIFileExecAndSymbols", "stepTargetRemote", "stepExecInitCommands", "stepExecResetCommands", "stepCreateMIGDBSetBreakpointPending", "stepStartTrackingBpForProcess", "stepExecRunCommands", "stepExecContinueCommands", "stepDispose"};
        }
        return null;
    }

    @ReflectionSequence.Execute
    public void stepStartServer(RequestMonitor requestMonitor) {
        ILaunchConfiguration config = this.fLaunch.getLaunchConfiguration();
        try {
            GdbServerDebugUtil.ClearDebugLogFile(config);
            GdbServerDebugUtil.startServer(config.getAttribute("com.gigadevice.debug.launch.jtagDevice", "GD-Link"), config.getAttribute("com.gigadevice.debug.launch.serverParam", ""), (ILaunch)this.fLaunch);
        }
        catch (Exception e) {
            requestMonitor.setStatus((IStatus)new Status(4, "com.gigadevice.debug.launch", e.getMessage()));
        }
        requestMonitor.done();
    }

    @ReflectionSequence.Execute
    public void stepInitializeBaseSequence(RequestMonitor requestMonitor) {
        this.fTracker = new DsfServicesTracker(Activator.getBundleContext(), this.fLaunch.getSession().getId());
        this.fGdbBackend = (IGDBBackend)this.fTracker.getService(IGDBBackend.class);
        this.fGdbControl = (IGDBControl)this.fTracker.getService(IGDBControl.class);
        if (this.fGdbControl == null) {
            requestMonitor.setStatus((IStatus)new Status(4, "com.gigadevice.debug.launch", -1, "can not get command control", null));
        } else {
            this.fCommandFactory = this.fGdbControl.getCommandFactory();
        }
        this.fMIProcesses = (IMIProcesses)this.fTracker.getService(IMIProcesses.class);
        if (this.fGdbBackend == null || this.fMIProcesses == null) {
            requestMonitor.setStatus((IStatus)new Status(4, "com.gigadevice.debug.launch", -1, "can not get gdb backend service or mi process", null));
        }
        ILaunchConfiguration config = this.fLaunch.getLaunchConfiguration();
        this.debugCommandsService = new DebugCommandsService(config, this.mode, this.fGdbBackend);
        requestMonitor.done();
    }

    @ReflectionSequence.Execute
    public void stepCreateMIEnvironmentCD(final RequestMonitor requestMonitor) {
        IPath dir = null;
        try {
            dir = this.fGdbBackend.getGDBWorkingDirectory();
        }
        catch (CoreException e) {
            requestMonitor.setStatus((IStatus)new Status(4, "com.gigadevice.debug.launch", -1, "can not get gdb working directory", (Throwable)e));
            requestMonitor.done();
            return;
        }
        this.fGdbControl.queueCommand(this.fCommandFactory.createMIGDBVersion(this.fGdbControl.getContext()), (DataRequestMonitor)new DataRequestMonitor<MIGDBVersionInfo>((Executor)this.getExecutor(), requestMonitor){

            protected void handleCompleted() {
                requestMonitor.done();
            }
        });
        if (dir != null) {
            this.fGdbControl.queueCommand(this.fCommandFactory.createMIEnvironmentCD(this.fGdbControl.getContext(), dir.toPortableString()), new DataRequestMonitor((Executor)this.getExecutor(), requestMonitor));
        } else {
            requestMonitor.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepSetEnvironment(RequestMonitor requestMonitor) {
        boolean clear = false;
        Properties properties = new Properties();
        try {
            clear = this.fGdbBackend.getClearEnvironment();
            properties = this.fGdbBackend.getEnvironmentVariables();
        }
        catch (CoreException e) {
            requestMonitor.setStatus((IStatus)new Status(4, "com.gigadevice.debug.launch", -1, "can not get environment vars", (Throwable)e));
            requestMonitor.done();
            return;
        }
        if (clear || properties.size() > 0) {
            this.fGdbControl.setEnvironment(properties, clear, requestMonitor);
        } else {
            requestMonitor.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepCreateMIGDBSetAutoSolib(RequestMonitor requestMonitor) {
        try {
            boolean autolib = this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.AUTO_SOLIB", true);
            this.fGdbControl.queueCommand(this.fCommandFactory.createMIGDBSetAutoSolib(this.fGdbControl.getContext(), autolib), new DataRequestMonitor((Executor)this.getExecutor(), requestMonitor));
        }
        catch (CoreException e) {
            requestMonitor.setStatus((IStatus)new Status(4, "com.gigadevice.debug.launch", -1, "can not get auto solib", (Throwable)e));
            requestMonitor.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepGetDebugger(RequestMonitor requestMonitor) {
        Throwable exception = null;
        try {
            this.fDebugger = this.getDebugger(this.fLaunch.getLaunchConfiguration());
        }
        catch (NullPointerException e) {
            exception = e;
        }
        catch (CoreException e) {
            exception = e;
        }
        if (this.fDebugger == null) {
            requestMonitor.setStatus((IStatus)new Status(4, "com.gigadevice.debug.launch", -1, "can not get debugger", exception));
        }
        requestMonitor.done();
    }

    @ReflectionSequence.Execute
    public void stepCreateMIFileExecAndSymbols(RequestMonitor requestMonitor) {
        IPath execPath = this.fGdbBackend.getProgramPath();
        if (execPath != null && !execPath.isEmpty()) {
            IMIContainerDMContext containerDmc = this.fMIProcesses.createContainerContextFromGroupId(this.fGdbControl.getContext(), "");
            this.fGdbControl.queueCommand(this.fCommandFactory.createMIFileExecAndSymbols(containerDmc, execPath.toPortableString()), new DataRequestMonitor((Executor)this.getExecutor(), requestMonitor));
        } else {
            requestMonitor.done();
        }
    }

    protected String escapeSpaces(String file) {
        if (file.indexOf(32) >= 0) {
            return String.valueOf(String.valueOf('\"')) + file + '\"';
        }
        return file;
    }

    @ReflectionSequence.Execute
    public void stepSetExecutableFile(RequestMonitor requestMonitor) {
        Process process = this.fGdbBackend.getProcess();
        ILaunchConfiguration config = this.fLaunch.getLaunchConfiguration();
        try {
            if (config.getAttribute("com.gigadevice.debug.launch.loadImage", true)) {
                String execPathString = "";
                if (config.getAttribute("com.gigadevice.debug.launch.useProjBinaryForImage", true)) {
                    IPath execPath = this.fGdbBackend.getProgramPath();
                    execPathString = execPath.toPortableString();
                } else {
                    execPathString = config.getAttribute("com.gigadevice.debug.launch.imageFileName", "");
                }
                if (process != null) {
                    if (!execPathString.isEmpty()) {
                        String imageOffset = config.getAttribute("com.gigadevice.debug.launch.imageOffset", "");
                        if (!imageOffset.isEmpty()) {
                            imageOffset = execPathString.endsWith(".elf") ? "" : "0x" + imageOffset;
                        }
                        ArrayList<String> commands = new ArrayList<String>();
                        commands.add("load " + execPathString + ' ' + imageOffset);
                        this.queueCommandsSecondaryGDB(commands, requestMonitor);
                    }
                } else {
                    requestMonitor.done();
                }
            } else {
                requestMonitor.done();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            requestMonitor.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepExecSymbolFile(RequestMonitor requestMonitor) {
        Process process = this.fGdbBackend.getProcess();
        ILaunchConfiguration config = this.fLaunch.getLaunchConfiguration();
        try {
            if (config.getAttribute("com.gigadevice.debug.launch.loadSymbols", true)) {
                String symbolsFileName = "";
                if (config.getAttribute("com.gigadevice.debug.launch.useProjBinaryForSymbols", true)) {
                    IPath execPath = this.fGdbBackend.getProgramPath();
                    symbolsFileName = execPath.toPortableString();
                } else {
                    symbolsFileName = config.getAttribute("com.gigadevice.debug.launch.symbolsFileName", "");
                }
                if (process != null) {
                    if (!symbolsFileName.isEmpty()) {
                        String symbolsOffset = config.getAttribute("com.gigadevice.debug.launch.symbolsOffset", "");
                        ArrayList<String> commands = new ArrayList<String>();
                        if (!symbolsOffset.isEmpty()) {
                            symbolsOffset = "0x" + symbolsOffset;
                            commands.add("add-symbol-file \"" + symbolsFileName + "\"" + " " + symbolsOffset + System.getProperty("line.separator"));
                        } else {
                            commands.add("symbol-file \"" + symbolsFileName + "\"" + System.getProperty("line.separator"));
                        }
                        this.queueCommandsSecondaryGDB(commands, requestMonitor);
                    }
                } else {
                    requestMonitor.done();
                }
            } else {
                requestMonitor.done();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            requestMonitor.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepTargetRemote(RequestMonitor requestMonitor) {
        try {
            ArrayList<String> commands = new ArrayList<String>();
            if (TargetOSInfo.isLinux()) {
                commands.add("set mi-async on" + System.getProperty("line.separator"));
            }
            this.debugCommandsService.addGnuMcuSelectRemoteCommands(commands);
            this.queueCommands(commands, requestMonitor);
        }
        catch (Exception e) {
            requestMonitor.setStatus((IStatus)new Status(4, "com.gigadevice.debug.launch", -1, "can not connect to client", (Throwable)e));
            requestMonitor.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepSetNonStop(final RequestMonitor rm) {
        block7: {
            ILaunchConfiguration config = this.fLaunch.getLaunchConfiguration();
            GdbDebugUtil.isNonStop = LaunchUtils.getIsNonStopMode((ILaunchConfiguration)config);
            try {
                try {
                    IMICommandControl commandControl = (IMICommandControl)this.fTracker.getService(IMICommandControl.class);
                    if (commandControl != null) {
                        ICommand SetTargetAsyncCommon = commandControl.getCommandFactory().createMIGDBSetTargetAsync(commandControl.getContext(), GdbDebugUtil.isNonStop);
                        commandControl.queueCommand(SetTargetAsyncCommon, (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.fLaunch.getDsfExecutor(), rm){

                            protected void handleError() {
                                rm.setStatus((IStatus)new Status(4, "com.gigadevice.debug.launch", "failed to start async"));
                            }
                        });
                        if (GdbDebugUtil.isNonStop) {
                            ICommand SetNonStopAsyncCommon = commandControl.getCommandFactory().createMIGDBSetNonStop(commandControl.getContext(), true);
                            commandControl.queueCommand(SetNonStopAsyncCommon, (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.fLaunch.getDsfExecutor(), rm){

                                protected void handleError() {
                                    rm.setStatus((IStatus)new Status(4, "com.gigadevice.debug.launch", "failed to set non-stop mode"));
                                }
                            });
                        }
                        break block7;
                    }
                    rm.setStatus((IStatus)new Status(4, "com.gigadevice.debug.launch", "Failed to start Live expression"));
                }
                catch (Exception e) {
                    rm.setStatus((IStatus)new Status(4, "com.gigadevice.debug.launch", -1, "Failed to start Live expression", (Throwable)e));
                    rm.done();
                }
            }
            finally {
                rm.done();
            }
        }
    }

    @ReflectionSequence.Execute
    public void stepExecContinueCommands(RequestMonitor requestMonitor) {
        ILaunchConfiguration config = this.fLaunch.getLaunchConfiguration();
        try {
            if (config.getAttribute("com.gigadevice.debug.launch.doContinue", true)) {
                ArrayList<String> commands = new ArrayList<String>();
                commands.add("-exec-continue");
                this.queueCommands(commands, requestMonitor);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @ReflectionSequence.Execute
    public void stepExecInitCommands(RequestMonitor requestMonitor) {
        this.fLaunch.getLaunchConfiguration();
        String script = "";
        if (!script.isEmpty()) {
            ArrayList<String> commands = new ArrayList<String>();
            String[] strs = script.split("\r?\n");
            int i = 0;
            while (i < strs.length) {
                commands.add(strs[i]);
                ++i;
            }
            this.queueCommands(commands, requestMonitor);
        }
        requestMonitor.done();
    }

    @ReflectionSequence.Execute
    public void stepExecResetCommands(RequestMonitor requestMonitor) {
        try {
            ArrayList<String> commands = new ArrayList<String>();
            this.debugCommandsService.addGnuMcuResetCommands(commands);
            this.fGdbControl.queueCommand((ICommand)new CLICommand((IDMContext)this.fGdbControl.getContext(), this.composeCommand(commands)), new DataRequestMonitor((Executor)this.getExecutor(), requestMonitor));
        }
        catch (Exception e) {
            requestMonitor.setStatus((IStatus)new Status(4, "com.gigadevice.debug.launch", -1, "can not get source startup command", (Throwable)e));
            requestMonitor.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepCreateMIGDBSetBreakpointPending(RequestMonitor requestMonitor) {
        if (this.fGdbBackend.getSessionType() != SessionType.CORE) {
            this.fGdbControl.queueCommand(this.fCommandFactory.createMIGDBSetBreakpointPending(this.fGdbControl.getContext(), true), new DataRequestMonitor((Executor)this.getExecutor(), requestMonitor));
        } else {
            requestMonitor.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepStartTrackingBpForProcess(RequestMonitor requestMonitor) {
        MIBreakpointsManager bpmService = (MIBreakpointsManager)this.fTracker.getService(MIBreakpointsManager.class);
        bpmService.startTrackingBpForProcess((IRunControl.IContainerDMContext)this.fMIProcesses.createContainerContextFromGroupId(this.fGdbControl.getContext(), "i1"), requestMonitor);
    }

    @ReflectionSequence.Execute
    public void stepExecRunCommands(RequestMonitor requestMonitor) {
        try {
            ArrayList<String> commands = new ArrayList<String>();
            this.debugCommandsService.addGnuMcuStartCommands(commands);
            this.fGdbControl.queueCommand((ICommand)new CLICommand((IDMContext)this.fGdbControl.getContext(), this.composeCommand(commands)), new DataRequestMonitor((Executor)this.getExecutor(), requestMonitor));
        }
        catch (Exception e) {
            requestMonitor.setStatus((IStatus)new Status(4, "com.gigadevice.debug.launch", -1, "can not get source startup command", (Throwable)e));
            requestMonitor.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepDispose(RequestMonitor requestMonitor) {
        this.fTracker.dispose();
        this.fTracker = null;
        requestMonitor.done();
        if (this.mode.equalsIgnoreCase("run")) {
            String debugName = "";
            try {
                debugName = this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", "");
            }
            catch (CoreException e2) {
                e2.printStackTrace();
            }
            try {
                if (debugName.contains("riscv")) {
                    Thread.sleep(8000L);
                } else {
                    Thread.sleep(3000L);
                }
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            try {
                this.fLaunch.terminate();
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
            GdbServerDebugUtil.shutdownServerProcess(-1);
            IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
            MessageConsole console = new MessageConsole("Gigadevice MCU Eclipse console", null);
            MessageConsoleStream fOut = console.newMessageStream();
            manager.addConsoles(new IConsole[]{console});
            fOut.println(String.valueOf(System.lineSeparator()) + "information: run successfully.");
        }
    }

    private AbstractDebugServer getDebugger(ILaunchConfiguration config) throws CoreException, NullPointerException {
        AbstractDebugServer debugger = null;
        String debuggerName = config.getAttribute("com.gigadevice.debug.launch.jtagDevice", "");
        debugger = GdbServerFactory.getServer(debuggerName);
        return debugger;
    }

    public void queueCommands(List<String> commands, RequestMonitor rm) {
        if (!commands.isEmpty()) {
            this.fGdbControl.queueCommand((ICommand)new CliExtendedCommand((IDMContext)this.fGdbControl.getContext(), this.composeCommand(commands)), new DataRequestMonitor((Executor)this.getExecutor(), rm));
        } else {
            rm.done();
        }
    }

    public void queueCommandsSecondaryGDB(List<String> commands, RequestMonitor rm) {
        if (commands != null && !commands.isEmpty()) {
            CountingRequestMonitor crm = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
            crm.setDoneCount(commands.size());
            Iterator<String> it = commands.iterator();
            while (it.hasNext()) {
                String s = it.next().trim();
                if (s.isEmpty() || s.startsWith("#")) {
                    crm.done();
                    continue;
                }
                this.fGdbControl.queueCommand((ICommand)new CLICommand((IDMContext)this.fGdbControl.getContext(), s), new DataRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)crm));
            }
        } else {
            rm.done();
        }
    }

    private String composeCommand(Collection<String> commands) {
        if (commands.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = commands.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
        }
        return sb.toString();
    }
}

