/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.dsf;

import com.gigadevice.debug.dsf.IDebugCommandsService;
import com.gigadevice.debug.utils.DebugUtil;
import com.gigadevice.utils.constants.DebugConstants;
import java.util.List;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;

public class DebugCommandsService
implements IDebugCommandsService {
    protected String fMode;
    private IGDBBackend fGdbBackend;
    protected ILaunchConfiguration config;

    public DebugCommandsService(ILaunchConfiguration lc, String mode, IGDBBackend fGdbBackend) {
        this.config = lc;
        this.fMode = mode;
        this.fGdbBackend = fGdbBackend;
    }

    @Override
    public IStatus addGdbInitCommandsCommands(List<String> commandsList) {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus addGnuMcuSelectRemoteCommands(List<String> commandsList) {
        try {
            String remoteTcpHost = this.config.getAttribute("com.gigadevice.debug.launch.ipAddress", "localhost");
            Integer remoteTcpPort = this.config.getAttribute("com.gigadevice.debug.launch.portNumber", 5099);
            commandsList.add("target remote " + remoteTcpHost + ":" + String.valueOf(remoteTcpPort) + System.lineSeparator());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus addGnuMcuResetCommands(List<String> commandsList) {
        try {
            String debuggerName = this.config.getAttribute("com.gigadevice.debug.launch.jtagDevice", "GD-Link");
            boolean isJLinkDebug = debuggerName.equals(DebugConstants.debuggerEnum.JLink.toString());
            IStatus status = this.addFirstResetCommands(commandsList);
            if (!status.isOK()) {
                return status;
            }
            if (isJLinkDebug) {
                String resetType;
                if (!DebugUtil.getCodeinRAMBooleanValue(this.config)) {
                    commandsList.add("monitor flash download = 1" + System.lineSeparator());
                }
                if ((resetType = this.config.getAttribute("com.gigadevice.debug.launch.resettype", "")).length() > 0 && this.config.getAttribute("com.gigadevice.debug.launch.doFirstReset", true)) {
                    commandsList.add("monitor reset 1" + System.lineSeparator());
                }
            }
            if (!(status = this.addLoadSymbolsCommands(commandsList)).isOK()) {
                return status;
            }
            if (this.config.getAttribute("com.gigadevice.debug.launch.loadImage", true) && !DebugUtil.getCodeinRAMBooleanValue(this.config) && !(status = this.addLoadImageCommands(commandsList)).isOK()) {
                return status;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus addGnuMcuStartCommands(List<String> commandsList) {
        IStatus status = this.addStartRestartCommands(true, commandsList);
        return status;
    }

    @Override
    public IStatus addFirstResetCommands(List<String> commandsList) {
        try {
            String otherInits;
            if (this.config.getAttribute("com.gigadevice.debug.launch.doFirstReset", true)) {
                String commandStr = "monitor reset ";
                String resetType = this.config.getAttribute("com.gigadevice.debug.launch.firstResetType", "init");
                commandsList.add(String.valueOf(commandStr) + resetType + System.lineSeparator());
                commandStr = "monitor halt" + System.lineSeparator();
                commandsList.add(commandStr);
            }
            if (!(otherInits = this.config.getAttribute("com.gigadevice.debug.launch.otherInitCommands", "").trim()).isEmpty()) {
                otherInits = DebugUtil.resolveAll(otherInits);
                DebugUtil.addMultiLine(otherInits, commandsList);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus addStartRestartCommands(boolean doReset, List<String> commandsList) {
        try {
            IStatus status;
            String commandStr;
            if (doReset && this.config.getAttribute("com.gigadevice.debug.launch.doSecondReset", true)) {
                commandStr = "monitor reset ";
                String resetType = this.config.getAttribute("com.gigadevice.debug.launch.secondResetType", "halt");
                commandsList.add(String.valueOf(commandStr) + resetType + System.lineSeparator());
            }
            commandStr = "monitor halt" + System.lineSeparator();
            commandsList.add(commandStr);
            if (this.config.getAttribute("com.gigadevice.debug.launch.loadImage", true) && DebugUtil.getCodeinRAMBooleanValue(this.config) && !(status = this.addLoadImageCommands(commandsList)).isOK()) {
                return status;
            }
            String userCmd = this.config.getAttribute("com.gigadevice.debug.launch.otherRunCommands", "").trim();
            if (!userCmd.isEmpty()) {
                userCmd = DebugUtil.resolveAll(userCmd);
                DebugUtil.addMultiLine(userCmd, commandsList);
            }
            this.addSetPcCommands(commandsList);
            this.addStopAtCommands(commandsList);
            commandsList.add("monitor reg" + System.lineSeparator());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus addGnuMcuRestartCommands(List<String> commandsList) {
        return this.addStartRestartCommands(true, commandsList);
    }

    @Override
    public IStatus addLoadSymbolsCommands(List<String> commandsList) {
        Process process = this.fGdbBackend.getProcess();
        try {
            if (this.config.getAttribute("com.gigadevice.debug.launch.loadSymbols", true)) {
                String symbolsFileName = "";
                if (this.config.getAttribute("com.gigadevice.debug.launch.useProjBinaryForSymbols", true)) {
                    IPath execPath = this.fGdbBackend.getProgramPath();
                    symbolsFileName = execPath.toPortableString();
                } else {
                    symbolsFileName = this.config.getAttribute("com.gigadevice.debug.launch.symbolsFileName", "");
                }
                if (process != null && !symbolsFileName.isEmpty()) {
                    symbolsFileName = DebugUtil.resolveAll(symbolsFileName);
                    symbolsFileName = symbolsFileName.replace("\\", "/");
                    String symbolsOffset = this.config.getAttribute("com.gigadevice.debug.launch.symbolsOffset", "");
                    if (!symbolsOffset.isEmpty()) {
                        symbolsOffset = "0x" + symbolsOffset;
                        commandsList.add("add-symbol-file \"" + symbolsFileName + "\"" + " " + symbolsOffset + System.lineSeparator());
                    } else {
                        commandsList.add("symbol-file \"" + symbolsFileName + "\"" + System.lineSeparator());
                    }
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus addLoadImageCommands(List<String> commandsList) {
        Process process = this.fGdbBackend.getProcess();
        try {
            if (this.config.getAttribute("com.gigadevice.debug.launch.loadImage", true)) {
                String execPathString = "";
                if (this.config.getAttribute("com.gigadevice.debug.launch.useProjBinaryForImage", true)) {
                    IPath execPath = this.fGdbBackend.getProgramPath();
                    execPathString = execPath.toPortableString();
                } else {
                    execPathString = this.config.getAttribute("com.gigadevice.debug.launch.imageFileName", "");
                }
                if (process != null && !execPathString.isEmpty()) {
                    execPathString = DebugUtil.resolveAll(execPathString);
                    execPathString = execPathString.replace("\\", "/");
                    String imageOffset = this.config.getAttribute("com.gigadevice.debug.launch.imageOffset", "");
                    if (!imageOffset.isEmpty()) {
                        imageOffset = execPathString.endsWith(".elf") ? "" : "0x" + imageOffset;
                    }
                    String command = "load \"" + execPathString + "\" " + imageOffset + System.lineSeparator();
                    commandsList.add(command.trim());
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus addSetPcCommands(List<String> commandsList) {
        try {
            String pcRegister;
            if (this.config.getAttribute("com.gigadevice.debug.launch.setPcRegister", false) && !(pcRegister = this.config.getAttribute("com.gigadevice.debug.launch.pcRegister", "")).isEmpty()) {
                commandsList.add("set $pc=0x" + pcRegister + System.lineSeparator());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public IStatus addStopAtCommands(List<String> commandsList) {
        try {
            String StopAt;
            if (this.fMode.equalsIgnoreCase("debug") && this.config.getAttribute("com.gigadevice.debug.launch.setStopAt", true) && !(StopAt = this.config.getAttribute("com.gigadevice.debug.launch.stopAt", "")).isEmpty()) {
                commandsList.add("tbreak " + StopAt + System.lineSeparator());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }
}

