/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug;

import com.gigadevice.adapter.AdapterUtils;
import com.gigadevice.adapter.TargetAdapter;
import com.gigadevice.debug.AbstractDebugServer;
import com.gigadevice.debug.Activator;
import com.gigadevice.debug.GdbServerFactory;
import com.gigadevice.debug.ui.PeripheralsView;
import com.gigadevice.debug.utils.DebugUtil;
import com.gigadevice.debug.utils.KillPort;
import com.gigadevice.utils.ProjectUtils;
import com.gigadevice.utils.constants.DebugConstants;
import com.gigadevice.venustool.xmlparse.CPNChangeXmlParse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;

public class GdbServerDebugUtil {
    public static String SVDFilePath = "";
    static IProcess serverProcess;
    static ILaunch projectLaunch;
    private static boolean isGDBServer;
    private static boolean isOpenocd;
    static ArrayList<ILaunch> launchs;

    static {
        isGDBServer = false;
        isOpenocd = false;
        launchs = new ArrayList();
    }

    public static void startServer(String deviceName, String cmdParams, ILaunch launch) throws CoreException {
        AbstractDebugServer serverToStart = null;
        Status status = new Status(1, Activator.getDefault().getBundle().getSymbolicName(), 1, " server cmd params 0 : " + cmdParams, null);
        Activator.getInstance().getLog().log((IStatus)status);
        serverToStart = GdbServerFactory.getServer(deviceName);
        if (serverToStart == null) {
            Status why = new Status(4, "com.gigadevice.debug.launch", "Gdb Server is null");
            Activator.log((IStatus)why);
            throw new CoreException((IStatus)why);
        }
        IProcess iProcess = null;
        try {
            String[] portNumbersStr;
            String latestSVDFilePath;
            String path = "";
            ILaunchConfiguration config = launch.getLaunchConfiguration();
            IProject project = DebugUtil.getCurProject(config);
            TargetAdapter.MbsType coreType = AdapterUtils.getToolChainType((IProject)project);
            String McuNo = AdapterUtils.getTargetMcuPartNo((IProject)project);
            if (McuNo == null) {
                McuNo = "";
            }
            String GDLinkDebuggerServer = config.getAttribute("com.gigadevice.debug.gdlink.server", DebugConstants.GDLinkDebuggerServerEnum.GDLinkGDBServer.toString());
            isGDBServer = GDLinkDebuggerServer.equals(DebugConstants.GDLinkDebuggerServerEnum.GDLinkGDBServer.toString());
            isOpenocd = GDLinkDebuggerServer.equals(DebugConstants.GDLinkDebuggerServerEnum.Openocd.toString());
            String serverExePath = serverToStart.getServerLocation(coreType, McuNo, GDLinkDebuggerServer, config.getAttribute("com.gigadevice.debug.openocd.location", ""));
            String serverWcDir = "";
            if (deviceName.equalsIgnoreCase(DebugConstants.debuggerEnum.GDLink.toString())) {
                String DefaultOpenocdFileAbsolutePath;
                String OldOpenocdFilePath;
                File OpenocdFile;
                path = config.getAttribute("com.gigadevice.debug.openocd.location", "");
                if (isGDBServer) {
                    path = DebugUtil.getGDLinkGDBServerEXEPath();
                }
                if (isOpenocd && !(OpenocdFile = new File(OldOpenocdFilePath = config.getAttribute("com.gigadevice.debug.launch.OpenocdFilePath", ""))).exists() && !(DefaultOpenocdFileAbsolutePath = DebugUtil.getFirstFileAbsolutePath(config, "openocd", true)).equals("")) {
                    cmdParams = cmdParams.replace(OldOpenocdFilePath, DefaultOpenocdFileAbsolutePath);
                }
            } else {
                path = config.getAttribute("com.gigadevice.debug.jlink.location", "");
            }
            SVDFilePath = config.getAttribute("com.gigadevice.debug.launch.svdpath", "");
            if (!path.equalsIgnoreCase(serverExePath)) {
                serverExePath = path;
            }
            String oldSVDFilePath = SVDFilePath;
            SVDFilePath = config.getAttribute("com.gigadevice.debug.launch.svdpath", "");
            if (!ProjectUtils.isExistingFilePath((String)SVDFilePath) && !SVDFilePath.equals(latestSVDFilePath = DebugUtil.getSVDFilePath(config))) {
                SVDFilePath = latestSVDFilePath;
            }
            if (!SVDFilePath.equals(oldSVDFilePath)) {
                PeripheralsView.onSVDFilePathChanged();
            }
            String OldCPN = config.getAttribute("com.gigadevice.debug.launch.device", "");
            String NewCPN = CPNChangeXmlParse.getNewCPN((String)OldCPN, (boolean)false);
            cmdParams = cmdParams.replace(OldCPN, NewCPN);
            serverWcDir = serverExePath.substring(0, serverExePath.lastIndexOf(File.separator));
            System.out.println("cmdParams1:" + cmdParams);
            if (deviceName.equals(DebugConstants.debuggerEnum.GDLink.toString()) && cmdParams.indexOf("-f") == 0 && cmdParams.indexOf("-f \"") < 0) {
                String tmp = "";
                tmp = cmdParams;
                status = new Status(1, Activator.getDefault().getBundle().getSymbolicName(), 1, "server path : " + serverExePath + " server cmd params tmp: " + tmp, null);
                Activator.getInstance().getLog().log((IStatus)status);
                status = new Status(1, Activator.getDefault().getBundle().getSymbolicName(), 1, " server cmd params : " + tmp, null);
                Activator.getInstance().getLog().log((IStatus)status);
            }
            String[] paramsArr = cmdParams.split(" ");
            ArrayList<String> command = new ArrayList<String>();
            command.add(serverExePath);
            if (paramsArr != null) {
                int i = 0;
                while (i < paramsArr.length) {
                    String param = paramsArr[i];
                    if (param.startsWith("\"")) {
                        if (!param.endsWith("\"")) {
                            ++i;
                            while (i < paramsArr.length) {
                                if ((param = String.valueOf(param) + " " + paramsArr[i]).endsWith("\"")) break;
                                ++i;
                            }
                        }
                        param = param.replaceAll("\"", "");
                    }
                    command.add(param);
                    ++i;
                }
            }
            if (isGDBServer && config.getAttribute("com.gigadevice.debug.connectUnderReset", false)) {
                command.add("-ConnectUnderReset");
            }
            ArrayList<Integer> portNumbers = new ArrayList<Integer>();
            if (cmdParams.contains("-port")) {
                String temp = cmdParams.substring(cmdParams.indexOf("-port") + 5, cmdParams.length());
                if (temp.contains("-")) {
                    temp = temp.substring(0, temp.indexOf("-"));
                }
                portNumbersStr = temp.trim().split(" ");
                int i = 0;
                while (i < portNumbersStr.length) {
                    portNumbers.add(config.getAttribute("com.gigadevice.debug.launch.portNumber", 10000) + i);
                    ++i;
                }
            } else {
                portNumbers.add(config.getAttribute("com.gigadevice.debug.launch.portNumber", 10000));
            }
            portNumbersStr = portNumbers.iterator();
            while (portNumbersStr.hasNext()) {
                int portNumber = (Integer)portNumbersStr.next();
                KillPort kp = new KillPort();
                kp.port = portNumber;
                kp.start(portNumber);
            }
            KillPort kp = new KillPort();
            String serverExeName = serverExePath.substring(serverExePath.lastIndexOf(File.separator) + 1);
            kp.start(serverExeName);
            ProcessBuilder pro = new ProcessBuilder(command);
            pro.directory(new File(serverWcDir));
            Process server = pro.start();
            serverProcess = iProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)server, (String)deviceName);
            projectLaunch = launch;
        }
        catch (Exception exception) {
            Status info = new Status(4, "com.gigadevice.debug.launch", "gdb session terminated");
            throw new CoreException((IStatus)info);
        }
        serverToStart.verifyServer(iProcess);
    }

    public static int getLaunchCount() {
        return launchs.size();
    }

    public static void addInnerLaunch(ILaunch launch) {
        launchs.add(launch);
    }

    public static void shutdownServerProcess(int LaunchID) {
        try {
            if (!serverProcess.isTerminated()) {
                int i = 0;
                while (i < launchs.size()) {
                    if (isGDBServer) {
                        launchs.get(i).removeProcess(serverProcess);
                    }
                    launchs.get(i).terminate();
                    ++i;
                }
                serverProcess.terminate();
                launchs.clear();
            }
        }
        catch (Exception exception) {}
    }

    public static void ClearDebugLogFile(ILaunchConfiguration configuration) {
        IProject project = DebugUtil.getCurProject(configuration);
        File file = new File(String.valueOf(project.getLocation().makeAbsolute().toFile().getAbsolutePath()) + DebugConstants.Debug_Log_FileName);
        if (file.exists()) {
            file.delete();
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void terminateAllLaunches() {
        ILaunch[] launches;
        ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            try {
                if (!launch.isTerminated()) {
                    launch.terminate();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }
}

