/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug;

import com.gigadevice.adapter.TargetAdapter;
import com.gigadevice.debug.ui.DebugTab;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractDebugServer {
    protected static final String LINESEP = System.getProperty("line.separator");
    protected DebugTab debuggerTab;

    public void createControl(Composite parent, DebugTab dt) {
        this.debuggerTab = dt;
    }

    protected DebugTab getDebuggerTab() {
        return this.debuggerTab;
    }

    public abstract Composite getControl();

    public void updateLaunchDialog() {
        this.debuggerTab.subPageChanged();
    }

    public String getDefaultGdbClient() {
        return "arm-none-eabi-gdb";
    }

    public String getServerLocation(TargetAdapter.MbsType type, String McuNo, String Server, String Location) {
        return "";
    }

    public String getServerStartArgs() {
        return "";
    }

    public void doRemote(String ip, int port, Collection<String> commands) {
        String cmd = "target remote " + ip + ":" + String.valueOf(port);
        this.addCmd(commands, cmd);
    }

    public String getDefaultIpAddress() {
        return "localhost";
    }

    public String getDefaultPortNumber() {
        return "3333";
    }

    protected void addCmd(Collection<String> commands, String cmd) {
        commands.add(String.valueOf(cmd) + LINESEP);
    }

    public int getSleepTime() {
        return 0;
    }

    public void verifyServer(IProcess iProcess) throws CoreException {
        try {
            Thread.sleep(this.getSleepTime() * 1000);
        }
        catch (InterruptedException interruptedException) {}
        if (iProcess.isTerminated()) {
            int exitVal = iProcess.getExitValue();
            throw new CoreException((IStatus)new Status(4, "com.gigadevice.debug.launch", "exit value " + Integer.toString(exitVal) + " connect to target failed"));
        }
    }

    public abstract void setDefaults(ILaunchConfigurationWorkingCopy var1, TargetAdapter.MbsType var2, String var3, String var4);

    public abstract void initializeFrom(ILaunchConfiguration var1, TargetAdapter.MbsType var2, String var3, String var4);

    public abstract void performApply(ILaunchConfigurationWorkingCopy var1, TargetAdapter.MbsType var2);

    public abstract void UpdateGroup(ILaunchConfigurationWorkingCopy var1, String var2, String var3, String var4, String var5);
}

