/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.clockconfigview;

import com.gigadevice.clockconfigview.BackgroundPanel;
import com.gigadevice.clockconfigview.ComponentAction;
import com.gigadevice.clockconfigview.utils.RCURelateUtil;
import com.gigadevice.clockconfigview.utils.RCUTreeUtil;
import com.gigadevice.customui.gdui.GDScrollPane;
import com.gigadevice.venustool.GeneralPathUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.clockconfiginfo.RCUClockSource;
import com.gigadevice.venustool.clockconfiginfo.RCUCondition;
import com.gigadevice.venustool.clockconfiginfo.RCUConfigControl;
import com.gigadevice.venustool.clockconfiginfo.RCUConfigControlGroup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.text.html.HTMLEditorKit;

public class RCUTreeView {
    private static BackgroundPanel ImagePanel;
    static int ImageWidth;
    static int ImageHeight;
    static double re_size;
    static double initialSize;
    static double minSize;
    static double maxSize;
    static int re_size_num;
    private static int Magnify;
    private static int Common;
    private static int Shrink;
    public static final Color Color_Foreground;
    private static JPanel ErrorTipsPanel;
    private static JEditorPane ErrorTipsLabel;
    private static GDScrollPane ErrorTipsScrollPane;

    static {
        re_size_num = 0;
        Magnify = 0;
        Common = 1;
        Shrink = 2;
        Color_Foreground = new Color(0, 104, 179);
    }

    public static JComponent createPartControl() {
        ToolTipManager.sharedInstance().setDismissDelay(60000);
        JPanel clockPanel = new JPanel(false);
        clockPanel.setBackground(Color.white);
        RCUCondition.RCUConfigControlMap.size();
        if (RCUCondition.RCUConfigImageList.size() <= 0) {
            return clockPanel;
        }
        re_size = RCUTreeUtil.RCUImageInitialSize;
        initialSize = RCUTreeUtil.RCUImageInitialSize;
        minSize = RCUTreeUtil.RCUImageMinSize;
        maxSize = RCUTreeUtil.RCUImageMaxSize;
        clockPanel.setLayout(new BorderLayout());
        RCUTreeView.InitImageView();
        RCUTreeView.InitControlsView();
        ImagePanel.removeAll();
        ImagePanel.repaint();
        ImagePanel.revalidate();
        RCUTreeView.InitControlsView();
        ImagePanel.updateUI();
        RCUTreeUtil.InitControlsValueDisplay();
        GDScrollPane ScrollPane = new GDScrollPane((Component)ImagePanel, 20, 30);
        ScrollPane.getVerticalScrollBar().setUnitIncrement(15);
        ScrollPane.getHorizontalScrollBar().setUnitIncrement(15);
        JViewport viewport = ScrollPane.getViewport();
        viewport.setBackground(Color.white);
        JPanel upPanel = new JPanel(false);
        upPanel.setLayout(new FlowLayout(1));
        upPanel.setPreferredSize(new Dimension(500, 70));
        upPanel.setBackground(Color.white);
        RCUTreeView.InitOperButton(upPanel);
        clockPanel.add((Component)ScrollPane, "Center");
        clockPanel.add((Component)upPanel, "North");
        clockPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                RCUTreeView.clearHighlight();
            }
        });
        return clockPanel;
    }

    private static void InitImageView() {
        if (RCUCondition.RCUConfigImageList.size() > 0) {
            String path = String.valueOf(GeneralPathUtil.ResourcePath) + "rcu" + File.separator + RCUTreeUtil.RCUImageName;
            BufferedImage image = null;
            try {
                image = ImageIO.read(new File(path));
                ImageWidth = image.getWidth();
                ImageHeight = image.getHeight();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (image != null) {
                if (re_size_num != 0) {
                    ImagePanel.re_BackgroundPanel(image, re_size);
                } else {
                    ImagePanel = new BackgroundPanel(image, re_size);
                }
            }
        }
    }

    private static void InitControlsView() {
        String TipText_NA;
        String Location2;
        int PositionY;
        int PositionX;
        String Type2;
        ComponentAction componentAction = new ComponentAction();
        if (RCUCondition.RCUClockSourceMap.size() > 0) {
            for (Map.Entry entry : RCUCondition.RCUClockSourceMap.entrySet()) {
                if (entry.getValue() == null) continue;
                Type2 = ((RCUClockSource)entry.getValue()).getType();
                PositionX = ((RCUClockSource)entry.getValue()).getPositionX();
                PositionY = ((RCUClockSource)entry.getValue()).getPositionY();
                Location2 = ((RCUClockSource)entry.getValue()).getLocation();
                String TipText = ((RCUClockSource)entry.getValue()).getTipText();
                TipText_NA = ((RCUClockSource)entry.getValue()).getTipText_NA();
                if (TipText_NA == null || TipText_NA.equals("")) {
                    TipText_NA = RCURelateUtil.getPrivilege2Sentence((String)entry.getKey());
                }
                if (!Type2.toUpperCase().equals("EDIT")) continue;
                JTextField TextField = new JTextField();
                ((RCUClockSource)entry.getValue()).setControlComponent((Component)TextField);
                ((RCUClockSource)entry.getValue()).setControlCurrentValue(((RCUClockSource)entry.getValue()).getValue());
                TextField.setName((String)entry.getKey());
                TextField.addActionListener(componentAction);
                TextField.setFont(new Font("Arial", 1, (int)(14.0 * re_size)));
                if (((RCUClockSource)entry.getValue()).isReadOnly()) {
                    TextField.setEditable(false);
                }
                if (((RCUClockSource)entry.getValue()).getDisplayText() != null) {
                    TextField.setText(((RCUClockSource)entry.getValue()).getDisplayText());
                } else {
                    TextField.setText(String.valueOf(((RCUClockSource)entry.getValue()).getValue()));
                }
                if (RCURelateUtil.GetControlType((String)entry.getKey()) == 1) {
                    if (RCURelateUtil.GetPrivilegeState((String)entry.getKey(), null) == 1) {
                        TextField.setEnabled(true);
                    } else {
                        TextField.setEnabled(false);
                    }
                }
                String unitStr = ((RCUClockSource)entry.getValue()).getUnit();
                RCUTreeView.AddComponent((String)entry.getKey(), TextField, PositionX, PositionY, Location2, TipText, TipText_NA, ((RCUClockSource)entry.getValue()).getBorderWidth(), unitStr);
            }
        }
        if (RCUCondition.RCUConfigControlMap.size() > 0) {
            for (Map.Entry entry : RCUCondition.RCUConfigControlMap.entrySet()) {
                if (entry.getValue() == null) continue;
                Type2 = ((RCUConfigControl)entry.getValue()).getType();
                PositionX = ((RCUConfigControl)entry.getValue()).getPositionX();
                PositionY = ((RCUConfigControl)entry.getValue()).getPositionY();
                Location2 = ((RCUConfigControl)entry.getValue()).getLocation();
                if (Type2.toUpperCase().equals("COMBO")) {
                    Map<String, String> TextMap;
                    LinkedHashSet<Object> ItemList = new LinkedHashSet();
                    ItemList = RCUTreeUtil.GetEnumValueSet(((RCUConfigControl)entry.getValue()).getName());
                    String[] Options = ItemList.toArray(new String[ItemList.size()]);
                    String TipText_NA2 = ((RCUConfigControl)entry.getValue()).getTipText_NA();
                    String TipText = ((RCUConfigControl)entry.getValue()).getTipText();
                    if (TipText_NA2 == null || TipText_NA2.equals("")) {
                        TipText_NA2 = RCURelateUtil.getPrivilege2Sentence((String)entry.getKey());
                    }
                    JComboBox<String> comboBox = new JComboBox<String>(Options);
                    comboBox.setBackground(Color.white);
                    comboBox.setFont(new Font("Arial", 1, (int)(14.0 * re_size)));
                    ((RCUConfigControl)entry.getValue()).setControlComponent(comboBox);
                    if (((RCUConfigControl)entry.getValue()).getReadOnly().booleanValue()) {
                        comboBox.setEnabled(false);
                    }
                    if (RCURelateUtil.GetControlType((String)entry.getKey()) == 1 || RCURelateUtil.GetControlType((String)entry.getKey()) == 12) {
                        int State = RCURelateUtil.GetPrivilegeState((String)entry.getKey(), null);
                        if (State == 1) {
                            ((RCUConfigControl)entry.getValue()).getControlComponent().setEnabled(true);
                        } else if (State == 0) {
                            ((RCUConfigControl)entry.getValue()).getControlComponent().setEnabled(false);
                        }
                    }
                    String setDefaultValue = "";
                    String selectedItem_visiablePrivilege = "";
                    if ((RCURelateUtil.GetControlType((String)entry.getKey()) == 2 || RCURelateUtil.GetControlType((String)entry.getKey()) == 12) && (TextMap = RCURelateUtil.GetEnumValueListForPrivilege((String)entry.getKey())) != null && TextMap.size() != 0) {
                        for (Map.Entry<String, String> textEntry : TextMap.entrySet()) {
                            String[] privilegeItemTemp;
                            String PrivilegeName = textEntry.getKey();
                            String PrivilegeItem = textEntry.getValue();
                            if (PrivilegeName.toLowerCase().equals("update")) {
                                setDefaultValue = PrivilegeItem;
                                continue;
                            }
                            if (!PrivilegeName.toLowerCase().equals("visible")) continue;
                            String displayText = ((RCUConfigControl)entry.getValue()).getDisplayText();
                            if (!PrivilegeItem.contains("##") || (privilegeItemTemp = PrivilegeItem.split("##")).length != 2) continue;
                            String privilegeItemsValue = privilegeItemTemp[0];
                            String privilegeDefaultValue = privilegeItemTemp[1];
                            String privilegeDefaultDisplayValue = RCUConfigControl.getItemDisplayValue((String)((String)entry.getKey()), (String)privilegeDefaultValue);
                            Vector visableItems = RCUConfigControl.parseRangeString((String)((String)entry.getKey()), (String)privilegeItemsValue);
                            selectedItem_visiablePrivilege = RCUTreeView.updateComboBoxItem(comboBox, visableItems, privilegeDefaultDisplayValue, displayText);
                        }
                    }
                    if (((RCUConfigControl)entry.getValue()).getDisplayText() != null) {
                        if (!setDefaultValue.equals("")) {
                            comboBox.setSelectedItem(setDefaultValue);
                        } else if (!selectedItem_visiablePrivilege.equals("")) {
                            comboBox.setSelectedItem(selectedItem_visiablePrivilege);
                        } else {
                            comboBox.setSelectedItem(((RCUConfigControl)entry.getValue()).getDisplayText());
                        }
                    }
                    comboBox.setName((String)entry.getKey());
                    comboBox.addActionListener(componentAction);
                    RCUTreeView.AddComponent((String)entry.getKey(), comboBox, PositionX, PositionY, Location2, TipText, TipText_NA2, ((RCUConfigControl)entry.getValue()).getBorderWidth(), null);
                    continue;
                }
                if (Type2.toUpperCase().equals("EDIT")) {
                    JTextField TextField = new JTextField();
                    TextField.setFont(new Font("Arial", 1, (int)(14.0 * re_size)));
                    ((RCUConfigControl)entry.getValue()).setControlComponent((Component)TextField);
                    TipText_NA = ((RCUConfigControl)entry.getValue()).getTipText_NA();
                    String TipText = ((RCUConfigControl)entry.getValue()).getTipText();
                    if (TipText_NA == null || TipText_NA.equals("")) {
                        TipText_NA = RCURelateUtil.getPrivilege2Sentence((String)entry.getKey());
                    }
                    TextField.setName((String)entry.getKey());
                    if (RCURelateUtil.GetControlType((String)entry.getKey()) == 1) {
                        int State = RCURelateUtil.GetPrivilegeState((String)entry.getKey(), null);
                        if (State == 1) {
                            ((RCUConfigControl)entry.getValue()).getControlComponent().setEnabled(true);
                        } else if (State == 0) {
                            ((RCUConfigControl)entry.getValue()).getControlComponent().setEnabled(false);
                        }
                    }
                    if (((RCUConfigControl)entry.getValue()).getReadOnly().booleanValue()) {
                        TextField.setEditable(false);
                    }
                    if (((RCUConfigControl)entry.getValue()).getDisplayText() != null) {
                        TextField.setText(((RCUConfigControl)entry.getValue()).getDisplayText());
                    }
                    TextField.addActionListener(componentAction);
                    RCUTreeView.AddComponent((String)entry.getKey(), TextField, PositionX, PositionY, Location2, TipText, TipText_NA, ((RCUConfigControl)entry.getValue()).getBorderWidth(), null);
                    continue;
                }
                if (!Type2.toUpperCase().equals("LABEL")) continue;
                JLabel label = new JLabel();
                ((RCUConfigControl)entry.getValue()).setControlComponent((Component)label);
                label.setName((String)entry.getKey());
                if (((RCUConfigControl)entry.getValue()).getPeri() != null && !((RCUConfigControl)entry.getValue()).getPeri().equals("")) {
                    if (!GlobalVariables.HaveExisted((String)((RCUConfigControl)entry.getValue()).getPeri(), (String)((RCUConfigControl)entry.getValue()).getPeriItem(), (String)((RCUConfigControl)entry.getValue()).getPeriItemSource())) {
                        label.setEnabled(false);
                    } else {
                        label.setEnabled(true);
                    }
                }
                label.setText("");
                label.setVisible(false);
            }
        }
        if (RCUCondition.RCUConfigControlGroupMap.size() > 0) {
            for (Map.Entry entry : RCUCondition.RCUConfigControlGroupMap.entrySet()) {
                TreeSet ControlSet;
                if (entry.getValue() == null || !(Type2 = ((RCUConfigControlGroup)entry.getValue()).getType()).toUpperCase().equals("SELECTOR") || (ControlSet = ((RCUConfigControlGroup)entry.getValue()).GetControlSet()).size() == 0) continue;
                ButtonGroup g = new ButtonGroup();
                for (String ControlName : ControlSet) {
                    int PositionX2 = ((RCUConfigControlGroup)entry.getValue()).getControlPositionX(ControlName);
                    int PositionY2 = ((RCUConfigControlGroup)entry.getValue()).getControlPositionY(ControlName);
                    String TipText = ((RCUConfigControlGroup)entry.getValue()).getControlTipText(ControlName);
                    String TipText_NA3 = ((RCUConfigControlGroup)entry.getValue()).getControlTipText_NA(ControlName);
                    if (TipText_NA3 == null || TipText_NA3.equals("")) {
                        TipText_NA3 = RCURelateUtil.getPrivilege2Sentence(ControlName);
                    }
                    String Location3 = ((RCUConfigControlGroup)entry.getValue()).getLocation();
                    JRadioButton radioButton = new JRadioButton();
                    radioButton.addActionListener(componentAction);
                    radioButton.setName(ControlName);
                    URL uncheckedIconUrl = RCUTreeView.class.getResource("/icons/unchecked.png");
                    URL checkedIconUrl = RCUTreeView.class.getResource("/icons/checked.png");
                    URL unchecked_disableIconUrl = RCUTreeView.class.getResource("/icons/unchecked_disable.png");
                    URL checked_disableIconUrl = RCUTreeView.class.getResource("/icons/checked_disable.png");
                    ImageIcon uncheckedIcon = new ImageIcon(uncheckedIconUrl);
                    ImageIcon checkedIcon = new ImageIcon(checkedIconUrl);
                    ImageIcon uncheckedIcon_Disabled = new ImageIcon(unchecked_disableIconUrl);
                    ImageIcon checkedIcon_Disabled = new ImageIcon(checked_disableIconUrl);
                    radioButton.setIcon(uncheckedIcon);
                    radioButton.setSelectedIcon(checkedIcon);
                    radioButton.setContentAreaFilled(false);
                    if (((RCUConfigControlGroup)entry.getValue()).getControlDefault(ControlName)) {
                        radioButton.setSelected(true);
                    }
                    if (RCURelateUtil.GetControlType(ControlName) == 3) {
                        if (RCURelateUtil.GetPrivilegeState(ControlName, null) == 1) {
                            radioButton.setIcon(uncheckedIcon);
                            radioButton.setSelectedIcon(checkedIcon);
                            radioButton.setEnabled(true);
                        } else if (RCURelateUtil.GetPrivilegeState(ControlName, null) == 4) {
                            radioButton.setIcon(uncheckedIcon);
                            radioButton.setSelectedIcon(checkedIcon);
                            if (!radioButton.isSelected()) {
                                radioButton.setSelected(true);
                            }
                            radioButton.setEnabled(true);
                            ((RCUConfigControlGroup)RCUCondition.RCUConfigControlGroupMap.get(entry.getKey())).setControlDefault(ControlName);
                        } else if (RCURelateUtil.GetPrivilegeState(ControlName, null) == 5) {
                            if (radioButton.isSelected()) {
                                radioButton.setSelected(false);
                            }
                            if (radioButton.isSelected()) {
                                radioButton.setDisabledIcon(checkedIcon_Disabled);
                                radioButton.setDisabledSelectedIcon(checkedIcon_Disabled);
                            } else {
                                radioButton.setDisabledIcon(uncheckedIcon_Disabled);
                                radioButton.setDisabledSelectedIcon(uncheckedIcon_Disabled);
                            }
                            radioButton.setEnabled(false);
                        } else {
                            if (radioButton.isSelected()) {
                                radioButton.setDisabledIcon(checkedIcon_Disabled);
                                radioButton.setDisabledSelectedIcon(checkedIcon_Disabled);
                            } else {
                                radioButton.setDisabledIcon(uncheckedIcon_Disabled);
                                radioButton.setDisabledSelectedIcon(uncheckedIcon_Disabled);
                            }
                            radioButton.setEnabled(false);
                        }
                    }
                    if (RCURelateUtil.GetControlType((String)entry.getKey()) == 1) {
                        if (RCURelateUtil.GetPrivilegeState((String)entry.getKey(), null) == 1) {
                            radioButton.setIcon(uncheckedIcon);
                            radioButton.setSelectedIcon(checkedIcon);
                            radioButton.setEnabled(true);
                        } else {
                            if (radioButton.isSelected()) {
                                radioButton.setDisabledIcon(checkedIcon_Disabled);
                                radioButton.setDisabledSelectedIcon(checkedIcon_Disabled);
                            } else {
                                radioButton.setDisabledIcon(uncheckedIcon_Disabled);
                                radioButton.setDisabledSelectedIcon(uncheckedIcon_Disabled);
                            }
                            radioButton.setEnabled(false);
                        }
                    }
                    ((RCUConfigControlGroup)entry.getValue()).setControlComponent(ControlName, (Component)radioButton);
                    RCUTreeView.AddComponent("", radioButton, PositionX2, PositionY2, Location3, TipText, TipText_NA3, ((RCUConfigControlGroup)entry.getValue()).getBorderWidth(), null);
                    g.add(radioButton);
                }
            }
        }
    }

    private static void AddComponent(String Name, JComponent component, int PositionX, int PositionY, String Location2, String TipText, String TipText_NA, String BorderWidth, String unitStr) {
        boolean isEnabled;
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                RCUTreeView.clearHighlight();
            }
        });
        ImagePanel.add(component);
        String re_TipText = RCUTreeView.splitString("TipText", TipText);
        String re_TipText_NA = RCUTreeView.splitString("TipText_NA", TipText_NA);
        int ObjPositionX = PositionX;
        int OffsetWidth = 0;
        if (BorderWidth == null) {
            OffsetWidth = (int)(60.0 * re_size * (double)ImageWidth / 1191.0);
        } else {
            double borderWidth = Double.parseDouble(BorderWidth);
            OffsetWidth = (int)(borderWidth * re_size);
            if (Name.equals("")) {
                OffsetWidth = (int)(borderWidth * re_size) - 5;
            }
        }
        if (Location2.toUpperCase().equals("TOLEFT")) {
            ObjPositionX = (int)((double)PositionX * re_size - (double)OffsetWidth);
            if (Name.equals("") && BorderWidth == null) {
                ObjPositionX = (int)((double)PositionX * re_size - 16.0 - 1.0);
            }
        } else if (Location2.toUpperCase().equals("TORIGHT")) {
            ObjPositionX = (int)((double)PositionX * re_size);
        }
        if (Name.equals("")) {
            component.setBounds(ObjPositionX, (int)((double)(PositionY - 10) * re_size), 16, 16);
            isEnabled = component.isEnabled();
            if (isEnabled) {
                component.setToolTipText(re_TipText);
            } else {
                component.setToolTipText(re_TipText_NA);
            }
        } else {
            component.setBounds(ObjPositionX, (int)((double)(PositionY - 15) * re_size), OffsetWidth, (int)(35.0 * re_size));
            component.setFont(new Font("Arial", 0, (int)(16.0 * re_size)));
            isEnabled = component.isEnabled();
            if (isEnabled) {
                component.setToolTipText(re_TipText);
            } else {
                component.setToolTipText(re_TipText_NA);
            }
        }
        if (!Name.equals("")) {
            String labelStr = Name;
            if (!(component instanceof JComboBox || unitStr != null && unitStr.equals(""))) {
                if (unitStr != null && !unitStr.equals("")) {
                    if (unitStr.equals("K")) {
                        labelStr = String.valueOf(labelStr) + "(KHz)";
                    } else if (unitStr.equals("M")) {
                        labelStr = String.valueOf(labelStr) + "(MHz)";
                    }
                } else {
                    labelStr = String.valueOf(labelStr) + "(MHz)";
                }
            }
            JLabel label = new JLabel(labelStr);
            ImagePanel.add(label);
            label.setBounds(ObjPositionX, (int)((double)(PositionY - 45) * re_size), OffsetWidth, (int)(30.0 * re_size));
            label.setFont(new Font("Arial", 1, (int)(16.0 * re_size)));
            label.setToolTipText(labelStr);
        }
    }

    public static void UpdateView(boolean IfUserModify) {
        if (ImagePanel == null) {
            return;
        }
        GlobalVariables.ClockTree_IfUserModify = IfUserModify;
        GlobalVariables.checkClockTree = true;
        int i = 0;
        while (i < 1) {
            ImagePanel.removeAll();
            RCUTreeView.InitControlsView();
            RCUTreeUtil.InitControlsValueDisplay();
            ImagePanel.updateUI();
            ++i;
        }
        RCUTreeView.updateErrorTipsPanel();
    }

    public static boolean UpdateView_CheckActionListener(boolean IfUserModify) {
        if (ImagePanel == null) {
            return true;
        }
        GlobalVariables.ClockTree_IfUserModify = IfUserModify;
        ImagePanel.removeAll();
        RCUTreeView.InitControlsView();
        boolean ret = RCUTreeUtil.InitControlsValueDisplay();
        RCUTreeView.updateErrorTipsPanel();
        return ret;
    }

    public static String splitString(String strType, String str) {
        if (str != null && str != "") {
            str = str.replace(" ", "&nbsp;");
            String[] strArr = str.split("\r\n|\r|\n");
            if (strType.equals("TipText_NA")) {
                String res = "<html><font color = Blue>";
                if (strArr == null) {
                    return null;
                }
                int i = 0;
                while (i < strArr.length - 1) {
                    res = String.valueOf(res) + strArr[i] + "<br>";
                    ++i;
                }
                res = String.valueOf(res) + strArr[strArr.length - 1] + "</font></html>";
                return res;
            }
            String res = "<html>";
            int i = 0;
            while (i < strArr.length - 1) {
                res = String.valueOf(res) + strArr[i] + "<br>";
                ++i;
            }
            res = String.valueOf(res) + strArr[strArr.length - 1] + "</html>";
            return res;
        }
        return null;
    }

    private static void InitOperButton(JPanel jpanel) {
        int Border2 = 50;
        RCUTreeView.AddOperButton(jpanel, "Magnify.png", Magnify, 0, 0, Border2);
        RCUTreeView.AddOperButton(jpanel, "Common.png", Common, 1, 0, Border2);
        RCUTreeView.AddOperButton(jpanel, "Shrink.png", Shrink, 2, 0, Border2);
        RCUTreeView.AddSearchComboBox(jpanel);
        RCUTreeView.AddErrorTipsPanel(jpanel);
        jpanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ImagePanel != null) {
                    ImagePanel.clearHighlight();
                }
            }
        });
    }

    private static void AddErrorTipsPanel(JPanel jpanel) {
        JLabel tipsTitle = new JLabel("Error Tips: ");
        tipsTitle.setFont(new Font("Arial", 1, 15));
        tipsTitle.setForeground(Color_Foreground);
        ErrorTipsPanel = new JPanel();
        ErrorTipsPanel.setLayout(new BorderLayout());
        ErrorTipsPanel.setBackground(Color.WHITE);
        ErrorTipsPanel.setBorder(BorderFactory.createLineBorder(Color_Foreground, 1));
        ErrorTipsPanel.setPreferredSize(new Dimension(500, 40));
        ErrorTipsLabel = new JEditorPane();
        ErrorTipsLabel.setEditorKit(new HTMLEditorKit());
        ErrorTipsLabel.setContentType("text/html");
        ErrorTipsLabel.setEditable(false);
        ErrorTipsLabel.setBackground(Color.WHITE);
        ErrorTipsLabel.setText("<html><body> </body></html>");
        ErrorTipsLabel.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        ErrorTipsLabel.setFont(new Font("Arial", 0, 12));
        ErrorTipsScrollPane = new GDScrollPane((Component)ErrorTipsLabel);
        ErrorTipsScrollPane.setVerticalScrollBarPolicy(20);
        ErrorTipsScrollPane.setHorizontalScrollBarPolicy(30);
        ErrorTipsScrollPane.setBorder(null);
        ErrorTipsScrollPane.setBackground(Color.WHITE);
        ErrorTipsScrollPane.getViewport().setBackground(Color.WHITE);
        ErrorTipsPanel.add((Component)ErrorTipsScrollPane, "Center");
        JPanel tipsContainer = new JPanel(new FlowLayout(0, 5, 5));
        tipsContainer.setBackground(Color.WHITE);
        tipsContainer.add(tipsTitle);
        tipsContainer.add(ErrorTipsPanel);
        tipsContainer.setVisible(false);
        jpanel.add(tipsContainer);
        ErrorTipsPanel.putClientProperty("container", tipsContainer);
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem copyItem = new JMenuItem("Paste");
        copyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorTipsLabel.copy();
            }
        });
        popupMenu.add(copyItem);
        ErrorTipsLabel.setComponentPopupMenu(popupMenu);
        RCUTreeView.updateErrorTipsPanel();
    }

    private static void AddOperButton(JPanel OperPanel, String PicturePath, final int OperType, int Width, int Height, int Border2) {
        String Path2 = GeneralPathUtil.ResourcePath;
        JButton button = new JButton();
        int startX = Border2 * Width + Border2 / 10 * Width;
        button.setBounds(startX, 0, Border2, Border2);
        button.setBackground(Color.white);
        ImageIcon icon = new ImageIcon(String.valueOf(Path2) + "icons" + File.separator + "PackageOper" + File.separator + PicturePath);
        Image image = icon.getImage();
        int n = button.getWidth();
        int n2 = button.getHeight();
        icon.getImage();
        Image temp = image.getScaledInstance(n, n2, 1);
        icon.setImage(temp);
        button.setIcon(icon);
        button.setBorderPainted(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RCUTreeView.clearHighlight();
                if (OperType == 2) {
                    if (re_size > minSize) {
                        re_size -= 0.1;
                    }
                } else if (OperType == 1) {
                    re_size = initialSize;
                } else if (OperType == 0 && re_size < maxSize) {
                    re_size += 0.1;
                }
                re_size_num = 1;
                BigDecimal bigDecimal = new BigDecimal(re_size);
                re_size = bigDecimal.setScale(2, 4).doubleValue();
                ImagePanel.removeAll();
                ImagePanel.repaint();
                ImagePanel.revalidate();
                GlobalVariables.ClockTree_IfUserModify = false;
                RCUTreeView.InitImageView();
                RCUTreeView.InitControlsView();
                RCUTreeUtil.InitControlsValueDisplay();
                ImagePanel.updateUI();
                RCUTreeView.updateErrorTipsPanel();
            }
        });
        OperPanel.add(button);
    }

    private static void AddSearchComboBox(JPanel jpanel) {
        JLabel searchLabel = new JLabel("Search: ");
        searchLabel.setBounds(485, 10, 60, 30);
        searchLabel.setFont(new Font("Arial", 1, 15));
        searchLabel.setForeground(Color_Foreground);
        jpanel.add(searchLabel);
        TreeSet<String> searchOptionsTreeSet = new TreeSet<String>();
        if (RCUCondition.RCUClockSourceMap.size() > 0) {
            for (Map.Entry entry : RCUCondition.RCUClockSourceMap.entrySet()) {
                if (entry.getValue() == null) continue;
                searchOptionsTreeSet.add((String)entry.getKey());
            }
        }
        if (RCUCondition.RCUConfigControlMap.size() > 0) {
            for (Map.Entry entry : RCUCondition.RCUConfigControlMap.entrySet()) {
                if (entry.getValue() == null) continue;
                searchOptionsTreeSet.add((String)entry.getKey());
            }
        }
        if (RCUCondition.RCUConfigControlGroupMap.size() > 0) {
            for (Map.Entry entry : RCUCondition.RCUConfigControlGroupMap.entrySet()) {
                TreeSet ControlSet;
                if (entry.getValue() == null) continue;
                searchOptionsTreeSet.add((String)entry.getKey());
                String Type2 = ((RCUConfigControlGroup)entry.getValue()).getType();
                if (!Type2.toUpperCase().equals("SELECTOR") || (ControlSet = ((RCUConfigControlGroup)entry.getValue()).GetControlSet()).size() == 0) continue;
                for (String ControlName : ControlSet) {
                    searchOptionsTreeSet.add(ControlName);
                }
            }
        }
        final String[] searchOptions = searchOptionsTreeSet.toArray(new String[0]);
        final JComboBox<String> searchComboBox = new JComboBox<String>(searchOptions);
        searchComboBox.setFont(new Font("Arial", 0, 15));
        searchComboBox.setForeground(Color_Foreground);
        searchComboBox.setEditable(true);
        searchComboBox.setBorder(BorderFactory.createLineBorder(Color_Foreground, 1));
        int maxWidth = 0;
        FontMetrics metrics = searchComboBox.getFontMetrics(searchComboBox.getFont());
        String[] stringArray = searchOptions;
        int n = searchOptions.length;
        int ControlName = 0;
        while (ControlName < n) {
            String item = stringArray[ControlName];
            int itemWidth = metrics.stringWidth(item);
            if (itemWidth > maxWidth) {
                maxWidth = itemWidth;
            }
            ++ControlName;
        }
        if (maxWidth == 0) {
            maxWidth = 150;
        }
        searchComboBox.setPreferredSize(new Dimension(maxWidth += 30, 30));
        searchComboBox.setMaximumRowCount(12);
        jpanel.add(searchComboBox);
        final JTextField searchField = (JTextField)searchComboBox.getEditor().getEditorComponent();
        SwingUtilities.invokeLater(() -> jpanel.requestFocusInWindow());
        searchComboBox.setFocusable(false);
        searchField.setFocusable(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                searchField.setFocusable(true);
                searchComboBox.setFocusable(true);
                searchField.requestFocusInWindow();
            }
        };
        searchComboBox.addMouseListener(mouseAdapter);
        searchField.addMouseListener(mouseAdapter);
        searchField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SwingUtilities.invokeLater(() -> {
                    searchField.setFocusable(false);
                    searchComboBox.setFocusable(false);
                });
            }
        });
        searchComboBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                searchField.requestFocusInWindow();
            }
        });
        searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                    return;
                }
                String input = searchField.getText();
                searchComboBox.hidePopup();
                searchComboBox.removeAllItems();
                int matchCount = 0;
                String[] stringArray = searchOptions;
                int n = searchOptions.length;
                int n2 = 0;
                while (n2 < n) {
                    String option = stringArray[n2];
                    if (option.toLowerCase().contains(input.toLowerCase())) {
                        searchComboBox.addItem(option);
                        ++matchCount;
                    }
                    ++n2;
                }
                searchField.setText(input);
                if (matchCount > 0) {
                    searchComboBox.setMaximumRowCount(Math.min(matchCount, 12));
                    searchComboBox.showPopup();
                    if (searchComboBox.getItemCount() > 0) {
                        searchComboBox.setSelectedIndex(0);
                    }
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                String selectedItem;
                int keyCode = e.getKeyCode();
                if (keyCode == 38 || keyCode == 40) {
                    e.consume();
                    int selectedIndex = searchComboBox.getSelectedIndex();
                    if (keyCode == 38 && selectedIndex > 0) {
                        searchComboBox.setSelectedIndex(selectedIndex - 1);
                    } else if (keyCode == 40 && selectedIndex < searchComboBox.getItemCount() - 1) {
                        searchComboBox.setSelectedIndex(selectedIndex + 1);
                    }
                } else if (keyCode == 10 && (selectedItem = (String)searchComboBox.getSelectedItem()) != null) {
                    RCUTreeView.moveToComponent(selectedItem);
                    searchComboBox.hidePopup();
                }
            }
        });
        searchComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedItem = (String)searchComboBox.getSelectedItem();
                if (selectedItem != null) {
                    RCUTreeView.moveToComponent(selectedItem);
                }
            }
        });
    }

    private static void moveToComponent(String componentName) {
        if (ImagePanel == null || componentName == null || componentName.isEmpty()) {
            return;
        }
        try {
            ImagePanel.clearHighlight();
            Component foundComponent = null;
            Rectangle bounds = null;
            Component[] componentArray = ImagePanel.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                if (componentName.equals(component.getName())) {
                    bounds = component.getBounds();
                    foundComponent = component;
                    break;
                }
                ++n2;
            }
            if (bounds == null && RCUCondition.RCUConfigControlGroupMap.size() > 0) {
                block3: for (Map.Entry entry : RCUCondition.RCUConfigControlGroupMap.entrySet()) {
                    TreeSet ControlSet;
                    String Type2;
                    if (entry.getValue() == null || !(Type2 = ((RCUConfigControlGroup)entry.getValue()).getType()).toUpperCase().equals("SELECTOR") || !((String)entry.getKey()).equals(componentName) || (ControlSet = ((RCUConfigControlGroup)entry.getValue()).GetControlSet()).size() == 0) continue;
                    String ControlName = "";
                    Iterator iter = ControlSet.iterator();
                    if (iter.hasNext()) {
                        ControlName = (String)iter.next();
                    }
                    Component[] componentArray2 = ImagePanel.getComponents();
                    int n3 = componentArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Component component = componentArray2[n4];
                        if (ControlName.equals(component.getName())) {
                            bounds = component.getBounds();
                            foundComponent = component;
                            continue block3;
                        }
                        ++n4;
                    }
                }
            }
            if (bounds != null) {
                int componentCenterX = bounds.x + bounds.width / 2;
                int componentCenterY = bounds.y + bounds.height / 2;
                GDScrollPane scrollPane = (GDScrollPane)SwingUtilities.getAncestorOfClass(GDScrollPane.class, ImagePanel);
                if (scrollPane != null) {
                    JViewport viewport = scrollPane.getViewport();
                    if (viewport == null) {
                        return;
                    }
                    int viewCenterX = componentCenterX - viewport.getWidth() / 2;
                    int viewCenterY = componentCenterY - viewport.getHeight() / 2;
                    viewport.setViewPosition(new Point(Math.max(viewCenterX, 0), Math.max(viewCenterY, 0)));
                    if (foundComponent != null) {
                        ImagePanel.setHighlightedComponent(foundComponent);
                    }
                }
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void clearHighlight() {
        if (ImagePanel != null) {
            ImagePanel.clearHighlight();
        }
    }

    public static void updateErrorTipsPanel() {
        if (ErrorTipsLabel == null || ErrorTipsPanel == null) {
            return;
        }
        boolean hasErrors = false;
        String ClockTreeSelectorWarningMessage = "";
        String ClockTreeSelectorName_Warning = "";
        String ClockTreeInvalidValueMessage = "";
        String ClockTreeInvalidValueName = "";
        Vector<String> errorComponentNames = new Vector<String>();
        try {
            Map clockTreeErrorInfo_MinMaxMap;
            Map clockTreeInvalidMap = RCUCondition.getClockTreeErrorInfo();
            if (clockTreeInvalidMap != null && clockTreeInvalidMap.size() > 0) {
                for (String key : clockTreeInvalidMap.keySet()) {
                    if (!key.equals("Selector")) continue;
                    Vector errorVector = (Vector)clockTreeInvalidMap.get(key);
                    if (errorVector != null && errorVector.size() > 0) {
                        hasErrors = true;
                        errorComponentNames.addAll(errorVector);
                        ClockTreeSelectorWarningMessage = errorVector.size() == 1 ? String.valueOf(ClockTreeSelectorWarningMessage) + "The option of the following selector is invalid. Please check and modify it:" : String.valueOf(ClockTreeSelectorWarningMessage) + "The options of the following selectors are invalid. Please check and modify them:";
                        ClockTreeSelectorWarningMessage = String.valueOf(ClockTreeSelectorWarningMessage) + System.lineSeparator() + "\t";
                    }
                    int i = 0;
                    while (i < errorVector.size()) {
                        ClockTreeSelectorName_Warning = i == 0 ? String.valueOf(ClockTreeSelectorName_Warning) + (String)errorVector.get(i) : String.valueOf(ClockTreeSelectorName_Warning) + "," + (String)errorVector.get(i);
                        ++i;
                    }
                }
            }
            if ((clockTreeErrorInfo_MinMaxMap = RCUCondition.getClockTreeErrorInfo_MinMax()).size() != 0) {
                hasErrors = true;
                ClockTreeInvalidValueMessage = clockTreeErrorInfo_MinMaxMap.size() == 1 ? String.valueOf(ClockTreeInvalidValueMessage) + "The value of the clock control below is invalid. Please check and modify it:" : String.valueOf(ClockTreeInvalidValueMessage) + "The values of the clock controls below are invalid. Please check and modify them:";
                int count = 0;
                for (String key : clockTreeErrorInfo_MinMaxMap.keySet()) {
                    errorComponentNames.add(key);
                    if (count > 0) {
                        ClockTreeInvalidValueName = String.valueOf(ClockTreeInvalidValueName) + ",";
                    }
                    ClockTreeInvalidValueName = String.valueOf(ClockTreeInvalidValueName) + key;
                    ++count;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            hasErrors = false;
        }
        JPanel tipsContainer = (JPanel)ErrorTipsPanel.getClientProperty("container");
        if (hasErrors) {
            StringBuilder html = new StringBuilder();
            html.append("<html><body style='padding: 2px;'>");
            if (!ClockTreeSelectorWarningMessage.equals("")) {
                html.append("<div style=\"color: black;\">").append(ClockTreeSelectorWarningMessage).append("</div>");
                html.append("<div style=\"color: red;\">").append(ClockTreeSelectorName_Warning.replace(System.lineSeparator(), "<br>")).append("</div>");
            }
            if (!ClockTreeInvalidValueMessage.equals("")) {
                html.append("<div style=\"color: black;\">").append(ClockTreeInvalidValueMessage).append("</div>");
                html.append("<div style=\"color: red;\">").append(ClockTreeInvalidValueName.replace(System.lineSeparator(), "<br>")).append("</div>");
            }
            html.append("</body></html>");
            String htmlContent = html.toString();
            ErrorTipsLabel.setText(htmlContent);
            ErrorTipsPanel.setBackground(new Color(255, 245, 245));
            if (tipsContainer != null) {
                tipsContainer.setVisible(true);
            }
            RCUTreeView.highlightErrorComponents(errorComponentNames);
        } else {
            if (tipsContainer != null) {
                tipsContainer.setVisible(false);
            }
            if (ImagePanel != null) {
                ImagePanel.clearErrorComponents();
            }
        }
        if (tipsContainer != null && tipsContainer.getParent() != null) {
            tipsContainer.getParent().revalidate();
            tipsContainer.getParent().repaint();
        }
    }

    private static void highlightErrorComponents(Vector<String> errorComponentNames) {
        if (ImagePanel == null || errorComponentNames == null || errorComponentNames.isEmpty()) {
            return;
        }
        Vector<Component> errorComponents = new Vector<Component>();
        HashMap<Component, String> errorComponentTooltips = new HashMap<Component, String>();
        Map<String, String> errorDetailsMap = RCUTreeView.getErrorDetails(errorComponentNames);
        Component[] componentArray = ImagePanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            String componentName = component.getName();
            if (componentName != null && errorComponentNames.contains(componentName)) {
                errorComponents.add(component);
                String originalTooltip = ((JComponent)component).getToolTipText();
                String errorDetail = errorDetailsMap.get(componentName);
                StringBuilder tooltipBuilder = new StringBuilder("<html>");
                tooltipBuilder.append("<div style='color: red; font-weight: bold;'>Error: ");
                tooltipBuilder.append(errorDetail != null ? errorDetail : "Invalid Value.");
                tooltipBuilder.append("</div>");
                if (originalTooltip != null && !originalTooltip.isEmpty()) {
                    if (originalTooltip.startsWith("<html>") && originalTooltip.endsWith("</html>")) {
                        String content = originalTooltip.substring(6, originalTooltip.length() - 7);
                        tooltipBuilder.append("<hr>").append(content);
                    } else {
                        tooltipBuilder.append("<hr>").append(originalTooltip);
                    }
                }
                tooltipBuilder.append("</html>");
                errorComponentTooltips.put(component, tooltipBuilder.toString());
            }
            ++n2;
        }
        for (String errorName : errorComponentNames) {
            RCUConfigControlGroup group;
            if (!RCUCondition.RCUConfigControlGroupMap.containsKey(errorName) || (group = (RCUConfigControlGroup)RCUCondition.RCUConfigControlGroupMap.get(errorName)) == null) continue;
            TreeSet controlSet = group.GetControlSet();
            String errorDetail = errorDetailsMap.get(errorName);
            for (String controlName : controlSet) {
                Component[] componentArray2 = ImagePanel.getComponents();
                int n3 = componentArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Component component = componentArray2[n4];
                    if (controlName.equals(component.getName())) {
                        errorComponents.add(component);
                        String originalTooltip = ((JComponent)component).getToolTipText();
                        StringBuilder tooltipBuilder = new StringBuilder("<html>");
                        tooltipBuilder.append("<div style='color: red; font-weight: bold;'>Error: ");
                        tooltipBuilder.append(errorDetail != null ? errorDetail : "Invalid selector option. Please select a valid option.");
                        tooltipBuilder.append("</div>");
                        if (originalTooltip != null && !originalTooltip.isEmpty()) {
                            if (originalTooltip.startsWith("<html>") && originalTooltip.endsWith("</html>")) {
                                String content = originalTooltip.substring(6, originalTooltip.length() - 7);
                                tooltipBuilder.append("<hr>").append(content);
                            } else {
                                tooltipBuilder.append("<hr>").append(originalTooltip);
                            }
                        }
                        tooltipBuilder.append("</html>");
                        errorComponentTooltips.put(component, tooltipBuilder.toString());
                    }
                    ++n4;
                }
            }
        }
        if (!errorComponents.isEmpty()) {
            if (!errorComponentTooltips.isEmpty()) {
                ImagePanel.setErrorComponents(errorComponents, errorComponentTooltips);
            } else {
                ImagePanel.setErrorComponents(errorComponents);
            }
        }
    }

    private static Map<String, String> getErrorDetails(Vector<String> errorComponentNames) {
        Map clockTreeErrorInfo_MinMaxMap;
        HashMap<String, String> errorDetailsMap = new HashMap<String, String>();
        Map clockTreeInvalidMap = RCUCondition.getClockTreeErrorInfo();
        if (clockTreeInvalidMap != null && clockTreeInvalidMap.size() > 0) {
            for (String key : clockTreeInvalidMap.keySet()) {
                Vector errorVector;
                if (!key.equals("Selector") || (errorVector = (Vector)clockTreeInvalidMap.get(key)) == null || errorVector.size() <= 0) continue;
                for (String componentName : errorVector) {
                    errorDetailsMap.put(componentName, "Invalid selector option. Please select a valid option.");
                }
            }
        }
        if ((clockTreeErrorInfo_MinMaxMap = RCUCondition.getClockTreeErrorInfo_MinMax()) != null && clockTreeErrorInfo_MinMaxMap.size() > 0) {
            Iterator iterator = clockTreeErrorInfo_MinMaxMap.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                String errorDetail = (String)clockTreeErrorInfo_MinMaxMap.get(key = (String)iterator.next());
                errorDetailsMap.put(key, errorDetail != null ? errorDetail : "Value out of range!");
            }
        }
        return errorDetailsMap;
    }

    private static String updateComboBoxItem(JComboBox<?> comboBox, Vector<String> visableItems, String privilegeDefaultDisplayValue, String displayText) {
        String retNeedSelected = displayText;
        if (comboBox == null || visableItems == null || visableItems.isEmpty()) {
            return retNeedSelected;
        }
        Vector allItems = new Vector();
        Vector<String> allItemsText = new Vector<String>();
        int i = 0;
        while (i < comboBox.getItemCount()) {
            Object item = comboBox.getItemAt(i);
            allItems.add(item);
            if (item != null) {
                allItemsText.add(item.toString());
            }
            ++i;
        }
        comboBox.removeAllItems();
        for (String visableItem : visableItems) {
            int index = allItemsText.indexOf(visableItem);
            if (index < 0) continue;
            comboBox.addItem(allItems.get(index));
        }
        if (!displayText.equals("") && visableItems.contains(displayText)) {
            retNeedSelected = displayText;
        } else if (privilegeDefaultDisplayValue != null && visableItems.contains(privilegeDefaultDisplayValue)) {
            retNeedSelected = privilegeDefaultDisplayValue;
        } else if (comboBox.getItemCount() > 0) {
            retNeedSelected = visableItems.get(0);
        }
        return retNeedSelected;
    }
}

