/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.clockconfigview;

import com.gigadevice.customui.gdui.GDScrollPane;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

class BackgroundPanel
extends JPanel {
    private static final long serialVersionUID = -6352788025440244338L;
    private BufferedImage image = null;
    private Double ZoomInOutVal = 1.0;
    private Dimension imageSize;
    private double scale_size;
    private Component highlightedComponent = null;
    private Vector<Component> highlightedComponents = new Vector();
    private Vector<Component> errorComponents = new Vector();
    private boolean isBlinking = false;
    private int blinkCount = 0;
    private int totalBlinks = 6;
    private Timer blinkTimer;
    private Point lastDragPoint = null;
    private boolean isDragging = false;
    private Map<Component, String> originalTooltips = new HashMap<Component, String>();
    private final MouseAdapter highlightMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            BackgroundPanel.this.clearHighlight();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            BackgroundPanel.this.lastDragPoint = e.getPoint();
            BackgroundPanel.this.isDragging = false;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            BackgroundPanel.this.lastDragPoint = null;
            BackgroundPanel.this.isDragging = false;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (BackgroundPanel.this.lastDragPoint != null) {
                JViewport viewport;
                BackgroundPanel.this.isDragging = true;
                GDScrollPane scrollPane = (GDScrollPane)SwingUtilities.getAncestorOfClass(GDScrollPane.class, BackgroundPanel.this);
                if (scrollPane != null && (viewport = scrollPane.getViewport()) != null) {
                    int deltaX = ((BackgroundPanel)BackgroundPanel.this).lastDragPoint.x - e.getX();
                    int deltaY = ((BackgroundPanel)BackgroundPanel.this).lastDragPoint.y - e.getY();
                    Point currentViewPosition = viewport.getViewPosition();
                    int newX = currentViewPosition.x + deltaX;
                    int newY = currentViewPosition.y + deltaY;
                    Dimension viewSize = viewport.getSize();
                    Dimension contentSize = BackgroundPanel.this.getPreferredSize();
                    newX = Math.max(0, Math.min(newX, contentSize.width - viewSize.width));
                    newY = Math.max(0, Math.min(newY, contentSize.height - viewSize.height));
                    viewport.setViewPosition(new Point(newX, newY));
                }
            }
        }
    };

    public void setErrorComponents(Vector<Component> components, Map<Component, String> errorTooltips) {
        if (components == null) {
            this.clearErrorComponents();
            return;
        }
        this.errorComponents.clear();
        for (Component component : components) {
            if (component == null || !component.isShowing()) continue;
            this.originalTooltips.put(component, ((JComponent)component).getToolTipText());
            String errorTooltip = errorTooltips.get(component);
            if (errorTooltip != null) {
                ((JComponent)component).setToolTipText(errorTooltip);
            }
            this.errorComponents.add(component);
        }
        this.repaint();
    }

    public void setErrorComponents(Vector<Component> components) {
        if (components == null) {
            this.errorComponents.clear();
            return;
        }
        this.errorComponents.clear();
        for (Component component : components) {
            if (component == null || !component.isShowing()) continue;
            this.errorComponents.add(component);
        }
        this.repaint();
    }

    public void clearErrorComponents() {
        if (!this.errorComponents.isEmpty()) {
            for (Component component : this.errorComponents) {
                String originalTooltip = this.originalTooltips.get(component);
                if (originalTooltip == null) continue;
                ((JComponent)component).setToolTipText(originalTooltip);
            }
            this.originalTooltips.clear();
            this.errorComponents.clear();
            this.repaint();
        }
    }

    public BackgroundPanel(BufferedImage image, Double re_size) {
        this.scale_size = re_size;
        this.image = image;
        this.imageSize = new Dimension((int)((double)this.image.getWidth(null) * this.scale_size), (int)((double)this.image.getHeight(null) * this.scale_size));
        this.setLayout(null);
        this.setMaximumSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
        this.setOpaque(false);
        this.addMouseListener(this.highlightMouseListener);
        this.addMouseMotionListener(this.highlightMouseListener);
        this.blinkTimer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BackgroundPanel.this.blinkCount >= BackgroundPanel.this.totalBlinks) {
                    BackgroundPanel.this.blinkTimer.stop();
                    BackgroundPanel.this.isBlinking = false;
                    BackgroundPanel.this.blinkCount = 0;
                    BackgroundPanel.this.repaint();
                } else {
                    BackgroundPanel.this.isBlinking = !BackgroundPanel.this.isBlinking;
                    BackgroundPanel backgroundPanel = BackgroundPanel.this;
                    backgroundPanel.blinkCount = backgroundPanel.blinkCount + 1;
                    BackgroundPanel.this.repaint();
                }
            }
        });
    }

    public void setHighlightedComponent(Component component) {
        this.highlightedComponents.clear();
        if (component == null || !component.isShowing()) {
            this.clearHighlight();
            return;
        }
        this.highlightedComponent = component;
        this.highlightedComponents.add(component);
        this.isBlinking = true;
        this.blinkCount = 0;
        if (this.blinkTimer.isRunning()) {
            this.blinkTimer.stop();
        }
        this.blinkTimer.start();
        this.repaint();
    }

    public void clearHighlight() {
        if (this.highlightedComponent != null || !this.highlightedComponents.isEmpty()) {
            this.highlightedComponent = null;
            this.highlightedComponents.clear();
            if (this.blinkTimer != null && this.blinkTimer.isRunning()) {
                this.blinkTimer.stop();
            }
            this.isBlinking = false;
            this.blinkCount = 0;
            this.repaint();
        }
    }

    public void re_BackgroundPanel(BufferedImage image, Double re_size) {
        EventListener listener;
        this.scale_size = re_size;
        this.image = image;
        this.imageSize = new Dimension((int)((double)this.image.getWidth(null) * this.scale_size), (int)((double)this.image.getHeight(null) * this.scale_size));
        this.setLayout(null);
        this.setMaximumSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
        this.setOpaque(false);
        boolean hasListener = false;
        boolean hasMouseMotionListener = false;
        EventListener[] eventListenerArray = this.getMouseListeners();
        int n = eventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            listener = eventListenerArray[n2];
            if (listener == this.highlightMouseListener) {
                hasListener = true;
                break;
            }
            ++n2;
        }
        eventListenerArray = this.getMouseMotionListeners();
        n = eventListenerArray.length;
        n2 = 0;
        while (n2 < n) {
            listener = eventListenerArray[n2];
            if (listener == this.highlightMouseListener) {
                hasMouseMotionListener = true;
                break;
            }
            ++n2;
        }
        if (!hasListener) {
            this.addMouseListener(this.highlightMouseListener);
        }
        if (!hasMouseMotionListener) {
            this.addMouseMotionListener(this.highlightMouseListener);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension((int)((double)this.imageSize.width + (double)this.imageSize.width * (this.ZoomInOutVal - 1.0)), (int)((double)this.imageSize.height + (double)this.imageSize.height * (this.ZoomInOutVal - 1.0)));
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.image != null) {
            Rectangle bounds;
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.scale(this.scale_size, this.scale_size);
            g2d.drawImage((Image)this.image, 0, 0, this);
            g2d.dispose();
            if (!this.errorComponents.isEmpty()) {
                g2d = (Graphics2D)g.create();
                g2d.setColor(Color.RED);
                g2d.setStroke(new BasicStroke(2.0f));
                for (Component component : this.errorComponents) {
                    bounds = component.getBounds();
                    g2d.drawRect(bounds.x - 3, bounds.y - 3, bounds.width + 6, bounds.height + 6);
                }
                g2d.dispose();
            }
            if (!this.blinkTimer.isRunning() || this.isBlinking) {
                g2d = (Graphics2D)g.create();
                g2d.setColor(Color.BLUE);
                g2d.setStroke(new BasicStroke(2.0f));
                if (this.highlightedComponent != null) {
                    Rectangle bounds2 = this.highlightedComponent.getBounds();
                    g2d.drawRect(bounds2.x - 3, bounds2.y - 3, bounds2.width + 6, bounds2.height + 6);
                }
                for (Component component : this.highlightedComponents) {
                    if (component == this.highlightedComponent) continue;
                    bounds = component.getBounds();
                    g2d.drawRect(bounds.x - 3, bounds.y - 3, bounds.width + 6, bounds.height + 6);
                }
                g2d.dispose();
            }
        }
    }
}

