/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.codegenerate.xmlparse;

import com.gigadevice.codegenerate.codetemplate.TemplateFunctionStruct;
import com.gigadevice.codegenerate.codetemplate.TemplateGroupStruct;
import com.gigadevice.codegenerate.codetemplate.TemplateInfoStruct;
import com.gigadevice.codegenerate.codetemplate.TemplateParamStruct;
import com.gigadevice.codegenerate.codetemplate.TemplatePeripheralStruct;
import com.gigadevice.codegenerate.codetemplate.TemplateStruct;
import com.gigadevice.codegenerate.codetemplate.TemplateTextStruct;
import com.gigadevice.conflict.baseinfo.ConditionInfo;
import com.gigadevice.conflict.baseinfo.ConflictGroupInfo;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CodeTemplateXMLParse {
    private static final String XML_GROUP = "Group";
    private static final String XML_PERIPHERAL = "Peripheral";
    private static final String XML_TEMPLATE = "Template";
    private static final String XML_TEXT = "Text";
    private static final String XML_RELATION = "Relation";
    private static final String XML_PRIVILEGEINFOS = "PrivilegeInfos";
    private static final String XML_PRIVILEGEUSER = "PrivilegeUser";
    private static final String XML_FUNCTION = "Function";
    private static final String XML_PARAM = "Param";
    private static final String ATTRIBUTES_NAME = "Name";
    private static final String ATTRIBUTES_TYPE = "Type";
    private static final String ATTRIBUTES_SOURCEPATH = "SourcePath";
    private static final String ATTRIBUTES_TARGETPATH = "TargetPath";
    private static final String ATTRIBUTES_SOURCETYPE = "SourceType";
    private static final String ATTRIBUTES_TARGETYPE = "TargetType";
    private static final String ATTRIBUTES_RELATEFROM = "RelateFrom";
    private static final String ATTRIBUTES_KEY = "Key";
    private static final String ATTRIBUTES_CONTENT = "Content";
    private static final String ATTRIBUTES_OPER = "Oper";

    public static TemplateGroupStruct parseTemplateCodeXML(String filePath) {
        TemplateGroupStruct templateGroupStructObj = new TemplateGroupStruct();
        if (filePath == null || filePath.trim().isEmpty()) {
            return templateGroupStructObj;
        }
        if (!Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
            return templateGroupStructObj;
        }
        SAXReader saxReader = new SAXReader();
        try {
            Document document = saxReader.read(new File(filePath));
            Element rootElm = document.getRootElement();
            List TemplateMapGroupList = rootElm.elements(XML_GROUP);
            CodeTemplateXMLParse.ParseRoot(templateGroupStructObj, TemplateMapGroupList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return templateGroupStructObj;
    }

    private static void ParseRoot(TemplateGroupStruct templateGroupStructObj, List<Element> listNode) {
        Iterator<Element> it = listNode.iterator();
        while (it.hasNext()) {
            TemplateInfoStruct templateInfoStruct = new TemplateInfoStruct();
            Element elm = it.next();
            String GroupName = elm.attributeValue(ATTRIBUTES_NAME);
            List TemplateNodeList = elm.elements(XML_TEMPLATE);
            CodeTemplateXMLParse.ParseGroup(templateInfoStruct, TemplateNodeList);
            templateGroupStructObj.putGroups(GroupName, templateInfoStruct);
        }
    }

    private static void ParseGroup(TemplateInfoStruct templateInfoStruct, List<Element> listNode) {
        Iterator<Element> it = listNode.iterator();
        while (it.hasNext()) {
            TemplateStruct templateObj = new TemplateStruct();
            Element elm = it.next();
            String Name = elm.attributeValue(ATTRIBUTES_NAME);
            String Type2 = elm.attributeValue(ATTRIBUTES_TYPE);
            String SourcePath = elm.attributeValue(ATTRIBUTES_SOURCEPATH);
            String TargetPath = elm.attributeValue(ATTRIBUTES_TARGETPATH);
            String SourceType = elm.attributeValue(ATTRIBUTES_SOURCETYPE);
            String TargetType = elm.attributeValue(ATTRIBUTES_TARGETYPE);
            templateObj.setName(Name);
            templateObj.setType(Type2);
            templateObj.setSourcePath(SourcePath);
            templateObj.setTargetPath(TargetPath);
            templateObj.setSourceType(SourceType);
            templateObj.setTargetType(TargetType);
            List PeripheralNodeList = elm.elements(XML_PERIPHERAL);
            CodeTemplateXMLParse.ParseTemplate(templateObj, PeripheralNodeList);
            templateInfoStruct.putTemplate(templateObj);
        }
    }

    private static void ParseTemplate(TemplateStruct templateObj, List<Element> listNode) {
        Iterator<Element> it = listNode.iterator();
        while (it.hasNext()) {
            TemplatePeripheralStruct templatePeripheralStruct = new TemplatePeripheralStruct();
            Element elm = it.next();
            String Name = elm.attributeValue(ATTRIBUTES_NAME);
            String RelateFrom = elm.attributeValue(ATTRIBUTES_RELATEFROM);
            templatePeripheralStruct.setName(Name);
            templatePeripheralStruct.setRelateFrom(RelateFrom);
            List TextNodeList = elm.elements(XML_TEXT);
            CodeTemplateXMLParse.ParsePeripheral(Name, templatePeripheralStruct, TextNodeList);
            templateObj.putPeripheral(Name, templatePeripheralStruct);
        }
    }

    private static void ParsePeripheral(String PeriName, TemplatePeripheralStruct templatePeripheralStruct, List<Element> listNode) {
        Iterator<Element> it = listNode.iterator();
        while (it.hasNext()) {
            TemplateTextStruct templateTextStruct = new TemplateTextStruct();
            Element elm = it.next();
            String Key = elm.attributeValue(ATTRIBUTES_KEY);
            templateTextStruct.setKey(Key);
            List RelationNodeList = elm.elements(XML_RELATION);
            List FunctionNodeList = elm.elements(XML_FUNCTION);
            for (Element elmRelation : RelationNodeList) {
                String TypeName = elmRelation.attributeValue(ATTRIBUTES_NAME);
                ConflictGroupInfo GroupInfoObj = new ConflictGroupInfo();
                GroupInfoObj.setType(TypeName);
                CodeTemplateXMLParse.ParsePrivilegeInfosList(PeriName, GroupInfoObj, elmRelation);
                templateTextStruct.putRelation(Key, GroupInfoObj);
            }
            for (Element elmFunction : FunctionNodeList) {
                String Name = elmFunction.attributeValue(ATTRIBUTES_NAME);
                TemplateFunctionStruct templateFunctionStruct = new TemplateFunctionStruct();
                templateFunctionStruct.setName(Name);
                List ParamNodeList = elmFunction.elements(XML_PARAM);
                CodeTemplateXMLParse.ParseFunction(Name, templateFunctionStruct, ParamNodeList);
                templateTextStruct.putFunction(Name, templateFunctionStruct);
            }
            templatePeripheralStruct.putText(templateTextStruct);
        }
    }

    private static void ParseFunction(String name, TemplateFunctionStruct templateFunctionStruct, List<Element> paramNodeList) {
        Iterator<Element> it = paramNodeList.iterator();
        while (it.hasNext()) {
            TemplateParamStruct templateParamStruct = new TemplateParamStruct();
            Element elm = it.next();
            String Content = elm.attributeValue(ATTRIBUTES_CONTENT);
            String Name = elm.attributeValue(ATTRIBUTES_NAME);
            String RelateFrom = elm.attributeValue(ATTRIBUTES_RELATEFROM);
            String Oper = elm.attributeValue(ATTRIBUTES_OPER);
            templateParamStruct.setContent(Content);
            templateParamStruct.setName(Name);
            templateParamStruct.setRelateFrom(RelateFrom);
            templateParamStruct.setOper(Oper);
            templateFunctionStruct.putParam(templateParamStruct);
        }
    }

    private static void ParsePrivilegeInfosList(String PeriName, ConflictGroupInfo GroupInfoObj, Element elmRelation) {
        List UserList = GroupInfoObj.getConditionsList();
        List PrivilegeInfosList = elmRelation.elements(XML_PRIVILEGEINFOS);
        for (Element elmPrivilegeInfos : PrivilegeInfosList) {
            List PrivilegeUserList = elmPrivilegeInfos.elements(XML_PRIVILEGEUSER);
            ArrayList<ConditionInfo> UList = new ArrayList<ConditionInfo>();
            for (Element elmPrivilegeUser : PrivilegeUserList) {
                ConditionInfo PrivilegeUserObj = new ConditionInfo();
                PrivilegeUserObj.setType("Item");
                Iterator itAttribute = elmPrivilegeUser.attributeIterator();
                while (itAttribute.hasNext()) {
                    Attribute attribute = (Attribute)itAttribute.next();
                    String attributeName = attribute.getName();
                    String attributeValue = attribute.getText();
                    if (attributeValue.equals("")) continue;
                    PrivilegeUserObj.setAttrValue(attributeName, attributeValue);
                }
                UList.add(PrivilegeUserObj);
            }
            UserList.add(UList);
        }
        GroupInfoObj.setConditionsList(UserList);
    }
}

