/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.codegenerate.tool;

import com.gigadevice.codegenerate.tool.DMAReflectionFunc;
import com.gigadevice.periconfigview.utils.MDMAConfigUtil;
import com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo;
import com.gigadevice.venustool.baseinfo.dma.MDMAConfigGroupInfo;
import com.gigadevice.venustool.baseinfo.dma.MDMAConfigInfo;
import com.gigadevice.venustool.baseinfo.dma.MDMAInfoUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class MDMAReflectionFunc {
    public String GetCycleNum(String PeriName) {
        int num = 0;
        if (MDMAInfoUtil.mDMAConfigInfo.containsKey(PeriName)) {
            Map mDMAChannelConfigInfo = (Map)MDMAInfoUtil.mDMAConfigInfo.get(PeriName);
            for (Map.Entry entry : mDMAChannelConfigInfo.entrySet()) {
                MDMAConfigGroupInfo mDMAConfigObj = (MDMAConfigGroupInfo)entry.getValue();
                LinkedHashMap mDMARequestMap = mDMAConfigObj.getMDMAInfoMap();
                if (mDMARequestMap.size() <= 0) continue;
                num += mDMARequestMap.size();
            }
            return String.valueOf(num);
        }
        return "0";
    }

    public String GetChannelCycleNum(String PeriName) {
        if (MDMAInfoUtil.mDMAConfigInfo.containsKey(PeriName)) {
            Map mDMAChannelConfigInfo = (Map)MDMAInfoUtil.mDMAConfigInfo.get(PeriName);
            return String.valueOf(mDMAChannelConfigInfo.size());
        }
        return "0";
    }

    public String GetRequestStr(String PeriName, String Cycle) {
        MDMAConfigInfo DMAConfigObj = this.GetMDMAConfigInfo(PeriName, Cycle);
        if (DMAConfigObj == null) {
            return null;
        }
        Map ContorlInfoMap = DMAConfigObj.getContorlInfoMap();
        String requestStr = (String)ContorlInfoMap.get("MDMA Request");
        return requestStr.toLowerCase();
    }

    public String GetMapValue(String PeriName, String Cycle, String AttriName) {
        MDMAConfigInfo DMAConfigObj = this.GetMDMAConfigInfo(PeriName, Cycle);
        if (DMAConfigObj == null) {
            return null;
        }
        Map ContorlInfoMap = DMAConfigObj.getContorlInfoMap();
        if (ContorlInfoMap.containsKey(AttriName)) {
            String ConfigValue = (String)ContorlInfoMap.get(AttriName);
            if (!MDMAConfigUtil.mdmaAllInfo.getCodeDefineMap().containsKey(AttriName)) {
                return (String)ContorlInfoMap.get(AttriName);
            }
            if (((Map)MDMAConfigUtil.mdmaAllInfo.getCodeDefineMap().get(AttriName)).containsKey(ConfigValue)) {
                return (String)((Map)MDMAConfigUtil.mdmaAllInfo.getCodeDefineMap().get(AttriName)).get(ConfigValue);
            }
        }
        return null;
    }

    public MDMAConfigInfo GetMDMAConfigInfo(String PeriName, String Cycle) {
        int CycleNum = 0;
        try {
            CycleNum = Integer.parseInt(Cycle);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        int num = 0;
        if (MDMAInfoUtil.mDMAConfigInfo.containsKey(PeriName)) {
            Map mDMAChannelConfigInfo = (Map)MDMAInfoUtil.mDMAConfigInfo.get(PeriName);
            for (Map.Entry entry : mDMAChannelConfigInfo.entrySet()) {
                MDMAConfigGroupInfo mDMAConfigObj = (MDMAConfigGroupInfo)entry.getValue();
                LinkedHashMap mDMARequestMap = mDMAConfigObj.getMDMAInfoMap();
                if (mDMARequestMap.size() <= 0) continue;
                ArrayList strList = new ArrayList(mDMARequestMap.keySet());
                if (num <= CycleNum && num + mDMARequestMap.size() > CycleNum) {
                    return (MDMAConfigInfo)mDMARequestMap.get(strList.get(CycleNum - num));
                }
                num += mDMARequestMap.size();
            }
        }
        return null;
    }

    public boolean checkisEqual(String str1, String str2) {
        DMAReflectionFunc obj = new DMAReflectionFunc();
        return obj.checkisEqual(str1, str2);
    }

    public boolean checkisNotEqual(String str1, String str2) {
        DMAReflectionFunc obj = new DMAReflectionFunc();
        return obj.checkisNotEqual(str1, str2);
    }

    public String GetMDMAChannelx(String PeriName, String Cycle) {
        String channel = this.GetChannel(PeriName, Cycle);
        return channel;
    }

    public String GetChannel(String PeriName, String Cycle) {
        MDMAConfigInfo DMAConfigObj = this.GetMDMAConfigInfo(PeriName, Cycle);
        if (DMAConfigObj == null) {
            return null;
        }
        if (DMAConfigObj.getContorlInfoMap().containsKey("Channel")) {
            return (String)DMAConfigObj.getContorlInfoMap().get("Channel");
        }
        return null;
    }

    public boolean checkIsCircularModeFirst(String PeriName, String Cycle) {
        int CycleNum = 0;
        try {
            CycleNum = Integer.parseInt(Cycle);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        int num = 0;
        if (MDMAInfoUtil.mDMAConfigInfo.containsKey(PeriName)) {
            Map mDMAChannelConfigInfo = (Map)MDMAInfoUtil.mDMAConfigInfo.get(PeriName);
            for (Map.Entry entry : mDMAChannelConfigInfo.entrySet()) {
                MDMAConfigGroupInfo mDMAConfigObj = (MDMAConfigGroupInfo)entry.getValue();
                LinkedHashMap mDMARequestMap = mDMAConfigObj.getMDMAInfoMap();
                if (mDMARequestMap.size() <= 0) continue;
                if (num + mDMARequestMap.size() <= CycleNum) {
                    num += mDMARequestMap.size();
                    continue;
                }
                return CycleNum == num;
            }
        }
        return false;
    }

    public boolean checkIsChannelNotFirst(String PeriName, String Cycle) {
        int CycleNum = 0;
        try {
            CycleNum = Integer.parseInt(Cycle);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        int num = 0;
        if (MDMAInfoUtil.mDMAConfigInfo.containsKey(PeriName)) {
            Map mDMAChannelConfigInfo = (Map)MDMAInfoUtil.mDMAConfigInfo.get(PeriName);
            for (Map.Entry entry : mDMAChannelConfigInfo.entrySet()) {
                MDMAConfigGroupInfo mDMAConfigObj = (MDMAConfigGroupInfo)entry.getValue();
                LinkedHashMap mDMARequestMap = mDMAConfigObj.getMDMAInfoMap();
                if (mDMARequestMap.size() <= 0) continue;
                if (num + mDMARequestMap.size() <= CycleNum) {
                    num += mDMARequestMap.size();
                    continue;
                }
                if (CycleNum == num) {
                    return false;
                }
                return num < CycleNum && num + mDMARequestMap.size() > CycleNum;
            }
        }
        return false;
    }

    public boolean checkIsCircularModeFinal(String PeriName, String Cycle) {
        int CycleNum = 0;
        try {
            CycleNum = Integer.parseInt(Cycle);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        int num = 0;
        if (MDMAInfoUtil.mDMAConfigInfo.containsKey(PeriName)) {
            Map mDMAChannelConfigInfo = (Map)MDMAInfoUtil.mDMAConfigInfo.get(PeriName);
            for (Map.Entry entry : mDMAChannelConfigInfo.entrySet()) {
                MDMAConfigGroupInfo mDMAConfigObj = (MDMAConfigGroupInfo)entry.getValue();
                LinkedHashMap mDMARequestMap = mDMAConfigObj.getMDMAInfoMap();
                if (mDMARequestMap.size() <= 0) continue;
                ArrayList strList = new ArrayList(mDMARequestMap.keySet());
                DMAConfigInfo mDMARequestObj = (DMAConfigInfo)mDMARequestMap.get(strList.get(0));
                String listMode = mDMARequestObj.getContorlValue("List Type");
                if (num + mDMARequestMap.size() <= CycleNum) {
                    num += mDMARequestMap.size();
                    continue;
                }
                return CycleNum == num + (mDMARequestMap.size() - 1) && listMode.contains("Circular List");
            }
        }
        return false;
    }

    public boolean checkIsFinal(String PeriName, String Cycle) {
        int CycleNum = 0;
        try {
            CycleNum = Integer.parseInt(Cycle);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        int num = 0;
        if (MDMAInfoUtil.mDMAConfigInfo.containsKey(PeriName)) {
            Map mDMAChannelConfigInfo = (Map)MDMAInfoUtil.mDMAConfigInfo.get(PeriName);
            for (Map.Entry entry : mDMAChannelConfigInfo.entrySet()) {
                MDMAConfigGroupInfo mDMAConfigObj = (MDMAConfigGroupInfo)entry.getValue();
                LinkedHashMap mDMARequestMap = mDMAConfigObj.getMDMAInfoMap();
                if (mDMARequestMap.size() <= 0) continue;
                new ArrayList(mDMARequestMap.keySet());
                if (num + mDMARequestMap.size() <= CycleNum) {
                    num += mDMARequestMap.size();
                    continue;
                }
                return CycleNum == num + (mDMARequestMap.size() - 1);
            }
        }
        return false;
    }

    public boolean checkIsChannelFirst(String PeriName, String Cycle) {
        int CycleNum = 0;
        try {
            CycleNum = Integer.parseInt(Cycle);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        int num = 0;
        if (MDMAInfoUtil.mDMAConfigInfo.containsKey(PeriName)) {
            Map mDMAChannelConfigInfo = (Map)MDMAInfoUtil.mDMAConfigInfo.get(PeriName);
            for (Map.Entry entry : mDMAChannelConfigInfo.entrySet()) {
                MDMAConfigGroupInfo mDMAConfigObj = (MDMAConfigGroupInfo)entry.getValue();
                LinkedHashMap mDMARequestMap = mDMAConfigObj.getMDMAInfoMap();
                if (mDMARequestMap.size() <= 0) continue;
                if (num + mDMARequestMap.size() <= CycleNum) {
                    num += mDMARequestMap.size();
                    continue;
                }
                return CycleNum == num;
            }
        }
        return false;
    }

    public String GetChannelStr(String PeriName, String Cycle) {
        String channel = this.GetChannel(PeriName, Cycle);
        channel = channel.replace(" ", "");
        return channel.toLowerCase();
    }

    public String GetCircularListNumStr(String PeriName, String Cycle) {
        int CycleNum = 0;
        try {
            CycleNum = Integer.parseInt(Cycle);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        int num = 0;
        if (MDMAInfoUtil.mDMAConfigInfo.containsKey(PeriName)) {
            Map mDMAChannelConfigInfo = (Map)MDMAInfoUtil.mDMAConfigInfo.get(PeriName);
            for (Map.Entry entry : mDMAChannelConfigInfo.entrySet()) {
                MDMAConfigGroupInfo mDMAConfigObj = (MDMAConfigGroupInfo)entry.getValue();
                LinkedHashMap mDMARequestMap = mDMAConfigObj.getMDMAInfoMap();
                if (mDMARequestMap.size() <= 0) continue;
                if (num <= CycleNum && num + mDMARequestMap.size() > CycleNum) {
                    return String.valueOf(CycleNum - num);
                }
                num += mDMARequestMap.size();
            }
        }
        return null;
    }

    public String GetCircularListBeforeNumStr(String PeriName, String Cycle) {
        String numStr = this.GetCircularListNumStr(PeriName, Cycle);
        if (numStr != null) {
            int num = Integer.valueOf(numStr);
            return String.valueOf(num - 1);
        }
        return null;
    }

    public String GetCircularListAfterNumStr(String PeriName, String Cycle) {
        String numStr = this.GetCircularListNumStr(PeriName, Cycle);
        if (numStr != null) {
            int num = Integer.valueOf(numStr);
            return String.valueOf(num + 1);
        }
        return null;
    }

    public String GetChannelDeDuplicationStr(String PeriName, String Cycle) {
        int CycleNum = 0;
        try {
            CycleNum = Integer.parseInt(Cycle);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        int num = 0;
        if (MDMAInfoUtil.mDMAConfigInfo.containsKey(PeriName)) {
            Map mDMAChannelConfigInfo = (Map)MDMAInfoUtil.mDMAConfigInfo.get(PeriName);
            for (Map.Entry entry : mDMAChannelConfigInfo.entrySet()) {
                if (num < CycleNum) {
                    ++num;
                    continue;
                }
                return (String)entry.getKey();
            }
        }
        return null;
    }

    public boolean checkIsCircularModeFirstAndNotFinal(String PeriName, String Cycle) {
        return this.checkIsChannelFirst(PeriName, Cycle) && !this.checkIsFinal(PeriName, Cycle);
    }

    public boolean checkIsNotCircularModeFirstAndNotFinal(String PeriName, String Cycle) {
        return !this.checkIsCircularModeFirstAndNotFinal(PeriName, Cycle);
    }

    public String GetControlCurConfigValue(String PeriName, String Cycle, String AttriName) {
        MDMAConfigInfo DMAConfigObj = this.GetMDMAConfigInfo(PeriName, Cycle);
        if (DMAConfigObj == null) {
            return null;
        }
        Map ContorlInfoMap = DMAConfigObj.getContorlInfoMap();
        if (ContorlInfoMap.containsKey(AttriName)) {
            String ConfigValue = (String)ContorlInfoMap.get(AttriName);
            return ConfigValue;
        }
        return null;
    }

    public String GetChannelRequestNum(String PeriName, String Cycle) {
        int CycleNum = 0;
        try {
            CycleNum = Integer.parseInt(Cycle);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        int num = 0;
        if (MDMAInfoUtil.mDMAConfigInfo.containsKey(PeriName)) {
            Map mDMAChannelConfigInfo = (Map)MDMAInfoUtil.mDMAConfigInfo.get(PeriName);
            for (Map.Entry entry : mDMAChannelConfigInfo.entrySet()) {
                MDMAConfigGroupInfo mDMAConfigObj = (MDMAConfigGroupInfo)entry.getValue();
                LinkedHashMap mDMARequestMap = mDMAConfigObj.getMDMAInfoMap();
                if (mDMARequestMap.size() <= 0) continue;
                if (num <= CycleNum && num + mDMARequestMap.size() > CycleNum) {
                    return String.valueOf(mDMARequestMap.size());
                }
                num += mDMARequestMap.size();
            }
        }
        return "0";
    }

    public String GetLinkNodeMacroAddress(String PeriName, String Cycle, String startAddress, String offset) {
        int CycleNum = 0;
        try {
            CycleNum = Integer.parseInt(Cycle);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        String addressStr = startAddress;
        int num = 0;
        int channelIndex = 0;
        if (MDMAInfoUtil.mDMAConfigInfo.containsKey(PeriName)) {
            Map mDMAChannelConfigInfo = (Map)MDMAInfoUtil.mDMAConfigInfo.get(PeriName);
            for (Map.Entry entry : mDMAChannelConfigInfo.entrySet()) {
                MDMAConfigGroupInfo mDMAConfigObj = (MDMAConfigGroupInfo)entry.getValue();
                ++channelIndex;
                LinkedHashMap mDMARequestMap = mDMAConfigObj.getMDMAInfoMap();
                if (mDMARequestMap.size() <= 0) continue;
                if (num <= CycleNum && num + mDMARequestMap.size() > CycleNum) break;
                num += mDMARequestMap.size();
            }
        }
        if (channelIndex != 0) {
            if (startAddress.startsWith("0x") && offset.startsWith("0x")) {
                long startAddress_Long = Long.parseLong(startAddress.substring(2), 16);
                long offset_Long = Long.parseLong(offset.substring(2), 16);
                addressStr = String.format("%x", offset_Long * (long)channelIndex + startAddress_Long);
            } else {
                long startAddress_Long = Long.parseLong(startAddress, 16);
                long offset_Long = Long.parseLong(offset, 16);
                addressStr = String.valueOf(offset_Long * (long)channelIndex + startAddress_Long);
            }
        }
        return addressStr;
    }

    public boolean GetConditionsAND(String strbl1, String strbl2) {
        return Boolean.parseBoolean(strbl1) && Boolean.parseBoolean(strbl2);
    }

    public boolean GetConditionsAND(String strbl1, String strbl2, String strbl3) {
        return Boolean.parseBoolean(strbl1) && Boolean.parseBoolean(strbl2) && Boolean.parseBoolean(strbl3);
    }

    public boolean GetConditionsAND(String strbl1, String strbl2, String strbl3, String strbl4) {
        return Boolean.parseBoolean(strbl1) && Boolean.parseBoolean(strbl2) && Boolean.parseBoolean(strbl3) && Boolean.parseBoolean(strbl4);
    }
}

