/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.codegenerate.tool;

import com.gigadevice.codegenerate.util.SystemVarUtil;
import com.gigadevice.periconfigview.baseinfo.PeriConfigItem;
import com.gigadevice.periconfigview.baseinfo.PeriConfigPart;
import com.gigadevice.periconfigview.utils.DMAConfigUtil;
import com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo;
import com.gigadevice.venustool.baseinfo.dma.DMAInfoUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DMAReflectionFunc {
    public String GetDMARequestCount() {
        int num = 0;
        for (Map.Entry entry : DMAInfoUtil.DMAConfigInfo.entrySet()) {
            num += ((LinkedHashMap)entry.getValue()).size();
        }
        return String.valueOf(num);
    }

    public String GetDMARequstUpper(String PeriName, String Cycle) {
        String Request = this.GetRequestStr(PeriName, Cycle);
        if (Request != null) {
            Request = Request.toUpperCase();
        }
        return Request;
    }

    public String GetCycleNum(String PeriName) {
        if (DMAInfoUtil.DMAConfigInfo.containsKey(PeriName)) {
            Map PartDMAConfigInfo = (Map)DMAInfoUtil.DMAConfigInfo.get(PeriName);
            int num = PartDMAConfigInfo.size();
            return String.valueOf(num);
        }
        return "0";
    }

    public String GetTIMERChannelIndex(String PeriName, String Cycle) {
        DMAConfigInfo DMAConfigObj = this.GetDMAConfigInfo(PeriName, Cycle);
        if (DMAConfigObj == null) {
            return null;
        }
        String requester = DMAConfigObj.getDMARequest();
        int index = -1;
        index = requester.indexOf("CH");
        if (index != -1) {
            requester = requester.substring(index + 2, index + 3);
        }
        return requester;
    }

    public String GetDMA(String PeriName, String Cycle) {
        String DMA = "";
        String Channel2 = this.GetChannel(PeriName, Cycle);
        DMA = Channel2.substring(0, 4);
        return DMA;
    }

    public String GetChannel(String PeriName, String Cycle) {
        DMAConfigInfo DMAConfigObj = this.GetDMAConfigInfo(PeriName, Cycle);
        if (DMAConfigObj == null) {
            return null;
        }
        if (DMAConfigObj.getContorlInfoMap().containsKey("Channel")) {
            return (String)DMAConfigObj.getContorlInfoMap().get("Channel");
        }
        return null;
    }

    public DMAConfigInfo GetDMAConfigInfo(String PeriName, String Cycle) {
        int CycleNum = 0;
        try {
            CycleNum = Integer.parseInt(Cycle);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        if (DMAInfoUtil.DMAConfigInfo.containsKey(PeriName)) {
            int num = 0;
            Map PartDMAConfigInfo = (Map)DMAInfoUtil.DMAConfigInfo.get(PeriName);
            for (Map.Entry entry : PartDMAConfigInfo.entrySet()) {
                if (CycleNum == num) {
                    return (DMAConfigInfo)entry.getValue();
                }
                ++num;
            }
        }
        return null;
    }

    public String GetRequestStr(String PeriName, String Cycle) {
        DMAConfigInfo DMAConfigObj = this.GetDMAConfigInfo(PeriName, Cycle);
        if (DMAConfigObj == null) {
            return null;
        }
        String Channel2 = "";
        Map ContorlInfoMap = DMAConfigObj.getContorlInfoMap();
        if (ContorlInfoMap.containsKey("Channel")) {
            Channel2 = (String)ContorlInfoMap.get("Channel");
        }
        if (((String)ContorlInfoMap.get("DMA Request")).equals("MEMTOMEM")) {
            String channelStr = Channel2;
            if (channelStr.contains("_")) {
                int tmp = channelStr.indexOf("_");
                channelStr = channelStr.substring(tmp + 1, Channel2.length());
                channelStr = channelStr.replaceAll(" ", "_");
            } else if (channelStr.contains(" ")) {
                channelStr = channelStr.replaceAll(" ", "_");
                channelStr = channelStr.replaceAll("Channel", "ch");
            }
            String Request = String.valueOf(channelStr.toLowerCase()) + "_m2m";
            SystemVarUtil.NVIC_DMAChannelGlobalParaInfo.put(Channel2, "dma_" + Request + "_info");
            return Request;
        }
        String Request = ((String)ContorlInfoMap.get("DMA Request")).toLowerCase();
        SystemVarUtil.NVIC_DMAChannelGlobalParaInfo.put(Channel2, "dma_" + Request + "_info");
        return Request;
    }

    public String GetDMARequestName(String PeriName, String Cycle) {
        DMAConfigInfo DMAConfigObj = this.GetDMAConfigInfo(PeriName, Cycle);
        if (DMAConfigObj == null) {
            return null;
        }
        Map ContorlInfoMap = DMAConfigObj.getContorlInfoMap();
        return (String)ContorlInfoMap.get("DMA Request");
    }

    public String GetBindInfo(String PeriName, String Cycle) {
        DMAConfigInfo DMAConfigObj = this.GetDMAConfigInfo(PeriName, Cycle);
        if (DMAConfigObj == null) {
            return null;
        }
        Map ContorlInfoMap = DMAConfigObj.getContorlInfoMap();
        if (((String)ContorlInfoMap.get("DMA Request")).contains("_TX")) {
            return "p_dma_tx";
        }
        if (((String)ContorlInfoMap.get("DMA Request")).contains("_RX")) {
            return "p_dma_rx";
        }
        if (((String)ContorlInfoMap.get("DMA Request")).contains("ADC")) {
            return "p_dma_adc";
        }
        if (((String)ContorlInfoMap.get("DMA Request")).contains("DAC")) {
            return "p_dma_dac";
        }
        if (((String)ContorlInfoMap.get("DMA Request")).contains("SAI")) {
            if (DMAConfigObj.getContorlValue("Direction").equals("Peripheral To Memory")) {
                return "p_dma_rx";
            }
            return "p_dma_tx";
        }
        PeriName = PeriName.replaceAll("[0-9]", "");
        PeriName = PeriName.toLowerCase();
        return "p_dma_" + PeriName;
    }

    public String GetTimerBindInfo(String PeriName, String Cycle, String Series) {
        String Request;
        String[] strList;
        DMAConfigInfo DMAConfigObj = this.GetDMAConfigInfo(PeriName, Cycle);
        if (DMAConfigObj == null) {
            return null;
        }
        Map ContorlInfoMap = DMAConfigObj.getContorlInfoMap();
        if (Series.equals("H7") && (strList = (Request = (String)ContorlInfoMap.get("DMA Request")).split("_")).length > 1) {
            return "p_dma_timer[TIMER_DMA_ID_" + strList[1] + "]";
        }
        return "";
    }

    public String GetMapValue(String PeriName, String Cycle, String AttriName) {
        DMAConfigInfo DMAConfigObj = this.GetDMAConfigInfo(PeriName, Cycle);
        if (DMAConfigObj == null) {
            return null;
        }
        Map ContorlInfoMap = DMAConfigObj.getContorlInfoMap();
        if (ContorlInfoMap.containsKey(AttriName)) {
            String ConfigValue = (String)ContorlInfoMap.get(AttriName);
            if (!DMAConfigUtil.dmaAllInfo.getCodeDefineMap().containsKey(AttriName)) {
                return (String)ContorlInfoMap.get(AttriName);
            }
            if (((Map)DMAConfigUtil.dmaAllInfo.getCodeDefineMap().get(AttriName)).containsKey(ConfigValue)) {
                return (String)((Map)DMAConfigUtil.dmaAllInfo.getCodeDefineMap().get(AttriName)).get(ConfigValue);
            }
        }
        return null;
    }

    public String GetControlCurConfigValue(String PeriName, String Cycle, String AttriName) {
        DMAConfigInfo DMAConfigObj = this.GetDMAConfigInfo(PeriName, Cycle);
        if (DMAConfigObj == null) {
            return null;
        }
        Map ContorlInfoMap = DMAConfigObj.getContorlInfoMap();
        if (ContorlInfoMap.containsKey(AttriName)) {
            String ConfigValue = (String)ContorlInfoMap.get(AttriName);
            return ConfigValue;
        }
        return null;
    }

    public boolean GetisNotTimerOrUsart(String PeriName) {
        return !PeriName.contains("TIMER") && !PeriName.contains("USART");
    }

    public boolean WhetheritisPeripheral(String PeriName1, String PeriName2) {
        return PeriName1.toUpperCase().contains(PeriName2.toUpperCase());
    }

    public boolean GetTimerDMARequestCondition(String PeriName, String strbl1, String Cycle) {
        String Request = this.GetMapValue(PeriName, Cycle, "DMA Request");
        if (Request == null) {
            return false;
        }
        return Request.toUpperCase().contains(strbl1.toUpperCase());
    }

    private PeriConfigPart GetPartNode(String PeriName, String Cycle, String partName) {
        Map parts;
        PeriConfigPart partNodeObj = null;
        String Request = this.GetMapValue(PeriName, Cycle, "DMA Request");
        if (PeriName.equals("DMA")) {
            Request = "MEMTOMEM";
        }
        Request = Request.toUpperCase();
        if (DMAConfigUtil.dmaAllInfo.getConfigInfoMap().containsKey(PeriName) && (parts = (Map)DMAConfigUtil.dmaAllInfo.getConfigInfoMap().get(PeriName)).containsKey(Request)) {
            List partList = (List)parts.get(Request);
            for (PeriConfigPart partObj : partList) {
                if (!partObj.getName().equals(partName)) continue;
                partNodeObj = partObj;
            }
        }
        return partNodeObj;
    }

    public boolean GetPartNodeAttrValue(String PeriName, String Cycle, String partName, String attrName) {
        PeriConfigPart partNodeObj = this.GetPartNode(PeriName, Cycle, partName);
        if (partNodeObj == null) {
            return false;
        }
        return false;
    }

    public boolean GetItemNodeAttrValue(String PeriName, String Cycle, String partName, String ItemName, String attrName) {
        PeriConfigPart partNodeObj = this.GetPartNode(PeriName, Cycle, partName);
        if (partNodeObj == null) {
            return false;
        }
        List IemList = partNodeObj.getIemList();
        for (PeriConfigItem itemObj : IemList) {
            if (!itemObj.getName().equals(ItemName)) continue;
            String value = itemObj.getOtherInfoMap(attrName);
            return value != null && value.toUpperCase().equals("TRUE");
        }
        return false;
    }

    public String GetDMAPeriph(String PeriName, String Cycle) {
        String channel = this.GetChannel(PeriName, Cycle);
        String dmaPeriph = channel.split("_")[0];
        return dmaPeriph;
    }

    public String GetDMAChannelx(String PeriName, String Cycle) {
        String channel = this.GetChannel(PeriName, Cycle);
        String[] strlist = channel.split("_");
        String dmaPeriph = "";
        if (strlist.length > 1) {
            dmaPeriph = strlist[1];
            dmaPeriph = dmaPeriph.replaceAll("[^0-9]", "");
            dmaPeriph = "DMA_CH" + dmaPeriph;
        }
        return dmaPeriph;
    }

    public boolean checkisEqual(String str1, String str2) {
        return str1.equals(str2);
    }

    public boolean checkisNotEqual(String str1, String str2) {
        return !str1.equals(str2);
    }
}

