/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.codegenerate.projectmigrate;

import com.gigadevice.adapter.AdapterUtils;
import com.gigadevice.codegenerate.projectmigrate.ProjectSettingsStruct;
import com.gigadevice.mbs.ProjectUpdateFile;
import com.gigadevice.mbs.arm.Option;
import com.gigadevice.mwcodegenerate.baseinfo.MwGenerateCode;
import com.gigadevice.mwcodegenerate.tools.GenerateFtlParamMap;
import com.gigadevice.periconfigview.utils.GeneralPeriConfigUtil;
import com.gigadevice.periconfigview.utils.ProjectManagerSettingUtil;
import com.gigadevice.templates.core.ProjectSetOptionValue;
import com.gigadevice.utils.ProjectUtils;
import com.gigadevice.utils.preferences.EclipsePreferences;
import com.gigadevice.venustool.ConstantsUtil;
import com.gigadevice.venustool.GeneralPathUtil;
import com.gigadevice.venustool.GlobalPathUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.TargetOSInfo;
import com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject;
import com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriVariables;
import com.gigadevice.venustool.baseinfo.jtreenode.AbstractJTreeNode;
import com.gigadevice.venustool.mcuxmlinfo.MCUs;
import com.gigadevice.venustool.mcuxmlinfo.McuFactory;
import com.gigadevice.venustool.mcuxmlinfo.McuSubGroup;
import com.gigadevice.venustool.tool.FolderProcess;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

public class GenerateProjectFile {
    private String projectPath;
    private String ProjectName;
    private String fileSrcPath;
    private String fileTargetPath;
    private String fileCodeLoaction;
    private String fileCodeLoactionAddress;
    private String fileRamLength;
    private String fileRamOrigin;
    private String fileFlashlength;
    private String fileFlashOrigin;
    private String fileEnvmlength;
    private String fileEnvmOrigin;
    private String fileStacklength;
    private String fileStackOrigin;
    private String toolchain;
    private String toolchainPath;
    private String buildtoolPath;
    private final String FD_LDS = "ldscripts";
    private final String FD_FWLIB = "Firmware";
    private final String FD_GCC_S = "gcc_startup";
    private final String FD_CMSIS_UP = "CMSIS";
    private FolderProcess folderProcess = new FolderProcess();
    private ProjectSettingsStruct ProjectSetStrObj = new ProjectSettingsStruct();
    private boolean IsFirstGenerate;
    private String pathFWLib;

    public GenerateProjectFile(String projectPath, String ProjectName) {
        this.projectPath = projectPath;
        this.ProjectName = ProjectName;
        this.IsFirstGenerate = this.updateIsFirstGenerate();
        this.pathFWLib = this.getFWLibPath();
    }

    public boolean updateIsFirstGenerate() {
        boolean bl;
        String ProjectRootPath = "";
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.ProjectName);
        if (project.exists()) {
            ProjectRootPath = project.getLocation().toOSString();
            if (ProjectRootPath.equals("")) {
                bl = true;
            }
        } else {
            bl = true;
        }
        String CProjectFilePath = String.valueOf(ProjectRootPath) + File.separator + ".cproject";
        String ProjectFilePath = String.valueOf(ProjectRootPath) + File.separator + ".project";
        File CProjectFile = new File(CProjectFilePath);
        File ProjectFile = new File(ProjectFilePath);
        boolean IsFirstGenerateResult = !CProjectFile.exists() || !ProjectFile.exists();
        return IsFirstGenerateResult;
    }

    public void UpdateFile() {
        this.CopyProjectFolder();
        this.UpdateProjectFile();
        this.UpdateCProjectFile();
    }

    public void CopyProjectFolder() {
        this.GenerateProjectAndCprojectFile();
        this.updateUtilsPreferences();
        this.UpdateLDFile();
        this.UpdateCFGFile();
        this.UpdateStartupFile();
        this.updateIncludePath();
    }

    public void GenerateProjectAndCprojectFile() {
        if (!this.IsFirstGenerate) {
            return;
        }
        String ProjectFilePath = String.valueOf(this.projectPath) + File.separator + ".project";
        File file = new File(ProjectFilePath);
        file.delete();
        String ProjectFolderPath = String.valueOf(GeneralPathUtil.ResourcePath) + "ProjectSetting" + File.separator;
        ProjectFolderPath = ConstantsUtil.typrProject == 2 ? String.valueOf(ProjectFolderPath) + "MDK" : (ConstantsUtil.typrProject == 3 ? (GlobalVariables.McuSeletorInfo.getCore().contains("cortex") ? String.valueOf(ProjectFolderPath) + "IAR" + File.separator + "ARM" : String.valueOf(ProjectFolderPath) + "IAR" + File.separator + "RISC-V") : (GlobalVariables.McuSeletorInfo.getCore().contains("cortex") ? String.valueOf(ProjectFolderPath) + "ARM" : String.valueOf(ProjectFolderPath) + "RISC-V"));
        GlobalVariables.copyFolder((String)ProjectFolderPath, (String)this.projectPath);
    }

    public void UpdateLDFile() {
        if (!ProjectManagerSettingUtil.getOverwriteState((String)"OverwriteLDFile") && this.getFileIsExistState("ld")) {
            return;
        }
        this.copyFileByFileType("ld");
        this.updateLDFilePath();
        if (!this.IsFirstGenerate) {
            EclipsePreferences tempPreferences = new EclipsePreferences("com.gigadevice.utils");
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.ProjectName);
            tempPreferences.putLinkFileSrcPath(this.fileSrcPath, project);
            tempPreferences.putLinkFileTargetPath(this.fileTargetPath, project);
            tempPreferences.flush(project);
            IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(this.ProjectName);
            tempPreferences = new EclipsePreferences("com.gigadevice.utils");
            ProjectUpdateFile.updateLinkFile((IProject)projectHandle, (EclipsePreferences)tempPreferences);
        }
    }

    public void UpdateCFGFile() {
        if (!ProjectManagerSettingUtil.getOverwriteState((String)"OverwriteCFGFile") && this.getFileIsExistState("openocd")) {
            return;
        }
        Path folderPath = Paths.get(this.projectPath, "firmware", "cmsis", "src", "openocd_gdlink.cfg");
        FolderProcess.deleteFolder((Path)folderPath);
        folderPath = Paths.get(this.projectPath, "openocd_gdlink.cfg");
        FolderProcess.deleteFolder((Path)folderPath);
        this.copyFileByFileType("openocd");
    }

    public void UpdateStartupFile() {
        if (!ProjectManagerSettingUtil.getOverwriteState((String)"OverwriteStartupFile") && this.getFileIsExistState("startup")) {
            return;
        }
        if (ConstantsUtil.typrProject == 3 && !GlobalVariables.McuSeletorInfo.getCore().contains("cortex")) {
            return;
        }
        Path folderPath = Paths.get(this.projectPath, "firmware", "cmsis", "gcc_startup");
        FolderProcess.deleteFolder((Path)folderPath);
        this.copyFileByFileType("startup");
    }

    public String copyFileByFileType(String FileType) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.ProjectName);
        ArrayList Files2 = AdapterUtils.getFilesByType((IProject)project, (String)FileType, (!this.IsFirstGenerate ? 1 : 0) != 0);
        if (Files2 != null && Files2.size() > 0) {
            String FirstFileName = (String)Files2.get(0);
            String SourceFileFolder = ProjectUtils.findFileFolder((String)this.pathFWLib, (String)FirstFileName);
            String TargetFileFolder = ProjectUtils.getTargetFileFolder((String)FirstFileName);
            for (String FileName : Files2) {
                String srcStartFolder = String.valueOf(this.pathFWLib) + SourceFileFolder + FileName;
                String desStartFolder = String.valueOf(this.projectPath) + File.separator + TargetFileFolder + File.separator + FileName;
                FolderProcess.copyFileOrDirectory((String)srcStartFolder, (String)desStartFolder);
            }
            return FirstFileName;
        }
        return "";
    }

    public boolean getFileIsExistState(String FileType) {
        List list1;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.ProjectName);
        String Suffix = "";
        switch (FileType) {
            case "startup": {
                Suffix = ".S";
                break;
            }
            case "ld": {
                Suffix = ".ld";
                break;
            }
            case "openocd": {
                Suffix = ".cfg";
                break;
            }
        }
        List list = ProjectUtils.getFilesWithSpecifiedSuffix((IProject)project, (String)Suffix);
        if (list.size() > 0) {
            return true;
        }
        return Suffix.equals(".S") && (list1 = ProjectUtils.getFilesWithSpecifiedSuffix((IProject)project, (String)(Suffix = ".s"))).size() > 0;
    }

    public void updateIncludePath() {
        if (!this.IsFirstGenerate) {
            return;
        }
        this.folderProcess.allFiles.clear();
        this.folderProcess.foldersWithHFiles.clear();
        this.folderProcess.scanFolder(new File(this.projectPath));
        for (String inc : this.folderProcess.foldersWithHFiles) {
            String includePath = "..";
            includePath = String.valueOf(includePath) + inc.replace(this.projectPath, "");
            this.ProjectSetStrObj.putIncludePath(includePath);
        }
    }

    public void updateCortexFile() {
        String srcCMSISPath = String.valueOf(this.pathFWLib) + File.separator + "Firmware" + File.separator + "CMSIS";
        String desCMSISPath = String.valueOf(this.projectPath) + File.separator + "CMSIS";
        try {
            this.folderProcess.copyTargetFile(srcCMSISPath, desCMSISPath, ".h");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getFWLibPath() {
        if (ConstantsUtil.typrProject == 0) {
            return String.valueOf(GlobalPathUtil.getGDProjectFWLibPath()) + File.separator;
        }
        return GlobalPathUtil.getTemplateProjectFWLibPath();
    }

    public void UpdateProjectFile() {
        if (!this.IsFirstGenerate) {
            return;
        }
        String ProjectFilePath = String.valueOf(this.projectPath) + File.separator + ".project";
        try {
            String str;
            FileReader fis = new FileReader(ProjectFilePath);
            char[] data = new char[0x200000];
            int rn = 0;
            StringBuilder sb = new StringBuilder();
            while ((rn = fis.read(data)) > 0) {
                str = String.valueOf(data, 0, rn);
                sb.append(str);
            }
            fis.close();
            str = sb.toString();
            str = str.replaceAll("ProjectName", this.ProjectName);
            String targetPath = ProjectFilePath;
            FileWriter fout = new FileWriter(targetPath);
            fout.write(str.toCharArray());
            fout.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void UpdateCProjectFile() {
        if (!this.IsFirstGenerate) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.ProjectName);
            this.normalizeIncludePaths(project);
            return;
        }
        String CProjectFilePath = String.valueOf(this.projectPath) + File.separator + ".cproject";
        this.updateUtilsPreferencesInfo();
        this.ProjectSetStrObj.putSettingsItem("fpu", "false");
        String Core = GlobalVariables.McuSeletorInfo.getCore().contains("cortex") ? "ARM" : "RISCV";
        this.ProjectSetStrObj.putToolchainPath(McuFactory.getDefaultToolChainPath((String)Core));
        if (GlobalVariables.McuSeletorInfo.getSeries().contains("GD32VW553")) {
            this.ProjectSetStrObj.putToolchainPath("Tools/NucleiRISCVGCC/bin");
        }
        this.ProjectSetStrObj.putBuildtoolPath(McuFactory.getDefaultToolChainBuildToolPath());
        if (!MwGenerateCode.includePaths_map.isEmpty()) {
            for (String includePath : MwGenerateCode.includePaths_map.keySet()) {
                this.ProjectSetStrObj.putIncludePath(includePath);
            }
        }
        try {
            FileReader fis = new FileReader(CProjectFilePath);
            char[] data = new char[0x200000];
            int rn = 0;
            StringBuilder sb = new StringBuilder();
            while ((rn = fis.read(data)) > 0) {
                String str = String.valueOf(data, 0, rn);
                sb.append(str);
            }
            fis.close();
            String input = sb.toString();
            String str = this.ReplaceFileInfo(input, this.ProjectSetStrObj);
            String targetPath = CProjectFilePath;
            FileWriter fout = new FileWriter(targetPath);
            fout.write(str.toCharArray());
            fout.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.AddProjectSettingsInfo(Core, this.ProjectSetStrObj);
    }

    public void changeToForwardSlashInLinux() {
        if (TargetOSInfo.isLinux()) {
            List<String> OldIncludePathList = this.ProjectSetStrObj.getIncludePathList();
            ArrayList<String> NewIncludePathList = new ArrayList<String>();
            for (String OldIncludePath : OldIncludePathList) {
                String NewIncludePath = OldIncludePath.replace("\\", "/");
                NewIncludePathList.add(NewIncludePath);
            }
            this.ProjectSetStrObj.setIncludePath(NewIncludePathList);
        }
    }

    public void normalizeIncludePaths(IProject project) {
        try {
            if (TargetOSInfo.isLinux()) {
                ArrayList<String> UniversalOptionIds = new ArrayList<String>();
                UniversalOptionIds.add("com.gigadevice.mbs.*****.option.CCompiler.includes.paths");
                String Core = "";
                Core = GlobalVariables.McuSeletorInfo.getCore().contains("cortex") ? "arm" : "riscv";
                ArrayList<String> OptionIds = new ArrayList<String>();
                for (String optionId : UniversalOptionIds) {
                    OptionIds.add(optionId.replace("*****", Core));
                }
                IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
                if (buildInfo == null) {
                    return;
                }
                IConfiguration[] configs = buildInfo.getManagedProject().getConfigurations();
                boolean changed = false;
                IConfiguration[] iConfigurationArray = configs;
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    ITool[] tools;
                    IConfiguration config = iConfigurationArray[n2];
                    ITool[] iToolArray = tools = config.getTools();
                    int n3 = tools.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ITool tool = iToolArray[n4];
                        for (String optionId : OptionIds) {
                            IOption option = tool.getOptionBySuperClassId(optionId);
                            if (option == null) continue;
                            try {
                                ArrayList<String> includePathList = this.getIncludePathsListWithStream(option);
                                String[] includePaths = includePathList.toArray(new String[0]);
                                boolean pathChanged = false;
                                int i = 0;
                                while (i < includePaths.length) {
                                    if (includePaths[i].contains("\\")) {
                                        includePaths[i] = includePaths[i].replace("\\", "/");
                                        pathChanged = true;
                                    }
                                    ++i;
                                }
                                if (!pathChanged) continue;
                                ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)option, (String[])includePaths);
                                changed = true;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
                if (changed) {
                    ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList<String> getIncludePathsListWithStream(IOption option) {
        try {
            Object value = option.getValue();
            if (value instanceof ArrayList) {
                ArrayList rawList = (ArrayList)value;
                return rawList.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toCollection(ArrayList::new));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ArrayList<String>();
    }

    private String ReplaceFileInfo(String input, ProjectSettingsStruct ProjectSetStrObj) {
        this.changeToForwardSlashInLinux();
        ArrayList<String> includePaths = new ArrayList<String>();
        int i = 0;
        while (i < ProjectSetStrObj.getIncludePathList().size()) {
            String include = "&quot;" + ProjectSetStrObj.getIncludePathList().get(i) + "&quot;";
            includePaths.add(include);
            ++i;
        }
        ArrayList<String> linkerScriptList = new ArrayList<String>();
        int i2 = 0;
        while (i2 < ProjectSetStrObj.getLinkerScriptList().size()) {
            String include = ProjectSetStrObj.getLinkerScriptList().get(i2);
            linkerScriptList.add(include);
            ++i2;
        }
        String includePathsString = this.listOptionValueToString(includePaths);
        String linkerScriptString = this.listOptionValueToString(linkerScriptList);
        String output = input.replace("projectName", this.ProjectName);
        output = input.replace("${linker.scriptfile}", linkerScriptString);
        output = ConstantsUtil.typrProject != 2 && ConstantsUtil.typrProject != 3 ? output.replace("${include.paths}", includePathsString) : output.replace("${include.paths}", "<listOptionValue builtIn=\"false\" value=\"&quot;&quot;\"/>");
        return output;
    }

    private void AddProjectSettingsInfo(String Core, ProjectSettingsStruct ProjectSetStrObj) {
        class ToolSettings {
            private String projectName;
            private String MCU;
            private String MCUSubGroup;
            private String MCUGroup;
            private String MCUCore;
            private String[] Symbols;
            private String FPU;
            private String FABIsoft = "Library (soft)";
            private String FABIhard = "FP instructions (hard)";
            private String CodeLocation;

            ToolSettings() {
            }
        }
        ToolSettings toolSettings = new ToolSettings();
        toolSettings.MCU = GlobalVariables.McuSeletorInfo.getMCUPart();
        toolSettings.MCUSubGroup = GlobalVariables.McuSeletorInfo.getSeries();
        toolSettings.MCUGroup = GlobalVariables.McuSeletorInfo.getMCUGroup();
        toolSettings.MCUCore = GlobalVariables.McuSeletorInfo.getCore();
        MCUs mcu = GlobalVariables.McuSeletorInfo.getMcuObj();
        this.fileFlashOrigin = mcu.getFlashAddress();
        this.fileFlashlength = mcu.getFlashSize();
        this.fileEnvmOrigin = mcu.getEnvmAddress();
        this.fileEnvmlength = mcu.getEnvmSize();
        this.fileRamOrigin = ProjectSetStrObj.getSettingsItem("fileRamOrigin");
        this.fileRamLength = GlobalVariables.McuSeletorInfo.getRamSize();
        if (GlobalVariables.McuSeletorInfo.getMCUGroup().equals("GD32H7xx")) {
            this.fileRamLength = "512";
        }
        toolSettings.projectName = this.ProjectName;
        toolSettings.FPU = ProjectSetStrObj.getSettingsItem("fpu");
        toolSettings.CodeLocation = ProjectSetStrObj.getSettingsItem("fileCodeLoaction");
        this.fileCodeLoaction = ProjectSetStrObj.getSettingsItem("fileCodeLoaction");
        this.fileCodeLoactionAddress = ProjectSetStrObj.getSettingsItem("fileCodeLoactionAddress");
        this.fileSrcPath = ProjectSetStrObj.getSettingsItem("fileSrcPath");
        this.fileTargetPath = ProjectSetStrObj.getSettingsItem("fileTargetPath");
        this.fileStacklength = ProjectSetStrObj.getSettingsItem("fileStacklength");
        this.fileStackOrigin = ProjectSetStrObj.getSettingsItem("fileStackOrigin");
        int len = GlobalVariables.McuSeletorInfo.getSymbols().size();
        toolSettings.Symbols = new String[len];
        int i = 0;
        while (i < len) {
            ((ToolSettings)toolSettings).Symbols[i] = (String)GlobalVariables.McuSeletorInfo.getSymbols().get(i);
            ++i;
        }
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(this.ProjectName);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription workspaceDesc = workspace.getDescription();
        workspaceDesc.isAutoBuilding();
        workspaceDesc.setAutoBuilding(false);
        try {
            workspace.setDescription(workspaceDesc);
        }
        catch (CoreException coreException) {}
        String filePath = this.getInstallLocation();
        String str = "/";
        filePath = filePath.substring(0, filePath.length() - str.length());
        String[] splits = filePath.split("/");
        filePath = splits[0];
        int n = 1;
        while (n < splits.length - 1) {
            filePath = String.valueOf(filePath) + "/" + splits[n];
            ++n;
        }
        this.toolchainPath = ProjectSetStrObj.GetToolchainPath();
        this.buildtoolPath = ProjectSetStrObj.GetBuildtoolPath();
        if (TargetOSInfo.isLinux()) {
            this.toolchainPath = this.toolchainPath.replaceAll(" ", "");
            this.buildtoolPath = this.buildtoolPath.replaceAll(" ", "");
        }
        EclipsePreferences tempPreferences = new EclipsePreferences("com.gigadevice.utils");
        ProjectSetOptionValue SetOptionValue = new ProjectSetOptionValue();
        SetOptionValue.setLdInfoStr("");
        SetOptionValue.setFileSrcPath(this.fileSrcPath);
        SetOptionValue.setFileTargetPath(this.fileTargetPath);
        SetOptionValue.setToolSettingsMCUCore(toolSettings.MCUCore);
        SetOptionValue.setFileCodeLoactionAddress(this.fileCodeLoactionAddress);
        SetOptionValue.setFileStackOrigin(this.fileStackOrigin);
        SetOptionValue.setFileStacklength(this.fileStacklength);
        SetOptionValue.setARMtoolchainPath(this.toolchainPath);
        SetOptionValue.setToolSettingsMCUCore(toolSettings.MCUCore);
        SetOptionValue.setToolSettingsFPU(toolSettings.FPU);
        SetOptionValue.setFileEnvmlength(this.fileEnvmlength);
        SetOptionValue.setFileEnvmOrigin(this.fileEnvmOrigin);
        SetOptionValue.setFileFlashlength(this.fileFlashlength);
        SetOptionValue.setFileRamLength(this.fileRamLength);
        SetOptionValue.setFileFlashOrigin(this.fileFlashOrigin);
        SetOptionValue.setFileRamOrigin(this.fileRamOrigin);
        SetOptionValue.setRISCVtoolchainPath(this.toolchainPath);
        SetOptionValue.setMcuObj(GlobalVariables.McuSeletorInfo.getMcuObj());
        SetOptionValue.setFileCodeLoaction(this.fileCodeLoaction);
        SetOptionValue.setBuildtoolPath(this.buildtoolPath);
        SetOptionValue.setToolSettingsMCU(toolSettings.MCU);
        SetOptionValue.setToolSettingsSymbols(toolSettings.Symbols);
        SetOptionValue.setFileSrcPath(this.fileSrcPath);
        SetOptionValue.setFileTargetPath(this.fileTargetPath);
        this.toolchain = Core.equals("ARM") ? "com.gigadevice.mbs.arm.toolChain" : "com.gigadevice.mbs.riscv.toolChain";
        SetOptionValue.setToolchain(this.toolchain);
        try {
            projectHandle.refreshLocal(2, null);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        try {
            GenerateProjectFile.SetAllOptionValue(projectHandle, SetOptionValue);
            ProjectUpdateFile.updateLinkFile((IProject)projectHandle, (EclipsePreferences)tempPreferences);
        }
        catch (ProcessFailureException e) {
            e.printStackTrace();
        }
        if (ConstantsUtil.typrProject == 0) {
            try {
                this.updateProjectSettingsSymbolsInfo();
            }
            catch (ProcessFailureException e) {
                e.printStackTrace();
            }
        }
    }

    private String listOptionValueToString(List<String> listOptionValue) {
        String listOptionValuetring = "";
        int i = 0;
        while (i < listOptionValue.size()) {
            String childValue = "<listOptionValue builtIn=\"false\" value=\"" + listOptionValue.get(i) + "\"/>" + "\r";
            listOptionValuetring = String.valueOf(listOptionValuetring) + childValue;
            ++i;
        }
        return listOptionValuetring;
    }

    private String getInstallLocation() {
        Location l = Platform.getInstallLocation();
        String filePath = l.getURL().toString();
        int start = 0;
        int length = 0;
        if (TargetOSInfo.isWindows()) {
            start = filePath.indexOf("file:/") + 6;
            length = filePath.length() - filePath.indexOf("file:/");
        } else if (TargetOSInfo.isLinux()) {
            start = filePath.indexOf("file:") + 5;
            length = filePath.length() - filePath.indexOf("file:");
        }
        filePath = filePath.substring(start, length);
        return filePath;
    }

    public static void SetAllOptionValue(IProject projectHandle, ProjectSetOptionValue SetOptionValue) throws ProcessFailureException {
        block41: {
            switch (SetOptionValue.getToolchain()) {
                case "com.gigadevice.mbs.arm.toolChain": {
                    try {
                        SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TARGET_ARMFAMILY, SetOptionValue.getToolSettingsMCUCore());
                        SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_CCOMPILER_CODEPOSITION, SetOptionValue.getFileCodeLoactionAddress().substring(2));
                        SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_CCOMPILER_STACKBASE, SetOptionValue.getFileStackOrigin().substring(2));
                        String Stacksize = Integer.toHexString(1024 * Integer.valueOf(SetOptionValue.getFileStacklength(), 10));
                        SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_CCOMPILER_STACKSIZE, Stacksize);
                        SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TARGET_MCU, SetOptionValue.getToolSettingsMCU());
                        SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TOOLCHAIN_NAME, "GNU Tools for ARM Embedded Processors");
                        SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TOOLCHAIN_PREFIX, "arm-none-eabi-");
                        SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TOOLCHAIN_C, "arm-none-eabi-gcc");
                        SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TOOLCHAIN_RM, "rm");
                        SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TOOLCHAIN_MAKE, "make");
                        SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TOOLCHAIN_OBJCOPY, "arm-none-eabi-objcopy");
                        SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TOOLCHAIN_OBJDUMP, "arm-none-eabi-objdump");
                        SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TOOLCHAIN_SIZE, "arm-none-eabi-size");
                        SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TOOLCHAIN_PATH, SetOptionValue.getARMtoolchainPath());
                        SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_BUILDTOOL_PATH, SetOptionValue.getBuildtoolPath());
                        if (SetOptionValue.getToolSettingsMCUCore().equals("cortex-m33") || SetOptionValue.getToolSettingsMCUCore().equals("cortex-m4")) {
                            if (SetOptionValue.getToolSettingsFPU().equals("true")) {
                                SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TARGET_FLOATABI, Option.OPTIONID_TARGET_FLOATABI_DEFAULT);
                                SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TARGET_FLOATUNIT, Option.OPTIONID_TARGET_FLOATUNIT_DEFAULT);
                            } else if (SetOptionValue.getToolSettingsFPU().equals("false")) {
                                SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TARGET_FLOATABI, Option.OPTIONID_TARGET_FLOATABI_DEFAULT);
                            }
                        }
                        if (SetOptionValue.getFileCodeLoaction().equals("FLASH")) {
                            SetOptionValue.setOptionValue(projectHandle, "com.gigadevice.mbs.arm.option.optimization.level", "com.gigadevice.mbs.option.toolSettings.optimization.level.none");
                        } else if (SetOptionValue.getFileCodeLoaction().equals("RAM")) {
                            SetOptionValue.setOptionValue(projectHandle, "com.gigadevice.mbs.arm.option.optimization.level", "com.gigadevice.mbs.option.toolSettings.optimization.level.size");
                        }
                        if (ConstantsUtil.typrProject == 2 || ConstantsUtil.typrProject == 3) break;
                        SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_CCOMPILER_SYMBOLS_DEF, SetOptionValue.getToolSettingsSymbols());
                        SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_ASSEMBLER_SYMBOLS_DEF, SetOptionValue.getToolSettingsSymbols());
                        break;
                    }
                    catch (BuildException e) {
                        throw new ProcessFailureException("SetOptionValue Failed:" + e.getMessage(), (Throwable)e);
                    }
                }
                case "com.gigadevice.mbs.riscv.toolChain": {
                    try {
                        long targetFlashlength = Integer.parseInt(SetOptionValue.getFileFlashlength(), 10) * 1024;
                        String targetFileFlashlength = Long.toHexString(targetFlashlength).toUpperCase();
                        long targetRamlength = Integer.parseInt(SetOptionValue.getFileRamLength(), 10) * 1024;
                        String targetFileRamLength = Long.toHexString(targetRamlength).toUpperCase();
                        if (SetOptionValue.getFileCodeLoaction().equals("FLASH")) {
                            SetOptionValue.setOptionValue(projectHandle, "com.gigadevice.mbs.riscv.option.optimization.level", "com.gigadevice.mbs.option.toolSettings.optimization.level.none");
                        } else if (SetOptionValue.getFileCodeLoaction().equals("RAM")) {
                            SetOptionValue.setOptionValue(projectHandle, "com.gigadevice.mbs.riscv.option.optimization.level", "com.gigadevice.mbs.option.toolSettings.optimization.level.size");
                            SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TARGET_SAVERESTORE, true);
                            SetOptionValue.setOptionValue(projectHandle, "com.gigadevice.mbs.riscv.option.optimization.lto", true);
                        }
                        SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_CCOMPILER_CODEBASE, SetOptionValue.getFileFlashOrigin().substring(2));
                        SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_CCOMPILER_CODESIZE, targetFileFlashlength);
                        SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_CCOMPILER_RAMBASE, SetOptionValue.getFileRamOrigin().substring(2));
                        SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_CCOMPILER_RAMSIZE, targetFileRamLength);
                        SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_NAME, "GNU MCU RISC-V GCC");
                        SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_PATH, SetOptionValue.getRISCVtoolchainPath());
                        SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_BUILDTOOL_PATH, SetOptionValue.getBuildtoolPath());
                        SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_PREFIX, "riscv-none-embed-");
                        SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_C, "riscv-none-embed-gcc");
                        SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_RM, "rm");
                        SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_MAKE, "make");
                        SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_OBJCOPY, "riscv-none-embed-objcopy");
                        SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_OBJDUMP, "riscv-none-embed-objdump");
                        SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_SIZE, "riscv-none-embed-size");
                        String SpecialToolChainPath = ((McuSubGroup)SetOptionValue.getMcuObj().getParent()).getToolChainPath();
                        if (!SpecialToolChainPath.equals("")) {
                            SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_NAME, "MCU RISC-V GCC");
                            SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_PREFIX, "riscv-nuclei-elf-");
                            SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_C, "riscv-nuclei-elf-gcc");
                            SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_OBJCOPY, "riscv-nuclei-elf-objcopy");
                            SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_OBJDUMP, "riscv-nuclei-elf-objdump");
                            SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_SIZE, "riscv-nuclei-elf-size");
                        }
                        SetOptionValue.setOptionValue(projectHandle, "com.gigadevice.mbs.riscv.option.targetMcu.partNo", SetOptionValue.getToolSettingsMCU());
                        SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_CCOMPILER_SYMBOLS_DEF, SetOptionValue.getToolSettingsSymbols());
                        SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_ASSEMBLER_SYMBOLS_DEF, SetOptionValue.getToolSettingsSymbols());
                        break;
                    }
                    catch (BuildException e) {
                        throw new ProcessFailureException(String.valueOf(Messages.getString((String)"SetMBSStringOptionValue.0")) + e.getMessage(), (Throwable)e);
                    }
                }
            }
            try {
                LinkedHashMap Options = SetOptionValue.getOptions();
                if (Options == null) break block41;
                Set IDSet = Options.keySet();
                for (String ID : IDSet) {
                    if ((ConstantsUtil.typrProject == 2 || ConstantsUtil.typrProject == 3 && GlobalVariables.McuSeletorInfo.getCore().contains("cortex")) && "com.gigadevice.mbs.arm.option.targetProcessor.other".equals(ID)) continue;
                    LinkedHashMap ValueType = (LinkedHashMap)Options.get(ID);
                    String Value = (String)ValueType.keySet().iterator().next();
                    String Type2 = (String)ValueType.get(Value);
                    if (Value.length() == 0) continue;
                    switch (Value.toLowerCase()) {
                        case "true": {
                            SetOptionValue.setOptionValue(projectHandle, ID, true);
                            break;
                        }
                        case "false": {
                            SetOptionValue.setOptionValue(projectHandle, ID, false);
                            break;
                        }
                        default: {
                            if (Value.contains(",") || Type2.equalsIgnoreCase("list")) {
                                SetOptionValue.setOptionValue(projectHandle, ID, ProjectUtils.StringToList((String)Value));
                                break;
                            }
                            SetOptionValue.setOptionValue(projectHandle, ID, Value);
                        }
                    }
                }
            }
            catch (BuildException e1) {
                throw new ProcessFailureException("AppendOptionValue Failed:" + e1.getMessage(), (Throwable)e1);
            }
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription workspaceDesc = workspace.getDescription();
        workspaceDesc.setAutoBuilding(true);
        try {
            workspace.setDescription(workspaceDesc);
        }
        catch (CoreException coreException) {}
        EclipsePreferences tempPreferences = new EclipsePreferences("com.gigadevice.utils");
        tempPreferences.putLinkFileSrcPath(SetOptionValue.getFileSrcPath(), projectHandle);
        tempPreferences.putLinkFileTargetPath(SetOptionValue.getFileTargetPath(), projectHandle);
        tempPreferences.putLinkFileCodeLoaction(SetOptionValue.getFileCodeLoaction(), projectHandle);
        tempPreferences.putLinkFileRamLength(SetOptionValue.getFileRamLength(), projectHandle);
        tempPreferences.putLinkFileRamOrigin(SetOptionValue.getFileRamOrigin(), projectHandle);
        tempPreferences.putLinkFileFlashlength(SetOptionValue.getFileFlashlength(), projectHandle);
        tempPreferences.putLinkFileFlashOrigin(SetOptionValue.getFileFlashOrigin(), projectHandle);
        tempPreferences.putLinkFileEnvmlength(SetOptionValue.getFileEnvmlength(), projectHandle);
        tempPreferences.putLinkFileEnvmOrigin(SetOptionValue.getFileEnvmOrigin(), projectHandle);
        tempPreferences.putLinkFileStacklength(SetOptionValue.getFileStacklength(), projectHandle);
        tempPreferences.putLinkFileStackOrigin(SetOptionValue.getFileStackOrigin(), projectHandle);
        tempPreferences.putTargetMCU(SetOptionValue.getToolSettingsMCU(), projectHandle);
        tempPreferences.putMCUTargetSVD(SetOptionValue.getMcuObj().getSVD(), projectHandle);
        tempPreferences.flush(projectHandle);
    }

    public void updateLDFilePath() {
        ArrayList Files2 = McuFactory.getFileParaList((String)"ld", (MCUs)GlobalVariables.McuSeletorInfo.getMcuObj());
        String FirstLDFileName = (String)Files2.get(0);
        String SourceFileFolder = ProjectUtils.findFileFolder((String)this.pathFWLib, (String)FirstLDFileName);
        String TargetFileFolder = ProjectUtils.getTargetFileFolder((String)FirstLDFileName);
        if (this.IsFirstGenerate) {
            this.ProjectSetStrObj.clearLinkerScriptList();
            this.ProjectSetStrObj.putLinkerScriptList(FirstLDFileName);
        }
        String targetLdPath = String.valueOf(this.projectPath) + File.separator + TargetFileFolder;
        this.fileTargetPath = String.valueOf(targetLdPath) + File.separator + FirstLDFileName;
        this.fileSrcPath = String.valueOf(this.pathFWLib) + SourceFileFolder + FirstLDFileName;
        this.fileTargetPath = ProjectUtils.NormalizePath((String)this.fileTargetPath);
        this.fileSrcPath = ProjectUtils.NormalizePath((String)this.fileSrcPath);
    }

    public void updateUtilsPreferencesInfo() {
        this.updateLDFilePath();
        if (GlobalVariables.McuSeletorInfo.getMCUGroup().equals("GD32H7xx")) {
            this.ProjectSetStrObj.putSettingsItem("fileRamOrigin", "0x24000000");
        } else {
            this.ProjectSetStrObj.putSettingsItem("fileRamOrigin", "0x20000000");
        }
        this.ProjectSetStrObj.putSettingsItem("fileCodeLoaction", "FLASH");
        this.ProjectSetStrObj.putSettingsItem("fileCodeLoactionAddress", "0x08000000");
        this.ProjectSetStrObj.putSettingsItem("fileStacklength", "1");
        this.ProjectSetStrObj.putSettingsItem("fileSrcPath", this.fileSrcPath);
        this.ProjectSetStrObj.putSettingsItem("fileTargetPath", this.fileTargetPath);
        if (GlobalVariables.McuSeletorInfo.getCore().contains("cortex")) {
            this.ProjectSetStrObj.putSettingsItem("fileStackOrigin", "0x20001000");
        } else {
            this.ProjectSetStrObj.putSettingsItem("fileStackOrigin", "0x20001800");
        }
    }

    public boolean checkUtilsFileExist() {
        File settingsDir = new File(this.projectPath, ".settings");
        File prefsFile = new File(settingsDir, "com.gigadevice.utils.prefs");
        return settingsDir.exists() && settingsDir.isDirectory() && prefsFile.exists() && prefsFile.isFile();
    }

    public void updateUtilsPreferences() {
        if (this.IsFirstGenerate) {
            return;
        }
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(this.ProjectName);
        EclipsePreferences tempPreferences = new EclipsePreferences("com.gigadevice.utils");
        this.updateUtilsPreferencesInfo();
        MCUs mcu = GlobalVariables.McuSeletorInfo.getMcuObj();
        String fileFlashlength = GlobalVariables.McuSeletorInfo.getFlashSize();
        String fileRamLength = GlobalVariables.McuSeletorInfo.getRamSize();
        if (GlobalVariables.McuSeletorInfo.getMCUGroup().equals("GD32H7xx")) {
            fileRamLength = "512";
        }
        String TargetMCU = GlobalVariables.McuSeletorInfo.getMCUPart();
        String SVD = GlobalVariables.McuSeletorInfo.getMcuObj().getSVD();
        tempPreferences.putLinkFileSrcPath(this.ProjectSetStrObj.getSettingsItem("fileSrcPath"), projectHandle);
        tempPreferences.putLinkFileTargetPath(this.ProjectSetStrObj.getSettingsItem("fileTargetPath"), projectHandle);
        tempPreferences.putLinkFileCodeLoaction(this.ProjectSetStrObj.getSettingsItem("fileCodeLoaction"), projectHandle);
        tempPreferences.putLinkFileRamLength(fileRamLength, projectHandle);
        tempPreferences.putLinkFileRamOrigin(this.ProjectSetStrObj.getSettingsItem("fileRamOrigin"), projectHandle);
        tempPreferences.putLinkFileFlashlength(fileFlashlength, projectHandle);
        tempPreferences.putLinkFileFlashOrigin(mcu.getFlashAddress(), projectHandle);
        tempPreferences.putLinkFileEnvmlength(mcu.getEnvmSize(), projectHandle);
        tempPreferences.putLinkFileEnvmOrigin(mcu.getEnvmAddress(), projectHandle);
        tempPreferences.putLinkFileStacklength(this.ProjectSetStrObj.getSettingsItem("fileStacklength"), projectHandle);
        tempPreferences.putLinkFileStackOrigin(this.ProjectSetStrObj.getSettingsItem("fileStackOrigin"), projectHandle);
        tempPreferences.putTargetMCU(TargetMCU, projectHandle);
        tempPreferences.putMCUTargetSVD(SVD, projectHandle);
        tempPreferences.flush(projectHandle);
    }

    public void updateProjectSettingsSymbolsInfo() throws ProcessFailureException {
        IConfiguration[] configurations;
        GlobalVariables.McuSeletorInfo.getSymbols();
        int Srclen = GlobalVariables.McuSeletorInfo.getSymbols().size();
        ArrayList Symbols = new ArrayList();
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(GlobalVariables.ProjectName);
        ProjectSetOptionValue OptionValue = new ProjectSetOptionValue();
        IConfiguration[] iConfigurationArray = configurations = ManagedBuildManager.getBuildInfo((IResource)projectHandle).getManagedProject().getConfigurations();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ITool[] tools;
            IConfiguration configuration = iConfigurationArray[n2];
            ITool[] iToolArray = tools = configuration.getTools();
            int n3 = tools.length;
            int n4 = 0;
            while (n4 < n3) {
                ITool tool = iToolArray[n4];
                IOption toolOption = tool.getOptionBySuperClassId(Option.OPTIONID_CCOMPILER_SYMBOLS_DEF);
                if (toolOption != null) {
                    Symbols = (ArrayList)toolOption.getValue();
                    int k = 0;
                    while (k < Srclen) {
                        String srcSymbol = (String)GlobalVariables.McuSeletorInfo.getSymbols().get(k);
                        String regex = "^(.+)=@(.+?)@$";
                        Pattern pattern = Pattern.compile(regex);
                        Matcher matcher = pattern.matcher(srcSymbol);
                        if (matcher.matches()) {
                            String srcSymbolname = matcher.group(1);
                            ListIterator<String> it = Symbols.listIterator();
                            boolean exist = false;
                            while (it.hasNext()) {
                                String Symbolname;
                                String tempSymbol = (String)it.next();
                                if (!tempSymbol.contains("=") || (Symbolname = tempSymbol.split("=")[0]).compareTo(srcSymbolname) != 0) continue;
                                exist = true;
                                it.set(srcSymbol);
                            }
                            if (!exist) {
                                Symbols.add(srcSymbol);
                            }
                        } else if (!Symbols.contains(srcSymbol)) {
                            Symbols.add(srcSymbol);
                        }
                        ++k;
                    }
                    boolean ifUpdate = false;
                    ListIterator<String> it = Symbols.listIterator();
                    while (it.hasNext()) {
                        String tempSymbol = (String)it.next();
                        if (!tempSymbol.contains("=")) continue;
                        String Symbolname = tempSymbol.split("=")[0];
                        int j = 0;
                        while (j < Srclen) {
                            String valuePath;
                            String[] parts;
                            String srcSymbolname;
                            String srcSymbol = (String)GlobalVariables.McuSeletorInfo.getSymbols().get(j);
                            String regex = "^(.+)=@(.+?)@$";
                            Pattern pattern = Pattern.compile(regex);
                            Matcher matcher = pattern.matcher(srcSymbol);
                            if (matcher.matches() && Symbolname.compareTo(srcSymbolname = matcher.group(1)) == 0 && (parts = (valuePath = matcher.group(2)).split("##")).length > 0) {
                                String PeriName = parts[0];
                                StringBuilder middleParts = new StringBuilder();
                                int s = 1;
                                while (s < parts.length - 1) {
                                    if (s > 1) {
                                        middleParts.append("##");
                                    }
                                    middleParts.append(parts[s]);
                                    ++s;
                                }
                                String parentPath = middleParts.toString();
                                String controlPath = parts[parts.length - 1];
                                String value = "";
                                if (PeriName.equals("Clock")) {
                                    LinkedHashMap perMap = new LinkedHashMap();
                                    GenerateFtlParamMap.getClockConfigInfo(perMap);
                                    if (perMap.containsKey(controlPath)) {
                                        value = perMap.get(controlPath).toString();
                                    }
                                } else if (GeneralPeriVariables.GeneralPeriParaObjectList.containsKey(PeriName)) {
                                    value = GeneralPeriConfigUtil.GetVarMacrofromPeriConfig((String)parentPath, (String)controlPath, (AbstractJTreeNode)((GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)PeriName)).PeriParaTreeApply, (boolean)true);
                                }
                                if (!value.equals("")) {
                                    String replacementPattern = "@" + valuePath + "@";
                                    it.set(srcSymbol.replace(replacementPattern, value));
                                    ifUpdate = true;
                                } else {
                                    it.remove();
                                }
                            }
                            ++j;
                        }
                    }
                    if (ifUpdate) {
                        String[] arr = Symbols.toArray(new String[0]);
                        try {
                            OptionValue.setOptionValue(projectHandle, configuration, Option.OPTIONID_CCOMPILER_SYMBOLS_DEF, arr);
                            OptionValue.setOptionValue(projectHandle, configuration, Option.OPTIONID_ASSEMBLER_SYMBOLS_DEF, arr);
                        }
                        catch (BuildException e) {
                            throw new ProcessFailureException("SetOptionValue Failed:" + e.getMessage(), (Throwable)e);
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public boolean isDoGenerateAndUpdateProjectAndCprojectFile() {
        return this.IsFirstGenerate;
    }

    public void setDoGenerateAndUpdateProjectAndCprojectFile(boolean doGenerateAndUpdateProjectAndCprojectFile) {
        this.IsFirstGenerate = doGenerateAndUpdateProjectAndCprojectFile;
    }
}

