/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.codegenerate.codetemplate;

import com.gigadevice.codegenerate.codetemplate.TemplateFunctionStruct;
import com.gigadevice.codegenerate.codetemplate.TemplateParamStruct;
import com.gigadevice.codegenerate.codetemplate.TemplatePeripheralStruct;
import com.gigadevice.codegenerate.codetemplate.TemplateStruct;
import com.gigadevice.codegenerate.codetemplate.TemplateTextStruct;
import com.gigadevice.conflict.ConflictCheck;
import com.gigadevice.conflict.baseinfo.ConflictGroupInfo;
import com.gigadevice.conflict.tool.ReflectionFunc;
import com.gigadevice.mwcodegenerate.tools.FtlToCode;
import com.gigadevice.mwcodegenerate.tools.GenerateFtlParamMap;
import com.gigadevice.mwcodegenerate.tools.UserCodeStruct;
import com.gigadevice.venustool.GeneralPathUtil;
import com.gigadevice.venustool.GlobalVariables;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenerateTemplateCode {
    private String name;
    private int type;
    private String sourcePath;
    private String targetPath;
    private String sourceType;
    private LinkedHashMap<String, Object> paramMap;
    private LinkedHashMap<String, TemplatePeripheralStruct> templatePeripheralMap;
    public LinkedHashMap<String, UserCodeStruct> userCode_map = new LinkedHashMap();
    private String generatedFilePath;

    public GenerateTemplateCode(TemplateStruct templateStruct, LinkedHashMap<String, Object> perMap) {
        this.paramMap = perMap;
        this.name = templateStruct.getName();
        this.type = templateStruct.getType();
        this.sourcePath = templateStruct.getSourcePath();
        this.targetPath = templateStruct.getTargetPath();
        this.sourceType = templateStruct.getSourceType();
        this.templatePeripheralMap = templateStruct.getPeripheral();
        this.userCode_map.clear();
        this.generatedFilePath = null;
    }

    /*
     * WARNING - void declaration
     */
    public void generateCode(String GdcFilePath, TemplateStruct templateStruct) {
        TemplatePeripheralStruct valueTemp;
        Vector<String> keyVector = new Vector<String>();
        for (Map.Entry<String, TemplatePeripheralStruct> Entry2 : this.templatePeripheralMap.entrySet()) {
            TemplatePeripheralStruct valueTemp2 = Entry2.getValue();
            valueTemp2.getName();
            LinkedHashMap<String, TemplateTextStruct> TemplateTextMap = valueTemp2.getText();
            for (Map.Entry<String, TemplateTextStruct> TemplateTextEntry : TemplateTextMap.entrySet()) {
                String keyName = TemplateTextEntry.getValue().getKey();
                keyVector.add(keyName);
                LinkedHashMap<String, ConflictGroupInfo> conflictMap = TemplateTextEntry.getValue().getRelation();
                for (Map.Entry<String, ConflictGroupInfo> conflictEntry : conflictMap.entrySet()) {
                    ConflictGroupInfo conflictGroupInfo = conflictEntry.getValue();
                    if (ConflictCheck.PrivilegeCheck((String)conflictGroupInfo.getType(), (List)conflictGroupInfo.getConditionsList())) continue;
                    keyVector.remove(keyName);
                }
            }
        }
        String PeripheralsName = "";
        for (Map.Entry entry : GlobalVariables.PeripheralConfigObjMap.entrySet()) {
            String keyTemp = (String)entry.getKey();
            PeripheralsName = String.valueOf(PeripheralsName) + "#" + keyTemp + "#";
        }
        this.paramMap.put("Peripherals", PeripheralsName);
        ReflectionFunc reflectionFunc = new ReflectionFunc();
        this.paramMap.put("ReflectionFunc", reflectionFunc);
        this.paramMap.put("MCUSelect_Package", GlobalVariables.McuSeletorInfo.getPackageType());
        int i = 0;
        while (i < keyVector.size()) {
            this.paramMap.put((String)keyVector.get(i), "");
            ++i;
        }
        for (Map.Entry<String, TemplatePeripheralStruct> Entry4 : this.templatePeripheralMap.entrySet()) {
            String periNameTemp;
            valueTemp = Entry4.getValue();
            String periName = valueTemp.getName();
            Vector<String> periNameVector = new Vector<String>();
            if (periName.contains(",")) {
                String[] periNameArr = periName.split(",");
                int i2 = 0;
                while (i2 < periNameArr.length) {
                    periNameTemp = periNameArr[i2];
                    if (periNameTemp.equals("*")) {
                        for (Map.Entry entry : GlobalVariables.PeripheralConfigObjMap.entrySet()) {
                            String keyTemp = (String)entry.getKey();
                            periNameVector.add(keyTemp);
                        }
                    } else {
                        periNameVector.add(periNameTemp);
                    }
                    ++i2;
                }
            } else if (periName.equals("*")) {
                for (Map.Entry Entry2 : GlobalVariables.PeripheralConfigObjMap.entrySet()) {
                    String keyTemp = (String)Entry2.getKey();
                    periNameVector.add(keyTemp);
                }
            } else {
                periNameVector.add(periName);
            }
            String perRelateFrom = valueTemp.getRelateFrom();
            int periNameIndex = 0;
            while (periNameIndex < periNameVector.size()) {
                void var14_27;
                periNameTemp = (String)periNameVector.get(periNameIndex);
                boolean bl = false;
                while (var14_27 < perRelateFrom.length()) {
                    char ch = perRelateFrom.charAt((int)var14_27);
                    if (ch >= '0' && ch <= '9') {
                        int relateFromNum = Integer.valueOf(String.valueOf(perRelateFrom.charAt((int)var14_27)));
                        switch (relateFromNum) {
                            case 0: {
                                GenerateFtlParamMap.getPerConfigInfo((String)periNameTemp, this.paramMap);
                                break;
                            }
                            case 1: {
                                GenerateFtlParamMap.getPerTreeInfo((String)periNameTemp, this.paramMap);
                                break;
                            }
                            case 2: {
                                GenerateFtlParamMap.getClockConfigInfo(this.paramMap);
                                break;
                            }
                        }
                    }
                    ++var14_27;
                }
                ++periNameIndex;
            }
            GenerateFtlParamMap.getPinInfo(this.paramMap);
        }
        for (Map.Entry<String, TemplatePeripheralStruct> Entry5 : this.templatePeripheralMap.entrySet()) {
            valueTemp = Entry5.getValue();
            valueTemp.getName();
            LinkedHashMap<String, TemplateTextStruct> TemplateTextMap = valueTemp.getText();
            for (Map.Entry<String, TemplateTextStruct> TemplateTextEntry : TemplateTextMap.entrySet()) {
                String keyName = TemplateTextEntry.getValue().getKey();
                LinkedHashMap<String, TemplateFunctionStruct> functionMap = TemplateTextEntry.getValue().getFunction();
                for (Map.Entry<Object, Object> entry : functionMap.entrySet()) {
                    String functionName = (String)entry.getKey();
                    if (!functionName.equals("GetPeriphClockType")) continue;
                    String reString = this.getPeriphClockType(entry);
                    this.paramMap.put(keyName, reString);
                }
            }
        }
        try {
            this.generateCode(GdcFilePath);
            if (this.sourceType.equals("2")) {
                this.getTemplateCode(this.generatedFilePath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void generateCode(String GdcFilePath) throws IOException, TemplateException {
        String templateSourcePath = String.valueOf(GeneralPathUtil.ResourcePath) + this.sourcePath;
        String templateTargetPath = String.valueOf(GdcFilePath) + this.targetPath;
        String templateFilePath = String.valueOf(templateSourcePath) + File.separator + this.name;
        Path path = Paths.get(templateFilePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (this.type == 1) {
            String generateName = this.name.contains("_h.ftl") ? this.name.replace("_h.ftl", ".h") : this.name.replace("ftl", "h");
            templateTargetPath = String.valueOf(templateTargetPath) + File.separator + generateName;
            FtlToCode.templateToCode((String)templateSourcePath, (String)templateTargetPath, (String)this.name, this.paramMap);
        } else if (this.type == 2) {
            String generateName = this.name.contains("_c.ftl") ? this.name.replace("_c.ftl", ".c") : this.name.replace("ftl", "c");
            templateTargetPath = String.valueOf(templateTargetPath) + File.separator + generateName;
            FtlToCode.templateToCode((String)templateSourcePath, (String)templateTargetPath, (String)this.name, this.paramMap);
        }
        this.generatedFilePath = templateTargetPath;
    }

    private void getTemplateCode(String filePath) {
        if (filePath == null) {
            return;
        }
        String initCode = "";
        try {
            String initCodeTemp;
            String readLine;
            File f = new File(filePath);
            if (!f.exists()) {
                return;
            }
            String fileName = f.getName();
            if (!fileName.contains("_") || !fileName.contains(".")) {
                return;
            }
            String periName = "";
            if (!fileName.contains("##")) {
                if (!fileName.contains("_")) {
                    f.delete();
                    return;
                }
                String strLeft = fileName.substring(fileName.lastIndexOf("_") + 1, fileName.length());
                periName = strLeft.substring(0, strLeft.lastIndexOf("."));
            } else {
                String[] fileNameArr = fileName.split("##");
                if (fileNameArr.length != 3) {
                    f.delete();
                    return;
                }
                String cfr_ignored_0 = fileNameArr[0];
                String functionNameTemp = fileNameArr[1];
                int index = functionNameTemp.indexOf(95);
                if (index == -1) {
                    f.delete();
                    return;
                }
                String string = functionNameTemp.substring(index + 1);
                String cfr_ignored_1 = fileNameArr[2];
                periName = fileName.substring(0, fileName.lastIndexOf("."));
            }
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            StringBuffer sb = new StringBuffer();
            while ((readLine = br.readLine()) != null) {
                sb.append(readLine);
                sb.append("\t" + System.lineSeparator());
            }
            initCode = sb.toString();
            fr.close();
            br.close();
            if (periName.equals("system")) {
                periName = "General";
            }
            if ((initCodeTemp = initCode).replaceAll("\\s+", "").equals("")) {
                initCode = "";
            }
            this.extractCodeFromFTL(periName, initCode);
            f.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getPeriphClockType(Map.Entry<String, TemplateFunctionStruct> functionEntry) {
        String reString = "";
        TemplateFunctionStruct functionValue = functionEntry.getValue();
        Vector<TemplateParamStruct> ParamVector = functionValue.getParam();
        int i = 0;
        while (i < ParamVector.size()) {
            block6: {
                String Name;
                block8: {
                    String valueTemp;
                    String Content;
                    block7: {
                        TemplateParamStruct templateParamStruct = ParamVector.get(i);
                        Content = templateParamStruct.getContent();
                        Name = templateParamStruct.getName();
                        templateParamStruct.getOper();
                        templateParamStruct.getRelateFrom();
                        if (!this.paramMap.containsKey(Content) || (valueTemp = (String)this.paramMap.get(Content)).equals("")) break block6;
                        if (!Content.equals("USBHS0SEL")) break block7;
                        String USBHS048MSEL_Value = "";
                        if (this.paramMap.containsKey("USBHS048MSEL")) {
                            USBHS048MSEL_Value = (String)this.paramMap.get("USBHS048MSEL");
                        }
                        if (valueTemp.equals("RCU_USBHSx_CKSRC_CK60M") || USBHS048MSEL_Value.equals("RCU_USBHSx48M_CKSRC_USBHSDV")) break block6;
                    }
                    if (!Content.equals("USBHS1SEL")) break block8;
                    String USBHS148MSEL_Value = "";
                    if (this.paramMap.containsKey("USBHS148MSEL")) {
                        USBHS148MSEL_Value = (String)this.paramMap.get("USBHS148MSEL");
                    }
                    if (valueTemp.equals("RCU_USBHSx_CKSRC_CK60M") || USBHS148MSEL_Value.equals("RCU_USBHSx48M_CKSRC_USBHSDV")) break block6;
                }
                reString = reString.equals("") ? "RCU_PERIPH_CLKTYPE_" + Name : String.valueOf(reString) + " | " + "RCU_PERIPH_CLKTYPE_" + Name;
            }
            ++i;
        }
        return reString;
    }

    private void extractCodeFromFTL(String periName, String initCode) {
        HashMap<String, String> initCodeTypeMap = new HashMap<String, String>();
        String pattern = "\\[<(.*?)>]\\s*([<\\s\\S>]*?)(?=\\[<|$)";
        Pattern r = Pattern.compile(pattern, 32);
        Matcher m = r.matcher(initCode);
        while (m.find()) {
            String initCodeType = m.group(1);
            String initCodeStr = m.group(2);
            initCodeTypeMap.put(initCodeType, initCodeStr);
        }
        if (initCodeTypeMap.isEmpty()) {
            initCodeTypeMap.put("InitCode", initCode);
        }
        GlobalVariables.InitCodeFromFTL.put(periName, initCodeTypeMap);
    }
}

