/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.codegenerate.util;

import com.gigadevice.codegenerate.baseinfo.CodeFuncImpleStruct;
import com.gigadevice.codegenerate.baseinfo.CodeGenInfo;
import com.gigadevice.codegenerate.baseinfo.VariablesXMLInfo;
import com.gigadevice.codegenerate.xmlparse.CodeGenerateXMLParse;
import com.gigadevice.venustool.GlobalPathUtil;
import com.gigadevice.venustool.baseinfo.dma.DMAInfoUtil;
import com.gigadevice.venustool.baseinfo.dma.MDMAInfoUtil;
import com.gigadevice.venustool.gpio.GPIOVariables;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SystemVarUtil {
    public static CodeFuncImpleStruct DMAInitFuncImpleStruct = new CodeFuncImpleStruct();
    public static CodeFuncImpleStruct DMADeInitFuncImpleStruct = new CodeFuncImpleStruct();
    public static CodeFuncImpleStruct GPIOInitFuncImpleStruct = new CodeFuncImpleStruct();
    public static CodeFuncImpleStruct GPIODeInitFuncImpleStruct = new CodeFuncImpleStruct();
    public static CodeFuncImpleStruct RCUInitFuncImpleStruct = new CodeFuncImpleStruct();
    public static CodeFuncImpleStruct RCUDeInitFuncImpleStruct = new CodeFuncImpleStruct();
    public static CodeGenInfo DMACodeGenInfoObj = new CodeGenInfo();
    public static VariablesXMLInfo DMAVarXMLInfo = new VariablesXMLInfo();
    public static CodeGenInfo MDMACodeGenInfoObj = new CodeGenInfo();
    public static VariablesXMLInfo MDMAVarXMLInfo = new VariablesXMLInfo();
    public static CodeGenInfo GPIOCodeGenInfoObj = new CodeGenInfo();
    public static VariablesXMLInfo GPIOVarXMLInfo = new VariablesXMLInfo();
    public static CodeGenInfo RCUCodeGenInfoObj = new CodeGenInfo();
    public static VariablesXMLInfo RCUVarXMLInfo = new VariablesXMLInfo();
    public static CodeGenInfo NVICCodeGenInfoObj = new CodeGenInfo();
    public static VariablesXMLInfo NVICVarXMLInfo = new VariablesXMLInfo();
    public static Map<String, String> NVIC_DMAChannelGlobalParaInfo = new HashMap<String, String>();
    public static Map<String, String> GPIOUserLabelMap = new HashMap<String, String>();

    public static void ClearAllGlobalVars() {
        DMACodeGenInfoObj = new CodeGenInfo();
        DMAVarXMLInfo = new VariablesXMLInfo();
        MDMACodeGenInfoObj = new CodeGenInfo();
        MDMAVarXMLInfo = new VariablesXMLInfo();
        GPIOCodeGenInfoObj = new CodeGenInfo();
        GPIOVarXMLInfo = new VariablesXMLInfo();
        RCUCodeGenInfoObj = new CodeGenInfo();
        RCUVarXMLInfo = new VariablesXMLInfo();
        NVICCodeGenInfoObj = new CodeGenInfo();
        NVICVarXMLInfo = new VariablesXMLInfo();
        GPIOVariables.GPIONoCodeSignal.clear();
        GPIOVariables.GPIONoCodePin.clear();
        GPIOVariables.GPIOSharePin.clear();
    }

    public static void InitAllGlobalVars() {
        SystemVarUtil.InitSystemPeriXMLInFO();
    }

    public static void InitSystemPeriXMLInFO() {
        SystemVarUtil.StorePeriCodeXMLInFO("DMA");
        SystemVarUtil.StorePeriCodeXMLInFO("MDMA");
        SystemVarUtil.StorePeriCodeXMLInFO("NVIC");
        SystemVarUtil.StorePeriCodeXMLInFO("RCU");
        SystemVarUtil.StorePeriCodeXMLInFO("GPIO");
        if (GPIOVariables.GPIONoCodeSignal.size() == 0 || GPIOVariables.GPIONoCodePin.size() == 0 || GPIOVariables.GPIOSharePin.size() == 0) {
            GPIOVariables.GetGPIONoCodeInfo();
        }
    }

    public static void StorePeriCodeXMLInFO(String PeriName) {
        GlobalPathUtil.CodeXmlPaths xmlPathsObj = GlobalPathUtil.getCodeXmlPaths((String)PeriName);
        String CodeXMLPath = xmlPathsObj.CodeXmlPath;
        String VariablesXMLPath = xmlPathsObj.CodeVarXmlPath;
        if (PeriName.equals("DMA")) {
            DMACodeGenInfoObj = CodeGenerateXMLParse.CodeGenXMLParse(CodeXMLPath);
            DMAVarXMLInfo = CodeGenerateXMLParse.VariableXMLParse(VariablesXMLPath);
        } else if (PeriName.equals("MDMA")) {
            MDMACodeGenInfoObj = CodeGenerateXMLParse.CodeGenXMLParse(CodeXMLPath);
            MDMAVarXMLInfo = CodeGenerateXMLParse.VariableXMLParse(VariablesXMLPath);
        } else if (PeriName.equals("NVIC")) {
            NVICCodeGenInfoObj = CodeGenerateXMLParse.CodeGenXMLParse(CodeXMLPath);
            NVICVarXMLInfo = CodeGenerateXMLParse.VariableXMLParse(VariablesXMLPath);
        } else if (PeriName.equals("RCU")) {
            RCUCodeGenInfoObj = CodeGenerateXMLParse.CodeGenXMLParse(CodeXMLPath);
            RCUVarXMLInfo = CodeGenerateXMLParse.VariableXMLParse(VariablesXMLPath);
        } else if (PeriName.equals("GPIO")) {
            GPIOCodeGenInfoObj = CodeGenerateXMLParse.CodeGenXMLParse(CodeXMLPath);
            GPIOVarXMLInfo = CodeGenerateXMLParse.VariableXMLParse(VariablesXMLPath);
        }
    }

    public static CodeFuncImpleStruct returnCodeFuncImpleStruct(String PeriName, String FuncName) {
        if (PeriName.equals("DMA")) {
            return SystemVarUtil.getCodeFuncImpleStruct(FuncName, DMACodeGenInfoObj);
        }
        if (PeriName.equals("MDMA")) {
            return SystemVarUtil.getCodeFuncImpleStruct(FuncName, MDMACodeGenInfoObj);
        }
        if (PeriName.equals("NVIC")) {
            return SystemVarUtil.getCodeFuncImpleStruct(FuncName, NVICCodeGenInfoObj);
        }
        if (PeriName.equals("RCU")) {
            return SystemVarUtil.getCodeFuncImpleStruct(FuncName, RCUCodeGenInfoObj);
        }
        if (PeriName.equals("GPIO")) {
            return SystemVarUtil.getCodeFuncImpleStruct(FuncName, GPIOCodeGenInfoObj);
        }
        return null;
    }

    public static boolean NeedReturnInitFunction(String SystemPeriName) {
        if (SystemPeriName.equals("NVIC")) {
            return true;
        }
        if (SystemPeriName.equals("DMA") && DMAInfoUtil.DMAConfigInfo.size() != 0) {
            return true;
        }
        if (SystemPeriName.equals("MDMA") && MDMAInfoUtil.mDMAConfigInfo.size() != 0) {
            return true;
        }
        if (SystemPeriName.equals("RCU")) {
            return true;
        }
        if (SystemPeriName.equals("GPIO")) {
            return true;
        }
        return SystemPeriName.equals("General");
    }

    private static CodeFuncImpleStruct getCodeFuncImpleStruct(String FuncName, CodeGenInfo CodeGenInfoObj) {
        List<CodeFuncImpleStruct> FuncImpleNodeList = CodeGenInfoObj.getFuncImpleNodeList();
        int i = 0;
        while (i < FuncImpleNodeList.size()) {
            CodeFuncImpleStruct FuncImpleStructObj = FuncImpleNodeList.get(i);
            String Name = FuncImpleStructObj.getName();
            if (Name.equals(FuncName)) {
                return FuncImpleStructObj;
            }
            ++i;
        }
        return null;
    }

    public static List<String> getDMAChannelGlobalParaLst(String DMAName, int channlMax, int channelMin) {
        ArrayList<String> strList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : NVIC_DMAChannelGlobalParaInfo.entrySet()) {
            String key = entry.getKey();
            if (!key.contains(DMAName)) continue;
            int i = channelMin;
            while (i <= channlMax) {
                String channelNumber;
                String channel = key.replaceAll(DMAName, "");
                Pattern pattern = Pattern.compile("(\\d+)");
                Matcher matcher = pattern.matcher(channel);
                if (matcher.find() && (channelNumber = matcher.group(0)).equals(String.valueOf(i))) {
                    strList.add(entry.getValue());
                }
                ++i;
            }
        }
        return strList;
    }

    public static <T> T cloneFrom(T src) throws RuntimeException {
        ByteArrayOutputStream memoryBuffer = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        ObjectInputStream in = null;
        Object dist = null;
        try {
            try {
                out = new ObjectOutputStream(memoryBuffer);
                out.writeObject(src);
                out.flush();
                in = new ObjectInputStream(new ByteArrayInputStream(memoryBuffer.toByteArray()));
                dist = in.readObject();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                    out = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                    in = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return (T)dist;
    }
}

