/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.codegenerate.tool;

import com.gigadevice.codegenerate.baseinfo.VarConditionStruct;
import com.gigadevice.codegenerate.baseinfo.VarConditionsStruct;
import com.gigadevice.conflict.ConflictCheck;
import com.gigadevice.periconfigview.utils.GeneralPeriConfigUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.GD32PinPad;
import com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject;
import com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriVariables;
import com.gigadevice.venustool.baseinfo.jtreenode.AbstractJTreeNode;
import com.gigadevice.venustool.gpio.GPIOInfoUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ReflectionFunc {
    public boolean OR(ArrayList<VarConditionsStruct> ConditionsNodeList) {
        int i = 0;
        while (i < ConditionsNodeList.size()) {
            VarConditionsStruct VarConditionsNode = ConditionsNodeList.get(i);
            String ReferPeri = VarConditionsNode.getReferPeri();
            List<VarConditionStruct> ConditionNodeList = VarConditionsNode.getConditionNodeList();
            int j = 0;
            while (j < ConditionNodeList.size()) {
                VarConditionStruct ConditionNodeObj = ConditionNodeList.get(j);
                if (this.CheckCondition(ReferPeri, ConditionNodeObj)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean AND(ArrayList<VarConditionsStruct> ConditionsNodeList) {
        int i = 0;
        while (i < ConditionsNodeList.size()) {
            VarConditionsStruct VarConditionsNode = ConditionsNodeList.get(i);
            String ReferPeri = VarConditionsNode.getReferPeri();
            List<VarConditionStruct> ConditionNodeList = VarConditionsNode.getConditionNodeList();
            int j = 0;
            while (j < ConditionNodeList.size()) {
                VarConditionStruct ConditionNodeObj = ConditionNodeList.get(j);
                if (!this.CheckCondition(ReferPeri, ConditionNodeObj)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean OR_AND(ArrayList<VarConditionsStruct> ConditionsNodeList) {
        boolean sign = false;
        int i = 0;
        while (i < ConditionsNodeList.size()) {
            sign = true;
            VarConditionsStruct VarConditionsNode = ConditionsNodeList.get(i);
            String ReferPeri = VarConditionsNode.getReferPeri();
            List<VarConditionStruct> ConditionNodeList = VarConditionsNode.getConditionNodeList();
            int j = 0;
            while (j < ConditionNodeList.size()) {
                VarConditionStruct ConditionNodeObj = ConditionNodeList.get(j);
                if (!this.CheckCondition(ReferPeri, ConditionNodeObj)) {
                    sign = false;
                    break;
                }
                ++j;
            }
            if (sign) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean AND_OR(ArrayList<VarConditionsStruct> ConditionsNodeList) {
        boolean sign = false;
        int i = 0;
        while (i < ConditionsNodeList.size()) {
            sign = false;
            VarConditionsStruct VarConditionsNode = ConditionsNodeList.get(i);
            String ReferPeri = VarConditionsNode.getReferPeri();
            List<VarConditionStruct> ConditionNodeList = VarConditionsNode.getConditionNodeList();
            int j = 0;
            while (j < ConditionNodeList.size()) {
                VarConditionStruct ConditionNodeObj = ConditionNodeList.get(j);
                if (this.CheckCondition(ReferPeri, ConditionNodeObj)) {
                    sign = true;
                    break;
                }
                ++j;
            }
            if (!sign) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean CheckCondition(String PeriName, VarConditionStruct ConditionNodeObj) {
        Method method;
        Object[] args;
        Class<?> demoClass;
        block18: {
            Class[] paraTypes;
            String Oper;
            block17: {
                String PeriNodeName;
                String Type2 = ConditionNodeObj.getType();
                demoClass = null;
                Oper = "";
                if (Type2.equals("0") || Type2.equals("3")) {
                    Oper = ConditionNodeObj.getNodeAttributesInfo("Oper");
                    try {
                        demoClass = Class.forName("com.gigadevice.codegenerate.tool.ReflectionFunc");
                    }
                    catch (ClassNotFoundException e1) {
                        e1.printStackTrace();
                    }
                } else if (Type2.equals("1") || Type2.equals("2") || Type2.equals("4")) {
                    Oper = "ConditionExamine";
                    try {
                        demoClass = Class.forName("com.gigadevice.codegenerate.tool.ConditionExaminefromClockTree");
                    }
                    catch (ClassNotFoundException e1) {
                        e1.printStackTrace();
                    }
                }
                if (!(PeriNodeName = ConditionNodeObj.getNodeAttributesInfo("PeriName")).equals("") && !PeriName.equals(PeriNodeName)) {
                    PeriName = PeriNodeName;
                }
                args = new Object[]{PeriName, ConditionNodeObj};
                paraTypes = new Class[args.length];
                int i = 0;
                while (i < args.length) {
                    paraTypes[i] = args[i].getClass();
                    ++i;
                }
                method = null;
                if (demoClass != null) break block17;
                return false;
            }
            try {
                method = demoClass.getMethod(Oper, paraTypes);
                if (method == null) {
                    System.out.println(Oper);
                    return false;
                }
            }
            catch (NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
            if (method != null) break block18;
            return false;
        }
        try {
            Object tmp = method.invoke(demoClass.newInstance(), args);
            boolean result = false;
            if (tmp != null) {
                result = Boolean.parseBoolean(tmp.toString());
            }
            return result;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean Contain(String PeriName, VarConditionStruct ConditionNodeObj) {
        String ParentNode = ConditionNodeObj.getNodeAttributesInfo("ParentNode");
        String Node2 = ConditionNodeObj.getNodeAttributesInfo("Node");
        String NodeItem = ConditionNodeObj.getNodeAttributesInfo("NodeItem");
        String strRelateFrom = ConditionNodeObj.getNodeAttributesInfo("RelateFrom");
        String strType = ConditionNodeObj.getType();
        if (strType.equals("3")) {
            String strTargetString = ConditionNodeObj.getNodeAttributesInfo("Value");
            String strPara = ConditionNodeObj.getNodeAttributesInfo("Para");
            return strPara.toUpperCase().contains(strTargetString.toUpperCase());
        }
        boolean result = ConflictCheck.Contain((String)PeriName, (String)ParentNode, (String)Node2, (String)NodeItem, (String)strRelateFrom, null);
        return result;
    }

    public boolean NotContain(String PeriName, VarConditionStruct ConditionNodeObj) {
        String ParentNode = ConditionNodeObj.getNodeAttributesInfo("ParentNode");
        String Node2 = ConditionNodeObj.getNodeAttributesInfo("Node");
        String NodeItem = ConditionNodeObj.getNodeAttributesInfo("NodeItem");
        String strRelateFrom = ConditionNodeObj.getNodeAttributesInfo("RelateFrom");
        String strType = ConditionNodeObj.getType();
        if (strType.equals("3")) {
            String strTargetString = ConditionNodeObj.getNodeAttributesInfo("Value");
            String strPara = ConditionNodeObj.getNodeAttributesInfo("Para");
            return !strTargetString.toUpperCase().contains(strPara.toUpperCase());
        }
        boolean result = !ConflictCheck.Contain((String)PeriName, (String)ParentNode, (String)Node2, (String)NodeItem, (String)strRelateFrom, null);
        return result;
    }

    public boolean Equal(String PeriName, VarConditionStruct ConditionNodeObj) {
        String ParentNode = ConditionNodeObj.getNodeAttributesInfo("ParentNode");
        String Node2 = ConditionNodeObj.getNodeAttributesInfo("Node");
        String NodeItem = ConditionNodeObj.getNodeAttributesInfo("NodeItem");
        String strRelateFrom = ConditionNodeObj.getNodeAttributesInfo("RelateFrom");
        String strType = ConditionNodeObj.getType();
        if (strType.equals("3")) {
            String strTargetString = ConditionNodeObj.getNodeAttributesInfo("Value");
            String strPara = ConditionNodeObj.getNodeAttributesInfo("Para");
            return strTargetString.toUpperCase().equals(strPara.toUpperCase());
        }
        boolean result = ConflictCheck.Equal((String)PeriName, (String)ParentNode, (String)Node2, (String)NodeItem, (String)strRelateFrom, null);
        return result;
    }

    public boolean NotEqual(String PeriName, VarConditionStruct ConditionNodeObj) {
        String ParentNode = ConditionNodeObj.getNodeAttributesInfo("ParentNode");
        String Node2 = ConditionNodeObj.getNodeAttributesInfo("Node");
        String NodeItem = ConditionNodeObj.getNodeAttributesInfo("NodeItem");
        String strRelateFrom = ConditionNodeObj.getNodeAttributesInfo("RelateFrom");
        String strType = ConditionNodeObj.getType();
        if (strType.equals("3")) {
            String strTargetString = ConditionNodeObj.getNodeAttributesInfo("Value");
            String strPara = ConditionNodeObj.getNodeAttributesInfo("Para");
            return !strTargetString.toUpperCase().equals(strPara.toUpperCase());
        }
        boolean result = !ConflictCheck.Equal((String)PeriName, (String)ParentNode, (String)Node2, (String)NodeItem, (String)strRelateFrom, null);
        return result;
    }

    public boolean Include(String PeriName, VarConditionStruct ConditionNodeObj) {
        boolean ret = false;
        String ParentNode = ConditionNodeObj.getNodeAttributesInfo("ParentNode");
        String strRelateFrom = ConditionNodeObj.getNodeAttributesInfo("RelateFrom");
        if (!strRelateFrom.equals("0") && strRelateFrom.equals("1") && GlobalVariables.PeripheralConfigObjMap.containsKey(ParentNode)) {
            ret = true;
        }
        return ret;
    }

    public String CheckCRCPolynomialInput(String str) {
        String strRet = "true";
        String[] strSrc = new String[]{"X0", "X1", "X2", "X3", "X4", "X5", "X6", "X7", "X8", "X9", "X10", "X11", "X12", "X13", "X14", "X15"};
        String[] strArray = str.split("\\+");
        int i = 0;
        while (i < strArray.length) {
            String strItem = strArray[i];
            if (!Arrays.asList(strSrc).contains(strItem)) {
                strRet = "false";
                break;
            }
            ++i;
        }
        return strRet;
    }

    public String GetCRCPolynomialCode(String str) {
        String strRet = "";
        int Sum = 0;
        List<Integer> lstIndex = this.SearchAllIndex(str, "X");
        List<Integer> lstNum = this.GetAllNum(str, lstIndex);
        int i = 0;
        while (i < lstNum.size()) {
            double a = 2.0;
            int b = lstNum.get(i);
            Sum = (int)((double)Sum + Math.pow(a, b));
            ++i;
        }
        strRet = Integer.toString(Sum);
        return strRet;
    }

    public String Multiply(String a, String b) {
        if (a.equals("") || b.equals("")) {
            return null;
        }
        String result = "";
        try {
            int aa = Integer.parseInt(a);
            int bb = Integer.parseInt(b);
            result = String.valueOf(aa * bb);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String Multiply(String a, String b, String isHex) {
        if (a.equals("") || b.equals("")) {
            return null;
        }
        String result = "";
        if (isHex.equals("true")) {
            int aa = 0;
            try {
                if (a.contains("0x") || a.contains("0X")) {
                    a = a.substring(2);
                }
                aa = Integer.parseInt(a, 16);
                int bb = Integer.parseInt(b);
                result = "0x" + Integer.toHexString(aa * bb).toUpperCase();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        } else {
            return this.Multiply(a, b);
        }
        return result;
    }

    private List<Integer> SearchAllIndex(String str, String key) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        int index = str.indexOf(key);
        while (index != -1) {
            lst.add(index);
            index = str.indexOf(key, index + 1);
        }
        return lst;
    }

    private List<Integer> GetAllNum(String str, List<Integer> allIndex) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        int i = 0;
        while (i < allIndex.size()) {
            int Pos2;
            int tempPos = Pos2 = allIndex.get(i) + 1;
            int len = 0;
            String strNum = "";
            while (tempPos <= str.length() - 1) {
                char c = str.charAt(tempPos);
                if (c < '0' || c > '9') break;
                ++len;
                ++tempPos;
            }
            strNum = str.substring(Pos2, Pos2 + len);
            lst.add((int)Integer.valueOf(strNum));
            ++i;
        }
        return lst;
    }

    public String GetBaudRate(String strPBxClock, String strPrescaler) {
        String strRet = "";
        if (strPBxClock.equals("") || strPrescaler.equals("")) {
            return strRet;
        }
        strPBxClock = strPBxClock.replaceAll("MHz", "");
        double douClock = Double.parseDouble(strPBxClock);
        double douPrescaler = Double.parseDouble(strPrescaler);
        double BaudRate = douClock / douPrescaler;
        strRet = String.format("%6f", BaudRate);
        strRet = String.valueOf(strRet) + " MBits/s";
        return strRet;
    }

    public String GetTimeQuantum(String strPCLK1, String strPrescaler) {
        String strRet = "";
        if (strPCLK1.equals("") || strPrescaler.equals("")) {
            return strRet;
        }
        double PCLK1 = Double.parseDouble(strPCLK1) * 1000000.0;
        double Prescaler = Double.parseDouble(strPrescaler) * 1.0E9;
        double TimeQuantum = Prescaler / PCLK1;
        strRet = String.format("%.1f", TimeQuantum);
        strRet = String.valueOf(strRet) + " ns";
        return strRet;
    }

    public String GetTimeForOneBit(String strPCLK1, String strPrescaler, String strBTS1, String strBTS2) {
        String strRet = "";
        if (strPCLK1.equals("") || strPrescaler.equals("") || strBTS1.equals("") || strBTS2.equals("")) {
            return strRet;
        }
        double PCLK1 = Double.parseDouble(strPCLK1) * 1000000.0;
        double Prescaler = Double.parseDouble(strPrescaler) * 1.0E9;
        double BTS1 = Double.parseDouble(strBTS1.split(" ")[0]);
        double BTS2 = Double.parseDouble(strBTS2.split(" ")[0]);
        double TimeForOneBit = Prescaler / PCLK1 + BTS1 * Prescaler / PCLK1 + BTS2 * Prescaler / PCLK1;
        strRet = String.format("%.2f", TimeForOneBit);
        strRet = String.valueOf(strRet) + " ns";
        return strRet;
    }

    public String GetCanBaudRate(String strPCLK1, String strPrescaler, String strBTS1, String strBTS2) {
        String strRet = "";
        if (strPCLK1.equals("") || strPrescaler.equals("") || strBTS1.equals("") || strBTS2.equals("")) {
            return strRet;
        }
        double PCLK1 = Double.parseDouble(strPCLK1) * 1000000.0;
        double Prescaler = Double.parseDouble(strPrescaler) * 1.0E9;
        double BTS1 = Double.parseDouble(strBTS1.split(" ")[0]);
        double BTS2 = Double.parseDouble(strBTS2.split(" ")[0]);
        double TimeForOneBit = Prescaler / PCLK1 + BTS1 * Prescaler / PCLK1 + BTS2 * Prescaler / PCLK1;
        double CanBaudRate = 1.0 / TimeForOneBit * 1.0E9;
        strRet = String.format("%.0f", Math.floor(CanBaudRate));
        strRet = String.valueOf(strRet) + " bit/s";
        return strRet;
    }

    public String StringJudge(String strDefaultValue, String strInput) {
        String strRet = "";
        if ((strInput = strInput.replaceAll("+", "")).contains("X")) {
            String[] strArray = strInput.split("X");
            int i = 0;
            while (i < strArray.length) {
                String strItem = strArray[i];
                int Num = 0;
                try {
                    Num = Integer.parseInt(strItem);
                }
                catch (Exception exception) {
                    strRet = strDefaultValue;
                    break;
                }
                if (Num > 15 || Num < 0) {
                    strRet = strDefaultValue;
                    break;
                }
                ++i;
            }
        } else {
            strRet = strDefaultValue;
        }
        return strRet;
    }

    public boolean GetConditionsAND(String ... conditions) {
        String[] stringArray = conditions;
        int n = conditions.length;
        int n2 = 0;
        while (n2 < n) {
            String condition = stringArray[n2];
            if (!Boolean.parseBoolean(condition)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean GetConditionsAND(String strbl1, String strbl2) {
        return Boolean.parseBoolean(strbl1) && Boolean.parseBoolean(strbl2);
    }

    public boolean GetConditionsAND(String strbl1, String strbl2, String strbl3) {
        return Boolean.parseBoolean(strbl1) && Boolean.parseBoolean(strbl2) && Boolean.parseBoolean(strbl3);
    }

    public boolean GetConditionsAND(String strbl1, String strbl2, String strbl3, String strbl4) {
        return Boolean.parseBoolean(strbl1) && Boolean.parseBoolean(strbl2) && Boolean.parseBoolean(strbl3) && Boolean.parseBoolean(strbl4);
    }

    public boolean GetConditionsOR(String strbl1, String strbl2) {
        return Boolean.parseBoolean(strbl1) || Boolean.parseBoolean(strbl2);
    }

    public boolean GetConditionsOR(String strbl1, String strbl2, String strbl3) {
        return Boolean.parseBoolean(strbl1) || Boolean.parseBoolean(strbl2) || Boolean.parseBoolean(strbl3);
    }

    public boolean GetConditionsOR(String strbl1, String strbl2, String strbl3, String strbl4) {
        return Boolean.parseBoolean(strbl1) || Boolean.parseBoolean(strbl2) || Boolean.parseBoolean(strbl3) || Boolean.parseBoolean(strbl4);
    }

    public boolean GetConditionOpposite(String strbl) {
        return !Boolean.parseBoolean(strbl);
    }

    public String GetAlarmMaskValue(String Alarm0DateMask, String Alarm0HoursMask, String Alarm0MinutesMask, String Alarm0SecondsMask) {
        String value = "";
        if (Alarm0DateMask.equals("Enable") && Alarm0HoursMask.equals("Enable") && Alarm0MinutesMask.equals("Enable") && Alarm0SecondsMask.equals("Enable")) {
            value = "HAL_RTC_ALARM_ALL_MASK";
        } else if (Alarm0DateMask.equals("Disable") && Alarm0HoursMask.equals("Disable") && Alarm0MinutesMask.equals("Disable") && Alarm0SecondsMask.equals("Disable")) {
            value = "HAL_RTC_ALARM_NONE_MASK";
        } else {
            if (Alarm0DateMask.equals("Enable")) {
                value = String.valueOf(value) + "HAL_RTC_ALARM_DATE_MASK | ";
            }
            if (Alarm0HoursMask.equals("Enable")) {
                value = String.valueOf(value) + "HAL_RTC_ALARM_HOUR_MASK | ";
            }
            if (Alarm0MinutesMask.equals("Enable")) {
                value = String.valueOf(value) + "HAL_RTC_ALARM_MINUTE_MASK | ";
            }
            if (Alarm0SecondsMask.equals("Enable")) {
                value = String.valueOf(value) + "HAL_RTC_ALARM_SECOND_MASK | ";
            }
        }
        int i = value.length() - 1;
        while (i >= 0) {
            char v = value.charAt(i);
            if (v >= 'a' && v <= 'z' || v >= 'A' && v <= 'Z') {
                value = value.substring(0, i + 1);
                break;
            }
            --i;
        }
        return value;
    }

    public String TimeRegulate(String strY, String strM, String strD, String strHH, String strMM, String strSS) {
        String value = "";
        int month = 0;
        List<String> monthlist = Arrays.asList("HAL_RTC_JAN", "HAL_RTC_FEB", "HAL_RTC_MAR", "HAL_RTC_APR", "HAL_RTC_MAY", "HAL_RTC_JUN", "HAL_RTC_JUL", "HAL_RTC_AUG", "HAL_RTC_SEP", "HAL_RTC_OCT", "HAL_RTC_NOV", "HAL_RTC_DEC");
        int i = 0;
        while (i < monthlist.size()) {
            if (monthlist.get(i).compareTo(strM) == 0) {
                month = i;
                break;
            }
            ++i;
        }
        int year = Integer.parseInt(strY);
        int date = Integer.parseInt(strD);
        int hour = Integer.parseInt(strHH);
        int minute = Integer.parseInt(strMM);
        int second = Integer.parseInt(strSS);
        long unix_TimeStamp = 0L;
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[12];
        nArray2[1] = 31;
        nArray2[2] = 60;
        nArray2[3] = 91;
        nArray2[4] = 121;
        nArray2[5] = 152;
        nArray2[6] = 182;
        nArray2[7] = 213;
        nArray2[8] = 244;
        nArray2[9] = 274;
        nArray2[10] = 305;
        nArray2[11] = 335;
        nArrayArray[1] = nArray2;
        int[][] Day_Count = nArrayArray;
        if (month > 0) {
            unix_TimeStamp = 10957 + year * 365 + (year + 3) / 4;
            unix_TimeStamp += (long)Day_Count[0][month - 1];
            if (year % 4 == 0 && month > 2) {
                ++unix_TimeStamp;
            }
            unix_TimeStamp = (unix_TimeStamp + (long)(date - 1)) * 24L;
            unix_TimeStamp = (unix_TimeStamp + (long)hour - 8L) * 3600L + (long)(minute * 60) + (long)second;
        } else {
            unix_TimeStamp = 1514779200L;
        }
        value = String.valueOf(unix_TimeStamp);
        return value;
    }

    public String GetValueLengthDependParameter(String peri, String hexParaParentPath, String hexParaName, String asciiParaParentPath, String asciiParaName, String typeParameterParentPath, String typeParameterName) {
        String length = "";
        if (GeneralPeriVariables.GeneralPeriParaObjectList.containsKey(peri)) {
            AbstractJTreeNode rootNode = ((GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)peri)).PeriParaTreeApply;
            String valueType = GeneralPeriConfigUtil.GetVarMacrofromPeriConfig((String)typeParameterParentPath, (String)typeParameterName, (AbstractJTreeNode)rootNode, (boolean)true);
            if (valueType.equals("ASCII")) {
                length = this.GetValueLength(peri, asciiParaParentPath, asciiParaName, valueType);
            } else if (valueType.equals("HEX")) {
                length = this.GetValueLength(peri, hexParaParentPath, hexParaName, valueType);
            }
        }
        return length;
    }

    public String GetValueLength(String peri, String parameterParentPath, String parameterName, String type) {
        String length = "";
        if (GeneralPeriVariables.GeneralPeriParaObjectList.containsKey(peri)) {
            AbstractJTreeNode rootNode = ((GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)peri)).PeriParaTreeApply;
            String value = GeneralPeriConfigUtil.GetVarMacrofromPeriConfig((String)parameterParentPath, (String)parameterName, (AbstractJTreeNode)rootNode, (boolean)true);
            if (type.equals("ASCII")) {
                length = Integer.toString(value.length());
            } else if (type.equals("HEX")) {
                value.replaceAll(" ", "");
                String regex16 = "[A-Fa-f0-9]+$";
                value = value.substring(2);
                if (value.matches(regex16)) {
                    int len = value.length();
                    if (value.length() % 2 != 0) {
                        ++len;
                    }
                    length = Integer.toString(len / 2);
                }
            }
        }
        return length;
    }

    public String GetValueArrayDependParameter(String peri, String hexParaParentPath, String hexParaName, String asciiParaParentPath, String asciiParaName, String typeParameterParentPath, String typeParameterName) {
        String valueArray = "";
        if (GeneralPeriVariables.GeneralPeriParaObjectList.containsKey(peri)) {
            AbstractJTreeNode rootNode = ((GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)peri)).PeriParaTreeApply;
            String valueType = GeneralPeriConfigUtil.GetVarMacrofromPeriConfig((String)typeParameterParentPath, (String)typeParameterName, (AbstractJTreeNode)rootNode, (boolean)true);
            if (valueType.equals("ASCII")) {
                valueArray = this.GetValueArray(peri, asciiParaParentPath, asciiParaName, valueType);
            } else if (valueType.equals("HEX")) {
                valueArray = this.GetValueArray(peri, hexParaParentPath, hexParaName, valueType);
            }
        }
        return valueArray;
    }

    public String GetValueArray(String peri, String parameterParentPath, String parameterName, String type) {
        String valueArray = "";
        if (GeneralPeriVariables.GeneralPeriParaObjectList.containsKey(peri)) {
            AbstractJTreeNode rootNode = ((GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)peri)).PeriParaTreeApply;
            String value = GeneralPeriConfigUtil.GetVarMacrofromPeriConfig((String)parameterParentPath, (String)parameterName, (AbstractJTreeNode)rootNode, (boolean)true);
            if (type.equals("ASCII")) {
                value = this.ASCIItoHEX(value);
            }
            value.replaceAll(" ", "");
            String regex16 = "[A-Fa-f0-9]+$";
            value = value.substring(2);
            if (value.matches(regex16)) {
                int len = value.length();
                if (value.length() % 2 != 0) {
                    ++len;
                    StringBuffer temp = new StringBuffer();
                    temp.append("0").append(value);
                    value = temp.toString();
                }
                int pos = 0;
                int i = 0;
                while (i < len / 2) {
                    valueArray = i == len / 2 - 1 ? String.valueOf(valueArray) + "0x" + value.substring(pos, pos + 2) : String.valueOf(valueArray) + "0x" + value.substring(pos, pos + 2) + ",";
                    pos += 2;
                    ++i;
                }
                StringBuffer temp = new StringBuffer();
                temp.append("{").append(valueArray).append("}");
                valueArray = temp.toString();
            }
        }
        return valueArray;
    }

    public String ASCIItoHEX(String ascii) {
        String ret = "";
        String value = ascii;
        StringBuilder hex = new StringBuilder();
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            hex.append(String.format("%02X", ch));
            String hexStr = hex.toString();
            ret = "0x" + hexStr;
            ++n2;
        }
        return ret;
    }

    public String HEXtoASCII(String hex) {
        String ret = "";
        String value = hex.substring(2);
        int len = value.length();
        if (value.length() % 2 != 0) {
            ++len;
            StringBuffer temp = new StringBuffer();
            temp.append("0").append(value);
            value = temp.toString();
        }
        StringBuilder ascii = new StringBuilder();
        int i = 0;
        while (i < len) {
            String hexByte = value.substring(i, i + 2);
            int decimal = Integer.parseInt(hexByte, 16);
            ascii.append((char)decimal);
            i += 2;
        }
        ret = ascii.toString();
        return ret;
    }

    public String GetI2C_BUSTOB(String BusTimeoutB, String CK_I2C) {
        String ret = "";
        try {
            double m_BusTimeoutB = Double.parseDouble(BusTimeoutB);
            double m_CK_I2C = Double.parseDouble(CK_I2C);
            double ti2c = 1.0 / (m_CK_I2C * Math.pow(10.0, 6.0));
            double InitResult = m_BusTimeoutB * Math.pow(10.0, -9.0) / 2048.0 / ti2c - 1.0;
            double result = Math.ceil(InitResult);
            if (result < 0.0) {
                result = 0.0;
            }
            int m_result = (int)result;
            StringBuilder bustobHexToUpper = new StringBuilder();
            char[] cArray = Integer.toHexString(m_result).toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                bustobHexToUpper.append(Character.toUpperCase(c));
                ++n2;
            }
            ret = "0x" + bustobHexToUpper;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public String floatStr2Hex_1_2_8(String floatString) {
        String ret = "";
        if (floatString == null || floatString.isEmpty()) {
            return ret;
        }
        try {
            float number = Float.parseFloat(floatString);
            number = this.roundToThreeDecimals(number * 256.0f);
            int tmp = (int)(number < 0.0f ? number + 2048.0f : number);
            ret = String.format("0x%03X", tmp);
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ret;
        }
    }

    public String floatStr2Hex_1_8_0(String inputString) {
        String ret = "";
        if (inputString == null || inputString.isEmpty()) {
            return ret;
        }
        try {
            int number = Integer.parseInt(inputString);
            int signBit = number < 0 ? 1 : 0;
            int Val = Math.abs(number) & 0xFF;
            if (signBit == 1) {
                Val = ~Val + 1 & 0xFF;
            }
            int result = signBit << 8 | Val;
            ret = String.format("0x%03X", result);
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ret;
        }
    }

    public String GetI2CBitsTiming(String timing, String start, String end) {
        int endInt;
        int startInt;
        long timingLong;
        if (timing == null || start == null || end == null || !timing.startsWith("0x")) {
            throw new IllegalArgumentException("Invalid timing format");
        }
        String hexValue = timing.substring(2);
        try {
            timingLong = Long.parseLong(hexValue, 16);
            startInt = Integer.parseInt(start);
            endInt = Integer.parseInt(end);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("\u6748\u64b3\u53c6\u9428\u52eb\u5f2c\u93c1\u677f\u7e40\u6924\u7ed8\u69f8\u93c8\u590b\u6665\u9428\u52ec\u66a3\u93c1\u7248\u7278\u5bee\u5fcb\ufffd\ufffd", e);
        }
        if (startInt < 0 || endInt > 31 || startInt > endInt) {
            throw new IllegalArgumentException("\u5bee\ufffd\u6fee\u5b29\u7d85\u935c\u5c80\u7ca8\u93c9\u71b6\u7d85\u8e47\u5474\u300f\u9366\u25570, 31]\u6d94\u5b2e\u68ff\u951b\u5c7d\u82df\u6d93\u65bf\u7d11\u6fee\u5b29\u7d85\u6d93\u5d88\u5158\u6fb6\u0442\u7c2c\u7f01\u64b4\u6f6b\u6d63\u5d83\ufffd\ufffd");
        }
        long mask = (1 << endInt - startInt + 1) - 1;
        long extractedValue = timingLong >> startInt & mask;
        String Timing_Reg_Str = "0x" + String.format("%02X", extractedValue).toUpperCase();
        return Timing_Reg_Str;
    }

    private float roundToThreeDecimals(float value) {
        return (float)Math.round(value * 1000.0f) / 1000.0f;
    }

    public boolean CheckGPIOxIsContainPin(String Str1, String Str2) {
        for (String key : GPIOInfoUtil.GPIOConfigInfoMap.keySet()) {
            Map GPIOTableDataMap = (Map)GPIOInfoUtil.GPIOConfigInfoMap.get(key);
            for (String PinName : GPIOTableDataMap.keySet()) {
                GD32PinPad GD32PinPadObj;
                String strPort;
                String strPinPort;
                if (PinName.charAt(0) != 'P' || !(strPinPort = "GPIO" + (strPort = PinName.substring(1, 2))).toUpperCase().equals(Str1.toUpperCase()) && !Str1.equals("GPIO") || (GD32PinPadObj = GlobalVariables.GetPinInfoByPinName((String)PinName)) == null || !GD32PinPadObj.getPinUsedFunctionStr().contains(Str2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean CheckGPIOxIsContainMode(String gpiox, String ConfigObj, String TargetVal) {
        for (String key : GPIOInfoUtil.GPIOConfigInfoMap.keySet()) {
            Map GPIOTableDataMap = (Map)GPIOInfoUtil.GPIOConfigInfoMap.get(key);
            for (String PinName : GPIOTableDataMap.keySet()) {
                Vector vData;
                String strConfigObj;
                int index;
                String strPort;
                String strPinPort;
                if (PinName.charAt(0) != 'P' || !(strPinPort = "GPIO" + (strPort = PinName.substring(1, 2))).toUpperCase().equals(gpiox.toUpperCase()) && !gpiox.equals("GPIO") || (index = GPIOInfoUtil.getConfigColIndex((String)ConfigObj)) < 0 || !(strConfigObj = (String)(vData = (Vector)GPIOTableDataMap.get(PinName)).get(index)).toUpperCase().contains(TargetVal.toUpperCase())) continue;
                return true;
            }
        }
        return false;
    }
}

