/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.mwcodegenerate.tools;

import com.gigadevice.logging.ide.LogManager;
import com.gigadevice.venustool.ConstantsUtil;
import com.gigadevice.venustool.code.FileUserCodeUpdate;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class FtlToCode {
    private static final String USER_CODE_FLAG = "/* user code";

    public static void templateToCode(String templatePath, String generatePath, String templateName, Map<String, Object> paramMap) throws IOException, TemplateException {
        try {
            FtlToCode.nullParamValueCheck(paramMap);
            Configuration configuration = new Configuration(Configuration.VERSION_2_3_32);
            configuration.setDirectoryForTemplateLoading(new File(templatePath));
            configuration.setDefaultEncoding("utf-8");
            Template template = configuration.getTemplate(templateName);
            StringWriter stringWriter = new StringWriter();
            template.process(paramMap, (Writer)stringWriter);
            String generatedCode = stringWriter.toString();
            StringBuilder processedCode = FtlToCode.getCheckedCode(generatedCode);
            boolean fileIsExitFlag = false;
            File file = new File(generatePath);
            if (file.exists()) {
                fileIsExitFlag = true;
            }
            String writeUserCode = processedCode.toString();
            if (fileIsExitFlag) {
                String fileExtension = FtlToCode.getFileExtension(generatePath);
                int fileType = -1;
                if (fileExtension.toUpperCase().equals("C")) {
                    fileType = ConstantsUtil.FileTypeEnum.isCFile.ordinal();
                } else if (fileExtension.toUpperCase().equals("H")) {
                    fileType = ConstantsUtil.FileTypeEnum.isHeadFile.ordinal();
                }
                if (fileType != -1) {
                    FileUserCodeUpdate fileUserCodeUpdate = new FileUserCodeUpdate(generatePath, processedCode.toString(), fileType, false);
                    writeUserCode = fileUserCodeUpdate.GetCode();
                }
            }
            FileWriter out = new FileWriter(new File(generatePath));
            out.write(writeUserCode);
            ((Writer)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            LogManager.getInstance().error("FTL", e.getMessage());
        }
    }

    public static StringBuilder getCheckedCode(String generatedCode) {
        String[] lines = generatedCode.split("\r?\n");
        StringBuilder processedCode = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.matches(".*=\\s*;.*")) {
                processedCode.append("/* The code: ");
                processedCode.append("\"");
                processedCode.append(line.trim());
                processedCode.append("\"");
                processedCode.append(" was not generated correctly because the IDE was not configured correctly! */");
                processedCode.append(System.lineSeparator());
            } else {
                processedCode.append(line).append(System.lineSeparator());
            }
            ++n2;
        }
        return processedCode;
    }

    public static String getFileExtension(String filePath) {
        int dotIndex;
        if (filePath == null || filePath.isEmpty()) {
            return "";
        }
        String fileName = filePath;
        int lastSeparatorIndex = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
        if (lastSeparatorIndex > -1) {
            fileName = filePath.substring(lastSeparatorIndex + 1);
        }
        if ((dotIndex = fileName.lastIndexOf(46)) == -1 || dotIndex == fileName.length() - 1) {
            return "";
        }
        return fileName.substring(dotIndex + 1);
    }

    public static void nullParamValueCheck(Map<String, Object> paramMap) {
        if (paramMap == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            if (entry.getValue() != null) continue;
            entry.setValue("");
        }
    }
}

