/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.mwcodegenerate.baseinfo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Map;
import java.util.Vector;

public class MwGenearteTools {
    public static boolean copyDir(String GdcFilePath, String sourceDirPath, String targetDirPath) {
        File[] files;
        File sourceDir = new File(sourceDirPath);
        if (!sourceDir.exists() || !sourceDir.isDirectory()) {
            return false;
        }
        File targetDir = new File(targetDirPath);
        if (!targetDir.exists()) {
            new File(targetDirPath).mkdirs();
        }
        if ((files = sourceDir.listFiles()) == null) {
            return false;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                File f = fileArray[n2];
                if (f.isFile()) {
                    try {
                        if (!MwGenearteTools.copyFile(GdcFilePath, f, new File(targetDir, f.getName()))) {
                            return false;
                        }
                        break block9;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                if (f.isDirectory() && !MwGenearteTools.copyDir(GdcFilePath, String.valueOf(sourceDirPath) + File.separator + f.getName(), String.valueOf(targetDirPath) + File.separator + f.getName())) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public static boolean copyFile(String GdcFilePath, File sourceFilePath, File targetFilePath) throws IOException {
        FileChannel inputChannel = null;
        AbstractInterruptibleChannel outputChannel = null;
        try {
            inputChannel = new FileInputStream(sourceFilePath).getChannel();
            outputChannel = new FileOutputStream(targetFilePath).getChannel();
            ((FileChannel)outputChannel).transferFrom(inputChannel, 0L, inputChannel.size());
        }
        finally {
            if (inputChannel == null) {
                return false;
            }
            if (outputChannel == null) {
                return false;
            }
            inputChannel.close();
            outputChannel.close();
        }
        return true;
    }

    public static void copySpecialFile(String GdcFilePath, File sourceFilePath, String targetFilePath, String suffix) throws IOException {
        File[] files = sourceFilePath.listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String[] fileNameList;
            File f = fileArray[n2];
            if (f.isFile() && (fileNameList = f.getName().split("\\."))[fileNameList.length - 1].equals(suffix)) {
                try {
                    MwGenearteTools.copyFile(GdcFilePath, f, new File(targetFilePath, f.getName()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public static boolean delAllFiles(String dirPath) {
        File dirFile = new File(dirPath);
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        if (files == null) {
            return false;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile()) {
                if (!MwGenearteTools.delFile(f.getAbsolutePath())) {
                    flag = false;
                    break;
                }
            } else if (f.isDirectory() && !MwGenearteTools.delAllFiles(f.getAbsolutePath())) {
                flag = false;
                break;
            }
            ++n2;
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public static boolean delFile(String filePath) {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            return file.delete();
        }
        return false;
    }

    public static void copyNecessaryDir(String GdcFilePath, String rootFilePath, String sourceDirPath, String targetDirPath, Map<String, Vector<String>> copyMap) throws IOException {
        String targetDirPathTemp;
        String[] folderPathList;
        File sourceDir = new File(sourceDirPath);
        if (!sourceDir.exists() || !sourceDir.isDirectory()) {
            return;
        }
        File targetDir = new File(targetDirPath);
        if (!targetDir.exists()) {
            new File(targetDirPath).mkdirs();
        }
        if (copyMap.containsKey("1")) {
            for (String folderPath : copyMap.get("1")) {
                folderPathList = folderPath.split("#");
                String sourceDirPathTemp = String.valueOf(rootFilePath) + folderPathList[0] + File.separator + folderPathList[1];
                targetDirPathTemp = String.valueOf(GdcFilePath) + File.separator + "MiddleWares" + folderPathList[0] + File.separator + folderPathList[1];
                MwGenearteTools.copyDir(GdcFilePath, sourceDirPathTemp, targetDirPathTemp);
            }
        }
        if (copyMap.containsKey("2")) {
            for (String fileName : copyMap.get("2")) {
                folderPathList = fileName.split("#");
                String fileNameTemp = folderPathList[1];
                targetDirPathTemp = String.valueOf(GdcFilePath) + File.separator + "MiddleWares" + folderPathList[0];
                File f = new File(String.valueOf(rootFilePath) + folderPathList[0] + File.separator + folderPathList[1]);
                File targetDirPathTempDir = new File(targetDirPathTemp);
                if (!targetDirPathTempDir.exists()) {
                    new File(targetDirPathTemp).mkdirs();
                }
                MwGenearteTools.copyFile(GdcFilePath, f, new File(targetDirPathTemp, fileNameTemp));
            }
        }
    }
}

