/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.pinoutview.xmlparse;

import com.gigadevice.venustool.baseinfo.PerisRelateInfo;
import com.gigadevice.venustool.baseinfo.RelateNodeStruct;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PerisRelationXMLParse {
    private static final String TREE_NODE = "Peri";
    private static final String ATTRIBUTES_TYPE = "Type";
    private static final String ATTRIBUTES_NAME = "Name";
    private static final String ATTRIBUTES_ITEM = "Item";
    private static final String ATTRIBUTES_PERIS = "PeriName";
    private static final String ATTRIBUTES_NODE = "Node";
    private static final String ATTRIBUTES_RELATE = "Relate";
    private static final String ATTRIBUTES_ENABLE = "Enable";

    public static Map<String, List<PerisRelateInfo>> parsePerisRelateXML(String filePath) {
        HashMap<String, List<PerisRelateInfo>> map = new HashMap<String, List<PerisRelateInfo>>();
        SAXReader saxReader = new SAXReader();
        try {
            Document document = saxReader.read(new File(filePath));
            Element rootElm = document.getRootElement();
            List PeripheralList = rootElm.elements(TREE_NODE);
            for (Element elmPeri : PeripheralList) {
                String strPeriNodeName = elmPeri.attributeValue(ATTRIBUTES_PERIS);
                List lstChildNode = elmPeri.elements();
                ArrayList<PerisRelateInfo> lstPerisRelateInfo = new ArrayList<PerisRelateInfo>();
                for (Element elmchildNode : lstChildNode) {
                    PerisRelateInfo perisRelateInfo = new PerisRelateInfo();
                    Iterator itAttribute = elmchildNode.attributeIterator();
                    while (itAttribute.hasNext()) {
                        Attribute attribute = (Attribute)itAttribute.next();
                        String attributeName = attribute.getName();
                        String value = attribute.getText();
                        if (attributeName.equals(ATTRIBUTES_NAME)) {
                            perisRelateInfo.setNodeName(value);
                            continue;
                        }
                        if (attributeName.equals(ATTRIBUTES_TYPE)) {
                            perisRelateInfo.setType(value);
                            continue;
                        }
                        if (!attributeName.equals(ATTRIBUTES_ITEM)) continue;
                        perisRelateInfo.setItem(value);
                    }
                    List lstRelateNodes = elmchildNode.elements();
                    for (Element elmRelateNodes : lstRelateNodes) {
                        String strRelate = elmRelateNodes.attributeValue(ATTRIBUTES_RELATE);
                        String strEnable = elmRelateNodes.attributeValue(ATTRIBUTES_ENABLE);
                        perisRelateInfo.setRelate(strRelate);
                        perisRelateInfo.setEnable(strEnable);
                        perisRelateInfo.setChange(strEnable);
                        if (strRelate.length() > 3) {
                            List lstCondition = elmRelateNodes.elements();
                            new ArrayList();
                            for (Element elmCondition : lstCondition) {
                                List lstRelateNode = elmCondition.elements();
                                perisRelateInfo.addlstRelateInfos(PerisRelationXMLParse.getRelateNodeInfo(lstRelateNode));
                            }
                            continue;
                        }
                        List lstRelateNode = elmRelateNodes.elements();
                        PerisRelationXMLParse.getRelateNodeInfo(lstRelateNode, perisRelateInfo);
                    }
                    lstPerisRelateInfo.add(perisRelateInfo);
                }
                map.put(strPeriNodeName, lstPerisRelateInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private static void getRelateNodeInfo(List lstRelateNode, PerisRelateInfo perisRelateInfo) {
        for (Element elmRelateNode : lstRelateNode) {
            String strPeriName = elmRelateNode.attributeValue(ATTRIBUTES_PERIS);
            String strNode = elmRelateNode.attributeValue(ATTRIBUTES_NODE);
            String strValue = elmRelateNode.getText();
            RelateNodeStruct tempRelateNodeStruct = new RelateNodeStruct();
            tempRelateNodeStruct.setPeris(strPeriName);
            tempRelateNodeStruct.setNode(strNode);
            tempRelateNodeStruct.setValue(strValue);
            perisRelateInfo.addRelateNode(tempRelateNodeStruct);
        }
    }

    private static List<RelateNodeStruct> getRelateNodeInfo(List lstRelateNode) {
        ArrayList<RelateNodeStruct> templstRelateNodeInfo = new ArrayList<RelateNodeStruct>();
        for (Element elmRelateNode : lstRelateNode) {
            String strPeriName = elmRelateNode.attributeValue(ATTRIBUTES_PERIS);
            String strNode = elmRelateNode.attributeValue(ATTRIBUTES_NODE);
            String strValue = elmRelateNode.getText();
            RelateNodeStruct tempRelateNodeStruct = new RelateNodeStruct();
            tempRelateNodeStruct.setPeris(strPeriName);
            tempRelateNodeStruct.setNode(strNode);
            tempRelateNodeStruct.setValue(strValue);
            templstRelateNodeInfo.add(tempRelateNodeStruct);
        }
        return templstRelateNodeInfo;
    }
}

