/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.pinoutview.utils;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringNumberComparator
implements Comparator<String> {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("(.*?)(\\d+)$");

    @Override
    public int compare(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return 0;
        }
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        ParsedString parsed1 = this.parseString(str1);
        ParsedString parsed2 = this.parseString(str2);
        int prefixComparison = parsed1.prefix.compareTo(parsed2.prefix);
        if (prefixComparison != 0) {
            return prefixComparison;
        }
        if (parsed1.hasNumber && parsed2.hasNumber) {
            return Integer.compare(parsed1.number, parsed2.number);
        }
        if (parsed1.hasNumber && !parsed2.hasNumber) {
            return 1;
        }
        if (!parsed1.hasNumber && parsed2.hasNumber) {
            return -1;
        }
        return str1.compareTo(str2);
    }

    private ParsedString parseString(String str) {
        Matcher matcher = NUMBER_PATTERN.matcher(str);
        if (matcher.matches()) {
            String prefix = matcher.group(1);
            int number = Integer.parseInt(matcher.group(2));
            return new ParsedString(prefix, number, true);
        }
        return new ParsedString(str, 0, false);
    }

    private static class ParsedString {
        final String prefix;
        final int number;
        final boolean hasNumber;

        ParsedString(String prefix, int number, boolean hasNumber) {
            this.prefix = prefix;
            this.number = number;
            this.hasNumber = hasNumber;
        }
    }
}

