/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.pinoutview.pinpackage;

import com.gigadevice.pinoutview.pinpackage.PinPanel;
import com.gigadevice.pinoutview.pinpackage.RoundButton;
import com.gigadevice.pinoutview.utils.PinoutUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.GD32PinPad;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLabel;

public class BGAPinPanel
extends PinPanel {
    private JLabel PinConfigLabel;

    public BGAPinPanel() {
        this.PinButton = new RoundButton();
        this.PinConfigLabel = new JLabel();
        this.setOpaque(false);
    }

    @Override
    public void Init(int Index, int direction, int x, int y, int width, int height) {
        this.setLayout(null);
        this.setBounds(x, y, width, height);
        Font font = new Font("Arial", 1, width / 4);
        if (this.PinButton.getText().length() > 5) {
            font = new Font("Arial", 1, width / 5);
        }
        this.PinButton.setBounds(0, 0, width, width);
        this.PinButton.setMargin(new Insets(0, 0, 0, 0));
        this.PinButton.setFont(font);
        this.PinConfigLabel.setBounds(0, width, width, height - width);
        this.PinConfigLabel.setHorizontalAlignment(0);
        Font font1 = new Font("Arial", 1, width / 6);
        this.PinConfigLabel.setFont(font1);
        this.PinConfigLabel.setForeground(Color.BLACK);
        this.add(this.PinButton);
        this.add(this.PinConfigLabel);
        this.setBackground(Color.white);
    }

    @Override
    public void setPinFun(String str) {
        this.PinConfigLabel.setText(str);
    }

    @Override
    public void setPinName(String str) {
        this.PinButton.setText(str);
    }

    @Override
    public void setHighlightedState(final GD32PinPad GD32PinPadObj) {
        if (!PinoutUtil.highlightedPinList.contains(GD32PinPadObj.getPinName())) {
            return;
        }
        if (PinoutUtil.isHighlightedPin && !GlobalVariables.isCubeRoverTest) {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    int num = 0;
                    Color pinColor = BGAPinPanel.this.PinButton.getBackground();
                    while (num < 1) {
                        try {
                            Thread.sleep(300L);
                            BGAPinPanel.this.PinButton.setBackground(PinoutUtil.Color_DEFAULT);
                            Thread.sleep(200L);
                            BGAPinPanel.this.PinButton.setBackground(pinColor);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ++num;
                    }
                    GD32PinPad obj = GlobalVariables.GetPinInfo((int)GD32PinPadObj.getPinIndex());
                    if (obj == null) {
                        return;
                    }
                    if (obj.getPinUsedType() != GD32PinPadObj.getPinUsedType()) {
                        if (obj.getPinUsedType() == 0) {
                            BGAPinPanel.this.PinButton.setBackground(PinoutUtil.Color_DEFAULT);
                        } else if (obj.getPinUsedType() == 2 || obj.getPinUsedType() == 3) {
                            BGAPinPanel.this.PinButton.setBackground(PinoutUtil.Color_AUTO_SELECTED);
                        } else if (obj.getPinUsedType() == 1) {
                            BGAPinPanel.this.PinButton.setBackground(PinoutUtil.Color_MANU_SELECTED);
                        }
                    }
                }
            }, 0L);
        }
    }

    @Override
    public void removeHighlightedState() {
    }
}

