/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.pinoutview.peritree;

import com.gigadevice.pinoutview.peritree.PeriTableModel;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.mcubasestruct.ModuleStruct;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class PeriTableCellRender
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Color COLOR_SELECTED_FORE = new Color(2, 104, 181);
    private static final Color COLOR_MIDDLEWARE_FORE = new Color(33, 145, 65);
    private static final Color COLOR_USED_BG = new Color(128, 255, 128);
    private static final Color COLOR_NORMAL_BG = Color.WHITE;
    private static final Color COLOR_NORMAL_FORE = Color.BLACK;
    private static final Font FONT_NORMAL = new Font("Arial", 1, 15);
    private static final Font FONT_SELECTED = new Font("Arial", 1, 22);
    private PeriTableModel model;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, false, false, row, column);
        label.setHorizontalAlignment(0);
        label.setFont(FONT_NORMAL);
        this.model = (PeriTableModel)table.getModel();
        String highlightedModule = this.model.getLableValue();
        List<String> usedModules = this.model.getUsedModules();
        Color foreground = COLOR_NORMAL_FORE;
        Color background = COLOR_NORMAL_BG;
        if (highlightedModule != null && highlightedModule.equals(value)) {
            foreground = COLOR_SELECTED_FORE;
            label.setFont(FONT_SELECTED);
        } else if (this.isMiddleWare(value)) {
            foreground = COLOR_MIDDLEWARE_FORE;
        }
        if (usedModules != null && usedModules.contains(value)) {
            background = COLOR_USED_BG;
        }
        label.setForeground(foreground);
        label.setBackground(background);
        label.setOpaque(true);
        Color gridColor = table.getGridColor() != null ? table.getGridColor() : new Color(200, 200, 200);
        int top = row == 0 ? 1 : 0;
        int left = column == 0 ? 1 : 0;
        int bottom = 1;
        int right = 1;
        MatteBorder cellBorder = BorderFactory.createMatteBorder(top, left, bottom, right, gridColor);
        label.setBorder(cellBorder);
        return label;
    }

    private boolean isMiddleWare(Object value) {
        if (value == null || GlobalVariables.MCUObj == null) {
            return false;
        }
        LinkedHashMap tableInfoMap = GlobalVariables.MCUObj.getModules();
        ModuleStruct ms = (ModuleStruct)tableInfoMap.get(value);
        return ms != null && "MiddleWare".equals(ms.getModuleType());
    }
}

