/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.pinoutview.peritree;

import com.gigadevice.pinoutview.peritree.PinAssignmentService;
import com.gigadevice.pinoutview.utils.PinoutUtil;
import com.gigadevice.venustool.ConstantsUtil;
import com.gigadevice.venustool.baseinfo.mCheckBox;
import com.gigadevice.venustool.baseinfo.mComboBox;
import com.gigadevice.venustool.controlconflict.ControlConflict;
import com.gigadevice.venustool.mcubasestruct.ItemStruct;
import com.gigadevice.venustool.mcubasestruct.NodeStruct;
import com.gigadevice.venustool.mcubasestruct.WidgetNodeStruct;
import java.util.LinkedHashMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class NodeStateService {
    private final PinAssignmentService pinService;

    public NodeStateService(PinAssignmentService pinService) {
        this.pinService = pinService;
    }

    public void initNodeAndUpdateState(int controlType, Object controlObj, NodeStruct node) {
        if (node == null || controlObj == null) {
            return;
        }
        int moduleState = ControlConflict.getModuleByNode((NodeStruct)node).getState();
        int moduleEnable = moduleState & 1;
        int moduleVisible = moduleState >> 1 & 1;
        int state = node.getState();
        int enable = moduleEnable;
        int visible = moduleVisible | state >> 6 & 1;
        if (enable != 0) {
            this.handleModuleDisabled(controlType, controlObj, node, enable, visible);
            return;
        }
        enable = state & 1 | moduleEnable;
        visible = state >> 1 & 1 | moduleVisible | state >> 6 & 1;
        if (controlType == ConstantsUtil.ControlType.CheckBox.ordinal()) {
            this.initCheckBox((mCheckBox)controlObj, node, enable, visible);
        } else if (controlType == ConstantsUtil.ControlType.Combox.ordinal()) {
            this.initComboBox((mComboBox)controlObj, node, enable, visible);
        } else if (controlType == ConstantsUtil.ControlType.Label.ordinal()) {
            this.initTipsLabel(controlObj, enable, visible);
        }
    }

    private void handleModuleDisabled(int controlType, Object controlObj, NodeStruct node, int enable, int visible) {
        if (controlType == ConstantsUtil.ControlType.CheckBox.ordinal()) {
            mCheckBox ck = (mCheckBox)controlObj;
            ck.setEnabled(enable == 0);
            ck.setVisible(visible == 0);
            PinoutUtil.pinRepaintPeriTree = false;
            this.pinService.assignAndUpdate(node, "false", "1");
            PinoutUtil.pinRepaintPeriTree = true;
            node.setValue("false");
            ck.setSelected(false);
        } else if (controlType == ConstantsUtil.ControlType.Combox.ordinal()) {
            mComboBox cb = (mComboBox)controlObj;
            this.fillComboItems(cb, node, enable, true);
            cb.setEnabled(enable == 0);
            cb.setVisible(visible == 0);
            String defaultValue = ControlConflict.getNodeDefaultItem((WidgetNodeStruct)node);
            if (defaultValue != null) {
                PinoutUtil.pinRepaintPeriTree = false;
                this.pinService.assignAndUpdate(node, defaultValue, "2");
                PinoutUtil.pinRepaintPeriTree = true;
                node.setValue(defaultValue);
                cb.setSelectedItem((Object)defaultValue);
            } else {
                cb.setSelectedIndex(-1);
            }
        } else if (controlType == ConstantsUtil.ControlType.Label.ordinal()) {
            this.initTipsLabel(controlObj, enable, visible);
        }
    }

    private void initCheckBox(mCheckBox ck, NodeStruct node, int enable, int visible) {
        if (enable == 0 && !this.pinService.canAssign(node, "true", "1")) {
            enable = 1;
        }
        ck.setEnabled(enable == 0);
        ck.setVisible(visible == 0);
        String val = node.getValue();
        if (val != null && "TRUE".equalsIgnoreCase(val)) {
            ck.setSelected(true);
        } else {
            ck.setSelected(false);
        }
    }

    private void initComboBox(mComboBox cb, NodeStruct node, int enable, int visible) {
        boolean needFallbackToDefault = this.fillComboItems(cb, node, enable, false);
        cb.setEnabled(enable == 0);
        cb.setVisible(visible == 0);
        String current = node.getValue();
        if (current != null) {
            if (needFallbackToDefault) {
                String def = ControlConflict.getNodeDefaultItem((WidgetNodeStruct)node);
                if (def != null) {
                    PinoutUtil.pinRepaintPeriTree = false;
                    this.pinService.assignAndUpdate(node, def, "2");
                    PinoutUtil.pinRepaintPeriTree = true;
                    node.setValue(def);
                    cb.setSelectedItem((Object)def);
                } else {
                    cb.setSelectedIndex(-1);
                }
            } else {
                cb.setSelectedItem((Object)current);
            }
        } else {
            cb.setSelectedIndex(-1);
        }
    }

    private void initTipsLabel(Object controlObj, int enable, int visible) {
        if (controlObj instanceof JScrollPane) {
            JScrollPane sp = (JScrollPane)controlObj;
            sp.setEnabled(enable == 0);
            sp.setVisible(visible == 0);
        } else if (controlObj instanceof JComponent) {
            JComponent comp = (JComponent)controlObj;
            comp.setEnabled(enable == 0);
            comp.setVisible(visible == 0);
        }
    }

    private boolean fillComboItems(mComboBox cb, NodeStruct node, int enable, boolean ignorePinAssignCheck) {
        cb.removeAllItems();
        boolean currentValueDisabled = false;
        LinkedHashMap mapItem = node.getItems();
        if (mapItem == null) {
            return false;
        }
        for (String itemName : mapItem.keySet()) {
            ItemStruct item = (ItemStruct)mapItem.get(itemName);
            if (item == null) continue;
            int itemState = item.getState();
            int itemEnable = itemState & 1;
            int itemVisible = itemState >> 1 & 1 | itemState >> 6 & 1;
            if (enable == 0 && !ignorePinAssignCheck && !this.pinService.canAssign(node, itemName, "2")) {
                itemEnable = 1;
            }
            if (itemVisible != 0) continue;
            String display = item.getValue();
            cb.addItem((Object)display);
            if (itemEnable == 0) continue;
            cb.disableItem((Object)display);
            if (!display.equals(node.getValue())) continue;
            currentValueDisabled = true;
        }
        return currentValueDisabled;
    }
}

