/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.ObjectReference;
import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.HeapWalkingManager;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JDIPlaceholderVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIPlaceholderValue;
import org.eclipse.jdt.internal.debug.core.model.JDIReferenceListEntryVariable;

public class JDIReferenceListValue
extends JDIObjectValue
implements IIndexedValue {
    private final IJavaObject fRoot;
    private boolean fIsMoreThanPreference;
    private IJavaType fType = null;

    public JDIReferenceListValue(IJavaObject root) {
        super((JDIDebugTarget)root.getDebugTarget(), ((JDIObjectValue)root).getUnderlyingObject());
        this.fRoot = root;
        try {
            IJavaType[] javaTypes = ((JDIDebugTarget)root.getDebugTarget()).getJavaTypes("java.lang.Object[]");
            if (javaTypes != null && javaTypes.length > 0) {
                this.fType = javaTypes[0];
            }
        }
        catch (DebugException debugException) {}
    }

    protected synchronized IJavaObject[] getReferences() {
        try {
            int max = HeapWalkingManager.getDefault().getAllReferencesMaxCount();
            IJavaObject[] referringObjects = null;
            this.fIsMoreThanPreference = false;
            if (max == 0) {
                referringObjects = this.fRoot.getReferringObjects(max);
            } else {
                referringObjects = this.fRoot.getReferringObjects(max + 1);
                if (referringObjects.length > max) {
                    this.fIsMoreThanPreference = true;
                    referringObjects[max] = new JDIPlaceholderValue((JDIDebugTarget)this.fRoot.getDebugTarget(), MessageFormat.format(JDIDebugModelMessages.JDIReferenceListValue_9, Integer.toString(max)));
                }
            }
            return referringObjects;
        }
        catch (DebugException e) {
            JDIDebugPlugin.log(e);
            return new IJavaObject[0];
        }
    }

    protected synchronized boolean referencesLoaded() {
        if (this.fRoot instanceof JDIObjectValue) {
            return ((JDIObjectValue)this.fRoot).isReferencesLoaded();
        }
        return false;
    }

    @Override
    public IVariable[] getVariables() throws DebugException {
        IJavaObject[] elements = this.getReferences();
        IVariable[] vars = new JDIPlaceholderVariable[elements.length];
        int length = elements.length;
        if (this.fIsMoreThanPreference) {
            vars[--length] = new JDIPlaceholderVariable(JDIDebugModelMessages.JDIReferenceListValue_11, elements[length]);
        }
        int i = 0;
        while (i < length) {
            vars[i] = new JDIReferenceListEntryVariable(MessageFormat.format(JDIDebugModelMessages.JDIReferenceListValue_0, Integer.toString(i)), elements[i]);
            ++i;
        }
        return vars;
    }

    @Override
    public ObjectReference getUnderlyingObject() {
        return null;
    }

    @Override
    public boolean hasVariables() throws DebugException {
        if (this.referencesLoaded()) {
            return this.getReferences().length > 0;
        }
        return true;
    }

    @Override
    public boolean isAllocated() throws DebugException {
        return this.fRoot.isAllocated();
    }

    @Override
    public IJavaType getJavaType() throws DebugException {
        return this.fType;
    }

    @Override
    public String getSignature() throws DebugException {
        return "[Ljava/lang/Object;";
    }

    @Override
    public String getReferenceTypeName() throws DebugException {
        return "java.lang.Object[]";
    }

    @Override
    public String getValueString() throws DebugException {
        return "";
    }

    public String getDetailString() {
        StringBuilder buf = new StringBuilder();
        IJavaObject[] elements = this.getReferences();
        if (elements.length == 0) {
            buf.append(JDIDebugModelMessages.JDIReferenceListValue_2);
        } else {
            String length = null;
            length = this.fIsMoreThanPreference ? MessageFormat.format(JDIDebugModelMessages.JDIReferenceListValue_15, Integer.toString(elements.length - 1)) : Integer.toString(elements.length);
            if (elements.length == 1) {
                buf.append(MessageFormat.format(JDIDebugModelMessages.JDIReferenceListValue_3, length));
            } else {
                buf.append(MessageFormat.format(JDIDebugModelMessages.JDIReferenceListValue_4, length));
            }
            IJavaObject[] iJavaObjectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaObject element = iJavaObjectArray[n2];
                buf.append(String.valueOf(element) + "\n");
                ++n2;
            }
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        return MessageFormat.format(JDIDebugModelMessages.JDIReferenceListValue_6, this.getUnderlyingValue().toString());
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof JDIReferenceListValue) {
            JDIReferenceListValue ref = (JDIReferenceListValue)o;
            return ref.fRoot.equals(this.fRoot);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + this.fRoot.hashCode();
    }

    public int getInitialOffset() {
        return 0;
    }

    public int getSize() throws DebugException {
        return this.getVariables().length;
    }

    public IVariable getVariable(int offset) throws DebugException {
        IVariable[] variables = this.getVariables();
        if (offset < variables.length) {
            return variables[offset];
        }
        this.requestFailed(JDIDebugModelMessages.JDIReferenceListValue_7, new IndexOutOfBoundsException());
        return null;
    }

    public IVariable[] getVariables(int offset, int length) throws DebugException {
        IVariable[] variables = this.getVariables();
        if (offset < variables.length && offset + length <= variables.length) {
            IVariable[] vars = new IJavaVariable[length];
            System.arraycopy(variables, offset, vars, 0, length);
            return vars;
        }
        this.requestFailed(JDIDebugModelMessages.JDIReferenceListValue_8, new IndexOutOfBoundsException());
        return null;
    }
}

