/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.importexport.internal.wizard;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.importexport.IUDetail;
import org.eclipse.equinox.internal.p2.importexport.VersionIncompatibleException;
import org.eclipse.equinox.internal.p2.importexport.internal.Messages;
import org.eclipse.equinox.internal.p2.importexport.internal.wizard.AbstractImportPage;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PatternFilter;

public class ImportPage
extends AbstractImportPage
implements ISelectableIUsPage {
    private List<IUDetail> features;
    private final List<URI> loadRepos = new ArrayList<URI>();
    private final Map<IUDetail, List<IUDetail>> newProposedFeature = new HashMap<IUDetail, List<IUDetail>>();
    private Button contactAll;
    private Button installLatest;
    private String oldDestination;

    public ImportPage(ProvisioningUI ui, ProvisioningOperationWizard wizard) {
        super("importpage", ui, wizard);
        this.setTitle(Messages.ImportPage_TITLE);
        this.setDescription(Messages.ImportPage_DESCRIPTION);
    }

    @Override
    protected void createContents(Composite composite) {
        this.createDestinationGroup(composite, false);
        this.createInstallationTable(composite);
        this.createAdditionOptions(composite);
    }

    private void createAdditionOptions(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.contactAll = new Button(composite, 32);
        this.contactAll.setText(ProvUIMessages.AvailableIUsPage_ResolveAllCheckbox);
        this.installLatest = new Button(composite, 32);
        this.installLatest.setText(Messages.ImportPage_InstallLatestVersion);
        this.installLatest.setSelection(true);
    }

    @Override
    protected ITreeContentProvider getContentProvider() {
        return new InstallationContentProvider();
    }

    @Override
    protected ITableLabelProvider getLabelProvider() {
        return new InstallationLabelProvider();
    }

    @Override
    protected int getBrowseDialogStyle() {
        return 4096;
    }

    @Override
    protected String getDestinationLabel() {
        return Messages.ImportPage_DESTINATION_LABEL;
    }

    @Override
    protected String getDialogTitle() {
        return Messages.ImportPage_FILEDIALOG_TITLE;
    }

    protected IUDetail[] getInput() {
        return new IUDetail[0];
    }

    @Override
    protected String getInvalidDestinationMessage() {
        return Messages.ImportPage_DEST_ERROR;
    }

    @Override
    protected void giveFocusToDestination() {
        this.destinationNameField.setFocus();
    }

    @Override
    protected void updatePageCompletion() {
        super.updatePageCompletion();
        if (this.isPageComplete()) {
            this.getProvisioningWizard().operationSelectionsChanged((ISelectableIUsPage)this);
        }
    }

    @Override
    protected void handleDestinationChanged(String newDestination) {
        if (this.validateDestinationGroup()) {
            if (!newDestination.equals(this.oldDestination)) {
                this.loadRepos.clear();
                this.newProposedFeature.clear();
            }
            BufferedInputStream input = null;
            try {
                input = new BufferedInputStream(new FileInputStream(this.getDestinationValue()));
                this.features = this.importexportService.importP2F(input);
                this.contactAll.setSelection(this.hasEntriesWithoutRepo());
                this.viewer.setInput((Object)this.features.toArray(new IUDetail[this.features.size()]));
                ((InputStream)input).close();
            }
            catch (VersionIncompatibleException e) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ImportPage_TITLE, (String)e.getMessage());
            }
            catch (FileNotFoundException fileNotFoundException) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ImportPage_TITLE, (String)Messages.ImportPage_FILENOTFOUND);
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ImportPage_TITLE, (String)e.getLocalizedMessage());
            }
        } else {
            this.viewer.setInput(null);
        }
        this.updatePageCompletion();
    }

    private boolean hasEntriesWithoutRepo() {
        for (IUDetail entry : this.features) {
            if (entry.getReferencedRepositories().size() != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void setDestinationValue(String selectedFileName) {
        this.oldDestination = this.getDestinationValue();
        super.setDestinationValue(selectedFileName);
    }

    @Override
    protected boolean validDestination() {
        File target = new File(this.getDestinationValue());
        return super.validDestination() && target.exists() && target.canRead();
    }

    public Object[] getCheckedIUElements() {
        Object[] checked = this.viewer.getCheckedElements();
        ArrayList<IUDetail> checkedFeatures = new ArrayList<IUDetail>(checked.length);
        boolean useLatest = this.installLatest.getSelection();
        Object[] objectArray = checked;
        int n = checked.length;
        int n2 = 0;
        while (n2 < n) {
            Object checked1 = objectArray[n2];
            IUDetail feature = (IUDetail)checked1;
            List<IUDetail> existingFeatures = this.newProposedFeature.get(feature);
            if (existingFeatures == null) {
                checkedFeatures.add(feature);
            } else {
                IUDetail matchPolicy = null;
                for (IUDetail f : existingFeatures) {
                    if (matchPolicy == null) {
                        matchPolicy = f;
                        continue;
                    }
                    if (matchPolicy.getIU().getVersion().compareTo((Object)f.getIU().getVersion()) < 0) {
                        if (!useLatest) continue;
                        matchPolicy = f;
                        continue;
                    }
                    if (useLatest) continue;
                    matchPolicy = f;
                }
                if (matchPolicy != null) {
                    checkedFeatures.add(matchPolicy);
                }
            }
            ++n2;
        }
        return checkedFeatures.toArray(new IUDetail[checkedFeatures.size()]);
    }

    public Object[] getSelectedIUElements() {
        return null;
    }

    public void setCheckedElements(Object[] elements) {
        throw new UnsupportedOperationException();
    }

    public ProvisioningContext getProvisioningContext() {
        if (agent != null) {
            Object[] checked = this.viewer.getCheckedElements();
            ArrayList<URI> referredRepos = new ArrayList<URI>(checked.length);
            Object[] objectArray = checked;
            int n = checked.length;
            int n2 = 0;
            while (n2 < n) {
                Object checkItem = objectArray[n2];
                IUDetail feature = (IUDetail)checkItem;
                for (URI uri : feature.getReferencedRepositories()) {
                    referredRepos.add(uri);
                }
                ++n2;
            }
            ProvisioningContext context = new ProvisioningContext(agent);
            if (!this.contactAll.getSelection()) {
                context.setArtifactRepositories(referredRepos.toArray(new URI[referredRepos.size()]));
                context.setMetadataRepositories(referredRepos.toArray(new URI[referredRepos.size()]));
            }
            return context;
        }
        return null;
    }

    public boolean hasUnloadedRepo() {
        Object[] objectArray = this.viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object checked = objectArray[n2];
            IUDetail feature = (IUDetail)checked;
            for (URI uri : feature.getReferencedRepositories()) {
                if (this.loadRepos.contains(uri)) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Object[] getChecked() {
        if (Display.findDisplay((Thread)Thread.currentThread()) != null) {
            return this.viewer.getCheckedElements();
        }
        GetCheckedElement get = new GetCheckedElement();
        Display.getDefault().syncExec((Runnable)get);
        return get.checkedElements;
    }

    public void recompute(IProgressMonitor monitor) throws InterruptedException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ImportPage_QueryFeaturesJob, (int)1000);
        if (agent != null) {
            IMetadataRepositoryManager metaManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.class);
            IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.class);
            Object[] checked = this.getChecked();
            sub.setWorkRemaining(100 * checked.length);
            Object[] objectArray = checked;
            int n = checked.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                IUDetail feature = (IUDetail)item;
                if (!this.newProposedFeature.containsKey(feature)) {
                    if (sub.isCanceled()) {
                        throw new InterruptedException();
                    }
                    SubMonitor sub2 = sub.newChild(100, 7);
                    sub2.setWorkRemaining(feature.getReferencedRepositories().size() * 500 + 100);
                    ArrayList<IMetadataRepository> repos = new ArrayList<IMetadataRepository>();
                    for (URI uri : feature.getReferencedRepositories()) {
                        if (!metaManager.contains(uri)) {
                            metaManager.addRepository(uri);
                        }
                        metaManager.setEnabled(uri, true);
                        try {
                            repos.add(metaManager.loadRepository(uri, (IProgressMonitor)sub2.newChild(500)));
                        }
                        catch (ProvisionException e) {
                            e.printStackTrace();
                        }
                        catch (OperationCanceledException e) {
                            throw new InterruptedException(e.getLocalizedMessage());
                        }
                        if (!artifactManager.contains(uri)) {
                            artifactManager.addRepository(uri);
                        }
                        artifactManager.setEnabled(uri, true);
                    }
                    if (sub2.isCanceled()) {
                        throw new InterruptedException();
                    }
                    VersionRange allNeverVersions = new VersionRange(feature.getIU().getVersion(), true, null, false);
                    IQuery query = QueryUtil.createIUQuery((String)feature.getIU().getId(), (VersionRange)allNeverVersions);
                    List<IUDetail> existingFeatures = new CompoundQueryable(repos).query(query, (IProgressMonitor)sub2.newChild(100)).stream().map(iu -> new IUDetail((IInstallableUnit)iu, feature.getReferencedRepositories())).toList();
                    this.newProposedFeature.put(feature, existingFeatures);
                } else {
                    if (sub.isCanceled()) {
                        throw new InterruptedException();
                    }
                    sub.worked(100);
                }
                ++n2;
            }
        }
    }

    @Override
    protected PatternFilter getPatternFilter() {
        return new P2ImportIUPatternFilter(this.getColumnConfig());
    }

    class GetCheckedElement
    implements Runnable {
        Object[] checkedElements = null;

        GetCheckedElement() {
        }

        @Override
        public void run() {
            this.checkedElements = ImportPage.this.viewer.getCheckedElements();
        }
    }

    class InstallationContentProvider
    implements ITreeContentProvider {
        InstallationContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public void inputChanged(Viewer viewer1, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    class InstallationLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        InstallationLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IInstallableUnit iu = ((IUDetail)element).getIU();
            switch (columnIndex) {
                case 0: {
                    return ImportPage.this.getIUNameWithDetail(iu);
                }
                case 1: {
                    return iu.getVersion().toString();
                }
                case 2: {
                    return iu.getId();
                }
            }
            throw new RuntimeException("Should not happen");
        }

        public Color getForeground(Object element) {
            if (ImportPage.this.hasInstalled((IInstallableUnit)ProvUI.getAdapter((Object)element, IInstallableUnit.class))) {
                return Display.getDefault().getSystemColor(15);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    class P2ImportIUPatternFilter
    extends PatternFilter {
        boolean checkName;
        boolean checkVersion;
        boolean checkId = false;
        String patternString;

        public P2ImportIUPatternFilter(IUColumnConfig[] columnConfig) {
            IUColumnConfig[] iUColumnConfigArray = columnConfig;
            int n = columnConfig.length;
            int n2 = 0;
            while (n2 < n) {
                IUColumnConfig columnConfig1 = iUColumnConfigArray[n2];
                int field = columnConfig1.getColumnType();
                if (field == 0) {
                    this.checkId = true;
                } else if (field == 1) {
                    this.checkName = true;
                } else if (field == 2) {
                    this.checkVersion = true;
                }
                ++n2;
            }
        }

        public boolean isElementSelectable(Object element) {
            return element instanceof IUDetail;
        }

        public void setPattern(String patternString) {
            super.setPattern(patternString);
            this.patternString = patternString;
        }

        protected boolean isParentMatch(Viewer viewer1, Object element) {
            if (this.patternString == null || this.patternString.length() == 0) {
                return true;
            }
            return super.isParentMatch(viewer1, element);
        }

        protected boolean isLeafMatch(Viewer viewer1, Object element) {
            String text = null;
            if (element instanceof IUDetail) {
                IInstallableUnit iu = ((IUDetail)element).getIU();
                if (this.checkName && (text = iu.getProperty("org.eclipse.equinox.p2.name", null)) != null && this.wordMatches(text)) {
                    return true;
                }
                if ((this.checkId || this.checkName && text == null) && this.wordMatches(text = iu.getId())) {
                    return true;
                }
                if (this.checkVersion && this.wordMatches(text = iu.getVersion().toString())) {
                    return true;
                }
            }
            return false;
        }
    }
}

