/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IPositionConverter;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.browser.ASTTypeInfo;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.model.ext.ICElementHandle;
import org.eclipse.cdt.internal.ui.search.CSearchMatch;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchProviderManager;
import org.eclipse.cdt.internal.ui.search.CSearchResult;
import org.eclipse.cdt.internal.ui.search.CSearchUtil;
import org.eclipse.cdt.internal.ui.search.LineSearchElement;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.cdt.internal.ui.viewsupport.CElementLabels;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.extensions.IExternalSearchProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class CSearchQuery
implements ISearchQuery {
    public static final int FIND_DECLARATIONS = 1;
    public static final int FIND_DEFINITIONS = 2;
    public static final int FIND_REFERENCES = 4;
    public static final int FIND_DECLARATIONS_DEFINITIONS = 3;
    public static final int FIND_ALL_OCCURRENCES = 7;
    protected static final long LABEL_FLAGS = 34629665L;
    protected CSearchResult result = new CSearchResult(this);
    protected int flags;
    protected ICElement[] scope;
    protected ICProject[] projects;
    private Set<String> fullPathFilter;

    protected CSearchQuery(ICElement[] scope, int flags) {
        this.flags = flags;
        this.scope = scope;
        try {
            if (scope == null) {
                Object[] allProjects = CoreModel.getDefault().getCModel().getCProjects();
                int i = 0;
                while (i < allProjects.length) {
                    if (!allProjects[i].getProject().isOpen()) {
                        allProjects[i] = null;
                    }
                    ++i;
                }
                this.projects = (ICProject[])ArrayUtil.removeNulls(ICProject.class, (Object[])allProjects);
            } else {
                HashMap<String, ICProject> projectMap = new HashMap<String, ICProject>();
                HashSet<String> pathFilter = new HashSet<String>();
                boolean needFilter = false;
                int i = 0;
                while (i < scope.length) {
                    ICProject project = scope[i].getCProject();
                    if (project != null && project.getProject().isOpen()) {
                        IResource res = scope[i].getResource();
                        if (res != null) {
                            pathFilter.add(res.getFullPath().toString());
                            needFilter = needFilter || !(res instanceof IProject);
                        }
                        projectMap.put(project.getElementName(), project);
                    }
                    ++i;
                }
                this.projects = projectMap.values().toArray(new ICProject[projectMap.size()]);
                if (needFilter) {
                    this.fullPathFilter = pathFilter;
                }
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
    }

    protected String labelForBinding(IIndex index, IBinding binding, String defaultLabel) throws CoreException {
        ICElementHandle elem;
        IIndexName[] names = index.findNames(binding, 3);
        if (names.length > 0 && (elem = IndexUI.getCElementForName(null, index, names[0])) != null) {
            return CElementLabels.getElementLabel((ICElement)elem, 34629665L);
        }
        return defaultLabel;
    }

    public String getLabel() {
        String type = (this.flags & 4) != 0 ? CSearchMessages.PDOMSearchQuery_refs_label : ((this.flags & 1) != 0 ? CSearchMessages.PDOMSearchQuery_decls_label : CSearchMessages.PDOMSearchQuery_defs_label);
        return type;
    }

    public abstract String getResultLabel(int var1);

    public String getResultLabel(String pattern, int matchCount) {
        return this.getResultLabel(pattern, null, matchCount);
    }

    public String getResultLabel(String pattern, String scope, int matchCount) {
        int kindFlags = this.flags & 7;
        String label = switch (kindFlags) {
            case 4 -> NLS.bind((String)CSearchMessages.PDOMSearchQuery_refs_result_label, (Object)pattern);
            case 1 -> NLS.bind((String)CSearchMessages.PDOMSearchQuery_decls_result_label, (Object)pattern);
            case 2 -> NLS.bind((String)CSearchMessages.PDOMSearchQuery_defs_result_label, (Object)pattern);
            case 3 -> NLS.bind((String)CSearchMessages.PDOMSearchQuery_decldefs_result_label, (Object)pattern);
            default -> NLS.bind((String)CSearchMessages.PDOMSearchQuery_occurrences_result_label, (Object)pattern);
        };
        if (scope != null) {
            label = NLS.bind((String)CSearchMessages.PDOMSearchPatternQuery_PatternQuery_labelPatternInScope, (Object)label, (Object)scope);
        }
        String countLabel = Messages.format(CSearchMessages.CSearchResultCollector_matches, matchCount);
        return String.valueOf(label) + " " + countLabel;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.result;
    }

    protected boolean filterName(IIndexName name) {
        return false;
    }

    private void createMatchesFromNames(IIndex index, Map<IIndexFile, Set<LineSearchElement.Match>> fileMatches, Collection<IIndexName> names, boolean isPolymorphicOnly) throws CoreException {
        if (names == null) {
            return;
        }
        ICProject preferred = this.getPreferredProject();
        for (IIndexName name : names) {
            IASTFileLocation loc;
            if (this.filterName(name) || isPolymorphicOnly && !name.couldBePolymorphicMethodCall() || (loc = name.getFileLocation()) == null) continue;
            IIndexFile file = name.getFile();
            Set<LineSearchElement.Match> matches = fileMatches.get(file);
            if (matches == null) {
                matches = new HashSet<LineSearchElement.Match>();
                fileMatches.put(file, matches);
            }
            int nodeOffset = loc.getNodeOffset();
            int nodeLength = loc.getNodeLength();
            ICElementHandle enclosingElement = null;
            IIndexName enclosingDefinition = name.getEnclosingDefinition();
            if (enclosingDefinition != null) {
                enclosingElement = IndexUI.getCElementForName(preferred, index, enclosingDefinition);
            } else {
                for (IExternalSearchProvider provider : CSearchProviderManager.INSTANCE.getExternalSearchProviders()) {
                    enclosingElement = provider.getEnclosingElement(name);
                    if (enclosingElement != null) break;
                }
            }
            boolean isWriteAccess = name.isWriteAccess();
            matches.add(new LineSearchElement.Match(nodeOffset, nodeLength, isPolymorphicOnly, (ICElement)enclosingElement, isWriteAccess));
        }
    }

    private Set<LineSearchElement.Match> convertMatchesPositions(IIndexFile file, Set<LineSearchElement.Match> matches) throws CoreException {
        IPath path = IndexLocationFactory.getPath((IIndexFileLocation)file.getLocation());
        long timestamp = file.getTimestamp();
        IPositionConverter converter = CCorePlugin.getPositionTrackerManager().findPositionConverter(path, timestamp);
        if (converter != null) {
            HashSet<LineSearchElement.Match> convertedMatches = new HashSet<LineSearchElement.Match>();
            for (LineSearchElement.Match match : matches) {
                Region region = new Region(match.getOffset(), match.getLength());
                region = converter.historicToActual((IRegion)region);
                int offset = region.getOffset();
                int length = region.getLength();
                boolean isPolymorphicCall = match.isPolymorphicCall();
                ICElement enclosingElement = match.getEnclosingElement();
                boolean isWriteAccess = match.isWriteAccess();
                convertedMatches.add(new LineSearchElement.Match(offset, length, isPolymorphicCall, enclosingElement, isWriteAccess));
            }
            matches = convertedMatches;
        }
        return matches;
    }

    private void collectNames(IIndex index, Collection<IIndexName> names, Collection<IIndexName> polymorphicNames) throws CoreException {
        HashMap<IIndexFile, Set<LineSearchElement.Match>> fileMatches = new HashMap<IIndexFile, Set<LineSearchElement.Match>>();
        this.createMatchesFromNames(index, fileMatches, names, false);
        this.createMatchesFromNames(index, fileMatches, polymorphicNames, true);
        IEditorPart[] dirtyEditors = CUIPlugin.getDirtyEditors();
        HashMap<IPath, ITextEditor> pathsDirtyEditors = new HashMap<IPath, ITextEditor>();
        IEditorPart[] iEditorPartArray = dirtyEditors;
        int n = dirtyEditors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart editorPart = iEditorPartArray[n2];
            if (editorPart instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editorPart;
                IEditorInput editorInput = editorPart.getEditorInput();
                if (editorInput instanceof IPathEditorInput) {
                    IPathEditorInput pathEditorInput = (IPathEditorInput)editorInput;
                    pathsDirtyEditors.put(pathEditorInput.getPath(), textEditor);
                }
            }
            ++n2;
        }
        for (Map.Entry entry : fileMatches.entrySet()) {
            IIndexFile file = (IIndexFile)entry.getKey();
            Set<LineSearchElement.Match> matches = (Set<LineSearchElement.Match>)entry.getValue();
            LineSearchElement[] lineElements = new LineSearchElement[]{};
            IPath absolutePath = IndexLocationFactory.getAbsolutePath((IIndexFileLocation)file.getLocation());
            if (pathsDirtyEditors.containsKey(absolutePath)) {
                matches = this.convertMatchesPositions(file, matches);
                ITextEditor textEditor = (ITextEditor)pathsDirtyEditors.get(absolutePath);
                IEditorInput input = textEditor.getEditorInput();
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
                LineSearchElement.Match[] matchesArray = matches.toArray(new LineSearchElement.Match[matches.size()]);
                lineElements = LineSearchElement.createElements(file.getLocation(), matchesArray, document);
            } else {
                LineSearchElement.Match[] matchesArray = matches.toArray(new LineSearchElement.Match[matches.size()]);
                lineElements = LineSearchElement.createElements(file.getLocation(), matchesArray);
            }
            LineSearchElement[] lineSearchElementArray = lineElements;
            int n3 = lineElements.length;
            int n4 = 0;
            while (n4 < n3) {
                LineSearchElement searchElement = lineSearchElementArray[n4];
                LineSearchElement.Match[] matchArray = searchElement.getMatches();
                int n5 = matchArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    LineSearchElement.Match lineMatch = matchArray[n6];
                    int offset = lineMatch.getOffset();
                    int length = lineMatch.getLength();
                    CSearchMatch match = new CSearchMatch(searchElement, offset, length);
                    if (lineMatch.isPolymorphicCall()) {
                        match.setIsPolymorphicCall();
                    }
                    if (lineMatch.isWriteAccess()) {
                        match.setIsWriteAccess();
                    }
                    this.result.addMatch(match);
                    ++n6;
                }
                ++n4;
            }
        }
    }

    protected void createMatches(IIndex index, IBinding binding) throws CoreException {
        this.createMatches(index, new IBinding[]{binding});
    }

    protected void createMatches(IIndex index, IBinding[] bindings) throws CoreException {
        IBinding binding;
        if (bindings == null) {
            return;
        }
        ArrayList<IIndexName> names = new ArrayList<IIndexName>();
        ArrayList<IIndexName> polymorphicNames = null;
        HashSet<Object> handled = new HashSet<Object>();
        IBinding[] iBindingArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            binding = iBindingArray[n2];
            if (binding != null && handled.add(binding)) {
                this.createMatches1(index, binding, names);
            }
            ++n2;
        }
        if ((this.flags & 4) != 0) {
            iBindingArray = bindings;
            n = bindings.length;
            n2 = 0;
            while (n2 < n) {
                binding = iBindingArray[n2];
                if (binding != null) {
                    ICPPMethod iCPPMethod;
                    ICPPMethod[] msInBases;
                    List<? extends IBinding> specializations = IndexUI.findSpecializations(index, binding);
                    for (IBinding iBinding : specializations) {
                        if (iBinding == null || !handled.add(iBinding)) continue;
                        this.createMatches1(index, iBinding, names);
                    }
                    if (binding instanceof ICPPMethod && (msInBases = ClassTypeHelper.findOverridden((ICPPMethod)(iCPPMethod = (ICPPMethod)binding))).length > 0) {
                        if (polymorphicNames == null) {
                            polymorphicNames = new ArrayList<IIndexName>();
                        }
                        ICPPMethod[] iCPPMethodArray = msInBases;
                        int n3 = msInBases.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ICPPMethod mInBase = iCPPMethodArray[n4];
                            if (mInBase != null && handled.add(mInBase)) {
                                this.createMatches1(index, (IBinding)mInBase, polymorphicNames);
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
        for (IExternalSearchProvider provider : CSearchProviderManager.INSTANCE.getExternalSearchProviders()) {
            IBinding[] iBindingArray2 = bindings;
            int n5 = bindings.length;
            int n6 = 0;
            while (n6 < n5) {
                IBinding binding2 = iBindingArray2[n6];
                provider.findNames(binding2, this.flags, this.projects, index, names);
                ++n6;
            }
        }
        if (!names.isEmpty() || polymorphicNames != null && !polymorphicNames.isEmpty()) {
            this.collectNames(index, names, (Collection<IIndexName>)polymorphicNames);
        }
    }

    private void createMatches1(IIndex index, IBinding binding, List<IIndexName> names) throws CoreException {
        IIndexName[] bindingNames = index.findNames(binding, this.flags);
        if (this.fullPathFilter == null) {
            names.addAll(Arrays.asList(bindingNames));
        } else {
            IIndexName[] iIndexNameArray = bindingNames;
            int n = bindingNames.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexName name = iIndexNameArray[n2];
                String fullPath = name.getFile().getLocation().getFullPath();
                if (fullPath != null && this.accept(fullPath)) {
                    names.add(name);
                }
                ++n2;
            }
        }
    }

    private boolean accept(String fullPath) {
        while (!this.fullPathFilter.contains(fullPath)) {
            int idx = fullPath.lastIndexOf(47);
            if (idx < 0) {
                return false;
            }
            fullPath = fullPath.substring(0, idx);
        }
        return true;
    }

    protected void createLocalMatches(IASTTranslationUnit ast, IBinding binding) throws CoreException {
        if (binding != null) {
            LineSearchElement[] lineElements;
            IASTName node;
            HashSet<IASTName> names = new HashSet<IASTName>();
            names.addAll(Arrays.asList(ast.getDeclarationsInAST(binding)));
            names.addAll(Arrays.asList(ast.getDefinitionsInAST(binding)));
            names.addAll(Arrays.asList(ast.getReferences(binding)));
            IIndexFileLocation fileLocation = null;
            HashSet<LineSearchElement.Match> localMatches = new HashSet<LineSearchElement.Match>();
            for (IASTName name : names) {
                ITypeReference ref;
                ASTTypeInfo typeInfo;
                if (!((this.flags & 1) != 0 && name.isDeclaration() || (this.flags & 2) != 0 && name.isDefinition()) && ((this.flags & 4) == 0 || !name.isReference()) || (typeInfo = ASTTypeInfo.create((IASTName)name)) == null || (ref = typeInfo.getResolvedReference()) == null) continue;
                ICElementHandle element = null;
                node = name;
                while (node != null && !(node instanceof IASTFunctionDefinition)) {
                    node = node.getParent();
                }
                if (node != null) {
                    IASTFunctionDefinition definition = (IASTFunctionDefinition)node;
                    element = IndexUI.getCElementForName(this.getPreferredProject(), ast.getIndex(), definition.getDeclarator().getName());
                }
                boolean isWrite = CSearchUtil.isWriteOccurrence(name, binding);
                localMatches.add(new LineSearchElement.Match(ref.getOffset(), ref.getLength(), false, (ICElement)element, isWrite));
                fileLocation = typeInfo.getIFL();
            }
            if (localMatches.isEmpty()) {
                return;
            }
            ITextEditor dirtyTextEditor = null;
            String fullPath = ast.getFilePath();
            node = CUIPlugin.getDirtyEditors();
            int element = ((IEditorPart[])node).length;
            int ref = 0;
            while (ref < element) {
                IEditorPart editorPart = node[ref];
                if (editorPart instanceof ITextEditor) {
                    IPathEditorInput pathEditorInput;
                    IPath path;
                    ITextEditor textEditor = (ITextEditor)editorPart;
                    IEditorInput editorInput = editorPart.getEditorInput();
                    if (editorInput instanceof IPathEditorInput && fullPath.equals((path = (pathEditorInput = (IPathEditorInput)editorInput).getPath()).toOSString())) {
                        dirtyTextEditor = textEditor;
                        break;
                    }
                }
                ++ref;
            }
            LineSearchElement.Match[] matchesArray = localMatches.toArray(new LineSearchElement.Match[localMatches.size()]);
            if (dirtyTextEditor != null) {
                IEditorInput input = dirtyTextEditor.getEditorInput();
                IDocument document = dirtyTextEditor.getDocumentProvider().getDocument((Object)input);
                lineElements = LineSearchElement.createElements(fileLocation, matchesArray, document);
            } else {
                lineElements = LineSearchElement.createElements(fileLocation, matchesArray);
            }
            LineSearchElement[] lineSearchElementArray = lineElements;
            int n = lineElements.length;
            int n2 = 0;
            while (n2 < n) {
                LineSearchElement searchElement = lineSearchElementArray[n2];
                LineSearchElement.Match[] matchArray = searchElement.getMatches();
                int n3 = matchArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    LineSearchElement.Match lineMatch = matchArray[n4];
                    int offset = lineMatch.getOffset();
                    int length = lineMatch.getLength();
                    CSearchMatch match = new CSearchMatch(searchElement, offset, length);
                    if (lineMatch.isWriteAccess()) {
                        match.setIsWriteAccess();
                    }
                    this.result.addMatch(match);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private ICProject getPreferredProject() {
        ICProject preferred = null;
        if (this.projects != null && this.projects.length == 1) {
            preferred = this.projects[0];
        }
        return preferred;
    }

    public final IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        IStatus iStatus;
        CSearchResult result = (CSearchResult)this.getSearchResult();
        result.removeAll();
        result.setIndexerBusy(!CCorePlugin.getIndexManager().isIndexerIdle());
        IIndex index = CCorePlugin.getIndexManager().getIndex(this.projects, 512);
        try {
            index.acquireReadLock();
        }
        catch (InterruptedException e) {
            return Status.CANCEL_STATUS;
        }
        try {
            iStatus = this.runWithIndex(index, monitor);
        }
        catch (Throwable throwable) {
            try {
                index.releaseReadLock();
                throw throwable;
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        index.releaseReadLock();
        return iStatus;
    }

    protected abstract IStatus runWithIndex(IIndex var1, IProgressMonitor var2);

    public ICProject[] getProjects() {
        return this.projects;
    }

    public String getScopeDescription() {
        StringBuilder buf = new StringBuilder();
        switch (this.scope.length) {
            case 0: {
                break;
            }
            case 1: {
                buf.append(this.scope[0].getElementName());
                break;
            }
            case 2: {
                buf.append(this.scope[0].getElementName());
                buf.append(", ");
                buf.append(this.scope[1].getElementName());
                break;
            }
            default: {
                buf.append(this.scope[0].getElementName());
                buf.append(", ");
                buf.append(this.scope[1].getElementName());
                buf.append(", ...");
            }
        }
        return buf.toString();
    }
}

