/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui.listener;

import com.gigadevice.debug.utils.GdbDebugUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DebugListener
implements IDebugEventSetListener {
    private IPartListener2 partListener;
    private boolean isMonitoring = false;
    private Job monitorJob = null;
    private long monitoringStartTime = 0L;
    private static final long MONITORING_TIMEOUT = 30000L;
    private int monitoringCount = 0;
    private ILaunch currentLaunch = null;
    private int elfExpandAttempts = 0;
    private int gdbLaunchExpandAttempts = 0;
    private int debugLaunchCount = 0;

    public int getDebugLaunchCount() {
        return this.debugLaunchCount;
    }

    public void setDebugLaunchCount(int debugLaunchCount) {
        this.debugLaunchCount = debugLaunchCount;
    }

    public void initialize() {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.setupPartListener();
        this.checkDebugViewIfOpen();
        Display.getDefault().asyncExec(() -> {
            try {
                ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
                if (launches.length > 0) {
                    this.startMonitoringDebugView();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void setupPartListener() {
        if (this.partListener != null) {
            return;
        }
        this.partListener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
                if ("org.eclipse.debug.ui.DebugView".equals(partRef.getId())) {
                    DebugListener.this.startMonitoringDebugView();
                }
            }

            public void partOpened(IWorkbenchPartReference partRef) {
                if ("org.eclipse.debug.ui.DebugView".equals(partRef.getId())) {
                    DebugListener.this.startMonitoringDebugView();
                }
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }
        };
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener(this.partListener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            if (event.getKind() == 2 && (event.getDetail() == 16 || event.getDetail() == 8)) {
                this.isMonitoring = false;
                this.cancelMonitorJob();
                return;
            }
            if (event.getKind() == 4 || event.getKind() == 1) {
                if (!this.isStoppedAtBreakpoint()) {
                    this.startMonitoringDebugView();
                }
            } else if (event.getKind() == 8) {
                this.isMonitoring = false;
                this.currentLaunch = null;
                this.cancelMonitorJob();
                if (!this.hasActiveDebugSession()) {
                    this.switchToCCPerspective();
                }
            }
            ++n2;
        }
    }

    private void switchToCCPerspective() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                try {
                    window.getWorkbench().showPerspective("org.eclipse.cdt.ui.CPerspective", window);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void checkDebugViewIfOpen() {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewPart view = page.findView("org.eclipse.debug.ui.DebugView");
            if (view != null) {
                this.startMonitoringDebugView();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    private boolean isStoppedAtBreakpoint() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void startMonitoringDebugView() {
        boolean isTimeout;
        if (this.isStoppedAtBreakpoint()) {
            return;
        }
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        if (launches.length > 1 && GdbDebugUtil.isNonStop) {
            this.isMonitoring = false;
            this.cancelMonitorJob();
            return;
        }
        ILaunch newLaunch = this.findGdbLaunch(launches);
        long currentTime = System.currentTimeMillis();
        boolean bl = isTimeout = this.isMonitoring && currentTime - this.monitoringStartTime > 30000L;
        if (newLaunch != null && !newLaunch.equals(this.currentLaunch) || isTimeout) {
            this.isMonitoring = false;
            this.cancelMonitorJob();
        }
        if (this.isMonitoring) {
            return;
        }
        boolean hasActiveLaunch = false;
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (!launch.isTerminated() && this.isGdbLaunch(launch)) {
                hasActiveLaunch = true;
                break;
            }
            ++n2;
        }
        if (!hasActiveLaunch) {
            return;
        }
        try {
            ILaunchConfiguration config = newLaunch.getLaunchConfiguration();
            if (config != null) {
                Boolean doFirstReset = config.getAttribute("com.gigadevice.debug.launch.doFirstReset", true);
                Boolean doSecondReset = config.getAttribute("com.gigadevice.debug.launch.doSecondReset", true);
                Boolean loadImage = config.getAttribute("com.gigadevice.debug.launch.loadImage", true);
                if (doFirstReset.booleanValue() || doSecondReset.booleanValue() || loadImage.booleanValue()) {
                    this.isMonitoring = false;
                    this.cancelMonitorJob();
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.isMonitoring = true;
        this.monitoringStartTime = System.currentTimeMillis();
        this.monitoringCount = 0;
        this.currentLaunch = newLaunch;
        this.monitorJob = new Job("ELF\u93c2\u56e6\u6b22\u9477\ue044\u59e9\u95ab\u590b\u5ae8"){

            protected IStatus run(IProgressMonitor monitor) {
                ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
                if (launches.length > 1 && GdbDebugUtil.isNonStop) {
                    DebugListener.this.isMonitoring = false;
                    return Status.OK_STATUS;
                }
                Display.getDefault().syncExec(() -> {
                    try {
                        DebugListener.this.processDebugViewTree();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                if (!monitor.isCanceled() && DebugListener.this.isMonitoring) {
                    this.schedule(300L);
                }
                return Status.OK_STATUS;
            }
        };
        this.monitorJob.setSystem(true);
        this.monitorJob.schedule();
    }

    private void cancelMonitorJob() {
        this.isMonitoring = false;
        if (this.monitorJob != null && this.monitorJob.getState() != 0) {
            this.monitorJob.cancel();
        }
    }

    private ILaunch findGdbLaunch(ILaunch[] launches) {
        int i = launches.length - 1;
        while (i >= 0) {
            ILaunch launch = launches[i];
            try {
                if (!launch.isTerminated() && this.isGdbLaunch(launch)) {
                    return launch;
                }
            }
            catch (Exception exception) {}
            --i;
        }
        return null;
    }

    private boolean isGdbLaunch(ILaunch launch) {
        try {
            String typeId = launch.getLaunchConfiguration().getType().getIdentifier();
            if (typeId.contains("gdb")) {
                return true;
            }
        }
        catch (Exception exception) {}
        String launchString = launch.toString().toLowerCase();
        return launchString.contains("gdb");
    }

    private void processDebugViewTree() {
        try {
            if (this.isStoppedAtBreakpoint()) {
                this.isMonitoring = false;
                this.cancelMonitorJob();
                return;
            }
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewPart debugView = page.findView("org.eclipse.debug.ui.DebugView");
            if (debugView == null) {
                return;
            }
            TreeViewer viewer = this.getTreeViewer(debugView);
            if (viewer == null) {
                Tree tree = this.findTree(debugView);
                if (tree != null) {
                    if (this.hasBreakpointIndicatorInTree(tree)) {
                        this.isMonitoring = false;
                        this.cancelMonitorJob();
                        return;
                    }
                    this.processSWTTree(tree);
                }
                return;
            }
            Tree tree = viewer.getTree();
            if (tree == null || tree.isDisposed()) {
                return;
            }
            if (this.hasBreakpointIndicatorInTree(tree)) {
                this.isMonitoring = false;
                this.cancelMonitorJob();
                return;
            }
            this.processSWTTree(tree);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean hasBreakpointIndicatorInTree(Tree tree) {
        if (tree == null || tree.getItemCount() == 0) {
            return false;
        }
        LinkedList<TreeItem> queue = new LinkedList<TreeItem>();
        queue.add(tree.getItem(0));
        while (!queue.isEmpty()) {
            TreeItem[] children;
            TreeItem current = (TreeItem)queue.poll();
            String text = current.getText();
            if (text.contains("Suspended") || text.contains("Breakpoint") || text.toLowerCase().contains("\u93c6\u509a\u4ee0") || text.toLowerCase().contains("\u93c2\ue160\u5063")) {
                return true;
            }
            TreeItem[] treeItemArray = children = current.getItems();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                queue.add(child);
                ++n2;
            }
        }
        return false;
    }

    private void processSWTTree(Tree tree) {
        try {
            if (tree.getItemCount() == 0) {
                return;
            }
            TreeItem rootItem = tree.getItem(0);
            if (!rootItem.getExpanded()) {
                ++this.gdbLaunchExpandAttempts;
                if (this.gdbLaunchExpandAttempts % 3 == 0) {
                    this.simulateDoubleClick(rootItem);
                    return;
                }
                rootItem.setExpanded(true);
                return;
            }
            this.gdbLaunchExpandAttempts = 0;
            TreeItem[] children = rootItem.getItems();
            if (children.length < 3) {
                ++this.monitoringCount;
                if (this.monitoringCount % 4 == 1) {
                    this.forceRefreshDebugView();
                }
                return;
            }
            TreeItem elfItem = this.findElfItem(children);
            if (elfItem != null) {
                this.selectTreeItem(tree, elfItem);
                if (elfItem.getExpanded()) {
                    this.processElfThreads(tree, elfItem);
                    return;
                }
                if (this.elfExpandAttempts >= 5) {
                    this.isMonitoring = false;
                    this.elfExpandAttempts = 0;
                    this.cancelMonitorJob();
                    return;
                }
                ++this.elfExpandAttempts;
                elfItem.setExpanded(true);
                if (elfItem.getExpanded()) {
                    this.processElfThreads(tree, elfItem);
                    return;
                }
                return;
            }
            ++this.monitoringCount;
            if (this.monitoringCount > 10) {
                this.processAvailableItems(rootItem, children);
                this.isMonitoring = false;
                this.cancelMonitorJob();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processElfThreads(Tree tree, TreeItem elfItem) {
        String threadText;
        TreeItem[] elfChildren = elfItem.getItems();
        if (elfChildren.length == 0) {
            if (this.elfExpandAttempts >= 5) {
                this.isMonitoring = false;
                this.elfExpandAttempts = 0;
                this.cancelMonitorJob();
                return;
            }
            ++this.elfExpandAttempts;
            return;
        }
        TreeItem threadItem = this.findThreadOrThreadGroupItem(elfChildren);
        if (threadItem != null && this.isThreadRunning(threadText = threadItem.getText())) {
            this.selectTreeItem(tree, threadItem);
        }
        this.elfExpandAttempts = 0;
        this.isMonitoring = false;
        this.cancelMonitorJob();
    }

    private boolean isThreadRunning(String threadText) {
        return threadText.contains("Running") || threadText.contains("User Request") || threadText.toLowerCase().contains("\u6769\u612f\ue511");
    }

    private TreeItem findElfItem(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            String text = item.getText();
            if (text.endsWith(".elf")) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private TreeItem findThreadOrThreadGroupItem(TreeItem[] items) {
        String text;
        TreeItem item;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            item = treeItemArray[n2];
            text = item.getText();
            if (text.startsWith("Thread #")) {
                return item;
            }
            ++n2;
        }
        treeItemArray = items;
        n = items.length;
        n2 = 0;
        while (n2 < n) {
            item = treeItemArray[n2];
            text = item.getText();
            if (text.contains("ThreadGroup")) {
                TreeItem[] groupChildren;
                if (!item.getExpanded() && item.getItemCount() > 0) {
                    item.setExpanded(true);
                }
                TreeItem[] treeItemArray2 = groupChildren = item.getItems();
                int n3 = groupChildren.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem child = treeItemArray2[n4];
                    if (child.getText().startsWith("Thread #")) {
                        return child;
                    }
                    ++n4;
                }
                return item;
            }
            ++n2;
        }
        return null;
    }

    private void selectTreeItem(Tree tree, TreeItem item) {
        TreeItem[] selectedItems;
        boolean isAlreadySelected = false;
        TreeItem[] treeItemArray = selectedItems = tree.getSelection();
        int n = selectedItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem selected = treeItemArray[n2];
            if (selected == item || selected.getText().equals(item.getText())) {
                isAlreadySelected = true;
                break;
            }
            ++n2;
        }
        if (isAlreadySelected) {
            return;
        }
        tree.setSelection(item);
        try {
            Event event = new Event();
            event.widget = tree;
            event.item = item;
            event.type = 13;
            tree.notifyListeners(13, event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void forceRefreshDebugView() {
        try {
            TreeViewer viewer;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewPart debugView = page.findView("org.eclipse.debug.ui.DebugView");
            if (debugView != null && (viewer = this.getTreeViewer(debugView)) != null) {
                Display.getDefault().asyncExec(() -> viewer.refresh());
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processAvailableItems(TreeItem rootItem, TreeItem[] children) {
        String text;
        TreeItem child;
        TreeItem[] treeItemArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            child = treeItemArray[n2];
            text = child.getText();
            if (text.endsWith(".elf")) {
                rootItem.getParent().setSelection(child);
                try {
                    Event event = new Event();
                    event.widget = rootItem.getParent();
                    event.item = child;
                    event.type = 13;
                    rootItem.getParent().notifyListeners(13, event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.isMonitoring = false;
                this.cancelMonitorJob();
                return;
            }
            ++n2;
        }
        treeItemArray = children;
        n = children.length;
        n2 = 0;
        while (n2 < n) {
            child = treeItemArray[n2];
            text = child.getText();
            if (!(text.equals("") || text.contains("GD-Link") || text.contains("Tools") || text.contains(":\\") || text.contains("/"))) {
                rootItem.getParent().setSelection(child);
                this.isMonitoring = false;
                this.cancelMonitorJob();
                return;
            }
            ++n2;
        }
        if (children.length > 0) {
            rootItem.getParent().setSelection(children[0]);
            this.isMonitoring = false;
            this.cancelMonitorJob();
        }
    }

    private TreeViewer getTreeViewer(IViewPart view) {
        try {
            String[] viewerFields;
            String[] stringArray = viewerFields = new String[]{"fViewer", "viewer", "treeViewer", "fTreeViewer"};
            int n = viewerFields.length;
            int n2 = 0;
            while (n2 < n) {
                String fieldName = stringArray[n2];
                try {
                    Field field = this.findField(view.getClass(), fieldName);
                    if (field != null) {
                        field.setAccessible(true);
                        Object viewerObj = field.get(view);
                        if (viewerObj instanceof TreeViewer) {
                            return (TreeViewer)viewerObj;
                        }
                    }
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private Field findField(Class<?> clazz, String fieldName) {
        while (clazz != null && !clazz.equals(Object.class)) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    private Tree findTree(IViewPart view) {
        try {
            Object control;
            Method getControlMethod = null;
            try {
                getControlMethod = view.getClass().getMethod("getControl", new Class[0]);
            }
            catch (Exception exception) {}
            if (getControlMethod != null) {
                control = getControlMethod.invoke((Object)view, new Object[0]);
                if (control instanceof Tree) {
                    return (Tree)control;
                }
                if (control instanceof Composite) {
                    return this.findTreeInComposite((Composite)control);
                }
            }
            if ((control = view.getSite().getShell().getDisplay().getFocusControl()) instanceof Tree) {
                return (Tree)control;
            }
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            return this.findTreeInComposite((Composite)shell);
        }
        catch (Exception e) {
            System.err.println("[\u9477\ue044\u59e9\u95ab\u590b\u5ae8ELF] \u93cc\u30e6\u58d8\u93cd\u621e\u5e36\u6d60\u8235\u6902\u9351\u6d2a\u654a");
            e.printStackTrace();
            return null;
        }
    }

    private Tree findTreeInComposite(Composite composite) {
        Control[] children;
        if (composite == null || composite.isDisposed()) {
            return null;
        }
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Tree tree;
            Control child = controlArray[n2];
            if (child instanceof Tree) {
                return (Tree)child;
            }
            if (child instanceof Composite && (tree = this.findTreeInComposite((Composite)child)) != null) {
                return tree;
            }
            ++n2;
        }
        return null;
    }

    private void simulateDoubleClick(TreeItem item) {
        try {
            Tree tree = item.getParent();
            tree.setSelection(item);
            Event event = new Event();
            event.widget = tree;
            event.item = item;
            event.type = 8;
            tree.notifyListeners(8, event);
            Event defaultEvent = new Event();
            defaultEvent.widget = tree;
            defaultEvent.item = item;
            defaultEvent.type = 14;
            tree.notifyListeners(14, defaultEvent);
            Display.getDefault().timerExec(500, () -> {
                if (!item.isDisposed() && !item.getExpanded()) {
                    item.setExpanded(true);
                }
            });
        }
        catch (Exception e) {
            System.err.println("[\u9477\ue044\u59e9\u95ab\u590b\u5ae8ELF] \u59af\u2103\u5ad9\u9359\u5c7d\u56ae\u93c3\u8dfa\u56ad\u95bf\ufffd");
            e.printStackTrace();
        }
    }

    private boolean hasActiveDebugSession() {
        ILaunch[] launches;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] iLaunchArray = launches = launchManager.getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (!launch.isTerminated()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

