/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui.listener;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AutoDisassemblyOpener
implements ILaunchListener {
    private static final String DISASSEMBLY_VIEW_ID = "org.eclipse.cdt.dsf.debug.ui.disassembly.view";
    private static final String DEBUG_PERSPECTIVE_ID = "org.eclipse.debug.ui.DebugPerspective";
    private volatile boolean waitingForDebugPerspective = false;
    private IPerspectiveListener perspectiveListener;

    public void register() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
    }

    public void launchAdded(ILaunch launch) {
        if ("debug".equals(launch.getLaunchMode())) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.asyncExec(() -> {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                IWorkbenchPage page = window.getActivePage();
                if (page == null) {
                    return;
                }
                IPerspectiveDescriptor currentPerspective = page.getPerspective();
                if (currentPerspective != null && DEBUG_PERSPECTIVE_ID.equals(currentPerspective.getId())) {
                    this.openDisassemblyView();
                } else {
                    this.waitingForDebugPerspective = true;
                    this.addPerspectiveListener(window);
                }
            });
        }
    }

    private void addPerspectiveListener(final IWorkbenchWindow window) {
        if (this.perspectiveListener != null) {
            window.removePerspectiveListener(this.perspectiveListener);
        }
        this.perspectiveListener = new IPerspectiveListener(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                if (AutoDisassemblyOpener.this.waitingForDebugPerspective && AutoDisassemblyOpener.DEBUG_PERSPECTIVE_ID.equals(perspective.getId())) {
                    AutoDisassemblyOpener.this.waitingForDebugPerspective = false;
                    Display.getDefault().timerExec(300, () -> {
                        AutoDisassemblyOpener.this.openDisassemblyView();
                        window.removePerspectiveListener((IPerspectiveListener)this);
                        AutoDisassemblyOpener.this.perspectiveListener = null;
                    });
                }
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            }
        };
        window.addPerspectiveListener(this.perspectiveListener);
    }

    private void openDisassemblyView() {
        try {
            IViewPart existingView;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page != null && (existingView = page.findView(DISASSEMBLY_VIEW_ID)) == null) {
                page.showView(DISASSEMBLY_VIEW_ID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchRemoved(ILaunch launch) {
    }
}

