/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui.handlers;

import com.gigadevice.venustool.TargetOSInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;

public class WelcomeConfigurationHandler {
    public static void welcomeConfigurationModify(String language) {
        String welcomeJarPath = WelcomeConfigurationHandler.getWelcomeJarPath();
        if (welcomeJarPath != null) {
            String introContentPath = String.valueOf(welcomeJarPath) + "introContent.xml";
            try {
                WelcomeConfigurationHandler.updateIntroContent(introContentPath, language);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void welcomeConfigurationModifyFromIni() {
        File iniFile = new File(Platform.getInstallLocation().getURL().getFile(), "GD32EmbeddedBuilder.ini");
        if (!iniFile.exists()) {
            return;
        }
        String language = "";
        try {
            List<String> lines = Files.readAllLines(iniFile.toPath());
            boolean inVmArgs = false;
            for (String line : lines) {
                if (line.equals("-vmargs")) {
                    inVmArgs = true;
                    continue;
                }
                if (!inVmArgs || !line.startsWith("-Duser.language=")) continue;
                if (line.contains("zh")) {
                    language = "zh";
                    continue;
                }
                if (!line.contains("en")) continue;
                language = "en";
            }
            if (!inVmArgs) {
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String welcomeJarPath = WelcomeConfigurationHandler.getWelcomeJarPath();
        if (welcomeJarPath != null) {
            String introContentPath = String.valueOf(welcomeJarPath) + "introContent.xml";
            try {
                WelcomeConfigurationHandler.updateIntroContent(introContentPath, language);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getWelcomeJarPath() {
        String welcomeJarPath = null;
        try {
            if (TargetOSInfo.isWindows()) {
                welcomeJarPath = FileLocator.toFileURL((URL)Platform.getBundle((String)"com.gigadevice.welcome").getEntry("")).getPath().substring(1);
            } else if (TargetOSInfo.isLinux()) {
                welcomeJarPath = FileLocator.toFileURL((URL)Platform.getBundle((String)"com.gigadevice.welcome").getEntry("")).getPath();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return welcomeJarPath;
    }

    public static void updateIntroContent(String xmlFilePath, String language) throws Exception {
        File xmlFile = new File(xmlFilePath);
        if (!xmlFile.exists()) {
            throw new FileNotFoundException("File not found: " + xmlFilePath);
        }
        String content = WelcomeConfigurationHandler.readFileContent(xmlFilePath);
        if (content == null) {
            throw new IOException("Failed to read file content: " + xmlFilePath);
        }
        String targetContent = language.equals("en") ? "content/root_en.xhtml" : "content/root_zh.xhtml";
        String updatedContent = content.replaceAll("(<page\\s+id=\"root\"\\s+content=\")[^\"]*(\"/>)", "$1" + targetContent + "$2");
        WelcomeConfigurationHandler.writeFileContent(xmlFilePath, updatedContent);
    }

    private static String readFileContent(String filePath) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
                String line;
                StringBuilder content = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    content.append(line).append(System.lineSeparator());
                }
                if (content.length() > 0) {
                    content.setLength(content.length() - System.lineSeparator().length());
                }
                return content.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void writeFileContent(String filePath, String content) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));){
                writer.write(content);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

