/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui.handlers;

import com.gigadevice.ui.handlers.CommentUtil;
import com.gigadevice.ui.handlers.HandlerUtil;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleCommentHandler
extends AbstractHandler {
    public boolean isEnabled() {
        return HandlerUtil.isTextEditorActive();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IEditorPart editor = window.getActivePage().getActiveEditor();
        if (!(editor instanceof ITextEditor)) {
            return null;
        }
        ITextEditor textEditor = (ITextEditor)editor;
        ISelection selection = textEditor.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            try {
                CommentUtil.SelectionInfo selectionInfo = CommentUtil.processComment(textEditor, textSelection, CommentUtil.CommentOperation.TOGGLE);
                textEditor.selectAndReveal(selectionInfo.offset, selectionInfo.length);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

