/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui.handlers;

import com.gigadevice.ui.tool.Messages;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SwitchLanguageHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        block10: {
            block11: {
                String langName;
                String newCountry;
                String newLang;
                String currentLang = System.getProperty("user.language");
                String currentCountry = System.getProperty("user.country");
                String[] languages = new String[]{Messages.SwitchLanguageHandler_English, Messages.SwitchLanguageHandler_Chinese};
                MessageDialog languageDialog = new MessageDialog(Display.getCurrent().getActiveShell(), Messages.SwitchLanguageHandler_DialogTitle, null, Messages.SwitchLanguageHandler_DialogMessage, 3, languages, 0);
                int languageChoice = languageDialog.open();
                if (languageChoice == -1) {
                    return null;
                }
                if (languageChoice == 0) {
                    newLang = "en";
                    newCountry = "US";
                    langName = Messages.SwitchLanguageHandler_English;
                } else {
                    newLang = "zh";
                    newCountry = "CN";
                    langName = Messages.SwitchLanguageHandler_Chinese;
                }
                if (newLang.equals(currentLang) && newCountry.equals(currentCountry)) {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.SwitchLanguageHandler_SettingsTitle, (String)MessageFormat.format(Messages.SwitchLanguageHandler_AlreadySet, langName));
                    return null;
                }
                File iniFile = new File(Platform.getInstallLocation().getURL().getFile(), "GD32EmbeddedBuilder.ini");
                List<String> lines = Files.readAllLines(iniFile.toPath());
                ArrayList<String> newLines = new ArrayList<String>();
                boolean inVmArgs = false;
                for (String line : lines) {
                    if (line.equals("-vmargs")) {
                        inVmArgs = true;
                        newLines.add(line);
                        continue;
                    }
                    if (inVmArgs && (line.startsWith("-Duser.language=") || line.startsWith("-Duser.country="))) continue;
                    newLines.add(line);
                }
                if (!inVmArgs) {
                    newLines.add("-vmargs");
                }
                newLines.add("-Duser.language=" + newLang);
                newLines.add("-Duser.country=" + newCountry);
                Files.write(iniFile.toPath(), newLines, new OpenOption[0]);
                boolean restart = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.SwitchLanguageHandler_SettingsTitle, (String)MessageFormat.format(Messages.SwitchLanguageHandler_SetAndRestart, langName));
                if (!restart) break block10;
                if (PlatformUI.getWorkbench().saveAllEditors(true)) break block11;
                return null;
            }
            try {
                PlatformUI.getWorkbench().restart();
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.SwitchLanguageHandler_Error, (String)MessageFormat.format(Messages.SwitchLanguageHandler_ErrorMessage, e.getMessage()));
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }
}

