/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui.handlers;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class CommentUtil {
    public static SelectionInfo processComment(ITextEditor editor, ITextSelection selection, CommentOperation operation) throws Exception {
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
        int startLine = selection.getStartLine();
        int endLine = selection.getEndLine();
        CommentInfo commentInfo = CommentUtil.getCommentInfo((IEditorPart)editor);
        int originalOffset = selection.getOffset();
        int originalLength = selection.getLength();
        int newOffset = originalOffset;
        int newLength = originalLength;
        DocumentRewriteSession rewriteSession = null;
        if (document instanceof IDocumentExtension4) {
            rewriteSession = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
        }
        try {
            switch (operation) {
                case ADD: {
                    if (operation == CommentOperation.ADD && CommentUtil.checkAllLinesCommentStatus(document, startLine, endLine, commentInfo.prefix)) {
                        SelectionInfo selectionInfo = new SelectionInfo(originalOffset, originalLength);
                        return selectionInfo;
                    }
                    newLength = CommentUtil.addLineComments(document, startLine, endLine, commentInfo.prefix, originalOffset, originalLength);
                    break;
                }
                case REMOVE: {
                    if (!CommentUtil.checkAllLinesCommentStatus(document, startLine, endLine, commentInfo.prefix)) {
                        SelectionInfo selectionInfo = new SelectionInfo(originalOffset, originalLength);
                        return selectionInfo;
                    }
                    SelectionInfo lineInfo = CommentUtil.removeLineComments(document, startLine, endLine, commentInfo.prefix, originalOffset, originalLength);
                    if (lineInfo != null) {
                        newOffset = lineInfo.offset;
                        newLength = lineInfo.length;
                    }
                    break;
                }
                case TOGGLE: {
                    if (CommentUtil.checkAllLinesCommentStatus(document, startLine, endLine, commentInfo.prefix)) {
                        SelectionInfo toggleInfo = CommentUtil.removeLineComments(document, startLine, endLine, commentInfo.prefix, originalOffset, originalLength);
                        if (toggleInfo != null) {
                            newOffset = toggleInfo.offset;
                            newLength = toggleInfo.length;
                        }
                        break;
                    }
                    newLength = CommentUtil.addLineComments(document, startLine, endLine, commentInfo.prefix, originalOffset, originalLength);
                }
            }
        }
        finally {
            if (document instanceof IDocumentExtension4 && rewriteSession != null) {
                ((IDocumentExtension4)document).stopRewriteSession(rewriteSession);
            }
        }
        return new SelectionInfo(newOffset, newLength);
    }

    public static SelectionInfo addComment(ITextEditor editor, ITextSelection selection) throws Exception {
        return CommentUtil.processComment(editor, selection, CommentOperation.ADD);
    }

    public static SelectionInfo removeComment(ITextEditor editor, ITextSelection selection) throws Exception {
        return CommentUtil.processComment(editor, selection, CommentOperation.REMOVE);
    }

    public static SelectionInfo toggleComment(ITextEditor editor, ITextSelection selection) throws Exception {
        return CommentUtil.processComment(editor, selection, CommentOperation.TOGGLE);
    }

    private static boolean checkAllLinesCommentStatus(IDocument document, int startLine, int endLine, String prefix) throws BadLocationException {
        boolean allCommented = true;
        int i = startLine;
        while (i <= endLine) {
            IRegion lineInfo = document.getLineInformation(i);
            String lineContent = document.get(lineInfo.getOffset(), lineInfo.getLength());
            if (!CommentUtil.isLineCommented(lineContent, prefix)) {
                allCommented = false;
                break;
            }
            ++i;
        }
        return allCommented;
    }

    private static int addLineComments(IDocument document, int startLine, int endLine, String prefix, int originalOffset, int originalLength) throws BadLocationException {
        int lengthChange = 0;
        int i = endLine;
        while (i >= startLine) {
            IRegion lineInfo = document.getLineInformation(i);
            document.replace(lineInfo.getOffset(), 0, prefix);
            lengthChange += prefix.length();
            --i;
        }
        return originalLength + lengthChange;
    }

    private static SelectionInfo removeLineComments(IDocument document, int startLine, int endLine, String prefix, int originalOffset, int originalLength) throws BadLocationException {
        boolean removedAny = false;
        int offsetChange = 0;
        int lengthChange = 0;
        String prefixNoSpace = prefix.trim();
        int i = endLine;
        while (i >= startLine) {
            IRegion lineInfo = document.getLineInformation(i);
            String lineContent = document.get(lineInfo.getOffset(), lineInfo.getLength());
            int commentIndex = CommentUtil.findLineCommentIndex(lineContent, prefix);
            if (commentIndex != -1) {
                int absoluteCommentPos = lineInfo.getOffset() + commentIndex;
                String actualPrefix = lineContent.substring(commentIndex).startsWith(prefix) ? prefix : prefixNoSpace;
                document.replace(absoluteCommentPos, actualPrefix.length(), "");
                removedAny = true;
                if (absoluteCommentPos < originalOffset) {
                    offsetChange -= actualPrefix.length();
                } else if (absoluteCommentPos < originalOffset + originalLength) {
                    lengthChange -= actualPrefix.length();
                }
            }
            --i;
        }
        if (removedAny) {
            return new SelectionInfo(originalOffset + offsetChange, originalLength + lengthChange);
        }
        return null;
    }

    private static boolean isLineCommented(String lineContent, String prefix) {
        String prefixNoSpace = prefix.trim();
        String trimmedLine = lineContent.trim();
        return trimmedLine.startsWith(prefix) || trimmedLine.startsWith(prefixNoSpace);
    }

    private static int findLineCommentIndex(String lineContent, String prefix) {
        String prefixNoSpace = prefix.trim();
        int indexWithSpace = lineContent.indexOf(prefix);
        int indexNoSpace = lineContent.indexOf(prefixNoSpace);
        if (indexWithSpace != -1 && indexNoSpace != -1) {
            if (indexNoSpace == indexWithSpace || indexNoSpace < indexWithSpace && indexNoSpace + prefixNoSpace.length() < indexWithSpace) {
                return indexNoSpace;
            }
            return indexWithSpace;
        }
        if (indexWithSpace != -1) {
            return indexWithSpace;
        }
        if (indexNoSpace != -1) {
            return indexNoSpace;
        }
        return -1;
    }

    private static int findFirstNonWhitespace(String line) {
        int index = 0;
        while (index < line.length() && Character.isWhitespace(line.charAt(index))) {
            ++index;
        }
        return index;
    }

    public static CommentInfo getCommentInfo(IEditorPart editor) {
        String editorId = editor.getSite().getId().toLowerCase();
        String fileExtension = CommentUtil.getFileExtension(editor);
        if (fileExtension != null) {
            if ((fileExtension = fileExtension.toLowerCase()).equals("java") || fileExtension.equals("js") || fileExtension.equals("c") || fileExtension.equals("cpp") || fileExtension.equals("h") || fileExtension.equals("hpp") || fileExtension.equals("cs") || fileExtension.equals("ts")) {
                return new CommentInfo("//");
            }
            if (fileExtension.equals("py") || fileExtension.equals("sh") || fileExtension.equals("bash") || fileExtension.equals("pl") || fileExtension.equals("rb")) {
                return new CommentInfo("#");
            }
            if (fileExtension.equals("sql")) {
                return new CommentInfo("--");
            }
            if (fileExtension.equals("xml") || fileExtension.equals("html") || fileExtension.equals("htm") || fileExtension.equals("xhtml") || fileExtension.equals("svg")) {
                return new CommentInfo("<!--");
            }
            if (fileExtension.equals("bat") || fileExtension.equals("cmd")) {
                return new CommentInfo("REM");
            }
            if (fileExtension.equals("vb") || fileExtension.equals("vbs")) {
                return new CommentInfo("'");
            }
        }
        if (editorId.contains("java") || editorId.contains("javascript") || editorId.contains("js") || editorId.contains("c") || editorId.contains("cpp")) {
            return new CommentInfo("//");
        }
        if (editorId.contains("python") || editorId.contains("shell") || editorId.contains("sh")) {
            return new CommentInfo("#");
        }
        if (editorId.contains("sql")) {
            return new CommentInfo("--");
        }
        if (editorId.contains("xml") || editorId.contains("html")) {
            return new CommentInfo("<!--");
        }
        return new CommentInfo("//");
    }

    private static String getFileExtension(IEditorPart editor) {
        IFile file;
        String fileName;
        int dotIndex;
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput && (dotIndex = (fileName = (file = ((IFileEditorInput)input).getFile()).getName()).lastIndexOf(46)) > 0 && dotIndex < fileName.length() - 1) {
            return fileName.substring(dotIndex + 1);
        }
        return null;
    }

    public static class CommentInfo {
        public String prefix;

        public CommentInfo(String prefix) {
            this.prefix = prefix;
        }
    }

    public static enum CommentOperation {
        ADD,
        REMOVE,
        TOGGLE;

    }

    public static class SelectionInfo {
        public int offset;
        public int length;

        public SelectionInfo(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }
    }
}

