/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class BuildActionProvider
extends CommonActionProvider {
    private BuildAction buildAction;
    private BuildAction cleanAction;
    private Shell shell;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.shell = aSite.getViewSite().getShell();
    }

    public void fillContextMenu(IMenuManager menu) {
        IShellProvider sp = new IShellProvider(){

            public Shell getShell() {
                return BuildActionProvider.this.shell;
            }
        };
        this.buildAction = new BuildAction(sp, 10);
        this.buildAction.setActionDefinitionId("org.eclipse.ui.project.buildProject");
        this.cleanAction = new BuildAction(sp, 15);
        this.cleanAction.setText("Clean Project");
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean isProjectSelection = true;
        Iterator<IProject> projects = BuildActionProvider.selectionToProjects(selection).iterator();
        while (projects.hasNext() && isProjectSelection) {
            IProject project = projects.next();
            if (project != null) continue;
            isProjectSelection = false;
        }
        if (isProjectSelection) {
            this.buildAction.selectionChanged(selection);
            menu.appendToGroup("group.build", (IAction)this.buildAction);
            this.cleanAction.selectionChanged(selection);
            menu.appendToGroup("group.build", (IAction)this.cleanAction);
        }
    }

    private static List<IProject> selectionToProjects(IStructuredSelection selection) {
        if (selection == null) {
            return Collections.emptyList();
        }
        ArrayList<IProject> resources = new ArrayList<IProject>();
        for (Object currentObject : selection) {
            IProject resource;
            if (currentObject instanceof IWorkingSet) {
                IWorkingSet workingSet = (IWorkingSet)currentObject;
                IAdaptable[] iAdaptableArray = workingSet.getElements();
                int n = iAdaptableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAdaptable element = iAdaptableArray[n2];
                    IProject project = (IProject)element.getAdapter(IProject.class);
                    if (project != null) {
                        resources.add(project);
                    }
                    ++n2;
                }
                continue;
            }
            if (!(currentObject instanceof IAdaptable) || (resource = (IProject)((IAdaptable)currentObject).getAdapter(IProject.class)) == null) continue;
            resources.add(resource);
        }
        return resources;
    }
}

