/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui;

import com.gigadevice.ui.Activator;
import com.gigadevice.venustool.TargetOSInfo;
import com.gigadevice.venustool.mcuxmlinfo.McuFactory;
import com.gigadevice.venustool.xmlparse.CPNChangeXmlParse;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class UpdateProjectConfig
implements IResourceChangeListener {
    private static UpdateProjectConfig instance;
    public static final String ARM_IdPrefix = "com.gigadevice.mbs.arm.option";
    public static final String RISCV_IdPrefix = "com.gigadevice.mbs.riscv.option";
    public static final String ARM_OPTIONID_TARGET_MCU = "com.gigadevice.mbs.arm.option.targetMcu.partNo";
    public static final String RISCV_OPTIONID_TARGET_MCU = "com.gigadevice.mbs.riscv.option.targetMcu.partNo";
    public static final String ARM_OPTIONID_TOOLCHAIN = "com.gigadevice.mbs.arm.option.toolChain.";
    public static final String ARM_OPTIONID_TOOLCHAIN_PATH = "com.gigadevice.mbs.arm.option.toolChain.path";
    public static final String ARM_OPTIONID_BUILDTOOL_PATH = "com.gigadevice.mbs.arm.option.toolChain.buildToolPath";
    public static final String RISCV_OPTIONID_TOOLCHAIN = "com.gigadevice.mbs.riscv.option.toolChain.";
    public static final String RISCV_OPTIONID_TOOLCHAIN_PATH = "com.gigadevice.mbs.riscv.option.toolChain.path";
    public static final String RISCV_OPTIONID_BUILDTOOL_PATH = "com.gigadevice.mbs.riscv.option.toolChain.buildToolPath";
    public static final String OLD_ARM__TOOLCHAIN_PATH = "./Tools/GNU Tools ARM Embedded/xpack-arm-none-eabi-gcc/9.2.1-1.1/bin";
    public static final String OLD_RISCV_TOOLCHAIN_PATH = "./Tools/RISC-V Embedded GCC/8.2.0-2.2-20190521-0004/bin";
    public static final String OLD_RISCV_TOOLCHAIN_PATH_NUCLEI = "./Tools/nuclei_riscv_newlibc_prebuilt_win32_2022.04/gcc/bin";
    public static final String OLD__BUILDTOOL_PATH = "./Tools/Build Tools/2.10-20180103-1919/bin";
    public static final String ARM_OPTIONID_INCLUDE_PATH = "com.gigadevice.mbs.arm.option.CCompiler.includes.paths";
    public static final String RISCV_OPTIONID_INCLUDE_PATH = "com.gigadevice.mbs.riscv.option.CCompiler.includes.paths";

    private UpdateProjectConfig() {
    }

    public static synchronized UpdateProjectConfig getInstance() {
        if (instance == null) {
            instance = new UpdateProjectConfig();
        }
        return instance;
    }

    public void startListening() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void stopListening() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            if (event.getType() != 1) {
                return;
            }
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource resource = delta.getResource();
                    if (resource instanceof IProject) {
                        final IProject project = (IProject)resource;
                        if ((delta.getKind() == 1 || delta.getKind() == 4 && (delta.getFlags() & 0x4000) != 0 && project.isOpen()) && project.isOpen() && project.hasNature("org.eclipse.cdt.core.cnature")) {
                            Job job = new Job("Updating project files: " + project.getName()){

                                protected IStatus run(IProgressMonitor monitor) {
                                    try {
                                        UpdateProjectConfig.this.modifyCProjectFile(project);
                                        return Status.OK_STATUS;
                                    }
                                    catch (Exception e) {
                                        return new Status(4, "com.gigadevice.ui", "Failed to update project files.", (Throwable)e);
                                    }
                                }
                            };
                            job.setPriority(40);
                            job.schedule(500L);
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.gigadevice.ui", "Error processing resource change", (Throwable)e));
        }
    }

    public void processExistingProjects() {
        try {
            IProject[] projects;
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                final IProject project = iProjectArray[n2];
                if (project.isOpen() && project.hasNature("org.eclipse.cdt.core.cnature")) {
                    Job job = new Job("Updating project files: " + project.getName()){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                UpdateProjectConfig.this.modifyCProjectFile(project);
                                return Status.OK_STATUS;
                            }
                            catch (Exception e) {
                                return new Status(4, "com.gigadevice.ui", "Failed to update project files.", (Throwable)e);
                            }
                        }
                    };
                    job.setPriority(40);
                    job.schedule(500L);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.gigadevice.ui", "Error processing existing projects", (Throwable)e));
        }
    }

    private void modifyCProjectFile(final IProject project) {
        try {
            if (project.hasNature("org.eclipse.cdt.core.cnature")) {
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        block21: {
                            try {
                                ICConfigurationDescription[] configs;
                                ICProjectDescription projectDesc = CCorePlugin.getDefault().getProjectDescription(project, true);
                                if (projectDesc == null) break block21;
                                ICConfigurationDescription[] iCConfigurationDescriptionArray = configs = projectDesc.getConfigurations();
                                int n = configs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    block22: {
                                        IOption option_RISCVToolChainBuildToolPath;
                                        IOption option_RISCVToolChainPath;
                                        IOption option_ARMToolChainBuildToolPath;
                                        IOption option_ARMToolChainPath;
                                        ICConfigurationDescription config = iCConfigurationDescriptionArray[n2];
                                        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
                                        IConfiguration buildConfig = buildInfo.getManagedProject().getConfiguration(config.getId());
                                        IToolChain toolChain = buildConfig.getToolChain();
                                        UpdateProjectConfig.this.updateBuildPath(toolChain);
                                        IOption option = toolChain.getOptionBySuperClassId(UpdateProjectConfig.ARM_OPTIONID_TARGET_MCU);
                                        if (option != null) {
                                            String currentValue = option.getStringValue();
                                            String newCPN = CPNChangeXmlParse.getNewCPN((String)currentValue, (boolean)false);
                                            ManagedBuildManager.setOption((IConfiguration)buildConfig, (IHoldsOptions)toolChain, (IOption)option, (String)newCPN);
                                        }
                                        if ((option_ARMToolChainPath = toolChain.getOptionBySuperClassId(UpdateProjectConfig.ARM_OPTIONID_TOOLCHAIN_PATH)) != null) {
                                            String toolChainPathCurrentValue = option_ARMToolChainPath.getStringValue();
                                            if ((toolChainPathCurrentValue = toolChainPathCurrentValue.replace("\\", "/")).equals(UpdateProjectConfig.OLD_ARM__TOOLCHAIN_PATH)) {
                                                ManagedBuildManager.setOption((IConfiguration)buildConfig, (IHoldsOptions)toolChain, (IOption)option_ARMToolChainPath, (String)McuFactory.getDefaultToolChainPath((String)"ARM"));
                                            }
                                        }
                                        if ((option_ARMToolChainBuildToolPath = toolChain.getOptionBySuperClassId(UpdateProjectConfig.ARM_OPTIONID_BUILDTOOL_PATH)) != null) {
                                            String BuildToolPathCurrentValue = option_ARMToolChainBuildToolPath.getStringValue();
                                            if ((BuildToolPathCurrentValue = BuildToolPathCurrentValue.replace("\\", "/")).equals(UpdateProjectConfig.OLD__BUILDTOOL_PATH)) {
                                                ManagedBuildManager.setOption((IConfiguration)buildConfig, (IHoldsOptions)toolChain, (IOption)option_ARMToolChainBuildToolPath, (String)McuFactory.getDefaultToolChainBuildToolPath());
                                            }
                                        }
                                        if ((option_RISCVToolChainPath = toolChain.getOptionBySuperClassId(UpdateProjectConfig.RISCV_OPTIONID_TOOLCHAIN_PATH)) != null) {
                                            String toolChainPathCurrentValue = option_RISCVToolChainPath.getStringValue();
                                            if ((toolChainPathCurrentValue = toolChainPathCurrentValue.replace("\\", "/")).equals(UpdateProjectConfig.OLD_RISCV_TOOLCHAIN_PATH)) {
                                                ManagedBuildManager.setOption((IConfiguration)buildConfig, (IHoldsOptions)toolChain, (IOption)option_RISCVToolChainPath, (String)McuFactory.getDefaultToolChainPath((String)"RISCV"));
                                            }
                                            if (toolChainPathCurrentValue.equals(UpdateProjectConfig.OLD_RISCV_TOOLCHAIN_PATH_NUCLEI)) {
                                                ManagedBuildManager.setOption((IConfiguration)buildConfig, (IHoldsOptions)toolChain, (IOption)option_RISCVToolChainPath, (String)McuFactory.getDefaultToolChainPath((String)"NucleiRISCV"));
                                            }
                                        }
                                        if ((option_RISCVToolChainBuildToolPath = toolChain.getOptionBySuperClassId(UpdateProjectConfig.RISCV_OPTIONID_BUILDTOOL_PATH)) != null) {
                                            String BuildToolPathCurrentValue = option_RISCVToolChainBuildToolPath.getStringValue();
                                            if ((BuildToolPathCurrentValue = BuildToolPathCurrentValue.replace("\\", "/")).equals(UpdateProjectConfig.OLD__BUILDTOOL_PATH)) {
                                                ManagedBuildManager.setOption((IConfiguration)buildConfig, (IHoldsOptions)toolChain, (IOption)option_RISCVToolChainBuildToolPath, (String)McuFactory.getDefaultToolChainBuildToolPath());
                                            }
                                        }
                                        if (TargetOSInfo.isLinux()) {
                                            try {
                                                ITool[] tools;
                                                String[] includePathOptionIds = new String[]{UpdateProjectConfig.ARM_OPTIONID_INCLUDE_PATH, UpdateProjectConfig.RISCV_OPTIONID_INCLUDE_PATH};
                                                ITool[] iToolArray = tools = toolChain.getTools();
                                                int n3 = tools.length;
                                                int n4 = 0;
                                                while (n4 < n3) {
                                                    ITool tool = iToolArray[n4];
                                                    String[] stringArray = includePathOptionIds;
                                                    int n5 = includePathOptionIds.length;
                                                    int n6 = 0;
                                                    while (n6 < n5) {
                                                        String optionId = stringArray[n6];
                                                        IOption option_IncludePath = tool.getOptionBySuperClassId(optionId);
                                                        if (option_IncludePath != null) {
                                                            String[] includePaths = option_IncludePath.getIncludePaths();
                                                            if (includePaths != null && includePaths.length > 0) {
                                                                int i = 0;
                                                                while (i < includePaths.length) {
                                                                    includePaths[i] = includePaths[i].replace("\\", "/");
                                                                    ++i;
                                                                }
                                                                ManagedBuildManager.setOption((IConfiguration)buildConfig, (IHoldsOptions)tool, (IOption)option_IncludePath, (String[])includePaths);
                                                            }
                                                            break block22;
                                                        }
                                                        ++n6;
                                                    }
                                                    ++n4;
                                                }
                                            }
                                            catch (BuildException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    }
                                    ++n2;
                                }
                                CCorePlugin.getDefault().setProjectDescription(project, projectDesc);
                            }
                            catch (Exception e) {
                                throw new CoreException((IStatus)new Status(4, "com.gigadevice.ui", "An error occurred while processing the project configuration.", (Throwable)e));
                            }
                        }
                    }
                };
                ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)project, 1, null);
                ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
                project.refreshLocal(2, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void updateBuildPath(IToolChain toolChain) {
        IBuilder m_builder = toolChain.getBuilder();
        if (m_builder != null) {
            String buildPath = null;
            if (m_builder instanceof Builder) {
                buildPath = ((Builder)m_builder).getBuildPathAttribute();
            }
            if (buildPath == null) {
                buildPath = m_builder.getBuildPath();
            }
            if (buildPath != null && buildPath.startsWith("${workspace_loc:/projectName}")) {
                String newBuildPath = "${workspace_loc:/${ProjName}}" + buildPath.substring("${workspace_loc:/projectName}".length());
                m_builder.setBuildPath(newBuildPath);
            }
        }
    }
}

